/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.messaging;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class Message {
    private final String id;
    private final String senderId;
    private final String recipientId;
    private final String content;
    private final String sentAt;
    private final String readAt;
    private final String conversationId;

    public Message(String id, String senderId, String recipientId, String content, String sentAt, String readAt, String conversationId) {
        this.id = id;
        this.senderId = senderId;
        this.recipientId = recipientId;
        this.content = content;
        this.sentAt = sentAt;
        this.readAt = readAt;
        this.conversationId = conversationId;
    }

    public String getId() {
        return this.id;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public String getRecipientId() {
        return this.recipientId;
    }

    public String getContent() {
        return this.content;
    }

    public String getSentAt() {
        return this.sentAt;
    }

    public String getReadAt() {
        return this.readAt;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public boolean isRead() {
        return this.readAt != null;
    }

    public boolean isSentByUser(String userId) {
        return this.senderId.equals(userId);
    }

    public String getFormattedTime() {
        try {
            Instant instant = Instant.parse(this.sentAt);
            ZonedDateTime zdt = instant.atZone(ZoneId.systemDefault());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("h:mm a");
            return formatter.format(zdt);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String createConversationId(String userId1, String userId2) {
        if (userId1.compareTo(userId2) < 0) {
            return userId1 + "_" + userId2;
        }
        return userId2 + "_" + userId1;
    }
}

