/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.DirectJoinServerScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.texboobcat.tunnelyrefab.tunnel.ClientTunnelManager;
import org.texboobcat.tunnelyrefab.ui.ToastNotificationManager;
import org.texboobcat.tunnelyrefab.ui.screens.ConnectionInfoScreen;
import org.texboobcat.tunnelyrefab.util.TunnelyResolver;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={DirectJoinServerScreen.class})
public abstract class DirectJoinServerScreenMixin {
    @Shadow
    private Button selectButton;
    @Shadow
    private EditBox ipEdit;
    private boolean tunnelyrefab$lastWasEndpoint = false;
    private boolean tunnelyrefab$normalizing = false;

    @Shadow
    private void updateSelectButtonStatus() {
    }

    @Inject(method={"updateSelectButtonStatus()V"}, at={@At(value="TAIL")})
    private void tunnelyrefab$allowTunnelyUrls(CallbackInfo ci) {
        String input = this.ipEdit.getValue();
        if (!this.selectButton.active && TunnelyResolver.isEndpoint(input)) {
            this.selectButton.active = true;
        }
    }

    @Inject(method={"init()V"}, at={@At(value="TAIL")})
    private void tunnelyrefab$wireResponder(CallbackInfo ci) {
        this.ipEdit.setResponder(s -> {
            this.updateSelectButtonStatus();
            this.tunnelyrefab$onInputChanged();
        });
    }

    @Inject(method={"onSelect()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void tunnelyrefab$interceptTunnelyEndpoint(CallbackInfo ci) {
        String input = this.ipEdit.getValue();
        TunnelyResolver.ParsedEndpoint endpoint = TunnelyResolver.parseEndpoint(input);
        if (endpoint == null) {
            return;
        }
        this.tunnelyrefab$setNormalizedText(endpoint);
        ToastNotificationManager.getInstance().showWarning("Tunnely", "Connecting via relay " + endpoint.relayUrl + " (session " + endpoint.sessionId + ")");
        ClientTunnelManager.getInstance().connectToServer(endpoint.relayUrl, endpoint.sessionId, () -> {}, err -> {
            ToastNotificationManager.getInstance().showWarning("Tunnely", "Connection failed: " + err);
            String type = DirectJoinServerScreenMixin.tunnelyrefab$categorizeError(err);
            Minecraft.getInstance().execute(() -> {
                Minecraft mc = Minecraft.getInstance();
                mc.setScreen((Screen)new ConnectionInfoScreen(mc.screen, "Direct Connection", type, (String)err, () -> ClientTunnelManager.getInstance().connectToServer(endpoint.relayUrl, endpoint.sessionId, () -> {}, e -> {})));
            });
        });
        ci.cancel();
    }

    private void tunnelyrefab$onInputChanged() {
        String value = this.ipEdit.getValue();
        boolean isEndpoint = TunnelyResolver.isEndpoint(value);
        if (isEndpoint != this.tunnelyrefab$lastWasEndpoint) {
            this.tunnelyrefab$lastWasEndpoint = isEndpoint;
            if (isEndpoint) {
                this.selectButton.setMessage((Component)Component.literal((String)"Join via Tunnely"));
                ToastNotificationManager.getInstance().showWarning("Tunnely", "Endpoint detected. Press Join to connect via relay.");
                TunnelyResolver.ParsedEndpoint parsed = TunnelyResolver.parseEndpoint(value);
                if (parsed != null) {
                    this.tunnelyrefab$setNormalizedText(parsed);
                }
            } else {
                this.selectButton.setMessage((Component)Component.translatable((String)"selectServer.select"));
            }
        }
    }

    private void tunnelyrefab$setNormalizedText(TunnelyResolver.ParsedEndpoint endpoint) {
        if (this.tunnelyrefab$normalizing) {
            return;
        }
        this.tunnelyrefab$normalizing = true;
        try {
            String normalized = endpoint.relayUrl + "/" + endpoint.sessionId;
            if (!normalized.equals(this.ipEdit.getValue())) {
                this.ipEdit.setValue(normalized);
            }
        }
        finally {
            this.tunnelyrefab$normalizing = false;
        }
    }

    private static String tunnelyrefab$categorizeError(String error) {
        if (error == null) {
            return "GENERIC";
        }
        String lower = error.toLowerCase();
        if (lower.contains("full") || lower.contains("capacity")) {
            return "FULL";
        }
        if (lower.contains("not authorized") || lower.contains("unauthorized")) {
            return "NOT_AUTHORIZED";
        }
        if (lower.contains("not found") || lower.contains("session not found")) {
            return "NOT_FOUND";
        }
        if (lower.contains("connection") || lower.contains("timeout") || lower.contains("failed to connect")) {
            return "CONNECTION_FAILED";
        }
        if (lower.contains("incompatible") || lower.contains("version")) {
            return "INCOMPATIBLE";
        }
        return "GENERIC";
    }
}

