/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.mixin;

import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.texboobcat.tunnelyrefab.ui.screens.TunnelyMainScreen;

@Mixin(value={TitleScreen.class})
public class TitleScreenMixin
extends Screen {
    protected TitleScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"init()V"}, at={@At(value="RETURN")})
    private void addTunnelyButton(CallbackInfo ci) {
        int buttonWidth = 98;
        int buttonHeight = 20;
        int minPadding = 5;
        int bottomPadding = this.calculateBottomPadding();
        int rightPadding = this.calculateRightPadding();
        int buttonX = Math.max(minPadding, this.width - buttonWidth - rightPadding);
        int buttonY = Math.max(minPadding, this.height - buttonHeight - bottomPadding);
        if (buttonX + buttonWidth > this.width) {
            buttonX = this.width - buttonWidth - minPadding;
        }
        if (buttonY + buttonHeight > this.height) {
            buttonY = this.height - buttonHeight - minPadding;
        }
        if (buttonX < minPadding) {
            buttonX = minPadding;
        }
        if (buttonY < minPadding) {
            buttonY = minPadding;
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\ud83c\udf10 Tunnely"), button -> {
            if (this.minecraft != null) {
                System.out.println("[Tunnely] Opening Tunnely UI from title screen");
                this.minecraft.setScreen((Screen)new TunnelyMainScreen(this));
            }
        }).bounds(buttonX, buttonY, buttonWidth, buttonHeight).build());
        System.out.println("[Tunnely] Added Tunnely button at (" + buttonX + ", " + buttonY + ") for screen size " + this.width + "x" + this.height);
    }

    private int calculateBottomPadding() {
        int basePadding = 5;
        int copyrightSpace = 24;
        if (this.height > 1080) {
            return basePadding + copyrightSpace + 5;
        }
        if (this.height > 720) {
            return basePadding + copyrightSpace;
        }
        return basePadding + 15;
    }

    private int calculateRightPadding() {
        int basePadding = 5;
        if (this.width > 1920) {
            return basePadding + 5;
        }
        if (this.width > 1280) {
            return basePadding;
        }
        return basePadding;
    }
}

