/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.security;

import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class TokenEncryptor {
    private static final String ALGORITHM = "AES/GCM/NoPadding";
    private static final int GCM_IV_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 128;
    private static final int KEY_SIZE = 256;
    private static TokenEncryptor instance;
    private final SecretKey machineKey = this.deriveMachineKey();

    private TokenEncryptor() {
    }

    public static synchronized TokenEncryptor getInstance() {
        if (instance == null) {
            instance = new TokenEncryptor();
        }
        return instance;
    }

    public String encrypt(String plaintext) {
        if (plaintext == null || plaintext.isEmpty()) {
            return "";
        }
        try {
            byte[] iv = new byte[12];
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)this.machineKey, parameterSpec);
            byte[] plainBytes = plaintext.getBytes(StandardCharsets.UTF_8);
            byte[] cipherBytes = cipher.doFinal(plainBytes);
            ByteBuffer byteBuffer = ByteBuffer.allocate(iv.length + cipherBytes.length);
            byteBuffer.put(iv);
            byteBuffer.put(cipherBytes);
            return Base64.getEncoder().encodeToString(byteBuffer.array());
        }
        catch (Exception e) {
            System.err.println("[Tunnely Security] Encryption failed: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public String decrypt(String ciphertext) {
        if (ciphertext == null || ciphertext.isEmpty()) {
            return "";
        }
        try {
            byte[] decoded = Base64.getDecoder().decode(ciphertext);
            ByteBuffer byteBuffer = ByteBuffer.wrap(decoded);
            byte[] iv = new byte[12];
            byteBuffer.get(iv);
            byte[] cipherBytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(cipherBytes);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)this.machineKey, parameterSpec);
            byte[] plainBytes = cipher.doFinal(cipherBytes);
            return new String(plainBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            System.err.println("[Tunnely Security] Decryption failed (token may be from another machine): " + e.getMessage());
            return null;
        }
    }

    public boolean isEncrypted(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        try {
            Base64.getDecoder().decode(value);
            return value.length() > 32;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private SecretKey deriveMachineKey() {
        try {
            StringBuilder machineId = new StringBuilder();
            String macAddress = this.getMacAddress();
            machineId.append("MAC:").append(macAddress).append("|");
            String username = System.getProperty("user.name", "unknown");
            machineId.append("USER:").append(username).append("|");
            String osName = System.getProperty("os.name", "unknown");
            String osVersion = System.getProperty("os.version", "unknown");
            machineId.append("OS:").append(osName).append(":").append(osVersion).append("|");
            String javaVersion = System.getProperty("java.version", "unknown");
            machineId.append("JAVA:").append(javaVersion);
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(machineId.toString().getBytes(StandardCharsets.UTF_8));
            SecretKeySpec key = new SecretKeySpec(hash, "AES");
            if (this.isDebugMode()) {
                System.out.println("[Tunnely Security] Machine key derived from: " + machineId.toString());
                System.out.println("[Tunnely Security] Key hash: " + this.bytesToHex(hash).substring(0, 16) + "...");
            }
            return key;
        }
        catch (Exception e) {
            System.err.println("[Tunnely Security] Failed to derive machine key: " + e.getMessage());
            e.printStackTrace();
            try {
                KeyGenerator keyGen = KeyGenerator.getInstance("AES");
                keyGen.init(256);
                return keyGen.generateKey();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to create encryption key", ex);
            }
        }
    }

    private String getMacAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                byte[] mac;
                NetworkInterface ni = networkInterfaces.nextElement();
                if (ni.isLoopback() || ni.isVirtual() || !ni.isUp() || (mac = ni.getHardwareAddress()) == null || mac.length != 6) continue;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X", mac[i]));
                    if (i >= mac.length - 1) continue;
                    sb.append(":");
                }
                return sb.toString();
            }
            return "NO_MAC_FOUND";
        }
        catch (Exception e) {
            System.err.println("[Tunnely Security] Failed to get MAC address: " + e.getMessage());
            return "MAC_ERROR";
        }
    }

    private boolean isDebugMode() {
        return Boolean.getBoolean("tunnely.debug");
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println("=== TokenEncryptor Test ===");
        TokenEncryptor encryptor = TokenEncryptor.getInstance();
        String testToken = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.test.signature";
        System.out.println("Original: " + testToken);
        String encrypted = encryptor.encrypt(testToken);
        System.out.println("Encrypted: " + encrypted);
        String decrypted = encryptor.decrypt(encrypted);
        System.out.println("Decrypted: " + decrypted);
        boolean success = testToken.equals(decrypted);
        System.out.println("\nTest " + (success ? "PASSED \u2713" : "FAILED \u2717"));
        String emptyEncrypted = encryptor.encrypt("");
        String emptyDecrypted = encryptor.decrypt(emptyEncrypted);
        System.out.println("Empty string test: " + ("".equals(emptyDecrypted) ? "PASSED \u2713" : "FAILED \u2717"));
        System.out.println("\nisEncrypted(encrypted): " + encryptor.isEncrypted(encrypted));
        System.out.println("isEncrypted(plaintext): " + encryptor.isEncrypted(testToken));
    }
}

