/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ConnectionInfoScreen
extends Screen {
    private final Screen parent;
    private final String serverName;
    private final String errorType;
    private final String errorMessage;
    private MultiLineLabel messageLabel;
    private Button backButton;
    private Button retryButton;
    private final Runnable retryAction;
    public static final String ERROR_FULL = "FULL";
    public static final String ERROR_NOT_AUTHORIZED = "NOT_AUTHORIZED";
    public static final String ERROR_NOT_FOUND = "NOT_FOUND";
    public static final String ERROR_CONNECTION_FAILED = "CONNECTION_FAILED";
    public static final String ERROR_INCOMPATIBLE = "INCOMPATIBLE";
    public static final String ERROR_GENERIC = "GENERIC";

    public ConnectionInfoScreen(Screen parent, String serverName, String errorType, String errorMessage) {
        this(parent, serverName, errorType, errorMessage, null);
    }

    public ConnectionInfoScreen(Screen parent, String serverName, String errorType, String errorMessage, Runnable retryAction) {
        super((Component)Component.literal((String)"Connection Info"));
        this.parent = parent;
        this.serverName = serverName != null ? serverName : "Server";
        this.errorType = errorType != null ? errorType : ERROR_GENERIC;
        this.errorMessage = errorMessage;
        this.retryAction = retryAction;
    }

    protected void init() {
        super.init();
        String displayMessage = this.buildDisplayMessage();
        this.messageLabel = MultiLineLabel.create((Font)this.font, (Component)Component.literal((String)displayMessage), (int)(this.width - 100));
        this.backButton = Button.builder((Component)Component.literal((String)"Back"), button -> this.minecraft.setScreen(this.parent)).bounds(this.width / 2 - 100, this.height - 50, 95, 20).build();
        this.addRenderableWidget((GuiEventListener)this.backButton);
        if (this.retryAction != null && this.shouldShowRetry()) {
            this.retryButton = Button.builder((Component)Component.literal((String)"Retry"), button -> {
                this.minecraft.setScreen(this.parent);
                this.retryAction.run();
            }).bounds(this.width / 2 + 5, this.height - 50, 95, 20).build();
            this.addRenderableWidget((GuiEventListener)this.retryButton);
        }
    }

    private boolean shouldShowRetry() {
        return this.errorType.equals(ERROR_FULL) || this.errorType.equals(ERROR_CONNECTION_FAILED);
    }

    private String buildDisplayMessage() {
        String cleanError;
        switch (this.errorType) {
            case "FULL": {
                return "\u00a7c\u00a7lServer Full\n\n\u00a77The server '\u00a7f" + this.serverName + "\u00a77' is currently full.\n\n\u00a77Please try again later when a slot becomes available.\n\u00a77You can refresh the server list to see updated player counts.\n\n\u00a78Tip: Join during off-peak hours for better availability.";
            }
            case "NOT_AUTHORIZED": {
                String authReason = this.extractAuthReason(this.errorMessage);
                if (authReason.contains("friends_only")) {
                    return "\u00a7c\u00a7lNot Authorized\n\n\u00a77The server '\u00a7f" + this.serverName + "\u00a77' is set to \u00a7eFriends Only\u00a77.\n\n\u00a77You need to be friends with the host to join.\n\u00a77Send them a friend request or ask for an invite.";
                }
                if (authReason.contains("invite_only")) {
                    return "\u00a7c\u00a7lNot Authorized\n\n\u00a77The server '\u00a7f" + this.serverName + "\u00a77' is set to \u00a7eInvite Only\u00a77.\n\n\u00a77You need an explicit invite to join this server.\n\u00a77Contact the host to request access.";
                }
                return "\u00a7c\u00a7lNot Authorized\n\n\u00a77You are not authorized to join '\u00a7f" + this.serverName + "\u00a77'.\n\n\u00a77Reason: \u00a7f" + authReason + "\n\n\u00a77Contact the server host for access.";
            }
            case "NOT_FOUND": {
                return "\u00a7c\u00a7lServer Not Found\n\n\u00a77The server '\u00a7f" + this.serverName + "\u00a77' could not be found.\n\n\u00a77Possible reasons:\n\u00a78\u2022 \u00a77The server has been shut down\n\u00a78\u2022 \u00a77The host closed the session\n\u00a78\u2022 \u00a77The server endpoint is invalid\n\n\u00a77Try refreshing the server list.";
            }
            case "CONNECTION_FAILED": {
                return "\u00a7c\u00a7lConnection Failed\n\n\u00a77Failed to connect to '\u00a7f" + this.serverName + "\u00a77'.\n\n\u00a77Possible causes:\n\u00a78\u2022 \u00a77Network connectivity issues\n\u00a78\u2022 \u00a77Relay server is down\n\u00a78\u2022 \u00a77Firewall blocking connection\n\n\u00a77Check your internet connection and try again.";
            }
            case "INCOMPATIBLE": {
                return "\u00a7c\u00a7lIncompatible Version\n\n\u00a77Cannot join '\u00a7f" + this.serverName + "\u00a77' - version mismatch.\n\n\u00a77Your game version, mod loader, or modpack differs from the server.\n\n\u00a77Make sure you have:\n\u00a78\u2022 \u00a77Same Minecraft version\n\u00a78\u2022 \u00a77Same mod loader (Fabric/Forge)\n\u00a78\u2022 \u00a77Same modpack (if applicable)";
            }
        }
        String string = cleanError = this.errorMessage != null ? this.errorMessage : "Unknown error";
        if (cleanError.startsWith("ERROR: ")) {
            cleanError = cleanError.substring(7);
        }
        return "\u00a7c\u00a7lConnection Error\n\n\u00a77Failed to join '\u00a7f" + this.serverName + "\u00a77'.\n\n\u00a77Error: \u00a7f" + cleanError + "\n\n\u00a77Please try again or contact the server host.";
    }

    private String extractAuthReason(String message) {
        int start;
        int end;
        if (message == null) {
            return "Unknown reason";
        }
        if (message.contains("(") && (end = message.indexOf(41, start = message.indexOf(40))) > start) {
            return message.substring(start + 1, end);
        }
        return message;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        String icon = this.getErrorIcon();
        int iconColor = this.getErrorColor();
        graphics.drawCenteredString(this.font, icon, this.width / 2, 60, iconColor);
        int messageY = 90;
        this.messageLabel.renderCentered(graphics, this.width / 2, messageY);
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    private String getErrorIcon() {
        switch (this.errorType) {
            case "FULL": {
                return "\u00a7c\u00a7l\u26a0";
            }
            case "NOT_AUTHORIZED": {
                return "\u00a7c\u00a7l\ud83d\udd12";
            }
            case "NOT_FOUND": {
                return "\u00a7c\u00a7l\u274c";
            }
            case "CONNECTION_FAILED": {
                return "\u00a7c\u00a7l\u26a1";
            }
            case "INCOMPATIBLE": {
                return "\u00a7c\u00a7l\u2699";
            }
        }
        return "\u00a7c\u00a7l!";
    }

    private int getErrorColor() {
        switch (this.errorType) {
            case "FULL": {
                return 0xFFAA00;
            }
            case "NOT_AUTHORIZED": {
                return 0xFF5555;
            }
            case "NOT_FOUND": {
                return 0xAA0000;
            }
            case "CONNECTION_FAILED": {
                return 0xFF5555;
            }
            case "INCOMPATIBLE": {
                return 0xFFAA00;
            }
        }
        return 0xFF5555;
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

