/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;

public class DownloadSettingsScreen
extends Screen {
    private final Screen parent;
    private final TunnelConfig config;
    private final WorldManager worldManager;
    private BandwidthSlider bandwidthSlider;
    private String statusMessage = "";

    public DownloadSettingsScreen(Screen parent) {
        super((Component)Component.literal((String)"Download Settings"));
        this.parent = parent;
        this.config = TunnelConfig.getInstance();
        this.worldManager = new WorldManager();
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        this.bandwidthSlider = new BandwidthSlider(centerX - 150, centerY - 20, 300, 20);
        this.addRenderableWidget((GuiEventListener)this.bandwidthSlider);
        int presetY = centerY + 20;
        int buttonWidth = 90;
        int buttonSpacing = 95;
        int startX = centerX - buttonSpacing * 3;
        this.addPresetButton(startX, presetY, "Unlimited", 0L);
        this.addPresetButton(startX + buttonSpacing, presetY, "100 KB/s", 102400L);
        this.addPresetButton(startX + buttonSpacing * 2, presetY, "500 KB/s", 512000L);
        this.addPresetButton(startX + buttonSpacing * 3, presetY, "1 MB/s", 0x100000L);
        this.addPresetButton(startX + buttonSpacing * 4, presetY, "2 MB/s", 0x200000L);
        this.addPresetButton(startX + buttonSpacing * 5, presetY, "5 MB/s", 0x500000L);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Save Settings"), button -> this.saveSettings()).bounds(centerX - 100, centerY + 80, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2190 Back"), button -> this.minecraft.setScreen(this.parent)).bounds(centerX - 50, this.height - 30, 100, 20).build());
    }

    private void addPresetButton(int x, int y, String label, long bytesPerSecond) {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)label), button -> this.setBandwidthPreset(bytesPerSecond)).bounds(x, y, 85, 18).build());
    }

    private void setBandwidthPreset(long bytesPerSecond) {
        this.worldManager.setBandwidthLimit(bytesPerSecond);
        this.bandwidthSlider.updateFromConfig();
        this.statusMessage = "\u00a7aPreset applied: " + this.formatBytesPerSecond(bytesPerSecond);
    }

    private void saveSettings() {
        this.statusMessage = "\u00a7aSettings saved!";
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        graphics.drawCenteredString(this.font, "\u2699 Download Settings", centerX, 20, 0xFFFFFF);
        graphics.drawCenteredString(this.font, "\u00a77Configure download speed limits", centerX, 40, 0xAAAAAA);
        graphics.drawCenteredString(this.font, "Download Speed Limit", centerX, centerY - 40, 0xFFFFFF);
        long currentLimit = this.config.getDownloadBandwidthLimit();
        String limitText = this.formatBytesPerSecond(currentLimit);
        graphics.drawCenteredString(this.font, "\u00a7e" + limitText, centerX, centerY + 5, 0xFFFF55);
        String helpText1 = "\u00a77Set to 0 (Unlimited) for maximum speed";
        String helpText2 = "\u00a77Limit speed to avoid network congestion";
        graphics.drawCenteredString(this.font, helpText1, centerX, centerY - 60, 0x888888);
        graphics.drawCenteredString(this.font, helpText2, centerX, centerY - 48, 0x888888);
        graphics.drawCenteredString(this.font, "\u00a77Quick Presets", centerX, centerY + 60, 0xAAAAAA);
        int useCaseY = centerY + 110;
        graphics.drawCenteredString(this.font, "\u00a78Recommendations:", centerX, useCaseY, 0x666666);
        graphics.drawString(this.font, "\u00a78\u2022 Gaming (active): 1-2 MB/s", centerX - 150, useCaseY + 15, 0x666666);
        graphics.drawString(this.font, "\u00a78\u2022 Shared network: 500 KB/s", centerX - 150, useCaseY + 27, 0x666666);
        graphics.drawString(this.font, "\u00a78\u2022 Mobile hotspot: 100 KB/s", centerX - 150, useCaseY + 39, 0x666666);
        graphics.drawString(this.font, "\u00a78\u2022 No constraint: Unlimited", centerX - 150, useCaseY + 51, 0x666666);
        if (!this.statusMessage.isEmpty()) {
            graphics.drawCenteredString(this.font, this.statusMessage, centerX, this.height - 50, 0xFFFFFF);
        }
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    private String formatBytesPerSecond(long bytesPerSecond) {
        if (bytesPerSecond == 0L) {
            return "Unlimited";
        }
        if (bytesPerSecond < 1024L) {
            return bytesPerSecond + " B/s";
        }
        int exp = (int)(Math.log(bytesPerSecond) / Math.log(1024.0));
        String pre = "" + "KMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB/s", (double)bytesPerSecond / Math.pow(1024.0, exp), pre);
    }

    private class BandwidthSlider
    extends AbstractSliderButton {
        private static final long MAX_LIMIT = 0xA00000L;

        public BandwidthSlider(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.empty(), 0.0);
            this.updateFromConfig();
            this.updateMessage();
        }

        public void updateFromConfig() {
            long currentLimit = DownloadSettingsScreen.this.config.getDownloadBandwidthLimit();
            this.value = currentLimit == 0L ? 0.0 : Math.min(1.0, (double)currentLimit / 1.048576E7);
            this.updateMessage();
        }

        protected void updateMessage() {
            long limit = (long)(this.value * 1.048576E7);
            if (limit < 10240L) {
                limit = 0L;
            }
            this.setMessage((Component)Component.literal((String)DownloadSettingsScreen.this.formatBytesPerSecond(limit)));
        }

        protected void applyValue() {
            long limit = (long)(this.value * 1.048576E7);
            if (limit < 10240L) {
                limit = 0L;
            }
            DownloadSettingsScreen.this.config.setDownloadBandwidthLimit(limit);
            DownloadSettingsScreen.this.worldManager.setBandwidthLimit(limit);
            DownloadSettingsScreen.this.statusMessage = "\u00a7aBandwidth limit updated";
        }
    }
}

