/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.tunnel.ClientTunnelManager;
import org.texboobcat.tunnelyrefab.ui.screens.ConnectionInfoScreen;

public class JoinFriendsScreen
extends Screen {
    private final Screen parent;
    private ServerListWidget serverList;
    private String statusMessage = "\u00a7eLoading servers...";
    private int statusColor = 0xFFFF00;
    private boolean isLoading = true;

    public JoinFriendsScreen(Screen parent) {
        super((Component)Component.literal((String)"Join Friends"));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        this.serverList = new ServerListWidget(this.minecraft, this.width, this.height, 50, this.height - 60, 40);
        this.addWidget((GuiEventListener)this.serverList);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\ud83d\udd04 Refresh"), button -> this.loadServers()).bounds(this.width / 2 - 155, this.height - 50, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), button -> this.minecraft.setScreen(this.parent)).bounds(this.width / 2 + 55, this.height - 50, 100, 20).build());
        this.loadServers();
    }

    private void loadServers() {
        System.out.println("[Tunnely UI] ===== LOADING FRIEND SERVERS =====");
        this.isLoading = true;
        this.statusMessage = "\u00a7eLoading servers...";
        this.statusColor = 0xFFFF00;
        this.serverList.clear();
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                SupabaseClient.ServerListResult result = client.getFriendServers();
                this.minecraft.execute(() -> {
                    block10: {
                        this.isLoading = false;
                        if (result.success) {
                            try {
                                System.out.println("[Tunnely UI] Parsing server data...");
                                JsonArray servers = JsonParser.parseString((String)result.data).getAsJsonArray();
                                System.out.println("[Tunnely UI] Found " + servers.size() + " server(s)");
                                if (servers.size() == 0) {
                                    this.statusMessage = "\u00a77No active servers from friends";
                                    this.statusColor = 0xAAAAAA;
                                    break block10;
                                }
                                for (JsonElement element : servers) {
                                    JsonObject server = element.getAsJsonObject();
                                    String serverId = server.get("id").getAsString();
                                    String endpoint = server.has("public_endpoint") ? server.get("public_endpoint").getAsString() : "N/A";
                                    String gameMode = server.has("game_mode") ? server.get("game_mode").getAsString() : "survival";
                                    String hostName = "Unknown";
                                    if (server.has("host") && !server.get("host").isJsonNull()) {
                                        JsonObject hostProfile = server.getAsJsonObject("host");
                                        if (hostProfile.has("minecraft_name")) {
                                            hostName = hostProfile.get("minecraft_name").getAsString();
                                        }
                                    } else if (server.has("host_name")) {
                                        hostName = server.get("host_name").getAsString();
                                    }
                                    System.out.println("[Tunnely UI] Server: " + hostName + " @ " + endpoint + " (" + gameMode + ")");
                                    this.serverList.addServer(serverId, hostName, endpoint, gameMode);
                                }
                                this.statusMessage = "\u00a7aFound " + servers.size() + " server(s)";
                                this.statusColor = 65280;
                            }
                            catch (Exception e) {
                                this.statusMessage = "\u00a7cFailed to parse server list";
                                this.statusColor = 0xFF0000;
                                System.err.println("[Tunnely UI] \u2717 Exception parsing servers: " + e.getMessage());
                                e.printStackTrace();
                            }
                        } else {
                            this.statusMessage = "\u00a7c" + result.error;
                            this.statusColor = 0xFF0000;
                            System.err.println("[Tunnely UI] \u2717 Failed to load servers: " + result.error);
                        }
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception loading servers: " + e.getMessage());
                e.printStackTrace();
                this.minecraft.execute(() -> {
                    this.isLoading = false;
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                });
            }
        }, "Tunnely-LoadServers").start();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        this.serverList.render(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, "\u00a76\u00a7lJoin Friends", this.width / 2, 20, 0xFFFFFF);
        graphics.drawCenteredString(this.font, this.statusMessage, this.width / 2, 35, this.statusColor);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private class ServerListWidget
    extends ObjectSelectionList<ServerEntry> {
        public ServerListWidget(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraft, width, height, top, bottom);
        }

        public void clear() {
            this.clearEntries();
        }

        public void addServer(String id, String hostName, String endpoint, String gameMode) {
            this.addEntry((AbstractSelectionList.Entry)new ServerEntry(id, hostName, endpoint, gameMode));
        }

        class ServerEntry
        extends ObjectSelectionList.Entry<ServerEntry> {
            private final String id;
            private final String hostName;
            private final String endpoint;
            private final String gameMode;
            private final Button joinButton;

            public ServerEntry(String id, String hostName, String endpoint, String gameMode) {
                this.id = id;
                this.hostName = hostName;
                this.endpoint = endpoint;
                this.gameMode = gameMode;
                this.joinButton = Button.builder((Component)Component.literal((String)"Join"), button -> this.joinServer()).bounds(0, 0, 60, 20).build();
            }

            /*
             * Enabled aggressive block sorting
             */
            private void joinServer() {
                String sessionId;
                Object relayUrl;
                block5: {
                    System.out.println("[Tunnely UI] Join server requested for: " + this.endpoint);
                    if (this.endpoint == null || this.endpoint.equals("N/A") || !this.endpoint.contains("/")) {
                        JoinFriendsScreen.this.statusMessage = "\u00a7cInvalid server endpoint";
                        JoinFriendsScreen.this.statusColor = 0xFF0000;
                        return;
                    }
                    if (this.endpoint.contains("://")) {
                        int lastSlash = this.endpoint.lastIndexOf(47);
                        if (lastSlash > 0 && lastSlash < this.endpoint.length() - 1) {
                            relayUrl = this.endpoint.substring(0, lastSlash);
                            sessionId = this.endpoint.substring(lastSlash + 1);
                            break block5;
                        } else {
                            JoinFriendsScreen.this.statusMessage = "\u00a7cInvalid endpoint format";
                            JoinFriendsScreen.this.statusColor = 0xFF0000;
                            return;
                        }
                    }
                    String[] parts = this.endpoint.split("/", 2);
                    if (parts.length != 2) {
                        JoinFriendsScreen.this.statusMessage = "\u00a7cInvalid endpoint format";
                        JoinFriendsScreen.this.statusColor = 0xFF0000;
                        return;
                    }
                    String relayHostPort = parts[0];
                    sessionId = parts[1];
                    relayUrl = "wss://" + relayHostPort;
                    System.out.println("[Tunnely UI] Legacy endpoint format detected, assuming WSS");
                }
                JoinFriendsScreen.this.statusMessage = "\u00a7eConnecting to " + this.hostName + "'s server...";
                JoinFriendsScreen.this.statusColor = 0xFFFF00;
                ClientTunnelManager clientManager = ClientTunnelManager.getInstance();
                clientManager.connectToServer((String)relayUrl, sessionId, () -> JoinFriendsScreen.this.minecraft.execute(() -> {
                    JoinFriendsScreen.this.statusMessage = "\u00a7aConnecting to Minecraft server...";
                    JoinFriendsScreen.this.statusColor = 65280;
                    System.out.println("[Tunnely UI] Successfully connected to " + this.hostName + "'s server");
                }), error -> JoinFriendsScreen.this.minecraft.execute(() -> {
                    System.err.println("[Tunnely UI] Connection error: " + error);
                    String errorType = this.categorizeError((String)error);
                    JoinFriendsScreen.this.minecraft.setScreen((Screen)new ConnectionInfoScreen(JoinFriendsScreen.this.parent, this.hostName + "'s Server", errorType, (String)error, errorType.equals("FULL") || errorType.equals("CONNECTION_FAILED") ? this::joinServer : null));
                }));
            }

            private String categorizeError(String error) {
                if (error == null) {
                    return "GENERIC";
                }
                String lowerError = error.toLowerCase();
                if (lowerError.contains("full") || lowerError.contains("capacity")) {
                    return "FULL";
                }
                if (lowerError.contains("not authorized") || lowerError.contains("unauthorized")) {
                    return "NOT_AUTHORIZED";
                }
                if (lowerError.contains("not found") || lowerError.contains("session not found")) {
                    return "NOT_FOUND";
                }
                if (lowerError.contains("connection") || lowerError.contains("timeout") || lowerError.contains("failed to connect")) {
                    return "CONNECTION_FAILED";
                }
                if (lowerError.contains("incompatible") || lowerError.contains("version")) {
                    return "INCOMPATIBLE";
                }
                return "GENERIC";
            }

            public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                graphics.drawString(JoinFriendsScreen.this.font, "\u00a7b" + this.hostName, left + 5, top + 5, 0xFFFFFF);
                graphics.drawString(JoinFriendsScreen.this.font, "\u00a77" + this.endpoint, left + 5, top + 18, 0xAAAAAA);
                graphics.drawString(JoinFriendsScreen.this.font, "\u00a7e" + this.gameMode, left + 5, top + 28, 0xFFFFFF);
                this.joinButton.setX(left + width - 70);
                this.joinButton.setY(top + 10);
                this.joinButton.render(graphics, mouseX, mouseY, partialTick);
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                return this.joinButton.mouseClicked(mouseX, mouseY, button);
            }

            public Component getNarration() {
                return Component.literal((String)(this.hostName + " - " + this.endpoint));
            }
        }
    }
}

