/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.worlds.WorldNotification;
import org.texboobcat.tunnelyrefab.worlds.ui.NotificationBell;
import org.texboobcat.tunnelyrefab.worlds.ui.NotificationPanelData;

public class NotificationPanelScreen
extends Screen {
    private final Screen parent;
    private final NotificationBell notificationBell;
    private List<NotificationPanelData.NotificationItem> items;
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;
    private NotificationPanelData.NotificationItem hoveredItem = null;

    public NotificationPanelScreen(Screen parent, NotificationBell notificationBell) {
        super((Component)Component.literal((String)"Notifications"));
        this.parent = parent;
        this.notificationBell = notificationBell;
        List<WorldNotification> notifications = notificationBell.getNotifications();
        this.items = NotificationPanelData.formatNotifications(notifications);
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        int buttonY = this.height - 30;
        if (this.notificationBell.getUnreadCount() > 0) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Mark All Read"), button -> this.markAllRead()).bounds(centerX - 105, buttonY, 100, 20).build());
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Close"), button -> this.minecraft.setScreen(this.parent)).bounds(centerX + 5, buttonY, 100, 20).build());
        this.updateMaxScroll();
    }

    private void markAllRead() {
        this.notificationBell.markAllAsRead();
        this.minecraft.setScreen((Screen)new NotificationPanelScreen(this.parent, this.notificationBell));
    }

    private void updateMaxScroll() {
        int contentHeight = this.items.size() * 70;
        int visibleHeight = this.height - 120;
        this.maxScrollOffset = Math.max(0, contentHeight - visibleHeight);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        String title = NotificationPanelData.getPanelHeader(this.notificationBell.getUnreadCount());
        graphics.drawCenteredString(this.font, title, this.width / 2, 15, 0xFFFFFF);
        this.renderNotifications(graphics, mouseX, mouseY);
        if (this.maxScrollOffset > 0) {
            graphics.drawString(this.font, "\u2195 Scroll for more", this.width / 2 - 40, this.height - 50, 0x888888);
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.fill(0, 0, this.width, this.height, -15724528);
    }

    private void renderNotifications(GuiGraphics graphics, int mouseX, int mouseY) {
        int startY = 40;
        int endY = this.height - 60;
        int centerX = this.width / 2;
        int contentWidth = Math.min(500, this.width - 40);
        int contentX = centerX - contentWidth / 2;
        graphics.enableScissor(0, startY, this.width, endY);
        if (this.items.isEmpty()) {
            graphics.drawCenteredString(this.font, NotificationPanelData.getEmptyMessage(), centerX, startY + 30, 0x888888);
        } else {
            int y = startY - this.scrollOffset;
            this.hoveredItem = null;
            for (NotificationPanelData.NotificationItem item : this.items) {
                boolean hovered;
                boolean bl = hovered = mouseX >= contentX && mouseX <= contentX + contentWidth && mouseY >= y && mouseY <= y + 65;
                if (hovered) {
                    this.hoveredItem = item;
                }
                this.renderNotificationItem(graphics, item, contentX, y, contentWidth, hovered);
                y += 70;
            }
        }
        graphics.disableScissor();
    }

    private void renderNotificationItem(GuiGraphics graphics, NotificationPanelData.NotificationItem item, int x, int y, int width, boolean hovered) {
        Object message;
        int bgColor = item.backgroundColor;
        if (bgColor == 0) {
            bgColor = hovered ? 0x40404040 : 0x40202020;
        }
        graphics.fill(x, y, x + width, y + 65, bgColor);
        graphics.fill(x, y, x + width, y + 1, -12566464);
        graphics.drawString(this.font, item.icon, x + 5, y + 5, item.textColor);
        graphics.drawString(this.font, item.title, x + 25, y + 5, item.textColor);
        if (!item.isRead) {
            graphics.fill(x + width - 10, y + 5, x + width - 5, y + 10, -13408513);
        }
        if (this.font.width((String)(message = item.message)) > width - 30) {
            while (this.font.width((String)message + "...") > width - 30 && ((String)message).length() > 0) {
                message = ((String)message).substring(0, ((String)message).length() - 1);
            }
            message = (String)message + "...";
        }
        graphics.drawString(this.font, (String)message, x + 25, y + 20, 0xAAAAAA);
        graphics.drawString(this.font, "\u00a77" + item.time, x + 25, y + 35, 0x888888);
        if (item.isCritical) {
            graphics.drawString(this.font, "\u00a7c\u00a7l!", x + width - 20, y + 5, -52429);
        }
        if (hovered) {
            graphics.drawString(this.font, "\u00a77Click to mark as read", x + 5, y + 50, 0x666666);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hoveredItem != null) {
            if (!this.hoveredItem.isRead) {
                this.notificationBell.markAsRead(this.hoveredItem.id);
            }
            return true;
        }
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double scrollDelta) {
        this.scrollOffset -= (int)(scrollDelta * 20.0);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScrollOffset));
        return true;
    }

    public boolean isPauseScreen() {
        return true;
    }
}

