/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.messaging.MessageManager;
import org.texboobcat.tunnelyrefab.presence.PresenceManager;
import org.texboobcat.tunnelyrefab.tunnel.ClientTunnelManager;
import org.texboobcat.tunnelyrefab.ui.models.FriendsDataModels;
import org.texboobcat.tunnelyrefab.ui.screens.ChatScreen;
import org.texboobcat.tunnelyrefab.ui.screens.ConnectionInfoScreen;
import org.texboobcat.tunnelyrefab.util.CompatibilityDetector;

public class UnifiedFriendsScreen
extends Screen {
    private final Screen parent;
    private Tab currentTab = Tab.FRIENDS;
    private List<FriendsDataModels.FriendEntry> acceptedFriends = new ArrayList<FriendsDataModels.FriendEntry>();
    private List<FriendsDataModels.PendingRequestEntry> incomingRequests = new ArrayList<FriendsDataModels.PendingRequestEntry>();
    private List<FriendsDataModels.PendingRequestEntry> outgoingRequests = new ArrayList<FriendsDataModels.PendingRequestEntry>();
    private List<FriendsDataModels.ServerEntry> activeServers = new ArrayList<FriendsDataModels.ServerEntry>();
    private EditBox addFriendBox;
    private int scrollOffset = 0;
    private final int ITEM_HEIGHT = 40;
    private String statusMessage = "\u00a7eLoading...";
    private int statusColor = 0xFFFF55;
    private int unreadMessageCount = 0;
    private final Consumer<Integer> unreadCountListener = count -> this.minecraft.execute(() -> {
        this.unreadMessageCount = count;
        this.updateStatusMessage();
    });

    public UnifiedFriendsScreen(Screen parent) {
        super((Component)Component.literal((String)"Friends & Servers"));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\ud83d\udc65 Friends"), button -> this.switchTab(Tab.FRIENDS)).bounds(centerX - 155, 35, 150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\ud83c\udfae Servers"), button -> this.switchTab(Tab.SERVERS)).bounds(centerX + 5, 35, 150, 20).build());
        this.addFriendBox = new EditBox(this.font, centerX - 105, this.height - 95, 140, 20, (Component)Component.literal((String)"Username"));
        this.addFriendBox.setMaxLength(16);
        this.addFriendBox.setHint((Component)Component.literal((String)"Add friend..."));
        this.addRenderableWidget((GuiEventListener)this.addFriendBox);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"+ Add"), button -> this.addFriend()).bounds(centerX + 40, this.height - 95, 60, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\ud83d\udd04 Refresh"), button -> this.loadData()).bounds(centerX - 105, this.height - 50, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), button -> this.minecraft.setScreen(this.parent)).bounds(centerX + 5, this.height - 50, 100, 20).build());
        MessageManager.getInstance().subscribeToUnreadCount(this.unreadCountListener);
        this.loadData();
    }

    private void switchTab(Tab tab) {
        if (this.currentTab != tab) {
            this.currentTab = tab;
            this.scrollOffset = 0;
            this.updateStatusMessage();
        }
    }

    private void loadData() {
        this.statusMessage = "\u00a7eLoading...";
        new Thread(() -> {
            this.loadFriendsData();
            this.loadServersData();
            this.minecraft.execute(this::updateStatusMessage);
        }, "Tunnely-LoadData").start();
    }

    private void loadFriendsData() {
        try {
            SupabaseClient client = new SupabaseClient();
            String currentUserId = TunnelConfig.getInstance().getSupabaseUserId();
            SupabaseClient.FriendListResult friendsResult = client.getFriends();
            if (friendsResult.success) {
                ArrayList<FriendsDataModels.FriendEntry> newFriends = new ArrayList<FriendsDataModels.FriendEntry>();
                JsonArray friendsArray = JsonParser.parseString((String)friendsResult.data).getAsJsonArray();
                for (Iterator element : friendsArray) {
                    JsonObject friendProfile;
                    JsonObject friend = element.getAsJsonObject();
                    String id = friend.get("id").getAsString();
                    String userId = friend.get("user_id").getAsString();
                    String friendIdInRow = friend.get("friend_id").getAsString();
                    boolean weAreUser = userId.equals(currentUserId);
                    String actualFriendId = weAreUser ? friendIdInRow : userId;
                    String username = this.extractUsername(friend, "friend");
                    PresenceManager.OnlineStatus status = PresenceManager.OnlineStatus.OFFLINE;
                    if (friend.has("friend") && !friend.get("friend").isJsonNull() && (friendProfile = friend.getAsJsonObject("friend")).has("last_seen") && !friendProfile.get("last_seen").isJsonNull()) {
                        String lastSeen = friendProfile.get("last_seen").getAsString();
                        status = PresenceManager.getOnlineStatus(lastSeen);
                    }
                    newFriends.add(new FriendsDataModels.FriendEntry(id, actualFriendId, username, status));
                }
                this.minecraft.execute(() -> {
                    this.acceptedFriends = newFriends;
                });
            }
            SupabaseClient.FriendListResult incomingResult = client.getPendingFriendRequests();
            if (incomingResult.success) {
                ArrayList<FriendsDataModels.PendingRequestEntry> newIncoming = new ArrayList<FriendsDataModels.PendingRequestEntry>();
                JsonArray requestsArray = JsonParser.parseString((String)incomingResult.data).getAsJsonArray();
                for (JsonElement element : requestsArray) {
                    JsonObject request = element.getAsJsonObject();
                    String id = request.get("id").getAsString();
                    String requestUserId = request.get("user_id").getAsString();
                    String username = this.extractUsername(request, "requester");
                    newIncoming.add(new FriendsDataModels.PendingRequestEntry(id, requestUserId, username, true));
                }
                this.minecraft.execute(() -> {
                    this.incomingRequests = newIncoming;
                });
            }
            SupabaseClient.FriendListResult outgoingResult = client.getOutgoingFriendRequests();
            if (outgoingResult.success) {
                ArrayList<FriendsDataModels.PendingRequestEntry> newOutgoing = new ArrayList<FriendsDataModels.PendingRequestEntry>();
                JsonArray requestsArray = JsonParser.parseString((String)outgoingResult.data).getAsJsonArray();
                for (JsonElement element : requestsArray) {
                    JsonObject request = element.getAsJsonObject();
                    String id = request.get("id").getAsString();
                    String requestFriendId = request.get("friend_id").getAsString();
                    String username = this.extractUsername(request, "friend");
                    newOutgoing.add(new FriendsDataModels.PendingRequestEntry(id, requestFriendId, username, false));
                }
                this.minecraft.execute(() -> {
                    this.outgoingRequests = newOutgoing;
                });
            }
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Error loading friends: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String extractUsername(JsonObject obj, String profileField) {
        JsonObject profile;
        if (obj.has(profileField) && !obj.get(profileField).isJsonNull() && (profile = obj.getAsJsonObject(profileField)).has("minecraft_name")) {
            return profile.get("minecraft_name").getAsString();
        }
        return "Unknown";
    }

    private void loadServersData() {
        try {
            SupabaseClient client = new SupabaseClient();
            SupabaseClient.ServerListResult result = client.getFriendServers();
            if (result.success) {
                ArrayList<FriendsDataModels.ServerEntry> newServers = new ArrayList<FriendsDataModels.ServerEntry>();
                JsonArray serversArray = JsonParser.parseString((String)result.data).getAsJsonArray();
                CompatibilityDetector.CompatibilityInfo clientCompat = CompatibilityDetector.detect();
                for (JsonElement element : serversArray) {
                    JsonObject server = element.getAsJsonObject();
                    String serverId = server.get("id").getAsString();
                    String endpoint = server.has("public_endpoint") && !server.get("public_endpoint").isJsonNull() ? server.get("public_endpoint").getAsString() : null;
                    if (endpoint == null) continue;
                    String gameMode = server.has("game_mode") ? server.get("game_mode").getAsString() : "survival";
                    String serverName = server.has("server_name") ? server.get("server_name").getAsString() : "Server";
                    String hostName = this.extractUsername(server, "host");
                    String mcVersion = this.getStringOrNull(server, "minecraft_version");
                    String modLoader = this.getStringOrNull(server, "mod_loader");
                    String modpackId = this.getStringOrNull(server, "modpack_id");
                    String modpackVersion = this.getStringOrNull(server, "modpack_version");
                    CompatibilityDetector.CompatibilityInfo serverCompat = new CompatibilityDetector.CompatibilityInfo(mcVersion, modLoader, modpackId, modpackVersion);
                    boolean isCompatible = clientCompat.isCompatibleWith(serverCompat);
                    newServers.add(new FriendsDataModels.ServerEntry(serverId, endpoint, hostName, serverName, gameMode, serverCompat, isCompatible));
                }
                this.minecraft.execute(() -> {
                    this.activeServers = newServers;
                });
            }
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Error loading servers: " + e.getMessage());
        }
    }

    private String getStringOrNull(JsonObject obj, String field) {
        return obj.has(field) && !obj.get(field).isJsonNull() ? obj.get(field).getAsString() : null;
    }

    private void updateStatusMessage() {
        if (this.currentTab == Tab.FRIENDS) {
            int total = this.acceptedFriends.size();
            int pending = this.incomingRequests.size();
            StringBuilder sb = new StringBuilder();
            if (this.unreadMessageCount > 0) {
                sb.append("\u00a7e\ud83d\udcac ").append(this.unreadMessageCount).append(" unread");
                if (pending > 0 || total > 0) {
                    sb.append(" \u2022 ");
                }
            }
            if (pending > 0) {
                sb.append("\u00a7e").append(pending).append(" pending");
                if (total > 0) {
                    sb.append(" \u2022 ");
                }
            }
            if (total > 0) {
                sb.append("\u00a77").append(total).append(" friend").append(total != 1 ? "s" : "");
            }
            if (sb.length() == 0) {
                sb.append("\u00a77No friends yet");
            }
            this.statusMessage = sb.toString();
            this.statusColor = this.unreadMessageCount > 0 || pending > 0 ? 0xFFFF55 : 0xAAAAAA;
        } else {
            int total = this.activeServers.size();
            long compatible = this.activeServers.stream().filter(s -> s.isCompatible).count();
            this.statusMessage = total == 0 ? "\u00a77No active servers" : "\u00a77" + total + " server" + (total != 1 ? "s" : "") + " \u2022 \u00a7a" + compatible + " compatible";
            this.statusColor = 0xAAAAAA;
        }
    }

    private void addFriend() {
        String username = this.addFriendBox.getValue().trim();
        if (username.isEmpty() || !username.matches("^[a-zA-Z0-9_]{3,16}$")) {
            this.statusMessage = "\u00a7cInvalid username";
            this.statusColor = 0xFF5555;
            return;
        }
        this.statusMessage = "\u00a7eSending...";
        new Thread(() -> {
            boolean success = new SupabaseClient().sendFriendRequestByUsername(username);
            this.minecraft.execute(() -> {
                this.statusMessage = success ? "\u00a7aRequest sent!" : "\u00a7cFailed";
                int n = this.statusColor = success ? 0x55FF55 : 0xFF5555;
                if (success) {
                    this.addFriendBox.setValue("");
                    this.loadFriendsData();
                }
            });
        }, "Tunnely-AddFriend").start();
    }

    private void removeFriend(String id, String username) {
        new Thread(() -> {
            boolean success = new SupabaseClient().removeFriend(id);
            this.minecraft.execute(() -> {
                if (success) {
                    this.statusMessage = "\u00a7aRemoved " + username;
                    this.loadFriendsData();
                }
            });
        }, "Tunnely-Remove").start();
    }

    private void acceptRequest(String id, String username) {
        new Thread(() -> {
            boolean success = new SupabaseClient().acceptFriendRequest(id);
            this.minecraft.execute(() -> {
                if (success) {
                    this.statusMessage = "\u00a7aAccepted!";
                    this.loadFriendsData();
                }
            });
        }, "Tunnely-Accept").start();
    }

    private void rejectRequest(String id) {
        new Thread(() -> {
            boolean success = new SupabaseClient().rejectFriendRequest(id);
            this.minecraft.execute(() -> {
                if (success) {
                    this.loadFriendsData();
                }
            });
        }, "Tunnely-Reject").start();
    }

    private void cancelRequest(String id) {
        new Thread(() -> {
            boolean success = new SupabaseClient().cancelFriendRequest(id);
            this.minecraft.execute(() -> {
                if (success) {
                    this.loadFriendsData();
                }
            });
        }, "Tunnely-Cancel").start();
    }

    private void joinServer(String id, String endpoint) {
        Object serverName = "Friend's Server";
        for (FriendsDataModels.ServerEntry server : this.activeServers) {
            if (!server.id.equals(id)) continue;
            serverName = server.hostName + "'s Server";
            break;
        }
        String finalServerName = serverName;
        new Thread(() -> {
            try {
                ClientTunnelManager manager = ClientTunnelManager.getInstance();
                manager.connectToServer(endpoint, id, () -> this.minecraft.execute(() -> {
                    this.statusMessage = "\u00a7aConnected!";
                }), errorMsg -> this.minecraft.execute(() -> {
                    System.err.println("[Tunnely UI] Connection error: " + errorMsg);
                    String errorType = this.categorizeError((String)errorMsg);
                    this.minecraft.setScreen((Screen)new ConnectionInfoScreen(this, finalServerName, errorType, (String)errorMsg, errorType.equals("FULL") || errorType.equals("CONNECTION_FAILED") ? () -> this.joinServer(id, endpoint) : null));
                }));
            }
            catch (Exception e) {
                this.minecraft.execute(() -> {
                    String errorType = this.categorizeError(e.getMessage());
                    this.minecraft.setScreen((Screen)new ConnectionInfoScreen(this, finalServerName, errorType, e.getMessage(), null));
                });
            }
        }, "Tunnely-Join").start();
    }

    private String categorizeError(String error) {
        if (error == null) {
            return "GENERIC";
        }
        String lowerError = error.toLowerCase();
        if (lowerError.contains("full") || lowerError.contains("capacity")) {
            return "FULL";
        }
        if (lowerError.contains("not authorized") || lowerError.contains("unauthorized")) {
            return "NOT_AUTHORIZED";
        }
        if (lowerError.contains("not found") || lowerError.contains("session not found")) {
            return "NOT_FOUND";
        }
        if (lowerError.contains("connection") || lowerError.contains("timeout") || lowerError.contains("failed to connect")) {
            return "CONNECTION_FAILED";
        }
        if (lowerError.contains("incompatible") || lowerError.contains("version")) {
            return "INCOMPATIBLE";
        }
        return "GENERIC";
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        int centerX = this.width / 2;
        graphics.drawCenteredString(this.font, "\u00a76\u00a7lFriends & Servers", centerX, 15, 0xFFFFFF);
        int underlineStart = this.currentTab == Tab.FRIENDS ? centerX - 155 : centerX + 5;
        graphics.fill(underlineStart, 54, underlineStart + 150, 56, -10496);
        int contentTop = 65;
        int contentBottom = this.height - 110;
        graphics.enableScissor(0, contentTop, this.width, contentBottom);
        if (this.currentTab == Tab.FRIENDS) {
            this.renderFriendsTab(graphics, mouseX, mouseY, contentTop, contentBottom - contentTop);
        } else {
            this.renderServersTab(graphics, mouseX, mouseY, contentTop, contentBottom - contentTop);
        }
        graphics.disableScissor();
        graphics.drawCenteredString(this.font, this.statusMessage, centerX, this.height - 70, this.statusColor);
        graphics.drawString(this.font, "\u00a77Add Friend:", centerX - 105, this.height - 108, 0xAAAAAA);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.fill(0, 0, this.width, this.height, -15724528);
    }

    private void renderFriendsTab(GuiGraphics graphics, int mouseX, int mouseY, int top, int height) {
        int y = top - this.scrollOffset;
        int centerX = this.width / 2;
        if (!this.incomingRequests.isEmpty()) {
            graphics.drawString(this.font, "\u00a7e\u00a7lPending Requests (" + this.incomingRequests.size() + ")", centerX - 150, y, 0xFFFF55);
            y += 20;
            for (FriendsDataModels.PendingRequestEntry req : this.incomingRequests) {
                if (y > top - 40 && y < top + height) {
                    this.renderPendingRequest(graphics, mouseX, mouseY, centerX, y, req, true);
                }
                y += 40;
            }
            y += 10;
        }
        if (!this.acceptedFriends.isEmpty()) {
            graphics.drawString(this.font, "\u00a7a\u00a7lFriends (" + this.acceptedFriends.size() + ")", centerX - 150, y, 0x55FF55);
            y += 20;
            for (FriendsDataModels.FriendEntry friend : this.acceptedFriends) {
                if (y > top - 40 && y < top + height) {
                    this.renderFriend(graphics, mouseX, mouseY, centerX, y, friend);
                }
                y += 40;
            }
        }
        if (!this.outgoingRequests.isEmpty()) {
            graphics.drawString(this.font, "\u00a77\u00a7lPending Sent (" + this.outgoingRequests.size() + ")", centerX - 150, y += 10, 0xAAAAAA);
            y += 20;
            for (FriendsDataModels.PendingRequestEntry req : this.outgoingRequests) {
                if (y > top - 40 && y < top + height) {
                    this.renderPendingRequest(graphics, mouseX, mouseY, centerX, y, req, false);
                }
                y += 40;
            }
        }
        if (this.acceptedFriends.isEmpty() && this.incomingRequests.isEmpty() && this.outgoingRequests.isEmpty()) {
            graphics.drawCenteredString(this.font, "\u00a77No friends yet", centerX, top + 50, 0xAAAAAA);
            graphics.drawCenteredString(this.font, "\u00a77Add a friend using the box below!", centerX, top + 65, 0xAAAAAA);
        }
    }

    private void renderPendingRequest(GuiGraphics graphics, int mouseX, int mouseY, int centerX, int y, FriendsDataModels.PendingRequestEntry req, boolean incoming) {
        int bgColor = incoming ? -2130716928 : 0x40555555;
        graphics.fill(centerX - 150, y, centerX + 150, y + 40 - 2, bgColor);
        graphics.drawString(this.font, "\u00a7f" + req.username, centerX - 140, y + 8, 0xFFFFFF);
        String subtext = incoming ? "\u00a77wants to be friends" : "\u00a78Waiting...";
        graphics.drawString(this.font, subtext, centerX - 140, y + 20, incoming ? 0xAAAAAA : 0x555555);
        if (incoming) {
            this.renderButton(graphics, mouseX, mouseY, centerX + 40, y + 10, 45, "Accept", -16733696, -16724992);
            this.renderButton(graphics, mouseX, mouseY, centerX + 90, y + 10, 45, "Reject", -5636096, -3407872);
        } else {
            this.renderButton(graphics, mouseX, mouseY, centerX + 80, y + 10, 55, "Cancel", -8961024, -5614336);
        }
    }

    private void renderFriend(GuiGraphics graphics, int mouseX, int mouseY, int centerX, int y, FriendsDataModels.FriendEntry friend) {
        graphics.fill(centerX - 150, y, centerX + 150, y + 40 - 2, 0x40555555);
        String statusIndicator = friend.onlineStatus.indicator;
        graphics.drawString(this.font, statusIndicator + " \u00a7f" + friend.username, centerX - 140, y + 13, 0xFFFFFF);
        this.renderButton(graphics, mouseX, mouseY, centerX + 20, y + 10, 55, "\ud83d\udcac Chat", -16759689, -16750934);
        this.renderButton(graphics, mouseX, mouseY, centerX + 80, y + 10, 55, "Remove", -8978432, -3407872);
    }

    private void renderServersTab(GuiGraphics graphics, int mouseX, int mouseY, int top, int height) {
        int y = top - this.scrollOffset;
        int centerX = this.width / 2;
        if (this.activeServers.isEmpty()) {
            graphics.drawCenteredString(this.font, "\u00a77No active servers", centerX, top + 50, 0xAAAAAA);
            return;
        }
        for (FriendsDataModels.ServerEntry server : this.activeServers) {
            if (y > top - 40 && y < top + height) {
                this.renderServer(graphics, mouseX, mouseY, centerX, y, server);
            }
            y += 40;
        }
    }

    private void renderServer(GuiGraphics graphics, int mouseX, int mouseY, int centerX, int y, FriendsDataModels.ServerEntry server) {
        int bgColor = server.isCompatible ? 0x40555555 : 1079325491;
        graphics.fill(centerX - 150, y, centerX + 150, y + 40 - 2, bgColor);
        String icon = server.isCompatible ? "\u00a7a\u2713" : "\u00a7c\u2717";
        graphics.drawString(this.font, icon + " \u00a7f" + server.serverName, centerX - 140, y + 6, 0xFFFFFF);
        graphics.drawString(this.font, "\u00a77" + server.hostName + " \u2022 " + server.gameMode, centerX - 140, y + 18, 0xAAAAAA);
        if (server.compatibility.minecraftVersion != null) {
            String badge = "\u00a7e" + server.compatibility.minecraftVersion;
            if (server.compatibility.modLoader != null) {
                String loaderColor = server.compatibility.modLoader.equals("fabric") ? "\u00a7b" : "\u00a7c";
                badge = badge + " " + loaderColor + server.compatibility.modLoader.toUpperCase();
            }
            graphics.drawString(this.font, badge, centerX - 140, y + 29, 0xFFFFFF);
        }
        int joinColor = server.isCompatible ? -16733696 : -8961024;
        int joinHover = server.isCompatible ? -16724992 : -5614336;
        this.renderButton(graphics, mouseX, mouseY, centerX + 85, y + 10, 50, "Join", joinColor, joinHover);
    }

    private void renderButton(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, int width, String text, int color, int hoverColor) {
        boolean hover = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + 18;
        graphics.fill(x, y, x + width, y + 18, hover ? hoverColor : color);
        graphics.drawCenteredString(this.font, "\u00a7f" + text, x + width / 2, y + 5, 0xFFFFFF);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        int contentTop = 65;
        int contentBottom = this.height - 110;
        if (mouseY < (double)contentTop || mouseY > (double)contentBottom) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        int y = contentTop - this.scrollOffset;
        int centerX = this.width / 2;
        if (this.currentTab == Tab.FRIENDS) {
            return this.handleFriendsClick(mouseX, mouseY, centerX, y);
        }
        return this.handleServersClick(mouseX, mouseY, centerX, y);
    }

    private boolean handleFriendsClick(double mouseX, double mouseY, int centerX, int y) {
        if (!this.incomingRequests.isEmpty()) {
            y += 20;
            for (FriendsDataModels.PendingRequestEntry req : this.incomingRequests) {
                if (mouseY >= (double)y && mouseY < (double)(y + 40)) {
                    if (this.clickInButton(mouseX, mouseY, centerX + 40, y + 10, 45)) {
                        this.acceptRequest(req.id, req.username);
                        return true;
                    }
                    if (this.clickInButton(mouseX, mouseY, centerX + 90, y + 10, 45)) {
                        this.rejectRequest(req.id);
                        return true;
                    }
                }
                y += 40;
            }
            y += 10;
        }
        if (!this.acceptedFriends.isEmpty()) {
            y += 20;
            for (FriendsDataModels.FriendEntry friend : this.acceptedFriends) {
                if (mouseY >= (double)y && mouseY < (double)(y + 40)) {
                    if (this.clickInButton(mouseX, mouseY, centerX + 20, y + 10, 55)) {
                        this.minecraft.setScreen((Screen)new ChatScreen(this, friend.friendId, friend.username));
                        return true;
                    }
                    if (this.clickInButton(mouseX, mouseY, centerX + 80, y + 10, 55)) {
                        this.removeFriend(friend.id, friend.username);
                        return true;
                    }
                }
                y += 40;
            }
        }
        if (!this.outgoingRequests.isEmpty()) {
            y += 30;
            for (FriendsDataModels.PendingRequestEntry req : this.outgoingRequests) {
                if (mouseY >= (double)y && mouseY < (double)(y + 40) && this.clickInButton(mouseX, mouseY, centerX + 80, y + 10, 55)) {
                    this.cancelRequest(req.id);
                    return true;
                }
                y += 40;
            }
        }
        return super.mouseClicked(mouseX, mouseY, 0);
    }

    private boolean handleServersClick(double mouseX, double mouseY, int centerX, int y) {
        for (FriendsDataModels.ServerEntry server : this.activeServers) {
            if (mouseY >= (double)y && mouseY < (double)(y + 40) && this.clickInButton(mouseX, mouseY, centerX + 85, y + 10, 50)) {
                this.joinServer(server.id, server.endpoint);
                return true;
            }
            y += 40;
        }
        return super.mouseClicked(mouseX, mouseY, 0);
    }

    private boolean clickInButton(double mouseX, double mouseY, int x, int y, int width) {
        return mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + 18);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double delta) {
        this.scrollOffset = Math.max(0, this.scrollOffset - (int)(delta * 10.0));
        return true;
    }

    public void onClose() {
        MessageManager.getInstance().unsubscribeFromUnreadCount(this.unreadCountListener);
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return true;
    }

    private static enum Tab {
        FRIENDS,
        SERVERS;

    }
}

