/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds.ui;

import org.texboobcat.tunnelyrefab.worlds.ScanResultDetails;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;

public class DownloadProtection {
    public static DownloadCheckResult checkDownloadSafety(WorldInfo world) {
        if (world == null) {
            return new DownloadCheckResult(CheckResult.BLOCKED, "\u26a0\ufe0f World Not Found", "The requested world could not be found.", null);
        }
        if (world.isQuarantined()) {
            ScanResultDetails details = world.getScanResultDetails();
            String summary = details != null ? details.getSummary() : "Failed security scan";
            return new DownloadCheckResult(CheckResult.BLOCKED, "\u26a0\ufe0f This World is Quarantined", "This world failed security scanning and cannot be downloaded.\n\nReason: " + summary + "\n\nContact the world author or support if you believe this is an error.", details);
        }
        if (world.isScanning()) {
            return new DownloadCheckResult(CheckResult.WARNING, "\u23f3 Scan in Progress", "This world is currently being scanned for security threats.\n\nPlease try again in a few moments.", null);
        }
        if (world.isScanPending()) {
            return new DownloadCheckResult(CheckResult.WARNING, "\u23f1\ufe0f Not Yet Scanned", "This world hasn't been scanned for security threats yet.\nIt may contain unsafe content.\n\nDo you want to download it anyway?", null);
        }
        if ("clean".equals(world.getScanStatus())) {
            return new DownloadCheckResult(CheckResult.SAFE, "\u2713 Safe to Download", "This world has passed security scanning.", null);
        }
        if ("failed".equals(world.getScanStatus())) {
            return new DownloadCheckResult(CheckResult.WARNING, "\u274c Scan Failed", "Security scanning failed for this world.\nThis doesn't mean it's unsafe, but it couldn't be verified.\n\nDownload at your own risk?", null);
        }
        return new DownloadCheckResult(CheckResult.SAFE, "Download", "Ready to download.", null);
    }

    public static String getDownloadButtonLabel(WorldInfo world) {
        if (world == null) {
            return "Download";
        }
        if (world.isQuarantined()) {
            return "\u26a0 Blocked";
        }
        if (world.isScanning()) {
            return "\u23f3 Scanning...";
        }
        if (world.isScanPending()) {
            return "\u23f1 Pending...";
        }
        if ("clean".equals(world.getScanStatus())) {
            return "\u2713 Download";
        }
        if ("failed".equals(world.getScanStatus())) {
            return "\u274c Download";
        }
        return "Download";
    }

    public static boolean isDownloadButtonEnabled(WorldInfo world) {
        if (world == null) {
            return false;
        }
        return !world.isQuarantined();
    }

    public static int getDownloadButtonColor(WorldInfo world) {
        if (world == null) {
            return -6710887;
        }
        if (world.isQuarantined()) {
            return -52429;
        }
        if (world.isScanning() || world.isScanPending()) {
            return -13261;
        }
        if ("clean".equals(world.getScanStatus())) {
            return -13369549;
        }
        if ("failed".equals(world.getScanStatus())) {
            return -26317;
        }
        return -1;
    }

    public static class DownloadCheckResult {
        private final CheckResult result;
        private final String title;
        private final String message;
        private final ScanResultDetails scanDetails;

        public DownloadCheckResult(CheckResult result, String title, String message, ScanResultDetails scanDetails) {
            this.result = result;
            this.title = title;
            this.message = message;
            this.scanDetails = scanDetails;
        }

        public CheckResult getResult() {
            return this.result;
        }

        public String getTitle() {
            return this.title;
        }

        public String getMessage() {
            return this.message;
        }

        public ScanResultDetails getScanDetails() {
            return this.scanDetails;
        }

        public boolean isBlocked() {
            return this.result == CheckResult.BLOCKED;
        }

        public boolean isWarning() {
            return this.result == CheckResult.WARNING;
        }

        public boolean isSafe() {
            return this.result == CheckResult.SAFE;
        }
    }

    public static enum CheckResult {
        SAFE,
        BLOCKED,
        WARNING;

    }
}

