/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds.ui;

import org.texboobcat.tunnelyrefab.worlds.WorldInfo;

public class ScanStatusColors {
    public static final int RED = -52429;
    public static final int ORANGE = -26317;
    public static final int YELLOW = -13261;
    public static final int GREEN = -13369549;
    public static final int GRAY = -6710887;
    public static final int WHITE = -1;
    public static final int DARK_RED = -10092544;
    public static final int LIGHT_BLUE = -13408513;

    public static int getStatusColor(WorldInfo world) {
        if (world == null) {
            return -6710887;
        }
        String status = world.getScanStatus();
        if (world.isQuarantined() || "infected".equals(status)) {
            return world.isHighThreat() ? -52429 : -26317;
        }
        switch (status) {
            case "clean": {
                return -13369549;
            }
            case "scanning": {
                return -13261;
            }
            case "pending": {
                return -13261;
            }
            case "failed": {
                return -6710887;
            }
        }
        return -6710887;
    }

    public static int getStatusBackgroundColor(WorldInfo world) {
        if (world == null) {
            return Integer.MIN_VALUE;
        }
        if (world.isQuarantined() || "infected".equals(world.getScanStatus())) {
            return world.isHighThreat() ? -2140798976 : -2140785920;
        }
        switch (world.getScanStatus()) {
            case "clean": {
                return -2147457536;
            }
            case "scanning": 
            case "pending": {
                return -2140772864;
            }
            case "failed": {
                return -2144128205;
            }
        }
        return Integer.MIN_VALUE;
    }

    public static int getThreatColor(String threatLevel) {
        if (threatLevel == null) {
            return -6710887;
        }
        switch (threatLevel.toLowerCase()) {
            case "critical": {
                return -52429;
            }
            case "high": {
                return -26317;
            }
            case "medium": {
                return -13261;
            }
            case "low": {
                return -13369549;
            }
        }
        return -1;
    }

    public static int getSeverityColor(String severity) {
        return ScanStatusColors.getThreatColor(severity);
    }
}

