/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.auth;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.awt.Desktop;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;

public class OAuthHelper {
    private static final int CALLBACK_PORT = 54321;
    private static final String CALLBACK_PATH = "/auth/callback";
    private static final int TIMEOUT_SECONDS = 120;
    private HttpServer callbackServer;
    private CompletableFuture<OAuthResult> resultFuture;

    public CompletableFuture<OAuthResult> startMicrosoftOAuth() {
        return this.startOAuthFlow("azure");
    }

    public CompletableFuture<OAuthResult> startOAuthFlow(String provider) {
        this.resultFuture = new CompletableFuture();
        try {
            this.startCallbackServer();
            String redirectUri = "http://localhost:54321/auth/callback";
            String supabaseUrl = TunnelConfig.getInstance().getSupabaseUrl();
            String scopes = "openid profile email";
            String oauthUrl = supabaseUrl + "/auth/v1/authorize?provider=" + provider + "&redirect_to=" + URLEncoder.encode(redirectUri, StandardCharsets.UTF_8.toString()) + "&scopes=" + URLEncoder.encode(scopes, StandardCharsets.UTF_8.toString());
            System.out.println("[Tunnely OAuth] Opening browser for " + provider + " login...");
            System.out.println("[Tunnely OAuth] OAuth URL: " + oauthUrl);
            this.openBrowser(oauthUrl);
            this.resultFuture.orTimeout(120L, TimeUnit.SECONDS).exceptionally(ex -> {
                this.stopCallbackServer();
                return new OAuthResult(false, null, null, "OAuth timeout - please try again");
            });
        }
        catch (Exception e) {
            System.err.println("[Tunnely OAuth] Failed to start OAuth flow: " + e.getMessage());
            e.printStackTrace();
            this.resultFuture.complete(new OAuthResult(false, null, null, "Failed to start OAuth: " + e.getMessage()));
            this.stopCallbackServer();
        }
        return this.resultFuture;
    }

    private void startCallbackServer() throws IOException {
        this.callbackServer = HttpServer.create(new InetSocketAddress(54321), 0);
        this.callbackServer.createContext(CALLBACK_PATH, exchange -> {
            try {
                this.handleCallback(exchange);
            }
            catch (Exception e) {
                System.err.println("[Tunnely OAuth] Error handling callback: " + e.getMessage());
                e.printStackTrace();
                this.sendErrorResponse(exchange, "Internal error processing OAuth callback");
            }
        });
        this.callbackServer.setExecutor(null);
        this.callbackServer.start();
        System.out.println("[Tunnely OAuth] Callback server started on port 54321");
    }

    private void handleCallback(HttpExchange exchange) throws IOException {
        String query = exchange.getRequestURI().getQuery();
        Map<String, String> params = this.parseQueryParams(query);
        System.out.println("[Tunnely OAuth] Received callback with params: " + String.valueOf(params.keySet()));
        if (params.containsKey("error")) {
            String error = params.get("error");
            String errorDescription = params.getOrDefault("error_description", "OAuth failed");
            System.err.println("[Tunnely OAuth] OAuth error: " + error + " - " + errorDescription);
            this.sendErrorResponse(exchange, "Authentication failed: " + errorDescription);
            this.resultFuture.complete(new OAuthResult(false, null, null, errorDescription));
            this.stopCallbackServer();
            return;
        }
        if (params.containsKey("access_token")) {
            String accessToken = params.get("access_token");
            String refreshToken = params.get("refresh_token");
            System.out.println("[Tunnely OAuth] Received access token via query params");
            this.sendSuccessResponse(exchange);
            this.resultFuture.complete(new OAuthResult(true, accessToken, refreshToken, null));
            this.stopCallbackServer();
            return;
        }
        if (params.containsKey("code")) {
            String authCode = params.get("code");
            System.out.println("[Tunnely OAuth] Received authorization code");
            this.sendSuccessResponse(exchange);
            this.resultFuture.complete(new OAuthResult(true, authCode, null, null, true));
            this.stopCallbackServer();
            return;
        }
        this.sendHashExtractorPage(exchange);
    }

    private void sendHashExtractorPage(HttpExchange exchange) throws IOException {
        String html = "<!DOCTYPE html>\n<html>\n<head>\n    <title>Tunnely - Authenticating...</title>\n    <style>\n        body {\n            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;\n            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);\n            display: flex;\n            justify-content: center;\n            align-items: center;\n            height: 100vh;\n            margin: 0;\n            color: white;\n        }\n        .container {\n            text-align: center;\n            background: rgba(255, 255, 255, 0.1);\n            padding: 40px;\n            border-radius: 20px;\n            backdrop-filter: blur(10px);\n        }\n        .spinner {\n            border: 4px solid rgba(255, 255, 255, 0.3);\n            border-top: 4px solid white;\n            border-radius: 50%;\n            width: 50px;\n            height: 50px;\n            animation: spin 1s linear infinite;\n            margin: 20px auto;\n        }\n        @keyframes spin {\n            0% { transform: rotate(0deg); }\n            100% { transform: rotate(360deg); }\n        }\n    </style>\n</head>\n<body>\n    <div class=\"container\">\n        <h1>\ud83c\udfae Tunnely</h1>\n        <div class=\"spinner\"></div>\n        <p>Completing authentication...</p>\n        <p id=\"status\">Please wait...</p>\n    </div>\n    <script>\n        // Extract tokens from URL hash\n        const hash = window.location.hash.substring(1);\n        const params = new URLSearchParams(hash);\n        const accessToken = params.get('access_token');\n        const refreshToken = params.get('refresh_token');\n        const error = params.get('error');\n\n        if (error) {\n            document.getElementById('status').textContent = 'Authentication failed: ' + error;\n            fetch('/auth/callback?error=' + encodeURIComponent(error));\n            setTimeout(() => window.close(), 3000);\n        } else if (accessToken) {\n            document.getElementById('status').textContent = 'Success! You can close this window.';\n            // Send tokens to callback server via query params\n            fetch('/auth/callback?access_token=' + encodeURIComponent(accessToken) +\n                  '&refresh_token=' + encodeURIComponent(refreshToken || ''))\n                .then(() => {\n                    setTimeout(() => window.close(), 2000);\n                });\n        } else {\n            document.getElementById('status').textContent = 'Waiting for authentication...';\n        }\n    </script>\n</body>\n</html>\n";
        byte[] response = html.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        exchange.sendResponseHeaders(200, response.length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(response);
        }
    }

    private void sendSuccessResponse(HttpExchange exchange) throws IOException {
        String html = "<!DOCTYPE html>\n<html>\n<head>\n    <title>Tunnely - Success</title>\n    <style>\n        body {\n            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;\n            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);\n            display: flex;\n            justify-content: center;\n            align-items: center;\n            height: 100vh;\n            margin: 0;\n            color: white;\n        }\n        .container {\n            text-align: center;\n            background: rgba(255, 255, 255, 0.1);\n            padding: 40px;\n            border-radius: 20px;\n            backdrop-filter: blur(10px);\n        }\n        .checkmark {\n            font-size: 64px;\n            margin-bottom: 20px;\n        }\n    </style>\n</head>\n<body>\n    <div class=\"container\">\n        <div class=\"checkmark\">\u2705</div>\n        <h1>Authentication Successful!</h1>\n        <p>You can close this window and return to Minecraft.</p>\n    </div>\n    <script>setTimeout(() => window.close(), 3000);</script>\n</body>\n</html>\n";
        byte[] response = html.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        exchange.sendResponseHeaders(200, response.length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(response);
        }
    }

    private void sendErrorResponse(HttpExchange exchange, String errorMessage) throws IOException {
        String html = "<!DOCTYPE html>\n<html>\n<head>\n    <title>Tunnely - Error</title>\n    <style>\n        body {\n            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;\n            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);\n            display: flex;\n            justify-content: center;\n            align-items: center;\n            height: 100vh;\n            margin: 0;\n            color: white;\n        }\n        .container {\n            text-align: center;\n            background: rgba(255, 255, 255, 0.1);\n            padding: 40px;\n            border-radius: 20px;\n            backdrop-filter: blur(10px);\n        }\n        .error-icon {\n            font-size: 64px;\n            margin-bottom: 20px;\n        }\n    </style>\n</head>\n<body>\n    <div class=\"container\">\n        <div class=\"error-icon\">\u274c</div>\n        <h1>Authentication Failed</h1>\n        <p>" + errorMessage + "</p>\n        <p>Please close this window and try again.</p>\n    </div>\n</body>\n</html>\n";
        byte[] response = html.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        exchange.sendResponseHeaders(400, response.length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(response);
        }
    }

    private Map<String, String> parseQueryParams(String query) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (query == null || query.isEmpty()) {
            return params;
        }
        for (String param : query.split("&")) {
            String[] pair = param.split("=", 2);
            if (pair.length != 2) continue;
            try {
                String key = URLDecoder.decode(pair[0], StandardCharsets.UTF_8.toString());
                String value = URLDecoder.decode(pair[1], StandardCharsets.UTF_8.toString());
                params.put(key, value);
            }
            catch (Exception e) {
                System.err.println("[Tunnely OAuth] Error decoding param: " + param);
            }
        }
        return params;
    }

    private void openBrowser(String url) {
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(new URI(url));
            } else {
                String os = System.getProperty("os.name").toLowerCase();
                Runtime runtime = Runtime.getRuntime();
                if (os.contains("win")) {
                    runtime.exec("rundll32 url.dll,FileProtocolHandler " + url);
                } else if (os.contains("mac")) {
                    runtime.exec("open " + url);
                } else if (os.contains("nix") || os.contains("nux")) {
                    runtime.exec("xdg-open " + url);
                } else {
                    System.err.println("[Tunnely OAuth] Unable to open browser on this OS. Please manually visit: " + url);
                }
            }
        }
        catch (Exception e) {
            System.err.println("[Tunnely OAuth] Failed to open browser: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void stopCallbackServer() {
        if (this.callbackServer != null) {
            this.callbackServer.stop(0);
            this.callbackServer = null;
            System.out.println("[Tunnely OAuth] Callback server stopped");
        }
    }

    public static class OAuthResult {
        public final boolean success;
        public final String token;
        public final String refreshToken;
        public final String error;
        public final boolean isAuthCode;

        public OAuthResult(boolean success, String token, String refreshToken, String error) {
            this(success, token, refreshToken, error, false);
        }

        public OAuthResult(boolean success, String token, String refreshToken, String error, boolean isAuthCode) {
            this.success = success;
            this.token = token;
            this.refreshToken = refreshToken;
            this.error = error;
            this.isAuthCode = isAuthCode;
        }
    }
}

