/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.tunnel.ClientTunnelManager;
import org.texboobcat.tunnelyrefab.ui.screens.ConnectionInfoScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WarningPopupScreen;
import org.texboobcat.tunnelyrefab.util.CompatibilityDetector;
import org.texboobcat.tunnelyrefab.util.SafeDisconnect;

public class PublicLobbiesScreen
extends Screen {
    private final Screen parent;
    private ServerListWidget serverList;
    private String statusMessage = "\u00a7eLoading public servers...";
    private int statusColor = 0xFFFF00;
    private Checkbox compatibleOnlyCheckbox;
    private CompatibilityDetector.CompatibilityInfo clientCompatibility;
    private String regionFilter = "ALL";
    private Button regionButton;
    private Button refreshButton;
    private Button backButton;
    private Set<String> availableRegions = new HashSet<String>();
    private volatile boolean isLoading = false;
    private List<JsonObject> cachedServers = new ArrayList<JsonObject>();
    private int totalServersCount = 0;
    private int compatibleServersCount = 0;
    private int totalPlayersOnline = 0;
    private static boolean warningShownThisSession = false;

    public PublicLobbiesScreen(Screen parent) {
        this(parent, false);
    }

    public PublicLobbiesScreen(Screen parent, boolean skipWarning) {
        super((Component)Component.m_237113_((String)"Public Lobbies"));
        this.parent = parent;
        this.clientCompatibility = CompatibilityDetector.detect();
        if (skipWarning) {
            warningShownThisSession = true;
        }
        System.out.println("[Tunnely] Client compatibility: " + this.clientCompatibility.toString());
    }

    private void cycleRegionFilter() {
        ArrayList<String> regions = new ArrayList<String>();
        regions.add("ALL");
        ArrayList<String> sortedRegions = new ArrayList<String>(this.availableRegions);
        Collections.sort(sortedRegions);
        regions.addAll(sortedRegions);
        int currentIndex = regions.indexOf(this.regionFilter);
        if (currentIndex == -1) {
            this.regionFilter = "ALL";
        } else {
            int nextIndex = (currentIndex + 1) % regions.size();
            this.regionFilter = (String)regions.get(nextIndex);
        }
    }

    private String regionButtonLabel() {
        if (this.availableRegions.isEmpty()) {
            return "Region: ALL";
        }
        return "Region: " + this.regionFilter;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (!warningShownThisSession && (this.clientCompatibility.modpackId == null || this.clientCompatibility.modpackId.isEmpty())) {
            System.out.println("[Tunnely] No modpack detected - showing compatibility warning popup");
            warningShownThisSession = true;
            this.f_96541_.m_91152_((Screen)new WarningPopupScreen(new PublicLobbiesScreen(this.parent, true), this.parent, "Warning: No Modpack Detected", "\u00a77You don't have a modpack file detected.\n\n\u00a77This means you're \u00a7chighly likely to be incompatible\u00a77\n\u00a77with most public servers.\n\n\u00a77Most public servers use modpacks from:\n\u00a78\u2022 \u00a77CurseForge\n\u00a78\u2022 \u00a77Modrinth\n\u00a78\u2022 \u00a77Custom modpacks\n\n\u00a77You can still browse, but check compatibility carefully!", 0xFFAA00, null));
            return;
        }
        this.serverList = new ServerListWidget(this.f_96541_, this.f_96543_, this.f_96544_, 70, this.f_96544_ - 60, 75);
        this.m_7787_((GuiEventListener)this.serverList);
        int buttonWidth = 100;
        int buttonSpacing = 8;
        int totalButtonsWidth = buttonWidth * 3 + buttonSpacing * 2 + 140;
        int startX = (this.f_96543_ - totalButtonsWidth) / 2;
        int buttonY = this.f_96544_ - 40;
        this.compatibleOnlyCheckbox = new Checkbox(startX, buttonY, 140, 20, (Component)Component.m_237113_((String)"Compatible Only"), false){

            public void m_5691_() {
                super.m_5691_();
                if (PublicLobbiesScreen.this.serverList != null) {
                    PublicLobbiesScreen.this.serverList.m_6987_(null);
                }
                if (!PublicLobbiesScreen.this.isLoading && !PublicLobbiesScreen.this.cachedServers.isEmpty()) {
                    PublicLobbiesScreen.this.applyFiltersAndRender();
                } else {
                    PublicLobbiesScreen.this.loadPublicServers();
                }
            }
        };
        this.m_142416_((GuiEventListener)this.compatibleOnlyCheckbox);
        this.regionButton = Button.m_253074_((Component)Component.m_237113_((String)this.regionButtonLabel()), button -> {
            this.cycleRegionFilter();
            button.m_93666_((Component)Component.m_237113_((String)this.regionButtonLabel()));
            if (!this.isLoading && !this.cachedServers.isEmpty()) {
                this.applyFiltersAndRender();
            } else {
                this.loadPublicServers();
            }
        }).m_252987_(startX + 140 + buttonSpacing, buttonY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.regionButton);
        this.refreshButton = Button.m_253074_((Component)Component.m_237113_((String)"\u27f3 Refresh"), button -> this.loadPublicServers()).m_252987_(startX + 140 + buttonSpacing + buttonWidth + buttonSpacing, buttonY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.refreshButton);
        this.backButton = Button.m_253074_((Component)Component.m_237113_((String)"Back"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(startX + 140 + buttonSpacing + (buttonWidth + buttonSpacing) * 2, buttonY, buttonWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.backButton);
        this.loadPublicServers();
    }

    private void loadPublicServers() {
        if (this.isLoading) {
            System.out.println("[Tunnely UI] Load already in progress; skipping new request");
            return;
        }
        this.isLoading = true;
        System.out.println("[Tunnely UI] ===== LOADING PUBLIC SERVERS =====");
        this.statusMessage = "\u00a7eLoading public servers...";
        this.statusColor = 0xFFFF00;
        this.serverList.clear();
        this.availableRegions.clear();
        this.cachedServers.clear();
        this.totalServersCount = 0;
        this.compatibleServersCount = 0;
        this.totalPlayersOnline = 0;
        if (this.compatibleOnlyCheckbox != null) {
            this.compatibleOnlyCheckbox.f_93623_ = false;
        }
        if (this.regionButton != null) {
            this.regionButton.f_93623_ = false;
        }
        if (this.refreshButton != null) {
            this.refreshButton.f_93623_ = false;
        }
        if (this.backButton != null) {
            this.backButton.f_93623_ = false;
        }
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                SupabaseClient.ServerListResult result = client.getPublicServers();
                this.f_96541_.execute(() -> {
                    if (result.success) {
                        try {
                            System.out.println("[Tunnely UI] Parsing public server data...");
                            JsonArray servers = JsonParser.parseString((String)result.data).getAsJsonArray();
                            System.out.println("[Tunnely UI] Found " + servers.size() + " public server(s)");
                            this.cachedServers.clear();
                            for (JsonElement element : servers) {
                                this.cachedServers.add(element.getAsJsonObject());
                            }
                            this.applyFiltersAndRender();
                            if (this.regionButton != null) {
                                this.regionButton.m_93666_((Component)Component.m_237113_((String)this.regionButtonLabel()));
                            }
                            if (this.compatibleOnlyCheckbox != null) {
                                this.compatibleOnlyCheckbox.f_93623_ = true;
                            }
                            if (this.regionButton != null) {
                                this.regionButton.f_93623_ = true;
                            }
                            if (this.refreshButton != null) {
                                this.refreshButton.f_93623_ = true;
                            }
                            if (this.backButton != null) {
                                this.backButton.f_93623_ = true;
                            }
                            this.isLoading = false;
                        }
                        catch (Exception e) {
                            this.statusMessage = "\u00a7cFailed to parse server list";
                            this.statusColor = 0xFF0000;
                            System.err.println("[Tunnely UI] \u2717 Exception parsing public servers: " + e.getMessage());
                            e.printStackTrace();
                            if (this.compatibleOnlyCheckbox != null) {
                                this.compatibleOnlyCheckbox.f_93623_ = true;
                            }
                            if (this.regionButton != null) {
                                this.regionButton.f_93623_ = true;
                            }
                            if (this.refreshButton != null) {
                                this.refreshButton.f_93623_ = true;
                            }
                            if (this.backButton != null) {
                                this.backButton.f_93623_ = true;
                            }
                            this.isLoading = false;
                        }
                    } else {
                        this.statusMessage = "\u00a7c" + result.error;
                        this.statusColor = 0xFF0000;
                        System.err.println("[Tunnely UI] \u2717 Failed to load public servers: " + result.error);
                        if (this.compatibleOnlyCheckbox != null) {
                            this.compatibleOnlyCheckbox.f_93623_ = true;
                        }
                        if (this.regionButton != null) {
                            this.regionButton.f_93623_ = true;
                        }
                        if (this.refreshButton != null) {
                            this.refreshButton.f_93623_ = true;
                        }
                        if (this.backButton != null) {
                            this.backButton.f_93623_ = true;
                        }
                        this.isLoading = false;
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception loading public servers: " + e.getMessage());
                e.printStackTrace();
                this.f_96541_.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                    if (this.compatibleOnlyCheckbox != null) {
                        this.compatibleOnlyCheckbox.f_93623_ = true;
                    }
                    if (this.regionButton != null) {
                        this.regionButton.f_93623_ = true;
                    }
                    if (this.refreshButton != null) {
                        this.refreshButton.f_93623_ = true;
                    }
                    if (this.backButton != null) {
                        this.backButton.f_93623_ = true;
                    }
                    this.isLoading = false;
                });
            }
        }, "Tunnely-LoadPublic").start();
    }

    private void applyFiltersAndRender() {
        try {
            this.serverList.clear();
            this.availableRegions.clear();
            boolean filterCompatible = this.compatibleOnlyCheckbox != null && this.compatibleOnlyCheckbox.m_93840_();
            String region = this.regionFilter;
            int displayedCount = 0;
            this.totalServersCount = 0;
            this.compatibleServersCount = 0;
            this.totalPlayersOnline = 0;
            if (this.cachedServers.isEmpty()) {
                this.statusMessage = "\u00a77No public servers available";
                this.statusColor = 0xAAAAAA;
            } else {
                for (JsonObject server : this.cachedServers) {
                    String relayRegion;
                    String serverId = server.get("id").getAsString();
                    String serverName = server.has("server_name") && !server.get("server_name").isJsonNull() ? server.get("server_name").getAsString() : "Unnamed Server";
                    String endpoint = server.has("public_endpoint") && !server.get("public_endpoint").isJsonNull() ? server.get("public_endpoint").getAsString() : "N/A";
                    String gameMode = server.has("game_mode") && !server.get("game_mode").isJsonNull() ? server.get("game_mode").getAsString() : "survival";
                    String string = relayRegion = server.has("relay_region") && !server.get("relay_region").isJsonNull() ? server.get("relay_region").getAsString() : "Unknown";
                    if (relayRegion != null && !relayRegion.equals("Unknown")) {
                        this.availableRegions.add(relayRegion);
                    }
                    String minecraftVersion = server.has("minecraft_version") && !server.get("minecraft_version").isJsonNull() ? server.get("minecraft_version").getAsString() : null;
                    String modLoader = server.has("mod_loader") && !server.get("mod_loader").isJsonNull() ? server.get("mod_loader").getAsString() : null;
                    String modpackId = server.has("modpack_id") && !server.get("modpack_id").isJsonNull() ? server.get("modpack_id").getAsString() : null;
                    String modpackVersion = server.has("modpack_version") && !server.get("modpack_version").isJsonNull() ? server.get("modpack_version").getAsString() : null;
                    int currentPlayers = server.has("current_players") && !server.get("current_players").isJsonNull() ? server.get("current_players").getAsInt() : 0;
                    int maxPlayers = server.has("max_players") && !server.get("max_players").isJsonNull() ? server.get("max_players").getAsInt() : 20;
                    this.totalPlayersOnline += currentPlayers;
                    CompatibilityDetector.CompatibilityInfo serverCompat = new CompatibilityDetector.CompatibilityInfo(minecraftVersion, modLoader, modpackId, modpackVersion);
                    boolean isCompatible = this.clientCompatibility.isCompatibleWith(serverCompat);
                    ++this.totalServersCount;
                    if (isCompatible) {
                        ++this.compatibleServersCount;
                    }
                    if (filterCompatible && !isCompatible || !"ALL".equalsIgnoreCase(region) && (relayRegion == null || !relayRegion.equalsIgnoreCase(region))) continue;
                    ++displayedCount;
                    String hostName = "Unknown";
                    if (server.has("host") && !server.get("host").isJsonNull()) {
                        JsonObject hostProfile = server.getAsJsonObject("host");
                        if (hostProfile.has("minecraft_name") && !hostProfile.get("minecraft_name").isJsonNull()) {
                            hostName = hostProfile.get("minecraft_name").getAsString();
                        }
                    } else if (server.has("host_name") && !server.get("host_name").isJsonNull()) {
                        hostName = server.get("host_name").getAsString();
                    }
                    this.serverList.addServer(serverId, serverName, hostName, endpoint, gameMode, relayRegion, serverCompat, isCompatible, currentPlayers, maxPlayers);
                }
                if (displayedCount == 0 && filterCompatible) {
                    this.statusMessage = "\u00a77No compatible servers found";
                    this.statusColor = 0xAAAAAA;
                } else if (displayedCount == 0) {
                    this.statusMessage = "\u00a77No servers match filters";
                    this.statusColor = 0xAAAAAA;
                } else {
                    this.statusMessage = "\u00a7aShowing " + displayedCount + " of " + this.totalServersCount + " server(s)";
                    this.statusColor = 65280;
                }
            }
            if (this.regionButton != null) {
                this.regionButton.m_93666_((Component)Component.m_237113_((String)this.regionButtonLabel()));
            }
        }
        catch (Exception e) {
            System.err.println("[Tunnely UI] Error while applying filters: " + e.getMessage());
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280509_(0, 0, this.f_96543_, 68, -1728053248);
        this.serverList.m_88315_(graphics, mouseX, mouseY, partialTick);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280137_(this.f_96547_, "\u00a76\u00a7lPublic Lobbies", this.f_96543_ / 2, 12, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, this.statusMessage, this.f_96543_ / 2, 28, this.statusColor);
        if (!this.isLoading && this.totalServersCount > 0) {
            String statsLeft = "\u00a77Players Online: \u00a7f" + this.totalPlayersOnline;
            String statsRight = "\u00a77Compatible: \u00a7a" + this.compatibleServersCount + "\u00a77/\u00a7f" + this.totalServersCount;
            graphics.m_280488_(this.f_96547_, statsLeft, 10, 48, 0xAAAAAA);
            graphics.m_280488_(this.f_96547_, statsRight, this.f_96543_ - this.f_96547_.m_92895_(statsRight) - 10, 48, 0xAAAAAA);
        }
        graphics.m_280509_(0, this.f_96544_ - 55, this.f_96543_, this.f_96544_, -1728053248);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private class ServerListWidget
    extends ObjectSelectionList<ServerEntry> {
        public ServerListWidget(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraft, width, height, top, bottom, itemHeight);
        }

        public void clear() {
            this.m_93516_();
            this.m_6987_(null);
        }

        public void addServer(String id, String serverName, String hostName, String endpoint, String gameMode, String relayRegion, CompatibilityDetector.CompatibilityInfo compatibility, boolean isCompatible, int currentPlayers, int maxPlayers) {
            this.m_7085_((AbstractSelectionList.Entry)new ServerEntry(id, serverName, hostName, endpoint, gameMode, relayRegion, compatibility, isCompatible, currentPlayers, maxPlayers));
        }

        class ServerEntry
        extends ObjectSelectionList.Entry<ServerEntry> {
            private final String id;
            private final String serverName;
            private final String hostName;
            private final String endpoint;
            private final String gameMode;
            private final String relayRegion;
            private final CompatibilityDetector.CompatibilityInfo compatibility;
            private final boolean isCompatible;
            private final int currentPlayers;
            private final int maxPlayers;
            private final Button joinButton;

            public ServerEntry(String id, String serverName, String hostName, String endpoint, String gameMode, String relayRegion, CompatibilityDetector.CompatibilityInfo compatibility, boolean isCompatible, int currentPlayers, int maxPlayers) {
                this.id = id;
                this.serverName = serverName;
                this.hostName = hostName;
                this.endpoint = endpoint;
                this.gameMode = gameMode;
                this.relayRegion = relayRegion;
                this.compatibility = compatibility;
                this.isCompatible = isCompatible;
                this.currentPlayers = currentPlayers;
                this.maxPlayers = maxPlayers;
                boolean isFull = currentPlayers >= maxPlayers;
                this.joinButton = Button.m_253074_((Component)Component.m_237113_((String)(isFull ? "Full" : "Join")), button -> this.joinServer()).m_252987_(0, 0, 60, 20).m_253136_();
                this.joinButton.f_93623_ = !isFull;
            }

            /*
             * Enabled aggressive block sorting
             */
            private void joinServer() {
                String sessionId;
                Object relayUrl;
                block6: {
                    System.out.println("[Tunnely UI] Joining server: " + this.id + " (" + this.serverName + ")");
                    if (this.endpoint == null || this.endpoint.equals("N/A")) {
                        System.err.println("[Tunnely UI] Cannot join - no endpoint available");
                        PublicLobbiesScreen.this.f_96541_.m_91152_((Screen)new ConnectionInfoScreen(PublicLobbiesScreen.this, this.serverName, "NOT_FOUND", "Server endpoint not available"));
                        return;
                    }
                    if (this.currentPlayers >= this.maxPlayers) {
                        System.err.println("[Tunnely UI] Cannot join - server is full");
                        PublicLobbiesScreen.this.f_96541_.m_91152_((Screen)new ConnectionInfoScreen(PublicLobbiesScreen.this, this.serverName, "FULL", "Server is full", this::joinServer));
                        return;
                    }
                    if (this.endpoint.contains("://")) {
                        int lastSlash = this.endpoint.lastIndexOf(47);
                        if (lastSlash > 0 && lastSlash < this.endpoint.length() - 1) {
                            relayUrl = this.endpoint.substring(0, lastSlash);
                            sessionId = this.endpoint.substring(lastSlash + 1);
                            break block6;
                        } else {
                            System.err.println("[Tunnely UI] Invalid endpoint format: " + this.endpoint);
                            PublicLobbiesScreen.this.f_96541_.m_91152_((Screen)new ConnectionInfoScreen(PublicLobbiesScreen.this, this.serverName, "GENERIC", "Invalid endpoint format: " + this.endpoint));
                            return;
                        }
                    }
                    if (!this.endpoint.contains("/")) {
                        System.err.println("[Tunnely UI] Invalid endpoint format: " + this.endpoint);
                        PublicLobbiesScreen.this.f_96541_.m_91152_((Screen)new ConnectionInfoScreen(PublicLobbiesScreen.this, this.serverName, "GENERIC", "Invalid endpoint format: " + this.endpoint));
                        return;
                    }
                    String[] parts = this.endpoint.split("/", 2);
                    String relayHostPort = parts[0];
                    sessionId = parts[1];
                    relayUrl = "wss://" + relayHostPort;
                    System.out.println("[Tunnely UI] Legacy endpoint format detected, assuming WSS");
                }
                System.out.println("[Tunnely UI] Parsed relay URL: " + (String)relayUrl);
                System.out.println("[Tunnely UI] Session ID: " + sessionId);
                SafeDisconnect.disconnectAndThen(() -> this.lambda$joinServer$4((String)relayUrl, sessionId));
            }

            private String categorizeError(String error) {
                if (error == null) {
                    return "GENERIC";
                }
                String lowerError = error.toLowerCase();
                if (lowerError.contains("full") || lowerError.contains("capacity")) {
                    return "FULL";
                }
                if (lowerError.contains("not authorized") || lowerError.contains("unauthorized")) {
                    return "NOT_AUTHORIZED";
                }
                if (lowerError.contains("not found") || lowerError.contains("session not found")) {
                    return "NOT_FOUND";
                }
                if (lowerError.contains("connection") || lowerError.contains("timeout") || lowerError.contains("failed to connect")) {
                    return "CONNECTION_FAILED";
                }
                if (lowerError.contains("incompatible") || lowerError.contains("version")) {
                    return "INCOMPATIBLE";
                }
                return "GENERIC";
            }

            public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                int textWidth;
                float playerRatio;
                int bgColor = isMouseOver ? 0x33FFFFFF : 0x22000000;
                graphics.m_280509_(left + 2, top + 2, left + width - 2, top + height - 2, bgColor);
                String compatIcon = this.isCompatible ? "\u00a7a\u2713" : "\u00a7c\u2717";
                graphics.m_280488_(PublicLobbiesScreen.this.f_96547_, compatIcon, left + 8, top + 8, 0xFFFFFF);
                String displayName = this.serverName.length() > 30 ? this.serverName.substring(0, 27) + "..." : this.serverName;
                graphics.m_280488_(PublicLobbiesScreen.this.f_96547_, "\u00a7f\u00a7l" + displayName, left + 28, top + 8, 0xFFFFFF);
                String hostInfo = "\u00a77Host: \u00a7f" + (String)(this.hostName.length() > 15 ? this.hostName.substring(0, 12) + "..." : this.hostName);
                graphics.m_280488_(PublicLobbiesScreen.this.f_96547_, hostInfo, left + 28, top + 20, 0xAAAAAA);
                Object playerText = "\u00a77Players: ";
                float f = playerRatio = this.maxPlayers > 0 ? (float)this.currentPlayers / (float)this.maxPlayers : 0.0f;
                String playerColor = playerRatio >= 0.9f ? "\u00a7c" : (playerRatio >= 0.7f ? "\u00a7e" : "\u00a7a");
                playerText = (String)playerText + playerColor + this.currentPlayers + "\u00a77/\u00a7f" + this.maxPlayers;
                int hostWidth = PublicLobbiesScreen.this.f_96547_.m_92895_(hostInfo);
                graphics.m_280488_(PublicLobbiesScreen.this.f_96547_, (String)playerText, left + 28 + hostWidth + 15, top + 20, 0xAAAAAA);
                int joinButtonStartX = left + width - 70;
                int maxBadgeX = joinButtonStartX - 20;
                int badgeX = left + 28;
                int badgeY = top + 32;
                int lineStartX = left + 28;
                if (this.compatibility.minecraftVersion != null) {
                    String versionText = "\u00a7e" + this.compatibility.minecraftVersion;
                    textWidth = PublicLobbiesScreen.this.f_96547_.m_92895_(versionText);
                    if (badgeX + textWidth > maxBadgeX) {
                        badgeY += 10;
                        badgeX = lineStartX;
                    }
                    graphics.m_280488_(PublicLobbiesScreen.this.f_96547_, versionText, badgeX, badgeY, 0xFFFFFF);
                    badgeX += textWidth + 8;
                }
                if (this.compatibility.modLoader != null) {
                    String loaderColor = this.compatibility.modLoader.equals("fabric") ? "\u00a7b" : (this.compatibility.modLoader.equals("forge") ? "\u00a7c" : "\u00a7d");
                    String loaderText = loaderColor + this.compatibility.modLoader.toUpperCase();
                    int textWidth2 = PublicLobbiesScreen.this.f_96547_.m_92895_(loaderText);
                    if (badgeX + textWidth2 > maxBadgeX) {
                        badgeY += 10;
                        badgeX = lineStartX;
                    }
                    graphics.m_280488_(PublicLobbiesScreen.this.f_96547_, loaderText, badgeX, badgeY, 0xFFFFFF);
                    badgeX += textWidth2 + 8;
                } else {
                    String vanillaText = "\u00a77VANILLA";
                    textWidth = PublicLobbiesScreen.this.f_96547_.m_92895_(vanillaText);
                    if (badgeX + textWidth > maxBadgeX) {
                        badgeY += 10;
                        badgeX = lineStartX;
                    }
                    graphics.m_280488_(PublicLobbiesScreen.this.f_96547_, vanillaText, badgeX, badgeY, 0xFFFFFF);
                    badgeX += textWidth + 8;
                }
                if (this.relayRegion != null) {
                    String regionText = "\u00a76" + this.relayRegion.toUpperCase();
                    int textWidth3 = PublicLobbiesScreen.this.f_96547_.m_92895_(regionText);
                    if (badgeX + textWidth3 > maxBadgeX) {
                        badgeY += 10;
                        badgeX = lineStartX;
                    }
                    graphics.m_280488_(PublicLobbiesScreen.this.f_96547_, regionText, badgeX, badgeY, 0xFFFFFF);
                    badgeX += textWidth3 + 8;
                }
                String gameModeText = "\u00a79" + this.gameMode.substring(0, 1).toUpperCase() + this.gameMode.substring(1);
                int gameModeWidth = PublicLobbiesScreen.this.f_96547_.m_92895_(gameModeText);
                if (badgeX + gameModeWidth > maxBadgeX) {
                    badgeY += 10;
                    badgeX = lineStartX;
                }
                graphics.m_280488_(PublicLobbiesScreen.this.f_96547_, gameModeText, badgeX, badgeY, 0xFFFFFF);
                if (this.compatibility.modpackId != null) {
                    String modpackText = "\u00a7d\ud83d\udce6 " + (String)(this.compatibility.modpackId.length() > 20 ? this.compatibility.modpackId.substring(0, 17) + "..." : this.compatibility.modpackId);
                    if (this.compatibility.modpackVersion != null) {
                        modpackText = modpackText + " \u00a77v" + this.compatibility.modpackVersion;
                    }
                    graphics.m_280488_(PublicLobbiesScreen.this.f_96547_, modpackText, left + 28, top + 44, 0xFFFFFF);
                }
                this.joinButton.m_252865_(left + width - 65);
                this.joinButton.m_253211_(top + height / 2 - 10);
                this.joinButton.m_88315_(graphics, mouseX, mouseY, partialTick);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                return this.joinButton.m_6375_(mouseX, mouseY, button);
            }

            public Component m_142172_() {
                return Component.m_237113_((String)(this.serverName + " by " + this.hostName + " (" + this.currentPlayers + "/" + this.maxPlayers + " players)" + (this.isCompatible ? " Compatible" : " Incompatible")));
            }

            private /* synthetic */ void lambda$joinServer$4(String relayUrl, String sessionId) {
                ClientTunnelManager manager = ClientTunnelManager.getInstance();
                manager.connectToServer(relayUrl, sessionId, () -> System.out.println("[Tunnely UI] \u2713 Connection successful"), error -> {
                    System.err.println("[Tunnely UI] \u2717 Connection failed: " + error);
                    PublicLobbiesScreen.this.f_96541_.execute(() -> {
                        String errorType = this.categorizeError((String)error);
                        PublicLobbiesScreen.this.f_96541_.m_91152_((Screen)new ConnectionInfoScreen(PublicLobbiesScreen.this, this.serverName, errorType, (String)error, errorType.equals("FULL") || errorType.equals("CONNECTION_FAILED") ? this::joinServer : null));
                    });
                });
            }
        }
    }
}

