/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.mixin;

import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.texboobcat.tunnelyrefab.util.TunnelyResolver;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={ServerAddress.class})
public abstract class ServerAddressMixin {
    @Inject(method={"isValidAddress"}, at={@At(value="HEAD")}, cancellable=true)
    private static void tunnelyrefab$allowHttpUrls(String input, CallbackInfoReturnable<Boolean> cir) {
        if (TunnelyResolver.looksLikeHttpUrl(input)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"parseString"}, at={@At(value="HEAD")}, cancellable=true)
    private static void tunnelyrefab$parseHttpUrls(String input, CallbackInfoReturnable<ServerAddress> cir) {
        TunnelyResolver.Resolved resolved = TunnelyResolver.resolveUrl(input);
        if (resolved != null) {
            cir.setReturnValue((Object)new ServerAddress(resolved.host, resolved.port));
        }
    }
}

