/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;

public class DownloadSettingsScreen
extends Screen {
    private final Screen parent;
    private final TunnelConfig config;
    private final WorldManager worldManager;
    private BandwidthSlider bandwidthSlider;
    private String statusMessage = "";

    public DownloadSettingsScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Download Settings"));
        this.parent = parent;
        this.config = TunnelConfig.getInstance();
        this.worldManager = new WorldManager();
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        this.bandwidthSlider = new BandwidthSlider(centerX - 150, centerY - 20, 300, 20);
        this.m_142416_((GuiEventListener)this.bandwidthSlider);
        int presetY = centerY + 20;
        int buttonWidth = 90;
        int buttonSpacing = 95;
        int startX = centerX - buttonSpacing * 3;
        this.addPresetButton(startX, presetY, "Unlimited", 0L);
        this.addPresetButton(startX + buttonSpacing, presetY, "100 KB/s", 102400L);
        this.addPresetButton(startX + buttonSpacing * 2, presetY, "500 KB/s", 512000L);
        this.addPresetButton(startX + buttonSpacing * 3, presetY, "1 MB/s", 0x100000L);
        this.addPresetButton(startX + buttonSpacing * 4, presetY, "2 MB/s", 0x200000L);
        this.addPresetButton(startX + buttonSpacing * 5, presetY, "5 MB/s", 0x500000L);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save Settings"), button -> this.saveSettings()).m_252987_(centerX - 100, centerY + 80, 200, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u2190 Back"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(centerX - 50, this.f_96544_ - 30, 100, 20).m_253136_());
    }

    private void addPresetButton(int x, int y, String label, long bytesPerSecond) {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)label), button -> this.setBandwidthPreset(bytesPerSecond)).m_252987_(x, y, 85, 18).m_253136_());
    }

    private void setBandwidthPreset(long bytesPerSecond) {
        this.worldManager.setBandwidthLimit(bytesPerSecond);
        this.bandwidthSlider.updateFromConfig();
        this.statusMessage = "\u00a7aPreset applied: " + this.formatBytesPerSecond(bytesPerSecond);
    }

    private void saveSettings() {
        this.statusMessage = "\u00a7aSettings saved!";
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        graphics.m_280137_(this.f_96547_, "\u2699 Download Settings", centerX, 20, 0xFFFFFF);
        graphics.m_280137_(this.f_96547_, "\u00a77Configure download speed limits", centerX, 40, 0xAAAAAA);
        graphics.m_280137_(this.f_96547_, "Download Speed Limit", centerX, centerY - 40, 0xFFFFFF);
        long currentLimit = this.config.getDownloadBandwidthLimit();
        String limitText = this.formatBytesPerSecond(currentLimit);
        graphics.m_280137_(this.f_96547_, "\u00a7e" + limitText, centerX, centerY + 5, 0xFFFF55);
        String helpText1 = "\u00a77Set to 0 (Unlimited) for maximum speed";
        String helpText2 = "\u00a77Limit speed to avoid network congestion";
        graphics.m_280137_(this.f_96547_, helpText1, centerX, centerY - 60, 0x888888);
        graphics.m_280137_(this.f_96547_, helpText2, centerX, centerY - 48, 0x888888);
        graphics.m_280137_(this.f_96547_, "\u00a77Quick Presets", centerX, centerY + 60, 0xAAAAAA);
        int useCaseY = centerY + 110;
        graphics.m_280137_(this.f_96547_, "\u00a78Recommendations:", centerX, useCaseY, 0x666666);
        graphics.m_280488_(this.f_96547_, "\u00a78\u2022 Gaming (active): 1-2 MB/s", centerX - 150, useCaseY + 15, 0x666666);
        graphics.m_280488_(this.f_96547_, "\u00a78\u2022 Shared network: 500 KB/s", centerX - 150, useCaseY + 27, 0x666666);
        graphics.m_280488_(this.f_96547_, "\u00a78\u2022 Mobile hotspot: 100 KB/s", centerX - 150, useCaseY + 39, 0x666666);
        graphics.m_280488_(this.f_96547_, "\u00a78\u2022 No constraint: Unlimited", centerX - 150, useCaseY + 51, 0x666666);
        if (!this.statusMessage.isEmpty()) {
            graphics.m_280137_(this.f_96547_, this.statusMessage, centerX, this.f_96544_ - 50, 0xFFFFFF);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private String formatBytesPerSecond(long bytesPerSecond) {
        if (bytesPerSecond == 0L) {
            return "Unlimited";
        }
        if (bytesPerSecond < 1024L) {
            return bytesPerSecond + " B/s";
        }
        int exp = (int)(Math.log(bytesPerSecond) / Math.log(1024.0));
        String pre = "" + "KMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB/s", (double)bytesPerSecond / Math.pow(1024.0, exp), pre);
    }

    private class BandwidthSlider
    extends AbstractSliderButton {
        private static final long MAX_LIMIT = 0xA00000L;

        public BandwidthSlider(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.m_237119_(), 0.0);
            this.updateFromConfig();
            this.m_5695_();
        }

        public void updateFromConfig() {
            long currentLimit = DownloadSettingsScreen.this.config.getDownloadBandwidthLimit();
            this.f_93577_ = currentLimit == 0L ? 0.0 : Math.min(1.0, (double)currentLimit / 1.048576E7);
            this.m_5695_();
        }

        protected void m_5695_() {
            long limit = (long)(this.f_93577_ * 1.048576E7);
            if (limit < 10240L) {
                limit = 0L;
            }
            this.m_93666_((Component)Component.m_237113_((String)DownloadSettingsScreen.this.formatBytesPerSecond(limit)));
        }

        protected void m_5697_() {
            long limit = (long)(this.f_93577_ * 1.048576E7);
            if (limit < 10240L) {
                limit = 0L;
            }
            DownloadSettingsScreen.this.config.setDownloadBandwidthLimit(limit);
            DownloadSettingsScreen.this.worldManager.setBandwidthLimit(limit);
            DownloadSettingsScreen.this.statusMessage = "\u00a7aBandwidth limit updated";
        }
    }
}

