/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.ui.screens.WarningPopupScreen;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;
import org.texboobcat.tunnelyrefab.worlds.ui.ScanReportData;

public class ScanReportScreen
extends Screen {
    private final Screen parent;
    private final WorldInfo world;
    private final WorldManager worldManager;
    private final ScanReportData reportData;
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;

    public ScanReportScreen(Screen parent, WorldInfo world) {
        super((Component)Component.m_237113_((String)"Security Scan Report"));
        this.parent = parent;
        this.world = world;
        this.worldManager = new WorldManager();
        this.reportData = new ScanReportData(world);
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int buttonY = this.f_96544_ - 30;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), button -> this.f_96541_.m_91152_(this.parent)).m_252987_(centerX - 105, buttonY, 100, 20).m_253136_());
        if (this.reportData.isQuarantined()) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Delete World"), button -> this.confirmDelete()).m_252987_(centerX + 5, buttonY, 100, 20).m_253136_());
        }
        this.updateMaxScroll();
    }

    private void confirmDelete() {
        this.f_96541_.m_91152_((Screen)new WarningPopupScreen(this, this, "Delete Quarantined World?", "Are you sure you want to delete \"" + this.world.getName() + "\"?\nThis world failed security scanning and cannot be recovered.", 0xFF0000, () -> this.deleteWorld()));
    }

    private void deleteWorld() {
        new Thread(() -> {
            try {
                this.worldManager.deleteWorld(this.world.getId());
                this.f_96541_.execute(() -> this.f_96541_.m_91152_(this.parent));
            }
            catch (Exception e) {
                this.f_96541_.execute(() -> this.f_96541_.m_91152_((Screen)this));
            }
        }).start();
    }

    private void updateMaxScroll() {
        int contentHeight = this.calculateContentHeight();
        int visibleHeight = this.f_96544_ - 120;
        this.maxScrollOffset = Math.max(0, contentHeight - visibleHeight);
    }

    private int calculateContentHeight() {
        int height = 80;
        for (ScanReportData.ScanReportSection section : this.reportData.getAllSections()) {
            height += 30;
            height += section.items.size() * 15;
            height += 10;
        }
        return height;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280137_(this.f_96547_, "\ud83d\udd12 Security Scan Report", this.f_96543_ / 2, 15, 0xFFFFFF);
        this.renderContent(graphics, mouseX, mouseY);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.maxScrollOffset > 0) {
            graphics.m_280488_(this.f_96547_, "\u2195 Scroll for more", this.f_96543_ / 2 - 40, this.f_96544_ - 50, 0x888888);
        }
    }

    private void renderContent(GuiGraphics graphics, int mouseX, int mouseY) {
        int startY = 40;
        int endY = this.f_96544_ - 60;
        int centerX = this.f_96543_ / 2;
        int contentWidth = Math.min(500, this.f_96543_ - 40);
        int contentX = centerX - contentWidth / 2;
        graphics.m_280588_(0, startY, this.f_96543_, endY);
        int y = startY - this.scrollOffset;
        graphics.m_280488_(this.f_96547_, "\u00a7lWorld: \u00a7r" + this.reportData.getWorldName(), contentX, y, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "\u00a77Author: " + this.reportData.getAuthor(), contentX, y += 15, 0xAAAAAA);
        String threatText = "Threat Level: " + this.reportData.getThreatLevel();
        graphics.m_280488_(this.f_96547_, threatText, contentX, y += 20, this.reportData.getThreatColor());
        String statusText = "Status: " + this.reportData.getStatus();
        graphics.m_280488_(this.f_96547_, statusText, contentX, y += 15, this.reportData.getStatusColor());
        graphics.m_280509_(contentX, y += 25, contentX + contentWidth, y + 1, -12566464);
        y += 15;
        if (!this.reportData.hasDetails()) {
            graphics.m_280488_(this.f_96547_, "\u00a77No scan details available", contentX, y, 0x888888);
        } else {
            for (ScanReportData.ScanReportSection section : this.reportData.getAllSections()) {
                graphics.m_280488_(this.f_96547_, section.title, contentX, y, section.titleColor);
                y += 18;
                for (ScanReportData.ScanReportItem item : section.items) {
                    List<String> lines = this.wrapText(item.text, contentWidth - 20);
                    for (String line : lines) {
                        graphics.m_280488_(this.f_96547_, "  \u2022 " + line, contentX + 5, y, item.color);
                        y += 12;
                    }
                }
                y += 10;
            }
        }
        graphics.m_280618_();
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
            if (this.f_96547_.m_92895_(testLine) <= maxWidth) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        this.scrollOffset -= (int)(scrollDelta * 20.0);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScrollOffset));
        return true;
    }
}

