/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.tunnel;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.shaded.org.java_websocket.client.WebSocketClient;
import org.texboobcat.tunnelyrefab.shaded.org.java_websocket.drafts.Draft_6455;
import org.texboobcat.tunnelyrefab.shaded.org.java_websocket.handshake.ServerHandshake;

public class ClientTunnelManager {
    private static ClientTunnelManager instance;
    private WebSocketClient relayClient;
    private ServerSocket localProxy;
    private Socket minecraftConnection;
    private Thread proxyThread;
    private AtomicBoolean running = new AtomicBoolean(false);
    private AtomicBoolean cleaningUp = new AtomicBoolean(false);
    private String sessionId;
    private int localPort = -1;
    private final Map<Integer, DatagramSocket> udpSockets = new HashMap<Integer, DatagramSocket>();
    private final Map<Integer, Thread> udpThreads = new HashMap<Integer, Thread>();

    private ClientTunnelManager() {
    }

    public static ClientTunnelManager getInstance() {
        if (instance == null) {
            instance = new ClientTunnelManager();
        }
        return instance;
    }

    public void connectToServer(String relayUrl, final String sessionId, final Runnable onSuccess, final Consumer<String> onError) {
        if (this.running.get()) {
            onError.accept("Already connecting to a server. Disconnect first.");
            return;
        }
        this.sessionId = sessionId;
        this.running.set(true);
        new Thread(() -> {
            try {
                this.localProxy = new ServerSocket(0);
                this.localPort = this.localProxy.getLocalPort();
                System.out.println("[Tunnely Client] Local proxy started on port: " + this.localPort);
                final TunnelConfig config = TunnelConfig.getInstance();
                final URI relayUri = new URI(relayUrl);
                this.relayClient = new WebSocketClient(relayUri, new Draft_6455()){
                    private boolean handshakeComplete;
                    private CountDownLatch handshakeLatch;
                    private String authToken;
                    {
                        super(serverUri, protocolDraft);
                        if (relayUri.getScheme().equals("wss")) {
                            try {
                                SSLContext sslContext = SSLContext.getInstance("TLS");
                                sslContext.init(null, ClientTunnelManager.getTrustAllCerts(), new SecureRandom());
                                SSLSocketFactory factory = sslContext.getSocketFactory();
                                this.setSocketFactory(factory);
                                System.out.println("[Tunnely Client] SSL configured for secure WebSocket");
                            }
                            catch (Exception e) {
                                System.err.println("[Tunnely Client] Failed to configure SSL: " + e.getMessage());
                            }
                        }
                        this.handshakeComplete = false;
                        this.handshakeLatch = new CountDownLatch(1);
                        this.authToken = config.getUserJwtToken();
                    }

                    @Override
                    public void onOpen(ServerHandshake handshake) {
                        System.out.println("[Tunnely Client] === WebSocket OPENED to relay ===");
                        System.out.println("[Tunnely Client] Waiting for handshake challenge...");
                    }

                    @Override
                    public void onMessage(String message) {
                        try {
                            String type;
                            JsonObject json = JsonParser.parseString((String)message).getAsJsonObject();
                            String string = type = json.has("type") ? json.get("type").getAsString() : null;
                            if (type == null) {
                                this.handleLegacyMessage(message);
                                return;
                            }
                            switch (type) {
                                case "HANDSHAKE_CHALLENGE": {
                                    this.handleHandshakeChallenge(json);
                                    break;
                                }
                                case "HANDSHAKE_SUCCESS": {
                                    this.handshakeComplete = true;
                                    this.handshakeLatch.countDown();
                                    System.out.println("[Tunnely Client] Handshake successful, joining session...");
                                    String joinMessage = "JOIN:" + sessionId;
                                    System.out.println("[Tunnely Client] Sending JOIN message: " + joinMessage);
                                    this.send(joinMessage);
                                    break;
                                }
                                case "ERROR": {
                                    String errorMsg = json.has("message") ? json.get("message").getAsString() : "Unknown error";
                                    System.err.println("[Tunnely Client] Server error: " + errorMsg);
                                    ClientTunnelManager.this.running.set(false);
                                    if (onError != null) {
                                        onError.accept(errorMsg);
                                    }
                                    ClientTunnelManager.this.cleanup();
                                    break;
                                }
                                case "UDP_PACKET": {
                                    this.handleUdpPacket(json);
                                    break;
                                }
                                default: {
                                    this.handleLegacyMessage(message);
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            this.handleLegacyMessage(message);
                        }
                    }

                    private void handleUdpPacket(JsonObject json) {
                        try {
                            if (!json.has("port") || !json.has("data")) {
                                return;
                            }
                            int port = json.get("port").getAsInt();
                            String base64Data = json.get("data").getAsString();
                            byte[] data = Base64.getDecoder().decode(base64Data);
                            DatagramSocket socket = ClientTunnelManager.this.getOrCreateUdpSocket(port);
                            if (socket != null && !socket.isClosed()) {
                                DatagramPacket packet = new DatagramPacket(data, data.length, InetAddress.getByName("localhost"), port);
                                socket.send(packet);
                            }
                        }
                        catch (Exception e) {
                            System.err.println("[Tunnely Client] Error handling UDP packet: " + e.getMessage());
                        }
                    }

                    private void handleLegacyMessage(String message) {
                        System.out.println("[Tunnely Client] Received message from relay: " + message);
                        if (message.startsWith("JOINED:")) {
                            System.out.println("[Tunnely Client] Successfully joined session!");
                            ClientTunnelManager.this.startProxyListener();
                            Minecraft.m_91087_().execute(() -> {
                                ClientTunnelManager.this.connectMinecraftToProxy();
                                if (onSuccess != null) {
                                    onSuccess.run();
                                }
                            });
                        } else if (message.startsWith("ERROR:")) {
                            String error = message.substring(6);
                            System.err.println("[Tunnely Client] Relay error: " + error);
                            ClientTunnelManager.this.running.set(false);
                            if (onError != null) {
                                onError.accept(error);
                            }
                            ClientTunnelManager.this.cleanup();
                        }
                    }

                    private void handleHandshakeChallenge(JsonObject json) {
                        try {
                            if (!json.has("challenge")) {
                                System.err.println("[Tunnely Client] Invalid handshake challenge");
                                this.close();
                                return;
                            }
                            String challenge = json.get("challenge").getAsString();
                            System.out.println("[Tunnely Client] Received handshake challenge, generating connection ticket...");
                            SupabaseClient supabaseClient = new SupabaseClient();
                            String ticket = supabaseClient.generateRelayConnectionTicket(challenge);
                            if (ticket == null) {
                                System.err.println("[Tunnely Client] Failed to generate connection ticket");
                                this.close();
                                return;
                            }
                            String signature = this.computeHmacSignature(challenge, ticket);
                            JsonObject response = new JsonObject();
                            response.addProperty("type", "HANDSHAKE_RESPONSE");
                            response.addProperty("signature", signature);
                            response.addProperty("clientType", "minecraft-client");
                            response.addProperty("ticket", ticket);
                            this.send(response.toString());
                            System.out.println("[Tunnely Client] Handshake response sent with ticket (JWT not exposed to relay)");
                        }
                        catch (Exception e) {
                            System.err.println("[Tunnely Client] Failed to process handshake: " + e.getMessage());
                            e.printStackTrace();
                            this.close();
                        }
                    }

                    private String computeHmacSignature(String challenge, String secret) throws NoSuchAlgorithmException, InvalidKeyException {
                        Mac hmac = Mac.getInstance("HmacSHA256");
                        SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
                        hmac.init(secretKey);
                        byte[] signatureBytes = hmac.doFinal(challenge.getBytes(StandardCharsets.UTF_8));
                        StringBuilder hexString = new StringBuilder();
                        for (byte b : signatureBytes) {
                            String hex = Integer.toHexString(0xFF & b);
                            if (hex.length() == 1) {
                                hexString.append('0');
                            }
                            hexString.append(hex);
                        }
                        return hexString.toString();
                    }

                    @Override
                    public void onMessage(ByteBuffer bytes) {
                        if (ClientTunnelManager.this.minecraftConnection == null || ClientTunnelManager.this.minecraftConnection.isClosed()) {
                            return;
                        }
                        try {
                            byte[] compressed = new byte[bytes.remaining()];
                            bytes.get(compressed);
                            byte[] data = ClientTunnelManager.this.decompressData(compressed);
                            ClientTunnelManager.this.minecraftConnection.getOutputStream().write(data);
                            ClientTunnelManager.this.minecraftConnection.getOutputStream().flush();
                        }
                        catch (IOException e) {
                            System.err.println("[Tunnely Client] Error forwarding packet: " + e.getMessage());
                        }
                    }

                    @Override
                    public void onClose(int code, String reason, boolean remote) {
                        ClientTunnelManager.this.running.set(false);
                        ClientTunnelManager.this.cleanup();
                    }

                    @Override
                    public void onError(Exception ex) {
                        System.err.println("[Tunnely Client] Relay error: " + ex.getMessage());
                        ClientTunnelManager.this.running.set(false);
                        if (onError != null) {
                            onError.accept("Connection error: " + ex.getMessage());
                        }
                        ClientTunnelManager.this.cleanup();
                    }
                };
                this.relayClient.addHeader("Authorization", "Bearer " + config.getUserJwtToken());
                this.relayClient.addHeader("X-Client-Type", "minecraft-client");
                this.relayClient.connect();
            }
            catch (Exception e) {
                System.err.println("[Tunnely Client] Failed to start client tunnel: " + e.getMessage());
                e.printStackTrace();
                this.running.set(false);
                if (onError != null) {
                    onError.accept("Failed to connect: " + e.getMessage());
                }
                this.cleanup();
            }
        }, "Tunnely-ClientConnect").start();
    }

    private void startProxyListener() {
        this.proxyThread = new Thread(() -> {
            try {
                int bytesRead;
                System.out.println("[Tunnely Client] === Waiting for Minecraft connection on port " + this.localPort + " ===");
                this.minecraftConnection = this.localProxy.accept();
                System.out.println("[Tunnely Client] === Minecraft CONNECTED to local proxy ===");
                InputStream in = this.minecraftConnection.getInputStream();
                byte[] buffer = new byte[8192];
                while (this.running.get() && (bytesRead = in.read(buffer)) != -1 && this.relayClient != null && this.relayClient.isOpen()) {
                    byte[] packet = new byte[bytesRead];
                    System.arraycopy(buffer, 0, packet, 0, bytesRead);
                    byte[] compressed = this.compressData(packet);
                    this.relayClient.send(compressed);
                }
                this.running.set(false);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.cleanup();
            }
            catch (IOException e) {
                if (this.running.get()) {
                    System.err.println("[Tunnely Client] Proxy listener error: " + e.getMessage());
                }
                this.disconnect();
            }
        }, "Tunnely-ProxyListener");
        this.proxyThread.start();
    }

    private void connectMinecraftToProxy() {
        Minecraft minecraft = Minecraft.m_91087_();
        ServerData serverData = new ServerData("Tunnely Server", "localhost:" + this.localPort, false);
        ConnectScreen.m_169267_((Screen)minecraft.f_91080_, (Minecraft)minecraft, (ServerAddress)ServerAddress.m_171864_((String)("localhost:" + this.localPort)), (ServerData)serverData);
    }

    public synchronized void disconnect() {
        this.running.set(false);
        this.cleanup();
    }

    private DatagramSocket getOrCreateUdpSocket(int port) {
        if (this.udpSockets.containsKey(port)) {
            return this.udpSockets.get(port);
        }
        try {
            DatagramSocket socket = new DatagramSocket();
            this.udpSockets.put(port, socket);
            Thread udpThread = new Thread(() -> {
                byte[] buffer = new byte[65507];
                while (this.running.get() && !socket.isClosed()) {
                    try {
                        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                        socket.receive(packet);
                        byte[] data = new byte[packet.getLength()];
                        System.arraycopy(packet.getData(), packet.getOffset(), data, 0, packet.getLength());
                        if (this.relayClient == null || !this.relayClient.isOpen()) continue;
                        JsonObject udpPacket = new JsonObject();
                        udpPacket.addProperty("type", "UDP_PACKET");
                        udpPacket.addProperty("port", (Number)port);
                        udpPacket.addProperty("data", Base64.getEncoder().encodeToString(data));
                        this.relayClient.send(udpPacket.toString());
                    }
                    catch (IOException e) {
                        if (!this.running.get()) break;
                        System.err.println("[Tunnely Client] UDP receive error on port " + port + ": " + e.getMessage());
                        break;
                    }
                }
            }, "Tunnely-Client-UDP-" + port);
            udpThread.setDaemon(true);
            udpThread.start();
            this.udpThreads.put(port, udpThread);
            System.out.println("[Tunnely Client] Started UDP proxy for port " + port);
            return socket;
        }
        catch (SocketException e) {
            System.err.println("[Tunnely Client] Failed to create UDP socket for port " + port + ": " + e.getMessage());
            return null;
        }
    }

    private void cleanup() {
        block16: {
            if (!this.cleaningUp.compareAndSet(false, true)) {
                return;
            }
            try {
                for (Map.Entry<Integer, DatagramSocket> entry : this.udpSockets.entrySet()) {
                    try {
                        entry.getValue().close();
                        System.out.println("[Tunnely Client] Closed UDP socket for port " + String.valueOf(entry.getKey()));
                    }
                    catch (Exception e) {
                        System.err.println("[Tunnely Client] Error closing UDP socket: " + e.getMessage());
                    }
                }
                this.udpSockets.clear();
                for (Thread thread : this.udpThreads.values()) {
                    try {
                        thread.interrupt();
                    }
                    catch (Exception exception) {}
                }
                this.udpThreads.clear();
                if (this.relayClient != null && this.relayClient.isOpen()) {
                    this.relayClient.close();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.relayClient = null;
                }
                if (this.minecraftConnection != null && !this.minecraftConnection.isClosed()) {
                    this.minecraftConnection.close();
                    this.minecraftConnection = null;
                }
                if (this.localProxy != null && !this.localProxy.isClosed()) {
                    this.localProxy.close();
                    this.localProxy = null;
                }
                if (this.proxyThread == null || !this.proxyThread.isAlive()) break block16;
                this.proxyThread.interrupt();
                try {
                    this.proxyThread.join(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.proxyThread = null;
            }
            catch (IOException e) {
                System.err.println("[Tunnely Client] Cleanup error: " + e.getMessage());
            }
        }
        this.localPort = -1;
        this.sessionId = null;
        this.cleaningUp.set(false);
    }

    public boolean isConnected() {
        return this.running.get();
    }

    private byte[] compressData(byte[] data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOut = new GZIPOutputStream(baos);){
            gzipOut.write(data);
        }
        return baos.toByteArray();
    }

    private byte[] decompressData(byte[] compressed) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(compressed);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPInputStream gzipIn = new GZIPInputStream(bais);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = gzipIn.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
        }
        return baos.toByteArray();
    }

    private static TrustManager[] getTrustAllCerts() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }
}

