/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;

public class ToastNotificationManager
extends GuiComponent {
    private static ToastNotificationManager instance;
    private final List<Toast> activeToasts = new ArrayList<Toast>();
    private static final int TOAST_DURATION_MS = 5000;
    private static final int TOAST_WIDTH = 250;
    private static final int TOAST_HEIGHT = 40;
    private static final int TOAST_PADDING = 10;
    private static final int SLIDE_DURATION_MS = 300;

    public static ToastNotificationManager getInstance() {
        if (instance == null) {
            instance = new ToastNotificationManager();
        }
        return instance;
    }

    public void showMessageNotification(String senderName, String messagePreview) {
        if (!TunnelConfig.getInstance().isMessageNotificationsEnabled()) {
            System.out.println("[Tunnely Toast] Notifications disabled in settings");
            return;
        }
        if (((String)messagePreview).length() > 30) {
            messagePreview = ((String)messagePreview).substring(0, 27) + "...";
        }
        String title = "\ud83d\udcac " + senderName;
        String message = messagePreview;
        System.out.println("[Tunnely Toast] Showing notification: " + title + " - " + message);
        Minecraft.m_91087_().execute(() -> {
            Toast toast = new Toast(title, message, System.currentTimeMillis());
            List<Toast> list = this.activeToasts;
            synchronized (list) {
                this.activeToasts.add(toast);
                System.out.println("[Tunnely Toast] Toast added. Active toasts: " + this.activeToasts.size());
            }
        });
    }

    public void showWarning(String title, String message) {
        System.out.println("[Tunnely Toast] Showing warning: " + title + " - " + message);
        Minecraft.m_91087_().execute(() -> {
            Toast toast = new Toast(title, message, System.currentTimeMillis());
            List<Toast> list = this.activeToasts;
            synchronized (list) {
                this.activeToasts.add(toast);
                System.out.println("[Tunnely Toast] Warning toast added. Active toasts: " + this.activeToasts.size());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(PoseStack poseStack, int screenWidth, int screenHeight) {
        if (this.activeToasts.isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        int yOffset = 10;
        List<Toast> list = this.activeToasts;
        synchronized (list) {
            this.activeToasts.removeIf(toast -> currentTime - toast.spawnTime > 5000L);
            for (Toast toast2 : this.activeToasts) {
                float alpha = this.calculateAlpha(toast2, currentTime);
                float slideOffset = this.calculateSlideOffset(toast2, currentTime);
                int x = screenWidth - 250 - 10 + (int)slideOffset;
                int y = 10 + yOffset;
                this.renderToast(poseStack, toast2, x, y, alpha);
                yOffset += 45;
            }
        }
    }

    private float calculateAlpha(Toast toast, long currentTime) {
        long age = currentTime - toast.spawnTime;
        if (age < 300L) {
            return (float)age / 300.0f;
        }
        long timeUntilExpire = 5000L - age;
        if (timeUntilExpire < 500L) {
            return (float)timeUntilExpire / 500.0f;
        }
        return 1.0f;
    }

    private float calculateSlideOffset(Toast toast, long currentTime) {
        long age = currentTime - toast.spawnTime;
        if (age < 300L) {
            float progress = (float)age / 300.0f;
            return (1.0f - this.easeOutCubic(progress)) * 260.0f;
        }
        return 0.0f;
    }

    private float easeOutCubic(float x) {
        return 1.0f - (float)Math.pow(1.0f - x, 3.0);
    }

    private void renderToast(PoseStack poseStack, Toast toast, int x, int y, float alpha) {
        int bgAlpha = (int)(alpha * 200.0f);
        int textAlpha = (int)(alpha * 255.0f);
        int bgColor = bgAlpha << 24 | 0x2C2C2C;
        int borderColor = bgAlpha << 24 | 0x55AAFF;
        ToastNotificationManager.m_93172_((PoseStack)poseStack, (int)(x - 1), (int)(y - 1), (int)(x + 250 + 1), (int)(y + 40 + 1), (int)borderColor);
        ToastNotificationManager.m_93172_((PoseStack)poseStack, (int)x, (int)y, (int)(x + 250), (int)(y + 40), (int)bgColor);
        int titleColor = textAlpha << 24 | 0xFFFFFF;
        Minecraft.m_91087_().f_91062_.m_92883_(poseStack, toast.title, (float)(x + 8), (float)(y + 6), titleColor);
        int messageColor = textAlpha << 24 | 0xAAAAAA;
        Minecraft.m_91087_().f_91062_.m_92883_(poseStack, toast.message, (float)(x + 8), (float)(y + 20), messageColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        List<Toast> list = this.activeToasts;
        synchronized (list) {
            this.activeToasts.clear();
        }
    }

    public void showTestNotification() {
        this.showMessageNotification("Test Friend", "This is a test message!");
    }

    private static class Toast {
        final String title;
        final String message;
        final long spawnTime;

        Toast(String title, String message, long spawnTime) {
            this.title = title;
            this.message = message;
            this.spawnTime = spawnTime;
        }
    }
}

