/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.tunnel.ClientTunnelManager;
import org.texboobcat.tunnelyrefab.ui.screens.ConnectionInfoScreen;

public class DirectJoinScreen
extends Screen {
    private final Screen parent;
    private EditBox endpointInput;
    private String statusMessage = "";
    private int statusColor = 0xFFFFFF;
    private Button connectButton;
    private Button helpButton;
    private boolean showHelpTooltip = false;

    public DirectJoinScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Direct Join"));
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int startY = this.f_96544_ / 2 - 50;
        this.endpointInput = new EditBox(this.f_96547_, centerX - 150, startY, 300, 20, (Component)Component.m_237113_((String)"Tunnel Endpoint"));
        this.endpointInput.m_94199_(200);
        this.endpointInput.m_94144_("");
        this.m_142416_((GuiEventListener)this.endpointInput);
        this.m_142416_((GuiEventListener)new Button(centerX - 155, startY + 30, 100, 20, (Component)Component.m_237113_((String)"\ud83d\udccb Paste"), button -> {
            String clipboard = this.f_96541_.f_91068_.m_90876_();
            this.endpointInput.m_94144_(clipboard);
            this.validateEndpoint(clipboard);
        }));
        this.m_142416_((GuiEventListener)new Button(centerX + 55, startY + 30, 100, 20, (Component)Component.m_237113_((String)"Clear"), button -> {
            this.endpointInput.m_94144_("");
            this.statusMessage = "";
        }));
        this.connectButton = new Button(centerX - 100, startY + 60, 200, 20, (Component)Component.m_237113_((String)"\ud83d\udd17 Connect"), button -> this.connectToServer());
        this.m_142416_((GuiEventListener)this.connectButton);
        this.helpButton = new Button(centerX - 100, startY + 90, 200, 20, (Component)Component.m_237113_((String)"\u2139\ufe0f How to use"), button -> {});
        this.m_142416_((GuiEventListener)this.helpButton);
        this.m_142416_((GuiEventListener)new Button(centerX - 100, this.f_96544_ - 30, 200, 20, (Component)Component.m_237113_((String)"Back"), button -> this.f_96541_.m_91152_(this.parent)));
    }

    private boolean validateEndpoint(String endpoint) {
        if (endpoint == null || endpoint.trim().isEmpty()) {
            this.statusMessage = "\u00a7cPlease enter a tunnel endpoint";
            this.statusColor = 0xFF0000;
            return false;
        }
        if (!(endpoint = endpoint.trim()).contains(":") || !endpoint.contains("/")) {
            this.statusMessage = "\u00a7cInvalid format. Expected: host:port/session-id";
            this.statusColor = 0xFF0000;
            return false;
        }
        String[] parts = endpoint.split("/", 2);
        if (parts.length != 2) {
            this.statusMessage = "\u00a7cInvalid format. Expected: host:port/session-id";
            this.statusColor = 0xFF0000;
            return false;
        }
        String hostPort = parts[0];
        String sessionId = parts[1];
        if (!hostPort.contains(":")) {
            this.statusMessage = "\u00a7cMissing port. Expected: host:port/session-id";
            this.statusColor = 0xFF0000;
            return false;
        }
        if (sessionId.trim().isEmpty()) {
            this.statusMessage = "\u00a7cMissing session ID";
            this.statusColor = 0xFF0000;
            return false;
        }
        this.statusMessage = "\u00a7aValid endpoint format \u2713";
        this.statusColor = 65280;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void connectToServer() {
        String sessionId;
        Object relayUrl;
        block5: {
            String endpoint = this.endpointInput.m_94155_().trim();
            if (!this.validateEndpoint(endpoint)) {
                return;
            }
            System.out.println("[Tunnely UI] Direct joining to endpoint: " + endpoint);
            if (endpoint.contains("://")) {
                int lastSlash = endpoint.lastIndexOf(47);
                if (lastSlash > 0 && lastSlash < endpoint.length() - 1) {
                    relayUrl = endpoint.substring(0, lastSlash);
                    sessionId = endpoint.substring(lastSlash + 1);
                    break block5;
                } else {
                    this.statusMessage = "\u00a7cInvalid endpoint format";
                    this.statusColor = 0xFF0000;
                    return;
                }
            }
            String[] parts = endpoint.split("/", 2);
            if (parts.length != 2) {
                this.statusMessage = "\u00a7cInvalid endpoint format";
                this.statusColor = 0xFF0000;
                return;
            }
            String relayHostPort = parts[0];
            sessionId = parts[1];
            relayUrl = "wss://" + relayHostPort;
            System.out.println("[Tunnely UI] Legacy endpoint format detected, assuming WSS");
        }
        this.statusMessage = "\u00a7eConnecting to server...";
        this.statusColor = 0xFFFF00;
        ClientTunnelManager clientManager = ClientTunnelManager.getInstance();
        clientManager.connectToServer((String)relayUrl, sessionId, () -> this.f_96541_.execute(() -> {
            this.statusMessage = "\u00a7aConnecting to Minecraft server...";
            this.statusColor = 65280;
            System.out.println("[Tunnely UI] Successfully connected through tunnel!");
        }), error -> this.f_96541_.execute(() -> {
            System.err.println("[Tunnely UI] Connection error: " + error);
            String errorType = this.categorizeError((String)error);
            this.f_96541_.m_91152_((Screen)new ConnectionInfoScreen(this.parent, "Direct Connection", errorType, (String)error, errorType.equals("FULL") || errorType.equals("CONNECTION_FAILED") ? this::connectToServer : null));
        }));
    }

    private String categorizeError(String error) {
        if (error == null) {
            return "GENERIC";
        }
        String lowerError = error.toLowerCase();
        if (lowerError.contains("full") || lowerError.contains("capacity")) {
            return "FULL";
        }
        if (lowerError.contains("not authorized") || lowerError.contains("unauthorized")) {
            return "NOT_AUTHORIZED";
        }
        if (lowerError.contains("not found") || lowerError.contains("session not found")) {
            return "NOT_FOUND";
        }
        if (lowerError.contains("connection") || lowerError.contains("timeout") || lowerError.contains("failed to connect")) {
            return "CONNECTION_FAILED";
        }
        if (lowerError.contains("incompatible") || lowerError.contains("version")) {
            return "INCOMPATIBLE";
        }
        return "GENERIC";
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        DirectJoinScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        DirectJoinScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)"\u00a77Enter a tunnel endpoint to connect directly", (int)(this.f_96543_ / 2), (int)35, (int)0xAAAAAA);
        DirectJoinScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"\u00a7eTunnel Endpoint:", (int)(this.f_96543_ / 2 - 150), (int)(this.f_96544_ / 2 - 65), (int)0xFFFF00);
        if (!this.statusMessage.isEmpty()) {
            DirectJoinScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.statusMessage, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + 20), (int)this.statusColor);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.showHelpTooltip = this.helpButton.m_5953_((double)mouseX, (double)mouseY);
        if (this.showHelpTooltip) {
            int tooltipX = mouseX + 10;
            int tooltipY = mouseY - 10;
            int tooltipWidth = 280;
            int tooltipHeight = 80;
            if (tooltipX + tooltipWidth > this.f_96543_) {
                tooltipX = this.f_96543_ - tooltipWidth - 5;
            }
            if (tooltipY + tooltipHeight > this.f_96544_) {
                tooltipY = this.f_96544_ - tooltipHeight - 5;
            }
            if (tooltipY < 5) {
                tooltipY = 5;
            }
            DirectJoinScreen.m_93172_((PoseStack)poseStack, (int)(tooltipX - 5), (int)(tooltipY - 5), (int)(tooltipX + tooltipWidth), (int)(tooltipY + tooltipHeight), (int)-267386864);
            int x1 = tooltipX - 5;
            int y1 = tooltipY - 5;
            int x2 = tooltipX + tooltipWidth;
            int y2 = tooltipY + tooltipHeight;
            DirectJoinScreen.m_93172_((PoseStack)poseStack, (int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)-11513776);
            DirectJoinScreen.m_93172_((PoseStack)poseStack, (int)x1, (int)y2, (int)x2, (int)(y2 + 1), (int)-11513776);
            DirectJoinScreen.m_93172_((PoseStack)poseStack, (int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)-11513776);
            DirectJoinScreen.m_93172_((PoseStack)poseStack, (int)(x2 - 1), (int)y1, (int)x2, (int)y2, (int)-11513776);
            int textY = tooltipY;
            DirectJoinScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"\u00a76How to use Direct Join:", (int)tooltipX, (int)textY, (int)0xFFFFFF);
            DirectJoinScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"\u00a771. Get endpoint from a friend", (int)tooltipX, (int)(textY += 14), (int)0xAAAAAA);
            DirectJoinScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"\u00a772. Paste it in the box above", (int)tooltipX, (int)(textY += 12), (int)0xAAAAAA);
            DirectJoinScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"\u00a773. Click Connect", (int)tooltipX, (int)(textY += 12), (int)0xAAAAAA);
            DirectJoinScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"\u00a774. Add server in multiplayer menu", (int)tooltipX, (int)(textY += 12), (int)0xAAAAAA);
            DirectJoinScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"\u00a78Example: relay.example.com:8080/abc-123", (int)tooltipX, (int)(textY += 16), (int)0x888888);
        }
    }

    public void m_86600_() {
        super.m_86600_();
        this.endpointInput.m_94120_();
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String text = this.endpointInput.m_94155_();
        super.m_6574_(minecraft, width, height);
        this.endpointInput.m_94144_(text);
    }

    public boolean m_7043_() {
        return false;
    }
}

