/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.ui.screens.DirectJoinScreen;
import org.texboobcat.tunnelyrefab.ui.screens.FriendsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.InvitesScreen;
import org.texboobcat.tunnelyrefab.ui.screens.JoinFriendsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.LoginScreen;
import org.texboobcat.tunnelyrefab.ui.screens.PublicLobbiesScreen;
import org.texboobcat.tunnelyrefab.ui.screens.SettingsScreen;

public class TunnelyMultiplayerScreen
extends Screen {
    private final Screen parent;
    private final TunnelConfig config;
    private final List<Button> menuButtons = new ArrayList<Button>();
    private int buttonWidth;
    private final int buttonHeight = 20;
    private int safeTop;
    private final int safeBottom = 70;
    private int spacing;
    private int stackStartY;
    private int stackTotalH;
    private boolean scrollable;
    private double scroll;
    private String footerMessage = "";
    private int footerColor = 0xFFFFFF;
    private Button donateButton;
    private Button backButton;

    public TunnelyMultiplayerScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Tunnely Multiplayer"));
        this.parent = parent;
        this.config = TunnelConfig.getInstance();
    }

    protected void m_7856_() {
        SupabaseClient client;
        super.m_7856_();
        this.m_169413_();
        if (this.config.isAuthenticated() && (client = new SupabaseClient()).needsLogin()) {
            this.f_96541_.m_91152_((Screen)new LoginScreen(this.parent));
            return;
        }
        this.computeHeaderSafeTop();
        this.computeButtons();
        this.addBottomBar();
    }

    private void computeHeaderSafeTop() {
        this.safeTop = 45;
    }

    private void computeButtons() {
        this.menuButtons.clear();
        this.buttonWidth = Math.min(240, Math.max(160, (int)((double)this.f_96543_ * 0.3)));
        int centerX = this.f_96543_ / 2 - this.buttonWidth / 2;
        boolean authed = this.config.isAuthenticated();
        if (!authed) {
            this.menuButtons.add(new Button(centerX, 0, this.buttonWidth, 20, (Component)Component.m_237113_((String)"Login / Register"), b -> this.f_96541_.m_91152_((Screen)new LoginScreen(this))));
            this.setFooterMessage("\u00a77Please log in to access Tunnely multiplayer features", 0xAAAAAA);
        } else {
            this.menuButtons.add(new Button(centerX, 0, this.buttonWidth, 20, (Component)Component.m_237113_((String)"Direct Join"), b -> this.f_96541_.m_91152_((Screen)new DirectJoinScreen(this))));
            this.menuButtons.add(new Button(centerX, 0, this.buttonWidth, 20, (Component)Component.m_237113_((String)"Join Friends"), b -> this.f_96541_.m_91152_((Screen)new JoinFriendsScreen(this))));
            this.menuButtons.add(new Button(centerX, 0, this.buttonWidth, 20, (Component)Component.m_237113_((String)"Public Lobbies"), b -> this.f_96541_.m_91152_((Screen)new PublicLobbiesScreen(this))));
            this.menuButtons.add(new Button(centerX, 0, this.buttonWidth, 20, (Component)Component.m_237113_((String)"Manage Friends"), b -> this.f_96541_.m_91152_((Screen)new FriendsScreen(this))));
            this.menuButtons.add(new Button(centerX, 0, this.buttonWidth, 20, (Component)Component.m_237113_((String)"Invites"), b -> this.f_96541_.m_91152_((Screen)new InvitesScreen(this))));
            this.menuButtons.add(new Button(centerX, 0, this.buttonWidth, 20, (Component)Component.m_237113_((String)"Settings"), b -> this.f_96541_.m_91152_((Screen)new SettingsScreen(this))));
        }
        int count = this.menuButtons.size();
        int areaH = Math.max(0, this.f_96544_ - this.safeTop - 70);
        int ideal = 22;
        int min = 5;
        this.spacing = ideal;
        int needed = count * 20 + (count - 1) * this.spacing;
        if (needed > areaH) {
            int neededMin = count * 20 + (count - 1) * min;
            this.spacing = neededMin > areaH ? min : (areaH - count * 20) / Math.max(1, count - 1);
        }
        this.stackTotalH = count * 20 + (count - 1) * this.spacing;
        boolean bl = this.scrollable = this.stackTotalH > areaH;
        if (!this.scrollable) {
            this.scroll = 0.0;
        }
        this.stackStartY = this.safeTop + Math.max(0, (areaH - this.stackTotalH) / 2);
        for (Button b2 : this.menuButtons) {
            this.m_142416_((GuiEventListener)b2);
        }
        this.layoutButtons();
    }

    private void layoutButtons() {
        int y = this.stackStartY - (int)Math.max(0.0, this.scroll);
        int centerX = this.f_96543_ / 2 - this.buttonWidth / 2;
        for (Button b : this.menuButtons) {
            b.f_93620_ = centerX;
            b.f_93621_ = y;
            y += 20 + this.spacing;
        }
    }

    private void addBottomBar() {
        int centerX = this.f_96543_ / 2 - this.buttonWidth / 2;
        this.donateButton = new Button(centerX, this.f_96544_ - 55, this.buttonWidth, 20, (Component)Component.m_237113_((String)"Donate"), btn -> this.openDonate());
        this.m_142416_((GuiEventListener)this.donateButton);
        this.backButton = new Button(centerX, this.f_96544_ - 30, this.buttonWidth, 20, (Component)Component.m_237113_((String)"Back"), btn -> this.f_96541_.m_91152_(this.parent));
        this.m_142416_((GuiEventListener)this.backButton);
    }

    private void openDonate() {
        try {
            Util.m_137581_().m_137646_("https://modrinth.com/mod/tunnely");
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Failed to open browser: " + e.getMessage());
            this.setFooterMessage("\u00a7cFailed to open browser", 0xFF5555);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        this.m_7333_(poseStack);
        TunnelyMultiplayerScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)"\u00a76\u00a7lTunnely Multiplayer", (int)(this.f_96543_ / 2), (int)15, (int)0xFFAA00);
        boolean authed = this.config.isAuthenticated();
        if (authed) {
            String username = "Player";
            if (this.f_96541_.f_91074_ != null) {
                username = this.f_96541_.f_91074_.m_7755_().getString();
            }
            TunnelyMultiplayerScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)("\u00a77Logged in as \u00a7b" + username), (int)(this.f_96543_ / 2), (int)28, (int)0xAAAAAA);
        } else {
            TunnelyMultiplayerScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)"\u00a77Join servers and play with friends", (int)(this.f_96543_ / 2), (int)28, (int)0xAAAAAA);
        }
        if (!this.footerMessage.isEmpty()) {
            TunnelyMultiplayerScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.footerMessage, (int)(this.f_96543_ / 2), (int)(this.f_96544_ - 65), (int)this.footerColor);
        }
        for (Button b : this.menuButtons) {
            b.m_6305_(poseStack, mouseX, mouseY, delta);
        }
        this.donateButton.m_6305_(poseStack, mouseX, mouseY, delta);
        this.backButton.m_6305_(poseStack, mouseX, mouseY, delta);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.scrollable) {
            int areaH = Math.max(0, this.f_96544_ - this.safeTop - 70);
            int maxScroll = Math.max(0, this.stackTotalH - areaH);
            this.scroll = Math.max(0.0, Math.min((double)maxScroll, this.scroll - delta * 10.0));
            this.layoutButtons();
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.scrollable && mouseY >= (double)this.safeTop && mouseY <= (double)(this.f_96544_ - 70)) {
            for (Button btn : this.menuButtons) {
                if (!btn.m_6375_(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_6574_(Minecraft mc, int w, int h) {
        super.m_6574_(mc, w, h);
        this.m_169413_();
        this.m_7856_();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return false;
    }

    private void setFooterMessage(String message, int color) {
        this.footerMessage = message;
        this.footerColor = color;
    }
}

