/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.texboobcat.tunnelyrefab.Tunnelyrefab;
import org.texboobcat.tunnelyrefab.commands.TunnelCommand;
import org.texboobcat.tunnelyrefab.events.ServerEvents;
import org.texboobcat.tunnelyrefab.neoforge.ToastRenderEventHandler;
import org.texboobcat.tunnelyrefab.ui.TunnelyKeybinds;
import org.texboobcat.tunnelyrefab.ui.screens.TunnelyMainScreen;

@Mod(value="tunnelyrefab")
public final class TunnelyrefabNeoForge {
    public TunnelyrefabNeoForge(IEventBus modEventBus) {
        Tunnelyrefab.init();
        modEventBus.addListener(TunnelyrefabNeoForge::onClientSetup);
        modEventBus.addListener(TunnelyrefabNeoForge::onKeyRegister);
        NeoForge.EVENT_BUS.addListener(TunnelyrefabNeoForge::onCommandRegister);
        NeoForge.EVENT_BUS.addListener(TunnelyrefabNeoForge::onServerStarting);
        NeoForge.EVENT_BUS.addListener(TunnelyrefabNeoForge::onServerStopping);
        NeoForge.EVENT_BUS.addListener(TunnelyrefabNeoForge::onClientTick);
        NeoForge.EVENT_BUS.addListener(ToastRenderEventHandler::onRenderGuiLayerPost);
    }

    private static void onCommandRegister(RegisterCommandsEvent event) {
        TunnelCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private static void onServerStarting(ServerStartingEvent event) {
        ServerEvents.onServerStarting(event.getServer());
    }

    private static void onServerStopping(ServerStoppingEvent event) {
        ServerEvents.onServerStopping(event.getServer());
    }

    private static void onKeyRegister(RegisterKeyMappingsEvent event) {
        event.register(TunnelyKeybinds.OPEN_MENU);
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
    }

    private static void onClientTick(ClientTickEvent.Post event) {
        Minecraft minecraft = Minecraft.getInstance();
        while (TunnelyKeybinds.OPEN_MENU.consumeClick()) {
            if (minecraft.screen != null) continue;
            minecraft.setScreen((Screen)new TunnelyMainScreen(null));
        }
    }
}

