/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.tunnel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.ConcurrentHashMap;
import org.texboobcat.tunnelyrefab.tunnel.TunnelClient;

public class HostProxyServer {
    private final String localhost = "127.0.0.1";
    private final int serverPort;
    private final TunnelClient tunnelClient;
    private final ConcurrentHashMap<String, ClientConnection> activeConnections = new ConcurrentHashMap();
    private volatile boolean running = true;

    public HostProxyServer(int serverPort, TunnelClient tunnelClient) {
        this.serverPort = serverPort;
        this.tunnelClient = tunnelClient;
    }

    public void handleRelayPacket(String clientId, byte[] data) {
        ClientConnection connection;
        if (!this.running || data == null || data.length == 0) {
            return;
        }
        if (clientId == null || clientId.isEmpty()) {
            clientId = "__legacy__";
        }
        if ((connection = this.getOrCreateConnection(clientId)) != null && connection.isConnected()) {
            try {
                connection.sendToMinecraft(data);
            }
            catch (IOException e) {
                System.err.println("[Tunnely Host] Error sending to Minecraft server for client " + clientId + ": " + e.getMessage());
                this.activeConnections.remove(clientId);
                connection.close();
            }
        }
    }

    public void handleRelayPacket(byte[] data) {
        this.handleRelayPacket("__legacy__", data);
    }

    private ClientConnection getOrCreateConnection(String clientId) {
        ClientConnection existing = this.activeConnections.get(clientId);
        if (existing != null && !existing.isConnected()) {
            System.out.println("[Tunnely Host] Removing dead connection for client " + clientId + ", will recreate");
            this.activeConnections.remove(clientId);
            existing.close();
            existing = null;
        }
        if (existing == null) {
            try {
                System.out.println("[Tunnely Host] Creating connection to local Minecraft server on port " + this.serverPort + " for client " + clientId);
                ClientConnection conn = new ClientConnection(clientId, "127.0.0.1", this.serverPort);
                conn.start();
                this.activeConnections.put(clientId, conn);
                return conn;
            }
            catch (IOException e) {
                System.err.println("[Tunnely Host] Failed to connect to local Minecraft server for client " + clientId + ": " + e.getMessage());
                return null;
            }
        }
        return existing;
    }

    public void forceReconnect(String clientId) {
        if (clientId == null) {
            System.out.println("[Tunnely Host] Forcing Minecraft connection refresh for ALL clients...");
            for (ClientConnection cc : this.activeConnections.values()) {
                cc.close();
            }
            this.activeConnections.clear();
            return;
        }
        System.out.println("[Tunnely Host] Forcing Minecraft connection refresh for client " + clientId + "...");
        ClientConnection current = this.activeConnections.get(clientId);
        if (current != null) {
            current.close();
            this.activeConnections.remove(clientId);
            System.out.println("[Tunnely Host] Connection closed for client " + clientId + ", will reconnect on next packet");
        }
    }

    public void forceReconnect() {
        this.forceReconnect("__legacy__");
    }

    public void shutdown() {
        this.running = false;
        for (ClientConnection connection : this.activeConnections.values()) {
            connection.close();
        }
        this.activeConnections.clear();
        System.out.println("[Tunnely Host] Proxy server shutdown complete");
    }

    private class ClientConnection {
        private final String clientId;
        private final Socket minecraftSocket;
        private final OutputStream toMinecraft;
        private final InputStream fromMinecraft;
        private final Thread readerThread;
        private volatile boolean connected = true;

        public ClientConnection(String clientId, String host, int port) throws IOException {
            this.clientId = clientId;
            this.minecraftSocket = new Socket(host, port);
            this.toMinecraft = this.minecraftSocket.getOutputStream();
            this.fromMinecraft = this.minecraftSocket.getInputStream();
            this.readerThread = new Thread(this::readFromMinecraft, "Tunnely-HostProxy-Reader-" + clientId);
            System.out.println("[Tunnely Host] Connected to local Minecraft server: " + host + ":" + port + " (client " + clientId + ")");
        }

        public void start() {
            this.readerThread.start();
        }

        public boolean isConnected() {
            return this.connected && !this.minecraftSocket.isClosed();
        }

        public void sendToMinecraft(byte[] data) throws IOException {
            if (!this.isConnected()) {
                throw new IOException("Connection closed");
            }
            this.toMinecraft.write(data);
            this.toMinecraft.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readFromMinecraft() {
            byte[] buffer = new byte[8192];
            try {
                int bytesRead;
                while (this.connected && HostProxyServer.this.running && (bytesRead = this.fromMinecraft.read(buffer)) != -1) {
                    byte[] packet = new byte[bytesRead];
                    System.arraycopy(buffer, 0, packet, 0, bytesRead);
                    if (HostProxyServer.this.tunnelClient == null || !HostProxyServer.this.tunnelClient.isConnected()) continue;
                    HostProxyServer.this.tunnelClient.sendPacketToClient(packet, this.clientId);
                }
                System.out.println("[Tunnely Host] Minecraft connection closed for client " + this.clientId + ", will auto-reconnect on next packet");
                this.connected = false;
            }
            catch (IOException e) {
                if (this.connected && HostProxyServer.this.running) {
                    System.err.println("[Tunnely Host] Error reading from Minecraft (client " + this.clientId + "): " + e.getMessage());
                }
                this.connected = false;
            }
            finally {
                System.out.println("[Tunnely Host] Reader thread exiting for client " + this.clientId + ", connection will be recreated as needed");
            }
        }

        public void close() {
            this.connected = false;
            try {
                if (this.minecraftSocket != null && !this.minecraftSocket.isClosed()) {
                    this.minecraftSocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.readerThread != null && this.readerThread.isAlive()) {
                this.readerThread.interrupt();
            }
        }
    }
}

