/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.tunnel.ClientTunnelManager;
import org.texboobcat.tunnelyrefab.ui.screens.ConnectionInfoScreen;

public class DirectJoinScreen
extends Screen {
    private final Screen parent;
    private EditBox endpointInput;
    private String statusMessage = "";
    private int statusColor = 0xFFFFFF;
    private Button connectButton;
    private Button helpButton;
    private boolean showHelpTooltip = false;

    public DirectJoinScreen(Screen parent) {
        super((Component)Component.literal((String)"Direct Join"));
        this.parent = parent;
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.fill(0, 0, this.width, this.height, -15724528);
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        int startY = this.height / 2 - 50;
        this.endpointInput = new EditBox(this.font, centerX - 150, startY, 300, 20, (Component)Component.literal((String)"Tunnel Endpoint"));
        this.endpointInput.setMaxLength(200);
        this.endpointInput.setHint((Component)Component.literal((String)"relay-host:port/session-id"));
        this.endpointInput.setValue("");
        this.addRenderableWidget((GuiEventListener)this.endpointInput);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\ud83d\udccb Paste"), button -> {
            String clipboard = this.minecraft.keyboardHandler.getClipboard();
            this.endpointInput.setValue(clipboard);
            this.validateEndpoint(clipboard);
        }).bounds(centerX - 155, startY + 30, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Clear"), button -> {
            this.endpointInput.setValue("");
            this.statusMessage = "";
        }).bounds(centerX + 55, startY + 30, 100, 20).build());
        this.connectButton = Button.builder((Component)Component.literal((String)"\ud83d\udd17 Connect"), button -> this.connectToServer()).bounds(centerX - 100, startY + 60, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.connectButton);
        this.helpButton = Button.builder((Component)Component.literal((String)"\u2139\ufe0f How to use"), button -> {}).bounds(centerX - 100, startY + 90, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.helpButton);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), button -> this.minecraft.setScreen(this.parent)).bounds(centerX - 100, this.height - 30, 200, 20).build());
    }

    private boolean validateEndpoint(String endpoint) {
        if (endpoint == null || endpoint.trim().isEmpty()) {
            this.statusMessage = "\u00a7cPlease enter a tunnel endpoint";
            this.statusColor = 0xFF0000;
            return false;
        }
        if (!(endpoint = endpoint.trim()).contains(":") || !endpoint.contains("/")) {
            this.statusMessage = "\u00a7cInvalid format. Expected: host:port/session-id";
            this.statusColor = 0xFF0000;
            return false;
        }
        String[] parts = endpoint.split("/", 2);
        if (parts.length != 2) {
            this.statusMessage = "\u00a7cInvalid format. Expected: host:port/session-id";
            this.statusColor = 0xFF0000;
            return false;
        }
        String hostPort = parts[0];
        String sessionId = parts[1];
        if (!hostPort.contains(":")) {
            this.statusMessage = "\u00a7cMissing port. Expected: host:port/session-id";
            this.statusColor = 0xFF0000;
            return false;
        }
        if (sessionId.trim().isEmpty()) {
            this.statusMessage = "\u00a7cMissing session ID";
            this.statusColor = 0xFF0000;
            return false;
        }
        this.statusMessage = "\u00a7aValid endpoint format \u2713";
        this.statusColor = 65280;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void connectToServer() {
        String sessionId;
        Object relayUrl;
        block5: {
            String endpoint = this.endpointInput.getValue().trim();
            if (!this.validateEndpoint(endpoint)) {
                return;
            }
            System.out.println("[Tunnely UI] Direct joining to endpoint: " + endpoint);
            if (endpoint.contains("://")) {
                int lastSlash = endpoint.lastIndexOf(47);
                if (lastSlash > 0 && lastSlash < endpoint.length() - 1) {
                    relayUrl = endpoint.substring(0, lastSlash);
                    sessionId = endpoint.substring(lastSlash + 1);
                    break block5;
                } else {
                    this.statusMessage = "\u00a7cInvalid endpoint format";
                    this.statusColor = 0xFF0000;
                    return;
                }
            }
            String[] parts = endpoint.split("/", 2);
            if (parts.length != 2) {
                this.statusMessage = "\u00a7cInvalid endpoint format";
                this.statusColor = 0xFF0000;
                return;
            }
            String relayHostPort = parts[0];
            sessionId = parts[1];
            relayUrl = "wss://" + relayHostPort;
            System.out.println("[Tunnely UI] Legacy endpoint format detected, assuming WSS");
        }
        this.statusMessage = "\u00a7eConnecting to server...";
        this.statusColor = 0xFFFF00;
        ClientTunnelManager clientManager = ClientTunnelManager.getInstance();
        clientManager.connectToServer((String)relayUrl, sessionId, () -> this.minecraft.execute(() -> {
            this.statusMessage = "\u00a7aConnecting to Minecraft server...";
            this.statusColor = 65280;
            System.out.println("[Tunnely UI] Successfully connected through tunnel!");
        }), error -> this.minecraft.execute(() -> {
            System.err.println("[Tunnely UI] Connection error: " + error);
            String errorType = this.categorizeError((String)error);
            this.minecraft.setScreen((Screen)new ConnectionInfoScreen(this.parent, "Direct Connection", errorType, (String)error, errorType.equals("FULL") || errorType.equals("CONNECTION_FAILED") ? this::connectToServer : null));
        }));
    }

    private String categorizeError(String error) {
        if (error == null) {
            return "GENERIC";
        }
        String lowerError = error.toLowerCase();
        if (lowerError.contains("full") || lowerError.contains("capacity")) {
            return "FULL";
        }
        if (lowerError.contains("not authorized") || lowerError.contains("unauthorized")) {
            return "NOT_AUTHORIZED";
        }
        if (lowerError.contains("not found") || lowerError.contains("session not found")) {
            return "NOT_FOUND";
        }
        if (lowerError.contains("connection") || lowerError.contains("timeout") || lowerError.contains("failed to connect")) {
            return "CONNECTION_FAILED";
        }
        if (lowerError.contains("incompatible") || lowerError.contains("version")) {
            return "INCOMPATIBLE";
        }
        return "GENERIC";
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        graphics.drawCenteredString(this.font, "\u00a77Enter a tunnel endpoint to connect directly", this.width / 2, 35, 0xAAAAAA);
        graphics.drawString(this.font, "\u00a7eTunnel Endpoint:", this.width / 2 - 150, this.height / 2 - 65, 0xFFFF00);
        if (!this.statusMessage.isEmpty()) {
            graphics.drawCenteredString(this.font, this.statusMessage, this.width / 2, this.height / 2 + 20, this.statusColor);
        }
        this.showHelpTooltip = this.helpButton.isMouseOver((double)mouseX, (double)mouseY);
        if (this.showHelpTooltip) {
            int tooltipX = mouseX + 10;
            int tooltipY = mouseY - 10;
            int tooltipWidth = 280;
            int tooltipHeight = 80;
            if (tooltipX + tooltipWidth > this.width) {
                tooltipX = this.width - tooltipWidth - 5;
            }
            if (tooltipY + tooltipHeight > this.height) {
                tooltipY = this.height - tooltipHeight - 5;
            }
            if (tooltipY < 5) {
                tooltipY = 5;
            }
            graphics.fill(tooltipX - 5, tooltipY - 5, tooltipX + tooltipWidth, tooltipY + tooltipHeight, -267386864);
            graphics.renderOutline(tooltipX - 5, tooltipY - 5, tooltipWidth + 5, tooltipHeight + 5, -11513776);
            int textY = tooltipY;
            graphics.drawString(this.font, "\u00a76How to use Direct Join:", tooltipX, textY, 0xFFFFFF);
            graphics.drawString(this.font, "\u00a771. Get endpoint from a friend", tooltipX, textY += 14, 0xAAAAAA);
            graphics.drawString(this.font, "\u00a772. Paste it in the box above", tooltipX, textY += 12, 0xAAAAAA);
            graphics.drawString(this.font, "\u00a773. Click Connect", tooltipX, textY += 12, 0xAAAAAA);
            graphics.drawString(this.font, "\u00a774. Add server in multiplayer menu", tooltipX, textY += 12, 0xAAAAAA);
            graphics.drawString(this.font, "\u00a78Example: relay.example.com:8080/abc-123", tooltipX, textY += 16, 0x888888);
        }
    }

    public void tick() {
        super.tick();
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String text = this.endpointInput.getValue();
        super.resize(minecraft, width, height);
        this.endpointInput.setValue(text);
    }

    public boolean isPauseScreen() {
        return true;
    }
}

