/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.ui.screens.LoginScreen;
import org.texboobcat.tunnelyrefab.ui.screens.ScanReportScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldDetailsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldUpdateScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldUploadScreen;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;
import org.texboobcat.tunnelyrefab.worlds.ui.ScanStatusColors;
import org.texboobcat.tunnelyrefab.worlds.ui.ScanStatusRenderer;

public class MyWorldsScreen
extends Screen {
    private final Screen parent;
    private final WorldManager worldManager;
    private List<WorldInfo> myWorlds = new ArrayList<WorldInfo>();
    private int scrollOffset = 0;
    private final int WORLD_ENTRY_HEIGHT = 75;
    private int maxScrollOffset = 0;
    private boolean loading = false;
    private String statusMessage = "";
    private WorldInfo hoveredWorld = null;
    private String hoveredButton = null;

    public MyWorldsScreen(Screen parent) {
        super((Component)Component.literal((String)"My Worlds"));
        this.parent = parent;
        this.worldManager = new WorldManager();
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        if (!this.worldManager.isAuthenticated()) {
            this.statusMessage = "\u00a7cYou must be logged in to manage your worlds";
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Go to Login"), button -> this.minecraft.setScreen((Screen)new LoginScreen(this.parent))).bounds(centerX - 75, this.height / 2, 150, 20).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), button -> this.minecraft.setScreen(this.parent)).bounds(centerX - 50, this.height / 2 + 30, 100, 20).build());
            return;
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Upload New World"), button -> this.minecraft.setScreen((Screen)new WorldUploadScreen(this))).bounds(centerX - 105, this.height - 30, 110, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), button -> this.minecraft.setScreen(this.parent)).bounds(centerX + 10, this.height - 30, 100, 20).build());
        this.loadMyWorlds();
    }

    private void loadMyWorlds() {
        if (this.loading) {
            return;
        }
        this.loading = true;
        this.statusMessage = "Loading your worlds...";
        new Thread(() -> {
            try {
                List<WorldInfo> worlds = this.worldManager.getMyWorlds();
                this.minecraft.execute(() -> {
                    this.myWorlds = worlds;
                    this.scrollOffset = 0;
                    this.updateMaxScroll();
                    this.loading = false;
                    this.statusMessage = this.myWorlds.isEmpty() ? "You haven't uploaded any worlds yet" : "Loaded " + this.myWorlds.size() + " worlds";
                });
            }
            catch (Exception e) {
                this.minecraft.execute(() -> {
                    this.statusMessage = "\u00a7cFailed to load worlds: " + e.getMessage();
                    this.loading = false;
                });
            }
        }).start();
    }

    private void deleteWorld(WorldInfo world) {
        if (this.loading) {
            return;
        }
        this.loading = true;
        this.statusMessage = "Deleting " + world.getName() + "...";
        new Thread(() -> {
            try {
                boolean success = this.worldManager.deleteWorld(world.getId());
                this.minecraft.execute(() -> {
                    this.loading = false;
                    if (success) {
                        this.statusMessage = "\u00a7a\u2713 World deleted";
                        this.loadMyWorlds();
                    } else {
                        this.statusMessage = "\u00a7c\u2717 Failed to delete world";
                    }
                });
            }
            catch (Exception e) {
                this.minecraft.execute(() -> {
                    this.loading = false;
                    this.statusMessage = "\u00a7cDelete failed: " + e.getMessage();
                });
            }
        }).start();
    }

    private void viewWorld(WorldInfo world) {
        this.minecraft.setScreen((Screen)new WorldDetailsScreen(this, world));
    }

    private void updateMaxScroll() {
        int visibleHeight = this.height - 100;
        int contentHeight = this.myWorlds.size() * 75;
        this.maxScrollOffset = Math.max(0, contentHeight - visibleHeight);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, "\ud83d\udcc1 My Uploaded Worlds", this.width / 2, 15, 0xFFFFFF);
        if (!this.statusMessage.isEmpty()) {
            graphics.drawCenteredString(this.font, this.statusMessage, this.width / 2, 35, 0xAAAAAA);
        }
        this.renderWorldList(graphics, mouseX, mouseY);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.fill(0, 0, this.width, this.height, -15724528);
    }

    public boolean isPauseScreen() {
        return true;
    }

    private void renderWorldList(GuiGraphics graphics, int mouseX, int mouseY) {
        int startY = 55;
        int endY = this.height - 50;
        int centerX = this.width / 2;
        int entryWidth = 400;
        int entryX = centerX - entryWidth / 2;
        graphics.enableScissor(0, startY, this.width, endY);
        int yOffset = startY - this.scrollOffset;
        for (int i = 0; i < this.myWorlds.size(); ++i) {
            WorldInfo world = this.myWorlds.get(i);
            int entryY = yOffset + i * 75;
            if (entryY + 75 < startY || entryY > endY) continue;
            this.renderWorldEntry(graphics, world, entryX, entryY, entryWidth, mouseX, mouseY);
        }
        graphics.disableScissor();
    }

    private void renderWorldEntry(GuiGraphics graphics, WorldInfo world, int x, int y, int width, int mouseX, int mouseY) {
        boolean hovered = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + 75 - 5;
        int bgColor = hovered ? -2143272896 : -2145378272;
        graphics.fill(x, y, x + width, y + 75 - 5, bgColor);
        graphics.fill(x, y, x + width, y + 1, -12566464);
        graphics.fill(x, y + 75 - 5, x + width, y + 75 - 4, -12566464);
        graphics.drawString(this.font, world.getName(), x + 5, y + 5, 0xFFFFFF);
        String visibilityText = world.isPublic() ? "\u00a7aPublic" : "\u00a77Private";
        graphics.drawString(this.font, visibilityText, x + 5, y + 18, 0xAAAAAA);
        String statsLine = "\u00a77" + world.getFormattedRating() + " | \ud83d\udce5 " + world.getFormattedDownloadCount();
        graphics.drawString(this.font, statsLine, x + 80, y + 18, 0xAAAAAA);
        String scanStatus = ScanStatusRenderer.getStatusText(world, true);
        String warningIcon = ScanStatusRenderer.getWarningIcon(world);
        int statusColor = ScanStatusColors.getStatusColor(world);
        if (!warningIcon.isEmpty()) {
            graphics.drawString(this.font, warningIcon + " " + scanStatus, x + 5, y + 31, statusColor);
        } else {
            graphics.drawString(this.font, scanStatus, x + 5, y + 31, statusColor);
        }
        graphics.drawString(this.font, "\u00a77Uploaded: " + world.getFormattedCreatedAt(), x + 5, y + 44, 0x888888);
        int buttonY = y + 58;
        int buttonWidth = 60;
        int buttonHeight = 18;
        int buttonSpacing = 65;
        int buttonIndex = 0;
        int viewX = x + 5 + buttonIndex * buttonSpacing;
        boolean viewHovered = this.isMouseOverButton(mouseX, mouseY, viewX, buttonY, buttonWidth, buttonHeight);
        if (viewHovered) {
            graphics.fill(viewX, buttonY, viewX + buttonWidth, buttonY + buttonHeight, -2130706433);
            this.hoveredWorld = world;
            this.hoveredButton = "view";
        } else {
            graphics.fill(viewX, buttonY, viewX + buttonWidth, buttonY + buttonHeight, -2139062144);
        }
        graphics.drawCenteredString(this.font, "View", viewX + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
        ++buttonIndex;
        if (!this.loading && ScanStatusRenderer.shouldShowRescanButton(world)) {
            int rescanX = x + 5 + buttonIndex * buttonSpacing;
            boolean rescanHovered = this.isMouseOverButton(mouseX, mouseY, rescanX, buttonY, buttonWidth, buttonHeight);
            if (rescanHovered) {
                graphics.fill(rescanX, buttonY, rescanX + buttonWidth, buttonY + buttonHeight, -2130728448);
                this.hoveredWorld = world;
                this.hoveredButton = "rescan";
            } else {
                graphics.fill(rescanX, buttonY, rescanX + buttonWidth, buttonY + buttonHeight, -2138548992);
            }
            graphics.drawCenteredString(this.font, "Re-scan", rescanX + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
            ++buttonIndex;
        }
        if (!this.loading && ScanStatusRenderer.shouldShowReportButton(world)) {
            int reportX = x + 5 + buttonIndex * buttonSpacing;
            boolean reportHovered = this.isMouseOverButton(mouseX, mouseY, reportX, buttonY, buttonWidth, buttonHeight);
            if (reportHovered) {
                graphics.fill(reportX, buttonY, reportX + buttonWidth, buttonY + buttonHeight, -2130750123);
                this.hoveredWorld = world;
                this.hoveredButton = "report";
            } else {
                graphics.fill(reportX, buttonY, reportX + buttonWidth, buttonY + buttonHeight, -2138557645);
            }
            graphics.drawCenteredString(this.font, "Report", reportX + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
            ++buttonIndex;
        }
        if (!this.loading) {
            int updateX = x + 5 + buttonIndex * buttonSpacing;
            boolean updateHovered = this.isMouseOverButton(mouseX, mouseY, updateX, buttonY, buttonWidth, buttonHeight);
            if (updateHovered) {
                graphics.fill(updateX, buttonY, updateX + buttonWidth, buttonY + buttonHeight, -2147439873);
                this.hoveredWorld = world;
                this.hoveredButton = "update";
            } else {
                graphics.fill(updateX, buttonY, updateX + buttonWidth, buttonY + buttonHeight, -2147461752);
            }
            graphics.drawCenteredString(this.font, "Update", updateX + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
            ++buttonIndex;
        }
        if (!this.loading) {
            int deleteX = x + 5 + buttonIndex * buttonSpacing;
            boolean deleteHovered = this.isMouseOverButton(mouseX, mouseY, deleteX, buttonY, buttonWidth, buttonHeight);
            if (deleteHovered) {
                graphics.fill(deleteX, buttonY, deleteX + buttonWidth, buttonY + buttonHeight, -2130771968);
                this.hoveredWorld = world;
                this.hoveredButton = "delete";
            } else {
                graphics.fill(deleteX, buttonY, deleteX + buttonWidth, buttonY + buttonHeight, -2139095040);
            }
            graphics.drawCenteredString(this.font, "Delete", deleteX + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
        }
    }

    private void updateWorld(WorldInfo world) {
        this.minecraft.setScreen((Screen)new WorldUpdateScreen(this, world));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hoveredWorld != null && this.hoveredButton != null) {
            if (this.hoveredButton.equals("view")) {
                this.viewWorld(this.hoveredWorld);
                return true;
            }
            if (this.hoveredButton.equals("rescan")) {
                this.rescanWorld(this.hoveredWorld);
                return true;
            }
            if (this.hoveredButton.equals("report")) {
                this.viewScanReport(this.hoveredWorld);
                return true;
            }
            if (this.hoveredButton.equals("update")) {
                this.updateWorld(this.hoveredWorld);
                return true;
            }
            if (this.hoveredButton.equals("delete")) {
                this.deleteWorld(this.hoveredWorld);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void rescanWorld(WorldInfo world) {
        if (this.loading) {
            return;
        }
        this.loading = true;
        this.statusMessage = "Triggering scan for " + world.getName() + "...";
        new Thread(() -> {
            try {
                boolean success = this.worldManager.manualTriggerScan(world.getId());
                this.minecraft.execute(() -> {
                    this.loading = false;
                    this.statusMessage = success ? "\u00a7a\u2713 Scan triggered - refresh in a moment" : "\u00a7c\u2717 Failed to trigger scan";
                });
            }
            catch (Exception e) {
                this.minecraft.execute(() -> {
                    this.loading = false;
                    this.statusMessage = "\u00a7cScan trigger failed: " + e.getMessage();
                });
            }
        }).start();
    }

    private void viewScanReport(WorldInfo world) {
        this.minecraft.setScreen((Screen)new ScanReportScreen(this, world));
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.hoveredWorld = null;
        this.hoveredButton = null;
        super.mouseMoved(mouseX, mouseY);
    }

    private boolean isMouseOverButton(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double scrollDelta) {
        this.scrollOffset -= (int)(scrollDelta * 20.0);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScrollOffset));
        return true;
    }
}

