/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.ui.screens.DownloadProgressScreen;
import org.texboobcat.tunnelyrefab.worlds.DownloadState;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;

public class PausedDownloadsScreen
extends Screen {
    private final Screen parent;
    private final WorldManager worldManager;
    private List<PausedDownloadEntry> pausedDownloads = new ArrayList<PausedDownloadEntry>();
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;
    private static final int ENTRY_HEIGHT = 70;
    private PausedDownloadEntry hoveredEntry = null;
    private String hoveredButton = null;

    public PausedDownloadsScreen(Screen parent) {
        super((Component)Component.literal((String)"Paused Downloads"));
        this.parent = parent;
        this.worldManager = new WorldManager();
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\ud83d\udd04 Refresh"), button -> this.loadPausedDownloads()).bounds(centerX - 155, this.height - 30, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2190 Back"), button -> this.minecraft.setScreen(this.parent)).bounds(centerX + 55, this.height - 30, 100, 20).build());
        this.loadPausedDownloads();
    }

    private void loadPausedDownloads() {
        this.pausedDownloads.clear();
        List<Path> stateFiles = this.worldManager.listPausedDownloads();
        for (Path stateFile : stateFiles) {
            try {
                DownloadState state = this.worldManager.getPausedDownloadInfo(stateFile);
                if (state == null) continue;
                this.pausedDownloads.add(new PausedDownloadEntry(state, stateFile));
            }
            catch (Exception e) {
                System.err.println("Failed to load paused download: " + e.getMessage());
            }
        }
        this.updateMaxScroll();
    }

    private void resumeDownload(PausedDownloadEntry entry) {
        this.minecraft.setScreen((Screen)new DownloadProgressScreen(this.parent, this.worldManager, entry.stateFile));
    }

    private void deleteDownload(PausedDownloadEntry entry) {
        try {
            Files.deleteIfExists(Path.of(entry.state.getTempFilePath(), new String[0]));
            Files.deleteIfExists(entry.stateFile);
            this.loadPausedDownloads();
        }
        catch (Exception e) {
            System.err.println("Failed to delete paused download: " + e.getMessage());
        }
    }

    private void updateMaxScroll() {
        int visibleHeight = this.height - 100;
        int contentHeight = this.pausedDownloads.size() * 70;
        this.maxScrollOffset = Math.max(0, contentHeight - visibleHeight);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        int centerX = this.width / 2;
        graphics.drawCenteredString(this.font, "\u23f8 Paused Downloads", centerX, 15, 0xFFFFFF);
        String countText = this.pausedDownloads.isEmpty() ? "No paused downloads" : this.pausedDownloads.size() + " paused download" + (this.pausedDownloads.size() > 1 ? "s" : "");
        graphics.drawCenteredString(this.font, "\u00a77" + countText, centerX, 30, 0xAAAAAA);
        if (!this.pausedDownloads.isEmpty()) {
            this.renderDownloadList(graphics, mouseX, mouseY);
        } else {
            graphics.drawCenteredString(this.font, "\u00a77No paused downloads found", centerX, this.height / 2, 0x888888);
            graphics.drawCenteredString(this.font, "\u00a77Downloads are automatically paused when you close them", centerX, this.height / 2 + 15, 0x666666);
        }
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    private void renderDownloadList(GuiGraphics graphics, int mouseX, int mouseY) {
        int startY = 50;
        int endY = this.height - 40;
        int centerX = this.width / 2;
        int entryWidth = 400;
        int entryX = centerX - entryWidth / 2;
        graphics.enableScissor(0, startY, this.width, endY);
        int yOffset = startY - this.scrollOffset;
        for (int i = 0; i < this.pausedDownloads.size(); ++i) {
            PausedDownloadEntry entry = this.pausedDownloads.get(i);
            int entryY = yOffset + i * 70;
            if (entryY + 70 < startY || entryY > endY) continue;
            this.renderDownloadEntry(graphics, entry, entryX, entryY, entryWidth, mouseX, mouseY);
        }
        graphics.disableScissor();
    }

    private void renderDownloadEntry(GuiGraphics graphics, PausedDownloadEntry entry, int x, int y, int width, int mouseX, int mouseY) {
        DownloadState state = entry.state;
        boolean hovered = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + 70 - 5;
        int bgColor = hovered ? -2143272896 : -2145378272;
        graphics.fill(x, y, x + width, y + 70 - 5, bgColor);
        graphics.fill(x, y, x + width, y + 1, -12566464);
        graphics.fill(x, y + 70 - 5, x + width, y + 70 - 4, -12566464);
        graphics.drawString(this.font, state.getWorldName(), x + 10, y + 8, 0xFFFFFF);
        String progressText = state.getProgressPercentage() + "% complete";
        graphics.drawString(this.font, "\u00a77" + progressText, x + 10, y + 22, 0xAAAAAA);
        int barWidth = width - 20;
        int barHeight = 10;
        int barX = x + 10;
        int barY = y + 35;
        graphics.fill(barX, barY, barX + barWidth, barY + barHeight, Integer.MIN_VALUE);
        int fillWidth = barWidth * state.getProgressPercentage() / 100;
        graphics.fill(barX, barY, barX + fillWidth, barY + barHeight, -2130729728);
        graphics.fill(barX, barY, barX + barWidth, barY + 1, -12566464);
        graphics.fill(barX, barY + barHeight - 1, barX + barWidth, barY + barHeight, -12566464);
        String bytesInfo = state.getDownloadedBytesFormatted() + " / " + state.getTotalBytesFormatted();
        graphics.drawString(this.font, "\u00a77" + bytesInfo, x + 10, y + 48, 0x888888);
        String timeInfo = "Paused: " + this.formatTimeAgo(state.getLastUpdateAt());
        graphics.drawString(this.font, "\u00a78" + timeInfo, x + width - 10 - this.font.width(timeInfo), y + 48, 0x666666);
        int buttonY = y + 8;
        int buttonWidth = 60;
        int buttonHeight = 18;
        int buttonSpacing = 65;
        int buttonStartX = x + width - 130;
        boolean resumeHovered = this.isMouseOverButton(mouseX, mouseY, buttonStartX, buttonY, buttonWidth, buttonHeight);
        if (resumeHovered) {
            graphics.fill(buttonStartX, buttonY, buttonStartX + buttonWidth, buttonY + buttonHeight, -2147418368);
            this.hoveredEntry = entry;
            this.hoveredButton = "resume";
        } else {
            graphics.fill(buttonStartX, buttonY, buttonStartX + buttonWidth, buttonY + buttonHeight, -2147450880);
        }
        graphics.drawCenteredString(this.font, "\u25b6 Resume", buttonStartX + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
        boolean deleteHovered = this.isMouseOverButton(mouseX, mouseY, buttonStartX + buttonSpacing, buttonY, buttonWidth, buttonHeight);
        if (deleteHovered) {
            graphics.fill(buttonStartX + buttonSpacing, buttonY, buttonStartX + buttonSpacing + buttonWidth, buttonY + buttonHeight, -2130771968);
            this.hoveredEntry = entry;
            this.hoveredButton = "delete";
        } else {
            graphics.fill(buttonStartX + buttonSpacing, buttonY, buttonStartX + buttonSpacing + buttonWidth, buttonY + buttonHeight, -2139095040);
        }
        graphics.drawCenteredString(this.font, "\u2716 Delete", buttonStartX + buttonSpacing + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hoveredEntry != null && this.hoveredButton != null) {
            if (this.hoveredButton.equals("resume")) {
                this.resumeDownload(this.hoveredEntry);
                return true;
            }
            if (this.hoveredButton.equals("delete")) {
                int choice = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete this paused download?", "Delete Paused Download", 0);
                if (choice == 0) {
                    this.deleteDownload(this.hoveredEntry);
                }
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.hoveredEntry = null;
        this.hoveredButton = null;
        super.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double scrollDelta) {
        this.scrollOffset -= (int)(scrollDelta * 20.0);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScrollOffset));
        return true;
    }

    private boolean isMouseOverButton(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    private String formatTimeAgo(Instant instant) {
        long days;
        if (instant == null) {
            return "Unknown";
        }
        long secondsAgo = Duration.between(instant, Instant.now()).getSeconds();
        if (secondsAgo < 60L) {
            return "Just now";
        }
        if (secondsAgo < 3600L) {
            long minutes;
            return minutes + " minute" + ((minutes = secondsAgo / 60L) > 1L ? "s" : "") + " ago";
        }
        if (secondsAgo < 86400L) {
            long hours;
            return hours + " hour" + ((hours = secondsAgo / 3600L) > 1L ? "s" : "") + " ago";
        }
        return days + " day" + ((days = secondsAgo / 86400L) > 1L ? "s" : "") + " ago";
    }

    private static class PausedDownloadEntry {
        public final DownloadState state;
        public final Path stateFile;

        public PausedDownloadEntry(DownloadState state, Path stateFile) {
            this.state = state;
            this.stateFile = stateFile;
        }
    }
}

