/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.tunnel.ClientTunnelManager;
import org.texboobcat.tunnelyrefab.ui.screens.ConnectionInfoScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WarningPopupScreen;
import org.texboobcat.tunnelyrefab.util.CompatibilityDetector;
import org.texboobcat.tunnelyrefab.util.SafeDisconnect;

public class PublicLobbiesScreen
extends Screen {
    private final Screen parent;
    private ServerListWidget serverList;
    private String statusMessage = "\u00a7eLoading public servers...";
    private int statusColor = 0xFFFF00;
    private Checkbox compatibleOnlyCheckbox;
    private CompatibilityDetector.CompatibilityInfo clientCompatibility;
    private String regionFilter = "ALL";
    private Button regionButton;
    private Button refreshButton;
    private Button backButton;
    private Set<String> availableRegions = new HashSet<String>();
    private volatile boolean isLoading = false;
    private List<JsonObject> cachedServers = new ArrayList<JsonObject>();
    private int totalServersCount = 0;
    private int compatibleServersCount = 0;
    private int totalPlayersOnline = 0;
    private static boolean warningShownThisSession = false;

    public PublicLobbiesScreen(Screen parent) {
        this(parent, false);
    }

    public PublicLobbiesScreen(Screen parent, boolean skipWarning) {
        super((Component)Component.literal((String)"Public Lobbies"));
        this.parent = parent;
        this.clientCompatibility = CompatibilityDetector.detect();
        if (skipWarning) {
            warningShownThisSession = true;
        }
        System.out.println("[Tunnely] Client compatibility: " + this.clientCompatibility.toString());
    }

    private void cycleRegionFilter() {
        ArrayList<String> regions = new ArrayList<String>();
        regions.add("ALL");
        ArrayList<String> sortedRegions = new ArrayList<String>(this.availableRegions);
        Collections.sort(sortedRegions);
        regions.addAll(sortedRegions);
        int currentIndex = regions.indexOf(this.regionFilter);
        if (currentIndex == -1) {
            this.regionFilter = "ALL";
        } else {
            int nextIndex = (currentIndex + 1) % regions.size();
            this.regionFilter = (String)regions.get(nextIndex);
        }
    }

    private String regionButtonLabel() {
        if (this.availableRegions.isEmpty()) {
            return "Region: ALL";
        }
        return "Region: " + this.regionFilter;
    }

    protected void init() {
        super.init();
        if (!warningShownThisSession && (this.clientCompatibility.modpackId == null || this.clientCompatibility.modpackId.isEmpty())) {
            System.out.println("[Tunnely] No modpack detected - showing compatibility warning popup");
            warningShownThisSession = true;
            this.minecraft.setScreen((Screen)new WarningPopupScreen(new PublicLobbiesScreen(this.parent, true), this.parent, "Warning: No Modpack Detected", "\u00a77You don't have a modpack file detected.\n\n\u00a77This means you're \u00a7chighly likely to be incompatible\u00a77\n\u00a77with most public servers.\n\n\u00a77Most public servers use modpacks from:\n\u00a78\u2022 \u00a77CurseForge\n\u00a78\u2022 \u00a77Modrinth\n\u00a78\u2022 \u00a77Custom modpacks\n\n\u00a77You can still browse, but check compatibility carefully!", 0xFFAA00, null));
            return;
        }
        this.serverList = new ServerListWidget(this.minecraft, this.width, this.height, 70, this.height - 60, 75);
        this.addWidget((GuiEventListener)this.serverList);
        int buttonWidth = 100;
        int buttonSpacing = 8;
        int totalButtonsWidth = buttonWidth * 3 + buttonSpacing * 2 + 140;
        int startX = (this.width - totalButtonsWidth) / 2;
        int buttonY = this.height - 40;
        this.compatibleOnlyCheckbox = Checkbox.builder((Component)Component.literal((String)"Compatible Only"), (Font)this.font).pos(startX, buttonY).selected(false).onValueChange((checkbox, checked) -> {
            if (this.serverList != null) {
                this.serverList.setSelected(null);
            }
            if (!this.isLoading && !this.cachedServers.isEmpty()) {
                this.applyFiltersAndRender();
            } else {
                this.loadPublicServers();
            }
        }).build();
        this.addRenderableWidget((GuiEventListener)this.compatibleOnlyCheckbox);
        this.regionButton = Button.builder((Component)Component.literal((String)this.regionButtonLabel()), button -> {
            this.cycleRegionFilter();
            button.setMessage((Component)Component.literal((String)this.regionButtonLabel()));
            if (!this.isLoading && !this.cachedServers.isEmpty()) {
                this.applyFiltersAndRender();
            } else {
                this.loadPublicServers();
            }
        }).bounds(startX + 140 + buttonSpacing, buttonY, buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.regionButton);
        this.refreshButton = Button.builder((Component)Component.literal((String)"\u27f3 Refresh"), button -> this.loadPublicServers()).bounds(startX + 140 + buttonSpacing + buttonWidth + buttonSpacing, buttonY, buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.refreshButton);
        this.backButton = Button.builder((Component)Component.literal((String)"Back"), button -> this.minecraft.setScreen(this.parent)).bounds(startX + 140 + buttonSpacing + (buttonWidth + buttonSpacing) * 2, buttonY, buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.backButton);
        this.loadPublicServers();
    }

    private void loadPublicServers() {
        if (this.isLoading) {
            System.out.println("[Tunnely UI] Load already in progress; skipping new request");
            return;
        }
        this.isLoading = true;
        System.out.println("[Tunnely UI] ===== LOADING PUBLIC SERVERS =====");
        this.statusMessage = "\u00a7eLoading public servers...";
        this.statusColor = 0xFFFF00;
        this.serverList.clear();
        this.availableRegions.clear();
        this.cachedServers.clear();
        this.totalServersCount = 0;
        this.compatibleServersCount = 0;
        this.totalPlayersOnline = 0;
        if (this.compatibleOnlyCheckbox != null) {
            this.compatibleOnlyCheckbox.active = false;
        }
        if (this.regionButton != null) {
            this.regionButton.active = false;
        }
        if (this.refreshButton != null) {
            this.refreshButton.active = false;
        }
        if (this.backButton != null) {
            this.backButton.active = false;
        }
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                SupabaseClient.ServerListResult result = client.getPublicServers();
                this.minecraft.execute(() -> {
                    if (result.success) {
                        try {
                            System.out.println("[Tunnely UI] Parsing public server data...");
                            JsonArray servers = JsonParser.parseString((String)result.data).getAsJsonArray();
                            System.out.println("[Tunnely UI] Found " + servers.size() + " public server(s)");
                            this.cachedServers.clear();
                            for (JsonElement element : servers) {
                                this.cachedServers.add(element.getAsJsonObject());
                            }
                            this.applyFiltersAndRender();
                            if (this.regionButton != null) {
                                this.regionButton.setMessage((Component)Component.literal((String)this.regionButtonLabel()));
                            }
                            if (this.compatibleOnlyCheckbox != null) {
                                this.compatibleOnlyCheckbox.active = true;
                            }
                            if (this.regionButton != null) {
                                this.regionButton.active = true;
                            }
                            if (this.refreshButton != null) {
                                this.refreshButton.active = true;
                            }
                            if (this.backButton != null) {
                                this.backButton.active = true;
                            }
                            this.isLoading = false;
                        }
                        catch (Exception e) {
                            this.statusMessage = "\u00a7cFailed to parse server list";
                            this.statusColor = 0xFF0000;
                            System.err.println("[Tunnely UI] \u2717 Exception parsing public servers: " + e.getMessage());
                            e.printStackTrace();
                            if (this.compatibleOnlyCheckbox != null) {
                                this.compatibleOnlyCheckbox.active = true;
                            }
                            if (this.regionButton != null) {
                                this.regionButton.active = true;
                            }
                            if (this.refreshButton != null) {
                                this.refreshButton.active = true;
                            }
                            if (this.backButton != null) {
                                this.backButton.active = true;
                            }
                            this.isLoading = false;
                        }
                    } else {
                        this.statusMessage = "\u00a7c" + result.error;
                        this.statusColor = 0xFF0000;
                        System.err.println("[Tunnely UI] \u2717 Failed to load public servers: " + result.error);
                        if (this.compatibleOnlyCheckbox != null) {
                            this.compatibleOnlyCheckbox.active = true;
                        }
                        if (this.regionButton != null) {
                            this.regionButton.active = true;
                        }
                        if (this.refreshButton != null) {
                            this.refreshButton.active = true;
                        }
                        if (this.backButton != null) {
                            this.backButton.active = true;
                        }
                        this.isLoading = false;
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception loading public servers: " + e.getMessage());
                e.printStackTrace();
                this.minecraft.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                    if (this.compatibleOnlyCheckbox != null) {
                        this.compatibleOnlyCheckbox.active = true;
                    }
                    if (this.regionButton != null) {
                        this.regionButton.active = true;
                    }
                    if (this.refreshButton != null) {
                        this.refreshButton.active = true;
                    }
                    if (this.backButton != null) {
                        this.backButton.active = true;
                    }
                    this.isLoading = false;
                });
            }
        }, "Tunnely-LoadPublic").start();
    }

    private void applyFiltersAndRender() {
        try {
            this.serverList.clear();
            this.availableRegions.clear();
            boolean filterCompatible = this.compatibleOnlyCheckbox != null && this.compatibleOnlyCheckbox.selected();
            String region = this.regionFilter;
            int displayedCount = 0;
            this.totalServersCount = 0;
            this.compatibleServersCount = 0;
            this.totalPlayersOnline = 0;
            if (this.cachedServers.isEmpty()) {
                this.statusMessage = "\u00a77No public servers available";
                this.statusColor = 0xAAAAAA;
            } else {
                for (JsonObject server : this.cachedServers) {
                    String relayRegion;
                    String serverId = server.get("id").getAsString();
                    String serverName = server.has("server_name") && !server.get("server_name").isJsonNull() ? server.get("server_name").getAsString() : "Unnamed Server";
                    String endpoint = server.has("public_endpoint") && !server.get("public_endpoint").isJsonNull() ? server.get("public_endpoint").getAsString() : "N/A";
                    String gameMode = server.has("game_mode") && !server.get("game_mode").isJsonNull() ? server.get("game_mode").getAsString() : "survival";
                    String string = relayRegion = server.has("relay_region") && !server.get("relay_region").isJsonNull() ? server.get("relay_region").getAsString() : "Unknown";
                    if (relayRegion != null && !relayRegion.equals("Unknown")) {
                        this.availableRegions.add(relayRegion);
                    }
                    String minecraftVersion = server.has("minecraft_version") && !server.get("minecraft_version").isJsonNull() ? server.get("minecraft_version").getAsString() : null;
                    String modLoader = server.has("mod_loader") && !server.get("mod_loader").isJsonNull() ? server.get("mod_loader").getAsString() : null;
                    String modpackId = server.has("modpack_id") && !server.get("modpack_id").isJsonNull() ? server.get("modpack_id").getAsString() : null;
                    String modpackVersion = server.has("modpack_version") && !server.get("modpack_version").isJsonNull() ? server.get("modpack_version").getAsString() : null;
                    int currentPlayers = server.has("current_players") && !server.get("current_players").isJsonNull() ? server.get("current_players").getAsInt() : 0;
                    int maxPlayers = server.has("max_players") && !server.get("max_players").isJsonNull() ? server.get("max_players").getAsInt() : 20;
                    this.totalPlayersOnline += currentPlayers;
                    CompatibilityDetector.CompatibilityInfo serverCompat = new CompatibilityDetector.CompatibilityInfo(minecraftVersion, modLoader, modpackId, modpackVersion);
                    boolean isCompatible = this.clientCompatibility.isCompatibleWith(serverCompat);
                    ++this.totalServersCount;
                    if (isCompatible) {
                        ++this.compatibleServersCount;
                    }
                    if (filterCompatible && !isCompatible || !"ALL".equalsIgnoreCase(region) && (relayRegion == null || !relayRegion.equalsIgnoreCase(region))) continue;
                    ++displayedCount;
                    String hostName = "Unknown";
                    if (server.has("host") && !server.get("host").isJsonNull()) {
                        JsonObject hostProfile = server.getAsJsonObject("host");
                        if (hostProfile.has("minecraft_name") && !hostProfile.get("minecraft_name").isJsonNull()) {
                            hostName = hostProfile.get("minecraft_name").getAsString();
                        }
                    } else if (server.has("host_name") && !server.get("host_name").isJsonNull()) {
                        hostName = server.get("host_name").getAsString();
                    }
                    this.serverList.addServer(serverId, serverName, hostName, endpoint, gameMode, relayRegion, serverCompat, isCompatible, currentPlayers, maxPlayers);
                }
                if (displayedCount == 0 && filterCompatible) {
                    this.statusMessage = "\u00a77No compatible servers found";
                    this.statusColor = 0xAAAAAA;
                } else if (displayedCount == 0) {
                    this.statusMessage = "\u00a77No servers match filters";
                    this.statusColor = 0xAAAAAA;
                } else {
                    this.statusMessage = "\u00a7aShowing " + displayedCount + " of " + this.totalServersCount + " server(s)";
                    this.statusColor = 65280;
                }
            }
            if (this.regionButton != null) {
                this.regionButton.setMessage((Component)Component.literal((String)this.regionButtonLabel()));
            }
        }
        catch (Exception e) {
            System.err.println("[Tunnely UI] Error while applying filters: " + e.getMessage());
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.fill(0, 0, this.width, 68, -1728053248);
        this.serverList.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, "\u00a76\u00a7lPublic Lobbies", this.width / 2, 12, 0xFFFFFF);
        graphics.drawCenteredString(this.font, this.statusMessage, this.width / 2, 28, this.statusColor);
        if (!this.isLoading && this.totalServersCount > 0) {
            String statsLeft = "\u00a77Players Online: \u00a7f" + this.totalPlayersOnline;
            String statsRight = "\u00a77Compatible: \u00a7a" + this.compatibleServersCount + "\u00a77/\u00a7f" + this.totalServersCount;
            graphics.drawString(this.font, statsLeft, 10, 48, 0xAAAAAA);
            graphics.drawString(this.font, statsRight, this.width - this.font.width(statsRight) - 10, 48, 0xAAAAAA);
        }
        graphics.fill(0, this.height - 55, this.width, this.height, -1728053248);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.fill(0, 0, this.width, this.height, -15724528);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return true;
    }

    private class ServerListWidget
    extends ObjectSelectionList<ServerEntry> {
        public ServerListWidget(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraft, width, height, top, bottom);
        }

        public void clear() {
            this.clearEntries();
            this.setSelected(null);
        }

        public void addServer(String id, String serverName, String hostName, String endpoint, String gameMode, String relayRegion, CompatibilityDetector.CompatibilityInfo compatibility, boolean isCompatible, int currentPlayers, int maxPlayers) {
            this.addEntry((AbstractSelectionList.Entry)new ServerEntry(id, serverName, hostName, endpoint, gameMode, relayRegion, compatibility, isCompatible, currentPlayers, maxPlayers));
        }

        class ServerEntry
        extends ObjectSelectionList.Entry<ServerEntry> {
            private final String id;
            private final String serverName;
            private final String hostName;
            private final String endpoint;
            private final String gameMode;
            private final String relayRegion;
            private final CompatibilityDetector.CompatibilityInfo compatibility;
            private final boolean isCompatible;
            private final int currentPlayers;
            private final int maxPlayers;
            private final Button joinButton;

            public ServerEntry(String id, String serverName, String hostName, String endpoint, String gameMode, String relayRegion, CompatibilityDetector.CompatibilityInfo compatibility, boolean isCompatible, int currentPlayers, int maxPlayers) {
                this.id = id;
                this.serverName = serverName;
                this.hostName = hostName;
                this.endpoint = endpoint;
                this.gameMode = gameMode;
                this.relayRegion = relayRegion;
                this.compatibility = compatibility;
                this.isCompatible = isCompatible;
                this.currentPlayers = currentPlayers;
                this.maxPlayers = maxPlayers;
                boolean isFull = currentPlayers >= maxPlayers;
                this.joinButton = Button.builder((Component)Component.literal((String)(isFull ? "Full" : "Join")), button -> this.joinServer()).bounds(0, 0, 60, 20).build();
                this.joinButton.active = !isFull;
            }

            /*
             * Enabled aggressive block sorting
             */
            private void joinServer() {
                String sessionId;
                Object relayUrl;
                block6: {
                    System.out.println("[Tunnely UI] Joining server: " + this.id + " (" + this.serverName + ")");
                    if (this.endpoint == null || this.endpoint.equals("N/A")) {
                        System.err.println("[Tunnely UI] Cannot join - no endpoint available");
                        PublicLobbiesScreen.this.minecraft.setScreen((Screen)new ConnectionInfoScreen(PublicLobbiesScreen.this, this.serverName, "NOT_FOUND", "Server endpoint not available"));
                        return;
                    }
                    if (this.currentPlayers >= this.maxPlayers) {
                        System.err.println("[Tunnely UI] Cannot join - server is full");
                        PublicLobbiesScreen.this.minecraft.setScreen((Screen)new ConnectionInfoScreen(PublicLobbiesScreen.this, this.serverName, "FULL", "Server is full", this::joinServer));
                        return;
                    }
                    if (this.endpoint.contains("://")) {
                        int lastSlash = this.endpoint.lastIndexOf(47);
                        if (lastSlash > 0 && lastSlash < this.endpoint.length() - 1) {
                            relayUrl = this.endpoint.substring(0, lastSlash);
                            sessionId = this.endpoint.substring(lastSlash + 1);
                            break block6;
                        } else {
                            System.err.println("[Tunnely UI] Invalid endpoint format: " + this.endpoint);
                            PublicLobbiesScreen.this.minecraft.setScreen((Screen)new ConnectionInfoScreen(PublicLobbiesScreen.this, this.serverName, "GENERIC", "Invalid endpoint format: " + this.endpoint));
                            return;
                        }
                    }
                    if (!this.endpoint.contains("/")) {
                        System.err.println("[Tunnely UI] Invalid endpoint format: " + this.endpoint);
                        PublicLobbiesScreen.this.minecraft.setScreen((Screen)new ConnectionInfoScreen(PublicLobbiesScreen.this, this.serverName, "GENERIC", "Invalid endpoint format: " + this.endpoint));
                        return;
                    }
                    String[] parts = this.endpoint.split("/", 2);
                    String relayHostPort = parts[0];
                    sessionId = parts[1];
                    relayUrl = "wss://" + relayHostPort;
                    System.out.println("[Tunnely UI] Legacy endpoint format detected, assuming WSS");
                }
                System.out.println("[Tunnely UI] Parsed relay URL: " + (String)relayUrl);
                System.out.println("[Tunnely UI] Session ID: " + sessionId);
                SafeDisconnect.disconnectAndThen(() -> this.lambda$joinServer$4((String)relayUrl, sessionId));
            }

            private String categorizeError(String error) {
                if (error == null) {
                    return "GENERIC";
                }
                String lowerError = error.toLowerCase();
                if (lowerError.contains("full") || lowerError.contains("capacity")) {
                    return "FULL";
                }
                if (lowerError.contains("not authorized") || lowerError.contains("unauthorized")) {
                    return "NOT_AUTHORIZED";
                }
                if (lowerError.contains("not found") || lowerError.contains("session not found")) {
                    return "NOT_FOUND";
                }
                if (lowerError.contains("connection") || lowerError.contains("timeout") || lowerError.contains("failed to connect")) {
                    return "CONNECTION_FAILED";
                }
                if (lowerError.contains("incompatible") || lowerError.contains("version")) {
                    return "INCOMPATIBLE";
                }
                return "GENERIC";
            }

            public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                int textWidth;
                float playerRatio;
                int bgColor = isMouseOver ? 0x33FFFFFF : 0x22000000;
                graphics.fill(left + 2, top + 2, left + width - 2, top + height - 2, bgColor);
                String compatIcon = this.isCompatible ? "\u00a7a\u2713" : "\u00a7c\u2717";
                graphics.drawString(PublicLobbiesScreen.this.font, compatIcon, left + 8, top + 8, 0xFFFFFF);
                String displayName = this.serverName.length() > 30 ? this.serverName.substring(0, 27) + "..." : this.serverName;
                graphics.drawString(PublicLobbiesScreen.this.font, "\u00a7f\u00a7l" + displayName, left + 28, top + 8, 0xFFFFFF);
                String hostInfo = "\u00a77Host: \u00a7f" + (String)(this.hostName.length() > 15 ? this.hostName.substring(0, 12) + "..." : this.hostName);
                graphics.drawString(PublicLobbiesScreen.this.font, hostInfo, left + 28, top + 20, 0xAAAAAA);
                Object playerText = "\u00a77Players: ";
                float f = playerRatio = this.maxPlayers > 0 ? (float)this.currentPlayers / (float)this.maxPlayers : 0.0f;
                String playerColor = playerRatio >= 0.9f ? "\u00a7c" : (playerRatio >= 0.7f ? "\u00a7e" : "\u00a7a");
                playerText = (String)playerText + playerColor + this.currentPlayers + "\u00a77/\u00a7f" + this.maxPlayers;
                int hostWidth = PublicLobbiesScreen.this.font.width(hostInfo);
                graphics.drawString(PublicLobbiesScreen.this.font, (String)playerText, left + 28 + hostWidth + 15, top + 20, 0xAAAAAA);
                int joinButtonStartX = left + width - 70;
                int maxBadgeX = joinButtonStartX - 20;
                int badgeX = left + 28;
                int badgeY = top + 32;
                int lineStartX = left + 28;
                if (this.compatibility.minecraftVersion != null) {
                    String versionText = "\u00a7e" + this.compatibility.minecraftVersion;
                    textWidth = PublicLobbiesScreen.this.font.width(versionText);
                    if (badgeX + textWidth > maxBadgeX) {
                        badgeY += 10;
                        badgeX = lineStartX;
                    }
                    graphics.drawString(PublicLobbiesScreen.this.font, versionText, badgeX, badgeY, 0xFFFFFF);
                    badgeX += textWidth + 8;
                }
                if (this.compatibility.modLoader != null) {
                    String loaderColor = this.compatibility.modLoader.equals("fabric") ? "\u00a7b" : (this.compatibility.modLoader.equals("forge") ? "\u00a7c" : "\u00a7d");
                    String loaderText = loaderColor + this.compatibility.modLoader.toUpperCase();
                    int textWidth2 = PublicLobbiesScreen.this.font.width(loaderText);
                    if (badgeX + textWidth2 > maxBadgeX) {
                        badgeY += 10;
                        badgeX = lineStartX;
                    }
                    graphics.drawString(PublicLobbiesScreen.this.font, loaderText, badgeX, badgeY, 0xFFFFFF);
                    badgeX += textWidth2 + 8;
                } else {
                    String vanillaText = "\u00a77VANILLA";
                    textWidth = PublicLobbiesScreen.this.font.width(vanillaText);
                    if (badgeX + textWidth > maxBadgeX) {
                        badgeY += 10;
                        badgeX = lineStartX;
                    }
                    graphics.drawString(PublicLobbiesScreen.this.font, vanillaText, badgeX, badgeY, 0xFFFFFF);
                    badgeX += textWidth + 8;
                }
                if (this.relayRegion != null) {
                    String regionText = "\u00a76" + this.relayRegion.toUpperCase();
                    int textWidth3 = PublicLobbiesScreen.this.font.width(regionText);
                    if (badgeX + textWidth3 > maxBadgeX) {
                        badgeY += 10;
                        badgeX = lineStartX;
                    }
                    graphics.drawString(PublicLobbiesScreen.this.font, regionText, badgeX, badgeY, 0xFFFFFF);
                    badgeX += textWidth3 + 8;
                }
                String gameModeText = "\u00a79" + this.gameMode.substring(0, 1).toUpperCase() + this.gameMode.substring(1);
                int gameModeWidth = PublicLobbiesScreen.this.font.width(gameModeText);
                if (badgeX + gameModeWidth > maxBadgeX) {
                    badgeY += 10;
                    badgeX = lineStartX;
                }
                graphics.drawString(PublicLobbiesScreen.this.font, gameModeText, badgeX, badgeY, 0xFFFFFF);
                if (this.compatibility.modpackId != null) {
                    String modpackText = "\u00a7d\ud83d\udce6 " + (String)(this.compatibility.modpackId.length() > 20 ? this.compatibility.modpackId.substring(0, 17) + "..." : this.compatibility.modpackId);
                    if (this.compatibility.modpackVersion != null) {
                        modpackText = modpackText + " \u00a77v" + this.compatibility.modpackVersion;
                    }
                    graphics.drawString(PublicLobbiesScreen.this.font, modpackText, left + 28, top + 44, 0xFFFFFF);
                }
                this.joinButton.setX(left + width - 65);
                this.joinButton.setY(top + height / 2 - 10);
                this.joinButton.render(graphics, mouseX, mouseY, partialTick);
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                return this.joinButton.mouseClicked(mouseX, mouseY, button);
            }

            public Component getNarration() {
                return Component.literal((String)(this.serverName + " by " + this.hostName + " (" + this.currentPlayers + "/" + this.maxPlayers + " players)" + (this.isCompatible ? " Compatible" : " Incompatible")));
            }

            private /* synthetic */ void lambda$joinServer$4(String relayUrl, String sessionId) {
                ClientTunnelManager manager = ClientTunnelManager.getInstance();
                manager.connectToServer(relayUrl, sessionId, () -> System.out.println("[Tunnely UI] \u2713 Connection successful"), error -> {
                    System.err.println("[Tunnely UI] \u2717 Connection failed: " + error);
                    PublicLobbiesScreen.this.minecraft.execute(() -> {
                        String errorType = this.categorizeError((String)error);
                        PublicLobbiesScreen.this.minecraft.setScreen((Screen)new ConnectionInfoScreen(PublicLobbiesScreen.this, this.serverName, errorType, (String)error, errorType.equals("FULL") || errorType.equals("CONNECTION_FAILED") ? this::joinServer : null));
                    });
                });
            }
        }
    }
}

