/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;

public class TermsOfServiceScreen
extends Screen {
    private final Screen parent;
    private final Runnable onAccept;
    private TosContentWidget contentWidget;
    private Checkbox acceptCheckbox;
    private Button acceptButton;
    private Button declineButton;
    private Button exportButton;
    private String tosVersion = "";
    private String tosTitle = "";
    private String acceptanceText = "";
    private String footer = "";
    private List<TosSection> sections = new ArrayList<TosSection>();

    public TermsOfServiceScreen(Screen parent, Runnable onAccept) {
        super((Component)Component.literal((String)"Terms of Service"));
        this.parent = parent;
        this.onAccept = onAccept;
        this.loadTosFromJson();
    }

    private void loadTosFromJson() {
        try {
            InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/terms-of-service.json");
            if (stream == null) {
                System.err.println("[Tunnely] Could not load terms-of-service.json");
                this.tosTitle = "Terms of Service";
                this.sections.add(new TosSection("Error", "Could not load Terms of Service. Please contact support."));
                return;
            }
            InputStreamReader reader = new InputStreamReader(stream);
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            this.tosVersion = json.has("version") ? json.get("version").getAsString() : "1.0.0";
            this.tosTitle = json.has("title") ? json.get("title").getAsString() : "Terms of Service";
            this.acceptanceText = json.has("acceptance_text") ? json.get("acceptance_text").getAsString() : "I accept the Terms of Service";
            String string = this.footer = json.has("footer") ? json.get("footer").getAsString() : "";
            if (json.has("sections")) {
                JsonArray sectionsArray = json.getAsJsonArray("sections");
                for (int i = 0; i < sectionsArray.size(); ++i) {
                    JsonObject section = sectionsArray.get(i).getAsJsonObject();
                    String title = section.has("title") ? section.get("title").getAsString() : "";
                    String content = section.has("content") ? section.get("content").getAsString() : "";
                    this.sections.add(new TosSection(title, content));
                }
            }
            System.out.println("[Tunnely] Loaded TOS version " + this.tosVersion + " with " + this.sections.size() + " sections");
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Error loading TOS: " + e.getMessage());
            e.printStackTrace();
            this.tosTitle = "Terms of Service";
            this.sections.add(new TosSection("Error", "Could not load Terms of Service. Please contact support."));
        }
    }

    protected void init() {
        super.init();
        int footerHeight = 0;
        if (!this.footer.isEmpty()) {
            List<String> footerLines = this.wrapText(this.footer, this.width - 40);
            footerHeight = footerLines.size() * 11 + 10;
        }
        int topMargin = 55;
        int bottomMargin = 75 + footerHeight;
        this.contentWidget = new TosContentWidget(this.minecraft, this.width, this.height, topMargin, this.height - bottomMargin);
        this.contentWidget.setSections(this.sections);
        this.addWidget((GuiEventListener)this.contentWidget);
        int buttonY = this.height - 30;
        int checkboxY = buttonY - 35;
        int footerY = checkboxY - 15;
        this.acceptCheckbox = Checkbox.builder((Component)Component.literal((String)this.acceptanceText), (Font)this.font).pos(this.width / 2 - 100, checkboxY).selected(false).build();
        this.addRenderableWidget((GuiEventListener)this.acceptCheckbox);
        this.acceptButton = Button.builder((Component)Component.literal((String)"\u00a7aI Agree"), button -> this.acceptTos()).bounds(this.width / 2 - 155, buttonY, 100, 20).build();
        this.acceptButton.active = false;
        this.addRenderableWidget((GuiEventListener)this.acceptButton);
        this.declineButton = Button.builder((Component)Component.literal((String)"\u00a7cDecline"), button -> this.minecraft.setScreen(this.parent)).bounds(this.width / 2 - 50, buttonY, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.declineButton);
        this.exportButton = Button.builder((Component)Component.literal((String)"\u00a7e\ud83d\udcc4 Export"), button -> this.exportTos()).bounds(this.width / 2 + 55, buttonY, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.exportButton);
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            String testLine = String.valueOf(line) + (line.length() > 0 ? " " : "") + word;
            if (this.font.width(testLine) > maxWidth) {
                if (line.length() > 0) {
                    lines.add(line.toString());
                    line = new StringBuilder(word);
                    continue;
                }
                lines.add(word);
                continue;
            }
            line.append(line.length() > 0 ? " " : "").append(word);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        return lines;
    }

    public void tick() {
        super.tick();
        this.acceptButton.active = this.acceptCheckbox.selected();
    }

    private void acceptTos() {
        System.out.println("[Tunnely] TOS accepted - version " + this.tosVersion);
        TunnelConfig config = TunnelConfig.getInstance();
        config.setAcceptedTosVersion(this.tosVersion);
        if (this.onAccept != null) {
            this.onAccept.run();
        }
    }

    private void exportTos() {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String filename = String.format("Tunnely_TOS_%s_%s.txt", this.tosVersion.replace(".", "_"), dateFormat.format(new Date()));
            File exportFile = new File(filename);
            try (PrintWriter writer = new PrintWriter(new FileWriter(exportFile));){
                writer.println("=".repeat(80));
                writer.println(this.tosTitle);
                writer.println("Version: " + this.tosVersion);
                writer.println("Exported: " + String.valueOf(new Date()));
                writer.println("=".repeat(80));
                writer.println();
                for (TosSection section : this.sections) {
                    writer.println("-".repeat(80));
                    writer.println(section.title);
                    writer.println("-".repeat(80));
                    writer.println();
                    writer.println(section.content);
                    writer.println();
                }
                if (!this.footer.isEmpty()) {
                    writer.println("=".repeat(80));
                    writer.println("ACCEPTANCE NOTICE");
                    writer.println("=".repeat(80));
                    writer.println();
                    writer.println(this.footer);
                    writer.println();
                }
                writer.println("=".repeat(80));
                writer.println("End of Terms of Service");
                writer.println("=".repeat(80));
            }
            System.out.println("[Tunnely] \u2713 TOS exported to: " + exportFile.getAbsolutePath());
            this.minecraft.execute(() -> System.out.println("[Tunnely] TOS saved to game directory: " + filename));
        }
        catch (IOException e) {
            System.err.println("[Tunnely] \u2717 Failed to export TOS: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.fill(0, 0, this.width, this.height, -15724528);
        int topMargin = 55;
        int footerHeight = 0;
        if (!this.footer.isEmpty()) {
            List<String> footerLines = this.wrapText(this.footer, this.width - 40);
            footerHeight = footerLines.size() * 11 + 10;
        }
        int bottomMargin = 75 + footerHeight;
        int contentTop = topMargin;
        int contentBottom = this.height - bottomMargin;
        graphics.fill(20, contentTop, this.width - 20, contentBottom, -14671840);
        super.render(graphics, mouseX, mouseY, partialTick);
        this.contentWidget.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, "\u00a76\u00a7l" + this.tosTitle, this.width / 2, 15, 0xFFFFFF);
        graphics.drawCenteredString(this.font, "\u00a77Version " + this.tosVersion, this.width / 2, 30, 0xAAAAAA);
        if (!this.footer.isEmpty()) {
            List<String> footerLines = this.wrapText(this.footer, this.width - 40);
            int startY = this.height - 75 - footerLines.size() * 11;
            for (int i = 0; i < footerLines.size(); ++i) {
                graphics.drawCenteredString(this.font, "\u00a77\u00a7o" + footerLines.get(i), this.width / 2, startY + i * 11, 0xAAAAAA);
            }
        }
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static class TosSection {
        final String title;
        final String content;

        TosSection(String title, String content) {
            this.title = title;
            this.content = content;
        }
    }

    private class TosContentWidget
    extends ObjectSelectionList<SectionEntry> {
        private final int top;
        private final int bottom;

        public TosContentWidget(Minecraft minecraft, int width, int height, int top, int bottom) {
            super(minecraft, width, height, top, bottom);
            this.top = top;
            this.bottom = bottom;
        }

        public void setSections(List<TosSection> sections) {
            this.clearEntries();
            for (TosSection section : sections) {
                this.addEntry((AbstractSelectionList.Entry)new SectionEntry(section));
            }
        }

        public int getRowWidth() {
            return Math.min(600, this.width - 50);
        }

        protected int getScrollbarPosition() {
            return this.width / 2 + this.getRowWidth() / 2 + 10;
        }

        public int getRowLeft() {
            return this.width / 2 - this.getRowWidth() / 2;
        }

        protected int getMaxPosition() {
            int totalHeight = 0;
            for (int i = 0; i < this.getItemCount(); ++i) {
                totalHeight += ((SectionEntry)this.getEntry(i)).getItemHeight();
            }
            return totalHeight;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (mouseY < (double)this.top || mouseY > (double)this.bottom) {
                return false;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            if (mouseY < (double)this.top || mouseY > (double)this.bottom) {
                return false;
            }
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (mouseY < (double)this.top || mouseY > (double)this.bottom) {
                return false;
            }
            return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            graphics.enableScissor(0, this.top, this.width, this.bottom);
            int scrollAmount = (int)this.getScrollAmount();
            int left = this.getRowLeft();
            int width = this.getRowWidth();
            int yPos = this.top + 4 - scrollAmount;
            for (int i = 0; i < this.getItemCount(); ++i) {
                SectionEntry entry = (SectionEntry)this.getEntry(i);
                int entryHeight = entry.getItemHeight();
                if (yPos + entryHeight >= this.top && yPos <= this.bottom) {
                    entry.render(graphics, i, yPos, left, width, entryHeight, mouseX, mouseY, false, partialTick);
                }
                yPos += entryHeight;
            }
            graphics.disableScissor();
        }

        class SectionEntry
        extends ObjectSelectionList.Entry<SectionEntry> {
            private final TosSection section;
            private final List<String> wrappedContent;
            private final int entryHeight;

            public SectionEntry(TosSection section) {
                this.section = section;
                this.wrappedContent = this.wrapContentText(section.content, TosContentWidget.this.getRowWidth() - 30);
                this.entryHeight = 12 + this.wrappedContent.size() * 11 + 15;
            }

            public int getItemHeight() {
                return this.entryHeight;
            }

            private List<String> wrapContentText(String text, int maxWidth) {
                String[] paragraphs;
                ArrayList<String> lines = new ArrayList<String>();
                for (String paragraph : paragraphs = text.split("\\n")) {
                    if (paragraph.trim().isEmpty()) {
                        lines.add("");
                        continue;
                    }
                    String[] words = paragraph.split(" ");
                    StringBuilder line = new StringBuilder();
                    for (String word : words) {
                        String testLine = String.valueOf(line) + (line.length() > 0 ? " " : "") + word;
                        if (TermsOfServiceScreen.this.font.width(testLine) > maxWidth) {
                            if (line.length() > 0) {
                                lines.add(line.toString());
                                line = new StringBuilder(word);
                                continue;
                            }
                            lines.add(word);
                            continue;
                        }
                        line.append(line.length() > 0 ? " " : "").append(word);
                    }
                    if (line.length() <= 0) continue;
                    lines.add(line.toString());
                }
                return lines;
            }

            public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                graphics.drawString(TermsOfServiceScreen.this.font, "\u00a76\u00a7l" + this.section.title, left + 10, top + 8, 0xFFFFFF);
                int yOffset = top + 22;
                for (String line : this.wrappedContent) {
                    if (!line.isEmpty()) {
                        graphics.drawString(TermsOfServiceScreen.this.font, "\u00a77" + line, left + 20, yOffset, 0xFFFFFF);
                    }
                    yOffset += 11;
                }
            }

            public Component getNarration() {
                return Component.literal((String)this.section.title);
            }
        }
    }
}

