/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonObject;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.ui.screens.TunnelyMainScreen;

public class UsernameSelectionScreen
extends Screen {
    private final Screen parent;
    private final boolean isFirstTime;
    private EditBox usernameBox;
    private Button confirmButton;
    private String statusMessage = "";
    private int statusColor = 0xFFFFFF;
    private boolean isChecking = false;

    public UsernameSelectionScreen(Screen parent, boolean isFirstTime) {
        super((Component)Component.literal((String)(isFirstTime ? "Choose Your Username" : "Change Username")));
        this.parent = parent;
        this.isFirstTime = isFirstTime;
    }

    protected void init() {
        super.init();
        int inputWidth = 200;
        int inputHeight = 20;
        int buttonWidth = 200;
        int buttonHeight = 20;
        int centerX = this.width / 2 - inputWidth / 2;
        int startY = this.height / 2 - 40;
        this.usernameBox = new EditBox(this.font, centerX, startY, inputWidth, inputHeight, (Component)Component.literal((String)"Username"));
        this.usernameBox.setMaxLength(16);
        this.usernameBox.setHint((Component)Component.literal((String)"Enter username"));
        if (!this.isFirstTime) {
            TunnelConfig config = TunnelConfig.getInstance();
            SupabaseClient client = new SupabaseClient();
            JsonObject profile = client.getOwnProfile();
            if (profile != null && profile.has("minecraft_name")) {
                this.usernameBox.setValue(profile.get("minecraft_name").getAsString());
            }
        }
        this.addRenderableWidget((GuiEventListener)this.usernameBox);
        this.setInitialFocus((GuiEventListener)this.usernameBox);
        this.confirmButton = Button.builder((Component)Component.literal((String)(this.isFirstTime ? "Continue" : "Save")), button -> this.handleConfirm()).bounds(centerX, startY + 35, buttonWidth, buttonHeight).build();
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        if (!this.isFirstTime) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), button -> this.minecraft.setScreen(this.parent)).bounds(centerX, startY + 60, buttonWidth, buttonHeight).build());
        }
    }

    private void handleConfirm() {
        if (this.isChecking) {
            return;
        }
        String username = this.usernameBox.getValue().trim();
        if (username.isEmpty()) {
            this.statusMessage = "\u00a7cPlease enter a username";
            this.statusColor = 0xFF5555;
            return;
        }
        if (username.length() < 3) {
            this.statusMessage = "\u00a7cUsername must be at least 3 characters";
            this.statusColor = 0xFF5555;
            return;
        }
        if (username.length() > 16) {
            this.statusMessage = "\u00a7cUsername must be 16 characters or less";
            this.statusColor = 0xFF5555;
            return;
        }
        if (!username.matches("^[a-zA-Z0-9_]+$")) {
            this.statusMessage = "\u00a7cUsername can only contain letters, numbers, and underscores";
            this.statusColor = 0xFF5555;
            return;
        }
        this.isChecking = true;
        this.confirmButton.active = false;
        this.statusMessage = "\u00a7eChecking username availability...";
        this.statusColor = 0xFFFF55;
        String finalUsername = username;
        new Thread(() -> {
            try {
                boolean success;
                SupabaseClient client = new SupabaseClient();
                TunnelConfig config = TunnelConfig.getInstance();
                JsonObject currentProfile = client.getOwnProfile();
                String currentUsername = null;
                if (currentProfile != null && currentProfile.has("minecraft_name")) {
                    currentUsername = currentProfile.get("minecraft_name").getAsString();
                }
                if (currentUsername != null && currentUsername.equals(finalUsername)) {
                    this.minecraft.execute(() -> {
                        this.statusMessage = "\u00a7aUsername unchanged";
                        this.statusColor = 0x55FF55;
                        this.isChecking = false;
                        this.confirmButton.active = true;
                        new Thread(() -> {
                            try {
                                Thread.sleep(1000L);
                                this.minecraft.execute(() -> this.minecraft.setScreen(this.parent));
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }).start();
                    });
                    return;
                }
                boolean available = client.isUsernameAvailable(finalUsername);
                if (!available) {
                    this.minecraft.execute(() -> {
                        this.statusMessage = "\u00a7cUsername is already taken";
                        this.statusColor = 0xFF5555;
                        this.isChecking = false;
                        this.confirmButton.active = true;
                    });
                    return;
                }
                String userId = config.getSupabaseUserId();
                String minecraftUuid = "";
                if (this.minecraft.player != null) {
                    minecraftUuid = this.minecraft.player.getStringUUID();
                }
                if (success = client.createOrUpdateProfile(userId, finalUsername, minecraftUuid)) {
                    this.minecraft.execute(() -> {
                        this.statusMessage = "\u00a7aUsername set successfully!";
                        this.statusColor = 0x55FF55;
                        this.isChecking = false;
                        new Thread(() -> {
                            try {
                                Thread.sleep(1000L);
                                this.minecraft.execute(() -> {
                                    if (this.isFirstTime) {
                                        this.minecraft.setScreen((Screen)new TunnelyMainScreen(this.parent));
                                    } else {
                                        this.minecraft.setScreen(this.parent);
                                    }
                                });
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }).start();
                    });
                } else {
                    this.minecraft.execute(() -> {
                        this.statusMessage = "\u00a7cFailed to set username. Please try again.";
                        this.statusColor = 0xFF5555;
                        this.isChecking = false;
                        this.confirmButton.active = true;
                    });
                }
            }
            catch (Exception e) {
                System.err.println("[Tunnely] Error setting username: " + e.getMessage());
                e.printStackTrace();
                this.minecraft.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF5555;
                    this.isChecking = false;
                    this.confirmButton.active = true;
                });
            }
        }, "Tunnely-SetUsername").start();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        String title = this.isFirstTime ? "\u00a76\u00a7lChoose Your Username" : "\u00a76\u00a7lChange Username";
        graphics.drawCenteredString(this.font, title, this.width / 2, 30, 0xFFFFFF);
        if (this.isFirstTime) {
            graphics.drawCenteredString(this.font, "\u00a77Welcome! Please choose a username for Tunnely.", this.width / 2, 60, 0xAAAAAA);
            graphics.drawCenteredString(this.font, "\u00a77This will be visible to your friends.", this.width / 2, 75, 0xAAAAAA);
        } else {
            graphics.drawCenteredString(this.font, "\u00a77Enter your new username below.", this.width / 2, 60, 0xAAAAAA);
        }
        int requirementsY = this.height / 2 + 30;
        graphics.drawCenteredString(this.font, "\u00a78Requirements:", this.width / 2, requirementsY, 0x555555);
        graphics.drawCenteredString(this.font, "\u00a783-16 characters, letters/numbers/underscores only", this.width / 2, requirementsY + 12, 0x555555);
        if (!this.statusMessage.isEmpty()) {
            graphics.drawCenteredString(this.font, this.statusMessage, this.width / 2, this.height - 40, this.statusColor);
        }
    }

    public void onClose() {
        if (!this.isFirstTime) {
            this.minecraft.setScreen(this.parent);
        }
    }

    public boolean shouldCloseOnEsc() {
        return !this.isFirstTime;
    }

    public boolean isPauseScreen() {
        return false;
    }
}

