/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.texboobcat.tunnelyrefab.ui.screens.DownloadProgressScreen;
import org.texboobcat.tunnelyrefab.ui.screens.MyWorldsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.PausedDownloadsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WarningPopupScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldDetailsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldUploadScreen;
import org.texboobcat.tunnelyrefab.worlds.ImageLoader;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;
import org.texboobcat.tunnelyrefab.worlds.ui.DownloadProtection;
import org.texboobcat.tunnelyrefab.worlds.ui.WorldBadge;

public class WorldBrowserScreen
extends Screen {
    private final Screen parent;
    private final WorldManager worldManager;
    private EditBox searchBox;
    private List<WorldInfo> worlds = new ArrayList<WorldInfo>();
    private int scrollOffset = 0;
    private final int WORLD_ENTRY_HEIGHT = 85;
    private int maxScrollOffset = 0;
    private int currentPage = 0;
    private final int WORLDS_PER_PAGE = 20;
    private boolean loading = false;
    private String statusMessage = "";
    private WorldInfo hoveredWorld = null;
    private String hoveredButton = null;

    public WorldBrowserScreen(Screen parent) {
        super((Component)Component.literal((String)"Community Worlds"));
        this.parent = parent;
        this.worldManager = new WorldManager();
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        this.searchBox = new EditBox(this.font, centerX - 150, 35, 250, 20, (Component)Component.literal((String)"Search"));
        this.searchBox.setMaxLength(100);
        this.searchBox.setHint((Component)Component.literal((String)"Search worlds..."));
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\ud83d\udd0d"), button -> this.performSearch()).bounds(centerX + 105, 35, 45, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u25c0 Previous"), button -> this.previousPage()).bounds(centerX - 155, this.height - 55, 75, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Next \u25b6"), button -> this.nextPage()).bounds(centerX + 80, this.height - 55, 75, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Upload World"), button -> this.minecraft.setScreen((Screen)new WorldUploadScreen(this))).bounds(centerX - 205, this.height - 30, 90, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"My Worlds"), button -> this.minecraft.setScreen((Screen)new MyWorldsScreen(this))).bounds(centerX - 110, this.height - 30, 90, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u23f8 Downloads"), button -> this.minecraft.setScreen((Screen)new PausedDownloadsScreen(this))).bounds(centerX - 15, this.height - 30, 90, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), button -> this.minecraft.setScreen(this.parent)).bounds(centerX + 80, this.height - 30, 90, 20).build());
        this.loadWorlds();
    }

    private void loadWorlds() {
        if (this.loading) {
            return;
        }
        this.loading = true;
        this.statusMessage = "Loading worlds...";
        new Thread(() -> {
            try {
                List<WorldInfo> loadedWorlds = this.worldManager.listPublicWorlds(20, this.currentPage * 20);
                this.minecraft.execute(() -> {
                    this.worlds = loadedWorlds;
                    this.scrollOffset = 0;
                    this.updateMaxScroll();
                    this.loading = false;
                    this.statusMessage = this.worlds.isEmpty() ? "No worlds found" : "Loaded " + this.worlds.size() + " worlds";
                });
            }
            catch (Exception e) {
                this.minecraft.execute(() -> {
                    this.statusMessage = "\u00a7cFailed to load worlds: " + e.getMessage();
                    this.loading = false;
                });
            }
        }).start();
    }

    private void performSearch() {
        String query = this.searchBox.getValue().trim();
        if (query.isEmpty()) {
            this.loadWorlds();
            return;
        }
        if (this.loading) {
            return;
        }
        this.loading = true;
        this.statusMessage = "Searching...";
        new Thread(() -> {
            try {
                List<WorldInfo> searchResults = this.worldManager.searchWorlds(query);
                this.minecraft.execute(() -> {
                    this.worlds = searchResults;
                    this.scrollOffset = 0;
                    this.currentPage = 0;
                    this.updateMaxScroll();
                    this.loading = false;
                    this.statusMessage = this.worlds.isEmpty() ? "\u00a7cNo worlds found for: " + query : "Found " + this.worlds.size() + " worlds";
                });
            }
            catch (Exception e) {
                this.minecraft.execute(() -> {
                    this.statusMessage = "\u00a7cSearch failed: " + e.getMessage();
                    this.loading = false;
                });
            }
        }).start();
    }

    private void downloadWorld(WorldInfo world) {
        if (this.loading) {
            return;
        }
        DownloadProtection.DownloadCheckResult check = DownloadProtection.checkDownloadSafety(world);
        if (check.isBlocked()) {
            this.minecraft.setScreen((Screen)new WarningPopupScreen(this, this, check.getTitle(), check.getMessage(), 0xFF5555, null));
            return;
        }
        if (check.isWarning()) {
            this.minecraft.setScreen((Screen)new WarningPopupScreen(this, this, check.getTitle(), check.getMessage(), 0xFFAA00, () -> this.proceedWithDownload(world)));
            return;
        }
        this.proceedWithDownload(world);
    }

    private void proceedWithDownload(WorldInfo world) {
        this.minecraft.setScreen((Screen)new DownloadProgressScreen(this, world));
    }

    private void viewWorldDetails(WorldInfo world) {
        this.minecraft.setScreen((Screen)new WorldDetailsScreen(this, world));
    }

    private void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.loadWorlds();
        }
    }

    private void nextPage() {
        if (this.worlds.size() >= 20) {
            ++this.currentPage;
            this.loadWorlds();
        }
    }

    private void updateMaxScroll() {
        int visibleHeight = this.height - 130;
        int contentHeight = this.worlds.size() * 85;
        this.maxScrollOffset = Math.max(0, contentHeight - visibleHeight);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, "\ud83c\udf0d Community Worlds", this.width / 2, 15, 0xFFFFFF);
        if (!this.statusMessage.isEmpty()) {
            graphics.drawCenteredString(this.font, this.statusMessage, this.width / 2, 60, 0xAAAAAA);
        }
        this.renderWorldList(graphics, mouseX, mouseY);
        if (!this.worlds.isEmpty()) {
            String pageInfo = "Page " + (this.currentPage + 1);
            graphics.drawCenteredString(this.font, pageInfo, this.width / 2, this.height - 45, 0xAAAAAA);
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.fill(0, 0, this.width, this.height, -15724528);
    }

    private void renderWorldList(GuiGraphics graphics, int mouseX, int mouseY) {
        int startY = 75;
        int endY = this.height - 60;
        int centerX = this.width / 2;
        int entryWidth = 400;
        int entryX = centerX - entryWidth / 2;
        graphics.enableScissor(0, startY, this.width, endY);
        int yOffset = startY - this.scrollOffset;
        for (int i = 0; i < this.worlds.size(); ++i) {
            WorldInfo world = this.worlds.get(i);
            int entryY = yOffset + i * 85;
            if (entryY + 85 < startY || entryY > endY) continue;
            this.renderWorldEntry(graphics, world, entryX, entryY, entryWidth, mouseX, mouseY);
        }
        graphics.disableScissor();
    }

    private void renderWorldEntry(GuiGraphics graphics, WorldInfo world, int x, int y, int width, int mouseX, int mouseY) {
        boolean hovered = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + 85 - 5;
        int bgColor = hovered ? -2143272896 : -2145378272;
        graphics.fill(x, y, x + width, y + 85 - 5, bgColor);
        graphics.fill(x, y, x + width, y + 1, -12566464);
        graphics.fill(x, y + 85 - 5, x + width, y + 85 - 4, -12566464);
        int thumbnailSize = 64;
        int thumbnailX = x + 5;
        int thumbnailY = y + 5;
        if (world.hasScreenshot()) {
            ResourceLocation screenshot = ImageLoader.loadImage(world.getScreenshotUrl());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.blit(screenshot, thumbnailX, thumbnailY, 0.0f, 0.0f, thumbnailSize, thumbnailSize, thumbnailSize, thumbnailSize);
        } else {
            graphics.fill(thumbnailX, thumbnailY, thumbnailX + thumbnailSize, thumbnailY + thumbnailSize, -12566464);
            graphics.drawCenteredString(this.font, "No", thumbnailX + thumbnailSize / 2, thumbnailY + 20, 0x888888);
            graphics.drawCenteredString(this.font, "Image", thumbnailX + thumbnailSize / 2, thumbnailY + 32, 0x888888);
        }
        int textX = thumbnailX + thumbnailSize + 10;
        Object nameText = world.getName();
        if (world.isVerified()) {
            nameText = "\u2713 " + (String)nameText;
        }
        if (world.isFeatured()) {
            nameText = "\u2b50 " + (String)nameText;
        }
        graphics.drawString(this.font, (String)nameText, textX, y + 5, 0xFFFFFF);
        String authorLine = "\u00a77by " + world.getAuthorUsername() + " | " + world.getFormattedRating() + " | \ud83d\udce5 " + world.getFormattedDownloadCount();
        graphics.drawString(this.font, authorLine, textX, y + 18, 0xAAAAAA);
        String detailsLine = "\u00a77" + world.getWorldType() + " | " + world.getMinecraftVersion() + " | \ud83d\udcbe " + world.getFormattedFileSize();
        graphics.drawString(this.font, detailsLine, textX, y + 31, 0xAAAAAA);
        Object desc = world.getDescription();
        if (((String)desc).length() > 45) {
            desc = ((String)desc).substring(0, 42) + "...";
        }
        graphics.drawString(this.font, "\u00a77" + (String)desc, textX, y + 44, 0x888888);
        WorldBadge.BadgeInfo securityBadge = WorldBadge.getSecurityBadge(world);
        if (securityBadge != null) {
            int badgeX = x + width - 75;
            int badgeY = y + 5;
            int badgeWidth = 70;
            int badgeHeight = 16;
            graphics.fill(badgeX, badgeY, badgeX + badgeWidth, badgeY + badgeHeight, securityBadge.backgroundColor);
            graphics.drawCenteredString(this.font, securityBadge.text, badgeX + badgeWidth / 2, badgeY + 4, securityBadge.textColor);
        }
        int buttonY = y + 58;
        int buttonWidth = 80;
        int buttonHeight = 18;
        int buttonSpacing = 85;
        boolean viewDetailsHovered = this.isMouseOverButton(mouseX, mouseY, x + 5, buttonY, buttonWidth, buttonHeight);
        if (viewDetailsHovered) {
            graphics.fill(x + 5, buttonY, x + 5 + buttonWidth, buttonY + buttonHeight, -2130706433);
            this.hoveredWorld = world;
            this.hoveredButton = "details";
        } else {
            graphics.fill(x + 5, buttonY, x + 5 + buttonWidth, buttonY + buttonHeight, -2139062144);
        }
        graphics.drawCenteredString(this.font, "View Details", x + 5 + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
        if (!this.loading) {
            boolean downloadHovered = this.isMouseOverButton(mouseX, mouseY, x + buttonSpacing, buttonY, buttonWidth, buttonHeight);
            if (downloadHovered) {
                graphics.fill(x + buttonSpacing, buttonY, x + buttonSpacing + buttonWidth, buttonY + buttonHeight, -2147418368);
                this.hoveredWorld = world;
                this.hoveredButton = "download";
            } else {
                graphics.fill(x + buttonSpacing, buttonY, x + buttonSpacing + buttonWidth, buttonY + buttonHeight, -2147450880);
            }
            graphics.drawCenteredString(this.font, "\u2b07 Download", x + buttonSpacing + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hoveredWorld != null && this.hoveredButton != null) {
            if (this.hoveredButton.equals("details")) {
                this.viewWorldDetails(this.hoveredWorld);
                return true;
            }
            if (this.hoveredButton.equals("download")) {
                this.downloadWorld(this.hoveredWorld);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.hoveredWorld = null;
        this.hoveredButton = null;
        super.mouseMoved(mouseX, mouseY);
    }

    private boolean isMouseOverButton(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double scrollDelta) {
        this.scrollOffset -= (int)(scrollDelta * 20.0);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScrollOffset));
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox.isFocused() && keyCode == 257) {
            this.performSearch();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void removed() {
        super.removed();
    }

    public boolean isPauseScreen() {
        return true;
    }
}

