/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.texboobcat.tunnelyrefab.ui.screens.DownloadProgressScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WarningPopupScreen;
import org.texboobcat.tunnelyrefab.worlds.ContentModerator;
import org.texboobcat.tunnelyrefab.worlds.ImageLoader;
import org.texboobcat.tunnelyrefab.worlds.WorldComment;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;
import org.texboobcat.tunnelyrefab.worlds.ui.DownloadProtection;

public class WorldDetailsScreen
extends Screen {
    private final Screen parent;
    private final WorldInfo world;
    private final WorldManager worldManager;
    private boolean downloading = false;
    private String statusMessage = "";
    private int downloadProgress = 0;
    private int userRating = 0;
    private List<WorldComment> comments = new ArrayList<WorldComment>();
    private EditBox commentBox;
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;
    private static final int COMMENT_HEIGHT = 50;

    public WorldDetailsScreen(Screen parent, WorldInfo world) {
        super((Component)Component.literal((String)"World Details"));
        this.parent = parent;
        this.world = world;
        this.worldManager = new WorldManager();
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        this.loadUserRating();
        this.loadComments();
        this.commentBox = new EditBox(this.font, centerX - 200, this.height - 60, 340, 20, (Component)Component.literal((String)"Write a comment..."));
        this.commentBox.setMaxLength(500);
        this.addRenderableWidget((GuiEventListener)this.commentBox);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Post"), button -> this.postComment()).bounds(centerX + 145, this.height - 60, 55, 20).build());
        for (int i = 1; i <= 5; ++i) {
            int rating = i;
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)(rating <= this.userRating ? "\u2605" : "\u2606")), button -> this.rateWorld(rating)).bounds(centerX - 60 + (i - 1) * 25, this.height - 35, 20, 20).build());
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2b07 Download"), button -> this.downloadWorld()).bounds(this.width - 110, 10, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2190 Back"), button -> this.minecraft.setScreen(this.parent)).bounds(10, 10, 80, 20).build());
    }

    private void loadComments() {
        new Thread(() -> {
            List<WorldComment> loadedComments = this.worldManager.getComments(this.world.getId(), 20);
            this.minecraft.execute(() -> {
                this.comments = loadedComments;
            });
        }).start();
    }

    private void postComment() {
        String commentText = this.commentBox.getValue().trim();
        if (commentText.isEmpty()) {
            this.statusMessage = "\u00a7cComment cannot be empty";
            return;
        }
        if (!ContentModerator.quickCheck(commentText)) {
            this.statusMessage = "\u00a7cComment contains inappropriate content";
            return;
        }
        this.statusMessage = "Posting comment...";
        new Thread(() -> {
            WorldManager.CommentResult result = this.worldManager.postComment(this.world.getId(), commentText);
            this.minecraft.execute(() -> {
                if (result.isSuccess()) {
                    this.statusMessage = "\u00a7aComment posted successfully!";
                    this.commentBox.setValue("");
                    this.loadComments();
                } else {
                    this.statusMessage = "\u00a7c" + result.getMessage();
                }
            });
        }).start();
    }

    private void loadUserRating() {
        new Thread(() -> {
            int rating = this.worldManager.getUserRating(this.world.getId());
            this.minecraft.execute(() -> {
                this.userRating = rating;
            });
        }).start();
    }

    private void rateWorld(int rating) {
        new Thread(() -> {
            boolean success = this.worldManager.rateWorld(this.world.getId(), rating);
            this.minecraft.execute(() -> {
                if (success) {
                    this.userRating = rating;
                    this.statusMessage = "\u00a7aRated " + rating + " stars!";
                    this.init(this.minecraft, this.width, this.height);
                } else {
                    this.statusMessage = "\u00a7cFailed to rate world";
                }
            });
        }).start();
    }

    private void downloadWorld() {
        if (this.downloading) {
            return;
        }
        DownloadProtection.DownloadCheckResult check = DownloadProtection.checkDownloadSafety(this.world);
        if (check.isBlocked()) {
            this.minecraft.setScreen((Screen)new WarningPopupScreen(this, this, check.getTitle(), check.getMessage(), 0xFF5555, null));
            return;
        }
        if (check.isWarning()) {
            this.minecraft.setScreen((Screen)new WarningPopupScreen(this, this, check.getTitle(), check.getMessage(), 0xFFAA00, () -> this.proceedWithDownload()));
            return;
        }
        this.proceedWithDownload();
    }

    private void proceedWithDownload() {
        this.minecraft.setScreen((Screen)new DownloadProgressScreen(this, this.world));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, "\ud83c\udf0d World Details", this.width / 2, 15, 0xFFFFFF);
        int centerX = this.width / 2;
        int startY = 40 - this.scrollOffset;
        if (this.world.hasScreenshot()) {
            int screenshotWidth = 256;
            int screenshotHeight = 144;
            int screenshotX = centerX - screenshotWidth / 2;
            int screenshotY = startY;
            ResourceLocation screenshot = ImageLoader.loadImage(this.world.getScreenshotUrl());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.blit(screenshot, screenshotX, screenshotY, 0.0f, 0.0f, screenshotWidth, screenshotHeight, screenshotWidth, screenshotHeight);
            graphics.fill(screenshotX - 1, screenshotY - 1, screenshotX + screenshotWidth + 1, screenshotY, -1);
            graphics.fill(screenshotX - 1, screenshotY + screenshotHeight, screenshotX + screenshotWidth + 1, screenshotY + screenshotHeight + 1, -1);
            graphics.fill(screenshotX - 1, screenshotY, screenshotX, screenshotY + screenshotHeight, -1);
            graphics.fill(screenshotX + screenshotWidth, screenshotY, screenshotX + screenshotWidth + 1, screenshotY + screenshotHeight, -1);
            startY += screenshotHeight + 15;
        }
        Object nameText = this.world.getName();
        if (this.world.isVerified()) {
            nameText = "\u2713 " + (String)nameText;
        }
        if (this.world.isFeatured()) {
            nameText = "\u2b50 " + (String)nameText;
        }
        graphics.drawCenteredString(this.font, (String)nameText, centerX, startY, 0xFFFFFF);
        graphics.drawCenteredString(this.font, "\u00a77by " + this.world.getAuthorUsername(), centerX, startY + 15, 0xAAAAAA);
        graphics.drawCenteredString(this.font, this.world.getFormattedRating(), centerX, startY + 30, 0xFFFF55);
        String stats1 = "\u00a77\ud83d\udce5 " + this.world.getFormattedDownloadCount() + " downloads | \ud83d\udcbe " + this.world.getFormattedFileSize();
        graphics.drawCenteredString(this.font, stats1, centerX, startY + 50, 0xAAAAAA);
        String stats2 = "\u00a77\ud83c\udfae Minecraft " + this.world.getMinecraftVersion() + " | \ud83c\udfd7 " + this.world.getWorldType();
        graphics.drawCenteredString(this.font, stats2, centerX, startY + 65, 0xAAAAAA);
        if (!this.world.getTags().isEmpty()) {
            int tagY = startY + 85;
            graphics.drawCenteredString(this.font, "\u00a77Tags:", centerX, tagY, 0xAAAAAA);
            StringBuilder tagsStr = new StringBuilder();
            for (String tag : this.world.getTags()) {
                tagsStr.append("[").append(tag).append("] ");
            }
            graphics.drawCenteredString(this.font, "\u00a77" + tagsStr.toString(), centerX, tagY + 15, 0x888888);
        }
        int descY = startY + 115;
        graphics.drawCenteredString(this.font, "\u00a77Description:", centerX, descY, 0xAAAAAA);
        int boxX = centerX - 200;
        int boxY = descY + 15;
        int boxWidth = 400;
        int boxHeight = 60;
        graphics.fill(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -2145378272);
        graphics.fill(boxX, boxY, boxX + boxWidth, boxY + 1, -12566464);
        graphics.fill(boxX, boxY + boxHeight - 1, boxX + boxWidth, boxY + boxHeight, -12566464);
        String description = this.world.getDescription();
        if (!description.isEmpty()) {
            String[] lines = this.wrapText(description, boxWidth - 10);
            int lineY = boxY + 5;
            for (int i = 0; i < Math.min(lines.length, 4); ++i) {
                graphics.drawString(this.font, "\u00a77" + lines[i], boxX + 5, lineY, 0xAAAAAA);
                lineY += 12;
            }
        } else {
            graphics.drawString(this.font, "\u00a77No description provided", boxX + 5, boxY + 5, 0x888888);
        }
        graphics.drawCenteredString(this.font, "\u00a77Uploaded: " + this.world.getFormattedCreatedAt(), centerX, descY + boxHeight + 15, 0x888888);
        int commentsY = descY + boxHeight + 35;
        graphics.drawCenteredString(this.font, "\u00a77\ud83d\udcac Comments (" + this.comments.size() + ")", centerX, commentsY, 0xFFFFFF);
        int commentBoxY = commentsY + 20;
        int availableHeight = this.height - commentBoxY - 70;
        int commentBoxHeight = Math.min(availableHeight, 150);
        graphics.fill(boxX, commentBoxY, boxX + boxWidth, commentBoxY + commentBoxHeight, -2146430960);
        graphics.fill(boxX, commentBoxY, boxX + boxWidth, commentBoxY + 1, -12566464);
        graphics.fill(boxX, commentBoxY + commentBoxHeight - 1, boxX + boxWidth, commentBoxY + commentBoxHeight, -12566464);
        graphics.enableScissor(boxX, commentBoxY, boxX + boxWidth, commentBoxY + commentBoxHeight);
        if (this.comments.isEmpty()) {
            graphics.drawCenteredString(this.font, "\u00a77No comments yet. Be the first to comment!", centerX, commentBoxY + commentBoxHeight / 2 - 5, 0x888888);
        } else {
            int yOffset = commentBoxY + 5;
            int visibleComments = commentBoxHeight / 50 + 1;
            for (int i = 0; i < Math.min(this.comments.size(), visibleComments); ++i) {
                WorldComment comment = this.comments.get(i);
                this.renderComment(graphics, comment, boxX + 5, yOffset, boxWidth - 10);
                yOffset += 50;
            }
        }
        graphics.disableScissor();
        int totalContentHeight = startY + commentsY + 20 + this.comments.size() * 50 + 100;
        this.maxScrollOffset = Math.max(0, totalContentHeight - this.height + 100);
        if (!this.statusMessage.isEmpty()) {
            graphics.drawCenteredString(this.font, this.statusMessage, centerX, this.height - 80, 0xFFFFFF);
        }
        if (this.downloading && this.downloadProgress > 0) {
            int barWidth = 200;
            int barX = centerX - barWidth / 2;
            int barY = this.height - 60;
            graphics.fill(barX, barY, barX + barWidth, barY + 10, -2145378272);
            graphics.fill(barX, barY, barX + barWidth * this.downloadProgress / 100, barY + 10, -2141847723);
            graphics.fill(barX, barY, barX + barWidth, barY + 1, -12566464);
            graphics.fill(barX, barY + 9, barX + barWidth, barY + 10, -12566464);
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.fill(0, 0, this.width, this.height, -15724528);
    }

    public boolean isPauseScreen() {
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double delta) {
        int scrollAmount = (int)(delta * 20.0);
        this.scrollOffset = Math.max(0, Math.min(this.maxScrollOffset, this.scrollOffset - scrollAmount));
        return true;
    }

    private void renderComment(GuiGraphics graphics, WorldComment comment, int x, int y, int width) {
        String header = "\u00a7e" + comment.getUsername() + " \u00a78\u2022 \u00a77" + comment.getFormattedTime();
        if (comment.isEdited()) {
            header = header + " \u00a78(edited)";
        }
        graphics.drawString(this.font, header, x, y, 0xFFFFFF);
        String[] lines = this.wrapText(comment.getComment(), width);
        int lineY = y + 11;
        for (int i = 0; i < Math.min(lines.length, 2); ++i) {
            graphics.drawString(this.font, "\u00a77" + lines[i], x, lineY, 0xCCCCCC);
            lineY += 9;
        }
        if (lines.length > 2) {
            graphics.drawString(this.font, "\u00a78...", x, lineY, 0x888888);
        }
        graphics.fill(x, y + 50 - 3, x + width, y + 50 - 2, -14342875);
    }

    private String[] wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
            if (this.font.width(testLine) <= maxWidth) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines.toArray(new String[0]);
    }
}

