/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.ui.screens.WorldEditScreen;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;

public class WorldUpdateScreen
extends Screen {
    private final Screen parent;
    private final WorldInfo existingWorld;
    private final WorldManager worldManager;
    private List<String> localWorlds = new ArrayList<String>();
    private int scrollOffset = 0;
    private final int WORLD_ENTRY_HEIGHT = 40;
    private int maxScrollOffset = 0;
    private String selectedWorld = null;
    private String statusMessage = "";
    private boolean updating = false;
    private int uploadProgress = 0;

    public WorldUpdateScreen(Screen parent, WorldInfo existingWorld) {
        super((Component)Component.literal((String)"Update World"));
        this.parent = parent;
        this.existingWorld = existingWorld;
        this.worldManager = new WorldManager();
    }

    public Screen getParent() {
        return this.parent;
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Update World"), button -> this.updateWorld()).bounds(centerX - 105, this.height - 30, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), button -> this.minecraft.setScreen(this.parent)).bounds(centerX + 10, this.height - 30, 100, 20).build());
        this.loadLocalWorlds();
    }

    private void loadLocalWorlds() {
        try {
            Path savesDir = Paths.get("saves", new String[0]);
            if (Files.exists(savesDir, new LinkOption[0]) && Files.isDirectory(savesDir, new LinkOption[0])) {
                this.localWorlds = Files.list(savesDir).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(path -> path.getFileName().toString()).sorted().collect(Collectors.toList());
                this.updateMaxScroll();
            }
        }
        catch (IOException e) {
            this.statusMessage = "\u00a7cFailed to load worlds: " + e.getMessage();
        }
    }

    private void updateWorld() {
        if (this.selectedWorld == null) {
            this.statusMessage = "\u00a7cPlease select a world first";
            return;
        }
        this.minecraft.setScreen((Screen)new WorldEditScreen(this, this.existingWorld, this.selectedWorld));
    }

    private void updateMaxScroll() {
        int visibleHeight = this.height - 180;
        int contentHeight = this.localWorlds.size() * 40;
        this.maxScrollOffset = Math.max(0, contentHeight - visibleHeight);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, "Update: " + this.existingWorld.getName(), this.width / 2, 15, 0xFFFFFF);
        graphics.drawCenteredString(this.font, "\u00a77Select a local world to replace the uploaded version", this.width / 2, 35, 0xAAAAAA);
        graphics.drawCenteredString(this.font, "\u00a77This will keep ratings, comments, and download count", this.width / 2, 48, 0xAAAAAA);
        if (!this.statusMessage.isEmpty()) {
            graphics.drawCenteredString(this.font, this.statusMessage, this.width / 2, 65, 0xFFFFFF);
        }
        if (this.updating && this.uploadProgress > 0) {
            int barWidth = 300;
            int barX = this.width / 2 - barWidth / 2;
            int barY = 80;
            graphics.fill(barX, barY, barX + barWidth, barY + 10, -2145378272);
            graphics.fill(barX, barY, barX + barWidth * this.uploadProgress / 100, barY + 10, -2147439873);
            graphics.fill(barX, barY, barX + barWidth, barY + 1, -12566464);
            graphics.fill(barX, barY + 9, barX + barWidth, barY + 10, -12566464);
        }
        if (!this.updating) {
            this.renderWorldList(graphics, mouseX, mouseY);
        }
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    private void renderWorldList(GuiGraphics graphics, int mouseX, int mouseY) {
        int startY = 100;
        int endY = this.height - 50;
        int centerX = this.width / 2;
        int entryWidth = 400;
        int entryX = centerX - entryWidth / 2;
        graphics.enableScissor(0, startY, this.width, endY);
        int yOffset = startY - this.scrollOffset;
        for (int i = 0; i < this.localWorlds.size(); ++i) {
            String worldName = this.localWorlds.get(i);
            int entryY = yOffset + i * 40;
            if (entryY + 40 < startY || entryY > endY) continue;
            this.renderWorldEntry(graphics, worldName, entryX, entryY, entryWidth, mouseX, mouseY);
        }
        graphics.disableScissor();
    }

    private void renderWorldEntry(GuiGraphics graphics, String worldName, int x, int y, int width, int mouseX, int mouseY) {
        boolean hovered;
        boolean isSelected = worldName.equals(this.selectedWorld);
        boolean bl = hovered = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + 40 - 5;
        int bgColor = isSelected ? -2147461752 : (hovered ? -2143272896 : -2145378272);
        graphics.fill(x, y, x + width, y + 40 - 5, bgColor);
        graphics.fill(x, y, x + width, y + 1, -12566464);
        graphics.fill(x, y + 40 - 5, x + width, y + 40 - 4, -12566464);
        Object displayName = isSelected ? "\u00a7b\u2713 " + worldName : worldName;
        graphics.drawString(this.font, (String)displayName, x + 5, y + 10, 0xFFFFFF);
        graphics.drawString(this.font, "\u00a77saves/" + worldName, x + 5, y + 22, 0x888888);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && !this.updating) {
            int startY = 100;
            int endY = this.height - 50;
            int centerX = this.width / 2;
            int entryWidth = 400;
            int entryX = centerX - entryWidth / 2;
            if (mouseX >= (double)entryX && mouseX <= (double)(entryX + entryWidth) && mouseY >= (double)startY && mouseY <= (double)endY) {
                int yOffset = startY - this.scrollOffset;
                for (int i = 0; i < this.localWorlds.size(); ++i) {
                    int entryY = yOffset + i * 40;
                    if (!(mouseY >= (double)entryY) || !(mouseY <= (double)(entryY + 40 - 5))) continue;
                    this.selectedWorld = this.localWorlds.get(i);
                    this.statusMessage = "\u00a7aSelected: " + this.selectedWorld;
                    return true;
                }
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double delta) {
        if (!this.updating) {
            this.scrollOffset = Math.max(0, Math.min(this.maxScrollOffset, this.scrollOffset - (int)(delta * 20.0)));
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, horizontalAmount, delta);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

