/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.ui.screens.LoginScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldBrowserScreen;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;
import org.texboobcat.tunnelyrefab.worlds.WorldScannerUtil;
import org.texboobcat.tunnelyrefab.worlds.WorldUploadRequest;

public class WorldUploadScreen
extends Screen {
    private final Screen parent;
    private final WorldManager worldManager;
    private EditBox nameBox;
    private EditBox descBox1;
    private EditBox descBox2;
    private EditBox descBox3;
    private EditBox versionBox;
    private EditBox tagBox;
    private List<String> availableWorlds = new ArrayList<String>();
    private int selectedWorldIndex = 0;
    private String worldType = "survival";
    private boolean isPublic = true;
    private boolean pruneChunks = true;
    private List<String> tags = new ArrayList<String>();
    private WorldScannerUtil.ScanResult scanResult = null;
    private boolean scanning = false;
    private boolean uploading = false;
    private String statusMessage = "";
    private int statusColor = 0xAAAAAA;
    private int uploadProgress = 0;

    public WorldUploadScreen(Screen parent) {
        super((Component)Component.literal((String)"Upload World"));
        this.parent = parent;
        this.worldManager = new WorldManager();
    }

    protected void init() {
        super.init();
        if (!this.worldManager.isAuthenticated()) {
            this.statusMessage = "\u00a7cYou must be logged in to upload worlds";
            this.statusColor = 0xFF5555;
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Go to Login"), button -> this.minecraft.setScreen((Screen)new LoginScreen(this.parent))).bounds(this.width / 2 - 75, this.height / 2, 150, 20).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Back"), button -> this.minecraft.setScreen(this.parent)).bounds(this.width / 2 - 50, this.height / 2 + 30, 100, 20).build());
            return;
        }
        int centerX = this.width / 2;
        int leftX = centerX - 150;
        this.loadAvailableWorlds();
        String worldLabel = this.availableWorlds.isEmpty() ? "No worlds found" : (this.selectedWorldIndex < this.availableWorlds.size() ? this.availableWorlds.get(this.selectedWorldIndex) : "Select world");
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)worldLabel), button -> this.cycleWorld()).bounds(leftX, 35, 300, 20).build());
        this.nameBox = new EditBox(this.font, leftX, 75, 300, 20, (Component)Component.literal((String)"Name"));
        this.nameBox.setMaxLength(100);
        this.nameBox.setHint((Component)Component.literal((String)"World display name"));
        this.addRenderableWidget((GuiEventListener)this.nameBox);
        this.descBox1 = new EditBox(this.font, leftX, 115, 300, 20, (Component)Component.literal((String)"Description 1"));
        this.descBox1.setMaxLength(166);
        this.descBox1.setHint((Component)Component.literal((String)"Description line 1"));
        this.addRenderableWidget((GuiEventListener)this.descBox1);
        this.descBox2 = new EditBox(this.font, leftX, 140, 300, 20, (Component)Component.literal((String)"Description 2"));
        this.descBox2.setMaxLength(166);
        this.descBox2.setHint((Component)Component.literal((String)"Description line 2"));
        this.addRenderableWidget((GuiEventListener)this.descBox2);
        this.descBox3 = new EditBox(this.font, leftX, 165, 300, 20, (Component)Component.literal((String)"Description 3"));
        this.descBox3.setMaxLength(166);
        this.descBox3.setHint((Component)Component.literal((String)"Description line 3"));
        this.addRenderableWidget((GuiEventListener)this.descBox3);
        this.versionBox = new EditBox(this.font, leftX, 205, 145, 20, (Component)Component.literal((String)"Version"));
        this.versionBox.setMaxLength(20);
        this.versionBox.setValue("1.20.1");
        this.addRenderableWidget((GuiEventListener)this.versionBox);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)this.worldType), button -> this.cycleWorldType()).bounds(leftX + 155, 205, 145, 20).build());
        this.tagBox = new EditBox(this.font, leftX, 245, 250, 20, (Component)Component.literal((String)"Tag"));
        this.tagBox.setMaxLength(30);
        this.tagBox.setHint((Component)Component.literal((String)"Add tag..."));
        this.addRenderableWidget((GuiEventListener)this.tagBox);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"+"), button -> this.addTag()).bounds(leftX + 255, 245, 45, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)(this.isPublic ? "Public" : "Private")), button -> this.toggleVisibility()).bounds(leftX, 285, 95, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)(this.pruneChunks ? "Prune: ON" : "Prune: OFF")), button -> this.togglePruneChunks()).bounds(leftX + 100, 285, 95, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Scan World"), button -> this.scanWorld()).bounds(leftX + 200, 285, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Upload"), button -> this.uploadWorld()).bounds(centerX - 50, this.height - 30, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), button -> this.minecraft.setScreen(this.parent)).bounds(centerX + 55, this.height - 30, 100, 20).build());
        if (!this.availableWorlds.isEmpty()) {
            this.nameBox.setValue(this.availableWorlds.get(0));
            this.scanWorld();
        }
    }

    private void loadAvailableWorlds() {
        try {
            Path savesDir = Paths.get("saves", new String[0]);
            if (Files.exists(savesDir, new LinkOption[0])) {
                this.availableWorlds = Files.list(savesDir).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(p -> p.getFileName().toString()).collect(Collectors.toList());
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load worlds: " + e.getMessage());
        }
    }

    private void cycleWorld() {
        if (this.availableWorlds.isEmpty()) {
            return;
        }
        this.selectedWorldIndex = (this.selectedWorldIndex + 1) % this.availableWorlds.size();
        String worldName = this.availableWorlds.get(this.selectedWorldIndex);
        this.nameBox.setValue(worldName);
        this.scanWorld();
        this.init(this.minecraft, this.width, this.height);
    }

    private void cycleWorldType() {
        String[] types = new String[]{"survival", "creative", "adventure", "spectator"};
        int currentIndex = Arrays.asList(types).indexOf(this.worldType);
        this.worldType = types[(currentIndex + 1) % types.length];
        this.init(this.minecraft, this.width, this.height);
    }

    private void toggleVisibility() {
        this.isPublic = !this.isPublic;
    }

    private void togglePruneChunks() {
        this.pruneChunks = !this.pruneChunks;
    }

    private void addTag() {
        String tag = this.tagBox.getValue().trim().toLowerCase();
        if (!tag.isEmpty() && !this.tags.contains(tag) && this.tags.size() < 5) {
            this.tags.add(tag);
            this.tagBox.setValue("");
        }
    }

    private void removeTag(String tag) {
        this.tags.remove(tag);
    }

    private void scanWorld() {
        if (this.availableWorlds.isEmpty() || this.selectedWorldIndex >= this.availableWorlds.size()) {
            this.statusMessage = "\u00a7cNo world selected";
            this.statusColor = 0xFF5555;
            return;
        }
        if (this.scanning) {
            return;
        }
        this.scanning = true;
        this.statusMessage = "Scanning world for security issues...";
        this.statusColor = 0xFFFF55;
        String worldFolder = this.availableWorlds.get(this.selectedWorldIndex);
        new Thread(() -> {
            try {
                Path worldPath = Paths.get("saves", new String[0]).resolve(worldFolder);
                WorldScannerUtil.ScanResult result = WorldScannerUtil.scanWorld(worldPath);
                this.minecraft.execute(() -> {
                    this.scanResult = result;
                    this.scanning = false;
                    if (result.isSafe()) {
                        this.statusMessage = "\u00a7a\u2713 Scan complete: Safe (" + result.getFileCount() + " files, " + result.getFormattedSize() + ")";
                        this.statusColor = 0x55FF55;
                    } else {
                        this.statusMessage = "\u00a7c\u2717 Security issues found: " + result.getBlockedFiles().size() + " blocked files";
                        this.statusColor = 0xFF5555;
                    }
                });
            }
            catch (Exception e) {
                this.minecraft.execute(() -> {
                    this.scanning = false;
                    this.statusMessage = "\u00a7cScan failed: " + e.getMessage();
                    this.statusColor = 0xFF5555;
                });
            }
        }).start();
    }

    private void uploadWorld() {
        if (this.uploading) {
            return;
        }
        if (this.availableWorlds.isEmpty() || this.selectedWorldIndex >= this.availableWorlds.size()) {
            this.statusMessage = "\u00a7cNo world selected";
            this.statusColor = 0xFF5555;
            return;
        }
        if (this.scanResult == null) {
            this.statusMessage = "\u00a7cPlease scan the world first";
            this.statusColor = 0xFF5555;
            return;
        }
        if (!this.scanResult.isSafe()) {
            this.statusMessage = "\u00a7cWorld has security issues, cannot upload";
            this.statusColor = 0xFF5555;
            return;
        }
        String worldName = this.nameBox.getValue().trim();
        if (worldName.isEmpty()) {
            this.statusMessage = "\u00a7cPlease enter a world name";
            this.statusColor = 0xFF5555;
            return;
        }
        this.uploading = true;
        this.statusMessage = "Preparing upload...";
        this.uploadProgress = 0;
        WorldUploadRequest request = new WorldUploadRequest();
        request.setWorldName(worldName);
        request.setWorldFolderName(this.availableWorlds.get(this.selectedWorldIndex));
        request.setDescription(this.descBox1.getValue() + "\n" + this.descBox2.getValue() + "\n" + this.descBox3.getValue());
        request.setMinecraftVersion(this.versionBox.getValue());
        request.setWorldType(this.worldType);
        request.setTags(new ArrayList<String>(this.tags));
        request.setPublic(this.isPublic);
        request.setPruneUninhabitedChunks(this.pruneChunks);
        request.setProgressCallback((percentage, currentFile) -> this.minecraft.execute(() -> {
            this.uploadProgress = percentage;
            this.statusMessage = "Uploading... " + percentage + "%";
        }));
        new Thread(() -> {
            try {
                WorldManager.UploadResult result = this.worldManager.uploadWorld(request);
                this.minecraft.execute(() -> {
                    this.uploading = false;
                    if (result.isSuccess()) {
                        this.statusMessage = "\u00a7a\u2713 " + result.getMessage();
                        this.statusColor = 0x55FF55;
                        new Thread(() -> {
                            try {
                                Thread.sleep(2000L);
                                this.minecraft.execute(() -> this.minecraft.setScreen((Screen)new WorldBrowserScreen(this.parent)));
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }).start();
                    } else {
                        this.statusMessage = "\u00a7c\u2717 " + result.getMessage();
                        this.statusColor = 0xFF5555;
                    }
                });
            }
            catch (Exception e) {
                this.minecraft.execute(() -> {
                    this.uploading = false;
                    this.statusMessage = "\u00a7cUpload failed: " + e.getMessage();
                    this.statusColor = 0xFF5555;
                });
            }
        }).start();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, "\ud83d\udce4 Upload World", this.width / 2, 15, 0xFFFFFF);
        int centerX = this.width / 2;
        int leftX = centerX - 150;
        graphics.drawString(this.font, "Select World:", leftX, 25, 0xFFFFFF);
        graphics.drawString(this.font, "Display Name:", leftX, 65, 0xFFFFFF);
        graphics.drawString(this.font, "Description:", leftX, 105, 0xFFFFFF);
        graphics.drawString(this.font, "MC Version:", leftX, 195, 0xFFFFFF);
        graphics.drawString(this.font, "Tags:", leftX, 235, 0xFFFFFF);
        graphics.drawString(this.font, "Visibility:", leftX, 275, 0xFFFFFF);
        int tagY = 270;
        int tagX = leftX;
        for (String tag : this.tags) {
            graphics.fill(tagX, tagY, tagX + 60, tagY + 15, -2143272896);
            graphics.drawString(this.font, tag, tagX + 3, tagY + 3, 0xFFFFFF);
            if (mouseX >= tagX + 52 && mouseX <= tagX + 58 && mouseY >= tagY + 2 && mouseY <= tagY + 13) {
                graphics.fill(tagX + 52, tagY + 2, tagX + 58, tagY + 13, -2130771968);
                if (this.minecraft.mouseHandler.isLeftPressed()) {
                    this.removeTag(tag);
                }
            }
            graphics.drawString(this.font, "x", tagX + 53, tagY + 3, 0xFFFFFF);
            tagX += 65;
        }
        if (this.scanResult != null) {
            int boxY = 315;
            graphics.fill(leftX, boxY, leftX + 300, boxY + 45, -2145378272);
            graphics.fill(leftX, boxY, leftX + 300, boxY + 1, -12566464);
            if (this.scanResult.isSafe()) {
                graphics.drawString(this.font, "\u00a7aSize: " + this.scanResult.getFormattedSize() + " (uncompressed)", leftX + 5, boxY + 5, 0x55FF55);
                graphics.drawString(this.font, "\u00a7aFiles: " + this.scanResult.getFileCount(), leftX + 5, boxY + 18, 0x55FF55);
                graphics.drawString(this.font, "\u00a7aStatus: \u2713 Safe to upload", leftX + 5, boxY + 31, 0x55FF55);
            } else {
                graphics.drawString(this.font, "\u00a7cBlocked files: " + this.scanResult.getBlockedFiles().size(), leftX + 5, boxY + 5, 0xFF5555);
                graphics.drawString(this.font, "\u00a7cCannot upload - security issues", leftX + 5, boxY + 18, 0xFF5555);
                if (!this.scanResult.getBlockedFiles().isEmpty()) {
                    Object firstBlocked = this.scanResult.getBlockedFiles().get(0);
                    if (((String)firstBlocked).length() > 40) {
                        firstBlocked = ((String)firstBlocked).substring(0, 37) + "...";
                    }
                    graphics.drawString(this.font, "\u00a7c" + (String)firstBlocked, leftX + 5, boxY + 31, 0xFF5555);
                }
            }
        }
        if (!this.statusMessage.isEmpty()) {
            graphics.drawCenteredString(this.font, this.statusMessage, this.width / 2, this.height - 45, this.statusColor);
        }
        if (this.uploading && this.uploadProgress > 0) {
            int barWidth = 200;
            int barX = centerX - barWidth / 2;
            int barY = this.height - 60;
            graphics.fill(barX, barY, barX + barWidth, barY + 10, -2145378272);
            graphics.fill(barX, barY, barX + barWidth * this.uploadProgress / 100, barY + 10, -2141847723);
            graphics.fill(barX, barY, barX + barWidth, barY + 1, -12566464);
            graphics.fill(barX, barY + 9, barX + barWidth, barY + 10, -12566464);
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.fill(0, 0, this.width, this.height, -15724528);
    }

    public boolean isPauseScreen() {
        return true;
    }
}

