/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class ImageLoader {
    private static final Map<String, ResourceLocation> imageCache = new HashMap<String, ResourceLocation>();
    private static final Map<String, CompletableFuture<ResourceLocation>> loadingImages = new HashMap<String, CompletableFuture<ResourceLocation>>();
    private static final ResourceLocation PLACEHOLDER = ResourceLocation.withDefaultNamespace((String)"textures/misc/unknown_pack.png");

    public static ResourceLocation loadImage(String imageUrl) {
        if (imageUrl == null || imageUrl.isEmpty()) {
            return PLACEHOLDER;
        }
        if (imageCache.containsKey(imageUrl)) {
            return imageCache.get(imageUrl);
        }
        if (loadingImages.containsKey(imageUrl)) {
            return PLACEHOLDER;
        }
        CompletableFuture<ResourceLocation> future = CompletableFuture.supplyAsync(() -> {
            try {
                return ImageLoader.downloadAndRegisterImage(imageUrl);
            }
            catch (Exception e) {
                System.err.println("[ImageLoader] Failed to load image: " + imageUrl);
                e.printStackTrace();
                return PLACEHOLDER;
            }
        });
        loadingImages.put(imageUrl, future);
        future.thenAccept(resourceLocation -> {
            imageCache.put(imageUrl, (ResourceLocation)resourceLocation);
            loadingImages.remove(imageUrl);
        });
        return PLACEHOLDER;
    }

    public static boolean isImageLoaded(String imageUrl) {
        return imageCache.containsKey(imageUrl);
    }

    public static ResourceLocation getImage(String imageUrl) {
        return imageCache.getOrDefault(imageUrl, PLACEHOLDER);
    }

    private static ResourceLocation downloadAndRegisterImage(String imageUrl) throws Exception {
        URL url = new URL(imageUrl);
        try (InputStream inputStream = url.openStream();){
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            if (bufferedImage == null) {
                System.err.println("[ImageLoader] Failed to read image from: " + imageUrl);
                ResourceLocation resourceLocation = PLACEHOLDER;
                return resourceLocation;
            }
            NativeImage nativeImage = ImageLoader.convertToNativeImage(bufferedImage);
            DynamicTexture dynamicTexture = new DynamicTexture(nativeImage);
            String textureName = "world_screenshot_" + Math.abs(imageUrl.hashCode());
            ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"tunnelyrefab", (String)textureName);
            Minecraft.getInstance().execute(() -> Minecraft.getInstance().getTextureManager().register(resourceLocation, (AbstractTexture)dynamicTexture));
            ResourceLocation resourceLocation2 = resourceLocation;
            return resourceLocation2;
        }
    }

    private static NativeImage convertToNativeImage(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        NativeImage nativeImage = new NativeImage(width, height, false);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = bufferedImage.getRGB(x, y);
                int alpha = rgb >> 24 & 0xFF;
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                int abgr = alpha << 24 | blue << 16 | green << 8 | red;
                nativeImage.setPixelRGBA(x, y, abgr);
            }
        }
        return nativeImage;
    }

    public static void clearCache() {
        imageCache.clear();
        loadingImages.clear();
    }

    public static void removeFromCache(String imageUrl) {
        imageCache.remove(imageUrl);
        loadingImages.remove(imageUrl);
    }
}

