/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.networking;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.texboobcat.tunnelyrefab.networking.RouteOptimizer;

public class NetworkQualityMonitor {
    private static final int HISTORY_SIZE = 20;
    private static final long STALE_THRESHOLD_MS = 60000L;
    private final int[] latencyHistory;
    private final double[] packetLossHistory;
    private int historyIndex = 0;
    private int historySampleCount = 0;
    private final AtomicInteger packetsSent = new AtomicInteger(0);
    private final AtomicInteger packetsReceived = new AtomicInteger(0);
    private final AtomicLong totalLatency = new AtomicLong(0L);
    private final AtomicInteger latencySamples = new AtomicInteger(0);
    private RouteOptimizer.Route currentRoute;
    private long lastCheckTimestamp = 0L;

    public NetworkQualityMonitor() {
        this.latencyHistory = new int[20];
        this.packetLossHistory = new double[20];
    }

    public void recordLatency(int latencyMs) {
        this.latencyHistory[this.historyIndex] = latencyMs;
        this.historyIndex = (this.historyIndex + 1) % 20;
        if (this.historySampleCount < 20) {
            ++this.historySampleCount;
        }
        this.totalLatency.addAndGet(latencyMs);
        this.latencySamples.incrementAndGet();
    }

    public void recordPacketSent() {
        this.packetsSent.incrementAndGet();
    }

    public void recordPacketReceived() {
        this.packetsReceived.incrementAndGet();
    }

    public double calculateAverageLatency() {
        if (this.historySampleCount == 0) {
            return Double.MAX_VALUE;
        }
        long sum = 0L;
        for (int i = 0; i < this.historySampleCount; ++i) {
            sum += (long)this.latencyHistory[i];
        }
        return (double)sum / (double)this.historySampleCount;
    }

    public double calculateJitter() {
        if (this.historySampleCount < 2) {
            return 0.0;
        }
        double avg = this.calculateAverageLatency();
        double sumSquaredDiff = 0.0;
        for (int i = 0; i < this.historySampleCount; ++i) {
            double diff = (double)this.latencyHistory[i] - avg;
            sumSquaredDiff += diff * diff;
        }
        return Math.sqrt(sumSquaredDiff / (double)this.historySampleCount);
    }

    public double calculatePacketLoss() {
        int sent = this.packetsSent.get();
        int received = this.packetsReceived.get();
        if (sent == 0) {
            return 0.0;
        }
        int lost = Math.max(0, sent - received);
        return (double)lost / (double)sent * 100.0;
    }

    public void updatePacketLossHistory() {
        double loss;
        this.packetLossHistory[this.historyIndex] = loss = this.calculatePacketLoss();
    }

    public double calculateAveragePacketLoss() {
        if (this.historySampleCount == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < this.historySampleCount; ++i) {
            sum += this.packetLossHistory[i];
        }
        return sum / (double)this.historySampleCount;
    }

    public boolean shouldReroute() {
        boolean highJitter;
        if (this.currentRoute == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastCheckTimestamp < 60000L) {
            return false;
        }
        this.lastCheckTimestamp = now;
        double avgLatency = this.calculateAverageLatency();
        double avgPacketLoss = this.calculateAveragePacketLoss();
        double jitter = this.calculateJitter();
        boolean latencyDegraded = avgLatency > (double)this.currentRoute.totalLatencyMs * 1.5;
        boolean highPacketLoss = avgPacketLoss > 5.0;
        boolean bl = highJitter = jitter > 100.0;
        if (latencyDegraded || highPacketLoss || highJitter) {
            System.err.println(String.format("[Tunnely] Network degradation detected - Latency: %dms (baseline: %dms), Loss: %.2f%%, Jitter: %dms", (int)avgLatency, this.currentRoute.totalLatencyMs, avgPacketLoss, (int)jitter));
            return true;
        }
        return false;
    }

    public void setCurrentRoute(RouteOptimizer.Route route) {
        this.currentRoute = route;
        this.lastCheckTimestamp = System.currentTimeMillis();
        this.resetMetrics();
    }

    public void resetMetrics() {
        this.packetsSent.set(0);
        this.packetsReceived.set(0);
        this.totalLatency.set(0L);
        this.latencySamples.set(0);
        this.historyIndex = 0;
        this.historySampleCount = 0;
    }

    public NetworkMetrics getMetrics() {
        return new NetworkMetrics((int)this.calculateAverageLatency(), this.calculatePacketLoss(), this.calculateJitter(), this.packetsSent.get(), this.packetsReceived.get());
    }

    public static class NetworkMetrics {
        public final int currentLatencyMs;
        public final double packetLossPercent;
        public final double jitterMs;
        public final int packetsSent;
        public final int packetsReceived;

        public NetworkMetrics(int latency, double packetLoss, double jitter, int sent, int received) {
            this.currentLatencyMs = latency;
            this.packetLossPercent = packetLoss;
            this.jitterMs = jitter;
            this.packetsSent = sent;
            this.packetsReceived = received;
        }

        public String toString() {
            return String.format("NetworkMetrics[latency=%dms, loss=%.2f%%, jitter=%.1fms, sent=%d, received=%d]", this.currentLatencyMs, this.packetLossPercent, this.jitterMs, this.packetsSent, this.packetsReceived);
        }
    }
}

