/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.shaded.org.tukaani.xz;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.texboobcat.tunnelyrefab.shaded.org.tukaani.xz.ArrayCache;
import org.texboobcat.tunnelyrefab.shaded.org.tukaani.xz.CorruptedInputException;
import org.texboobcat.tunnelyrefab.shaded.org.tukaani.xz.XZIOException;
import org.texboobcat.tunnelyrefab.shaded.org.tukaani.xz.lz.LZDecoder;
import org.texboobcat.tunnelyrefab.shaded.org.tukaani.xz.lzma.LZMADecoder;
import org.texboobcat.tunnelyrefab.shaded.org.tukaani.xz.rangecoder.RangeDecoderFromBuffer;

public class LZMA2InputStream
extends InputStream {
    public static final int DICT_SIZE_MIN = 4096;
    public static final int DICT_SIZE_MAX = 0x7FFFFFF0;
    private static final int COMPRESSED_SIZE_MAX = 65536;
    private final ArrayCache arrayCache;
    private DataInputStream in;
    private LZDecoder lz;
    private RangeDecoderFromBuffer rc;
    private LZMADecoder lzma;
    private int uncompressedSize = 0;
    private boolean isLZMAChunk = false;
    private boolean needDictReset = true;
    private boolean needProps = true;
    private boolean endReached = false;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];

    public static int getMemoryUsage(int n) {
        return 104 + LZMA2InputStream.getDictSize(n) / 1024;
    }

    private static int getDictSize(int n) {
        if (n < 4096 || n > 0x7FFFFFF0) {
            throw new IllegalArgumentException("Unsupported dictionary size " + n);
        }
        return n + 15 & 0xFFFFFFF0;
    }

    public LZMA2InputStream(InputStream inputStream, int n) {
        this(inputStream, n, null);
    }

    public LZMA2InputStream(InputStream inputStream, int n, byte[] byArray) {
        this(inputStream, n, byArray, ArrayCache.getDefaultCache());
    }

    LZMA2InputStream(InputStream inputStream, int n, byte[] byArray, ArrayCache arrayCache) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.arrayCache = arrayCache;
        this.in = new DataInputStream(inputStream);
        this.rc = new RangeDecoderFromBuffer(65536, arrayCache);
        this.lz = new LZDecoder(LZMA2InputStream.getDictSize(n), byArray, arrayCache);
        if (byArray != null && byArray.length > 0) {
            this.needDictReset = false;
        }
    }

    @Override
    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.endReached) {
            return -1;
        }
        try {
            int n3 = 0;
            while (n2 > 0) {
                if (this.uncompressedSize == 0) {
                    this.decodeChunkHeader();
                    if (this.endReached) {
                        return n3 == 0 ? -1 : n3;
                    }
                }
                int n4 = Math.min(this.uncompressedSize, n2);
                if (!this.isLZMAChunk) {
                    this.lz.copyUncompressed(this.in, n4);
                } else {
                    this.lz.setLimit(n4);
                    this.lzma.decode();
                }
                int n5 = this.lz.flush(byArray, n);
                n += n5;
                n2 -= n5;
                n3 += n5;
                this.uncompressedSize -= n5;
                if (this.uncompressedSize != 0 || this.rc.isFinished() && !this.lz.hasPending()) continue;
                throw new CorruptedInputException();
            }
            return n3;
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    private void decodeChunkHeader() throws IOException {
        int n = this.in.readUnsignedByte();
        if (n == 0) {
            this.endReached = true;
            this.putArraysToCache();
            return;
        }
        if (n >= 224 || n == 1) {
            this.needProps = true;
            this.needDictReset = false;
            this.lz.reset();
        } else if (this.needDictReset) {
            throw new CorruptedInputException();
        }
        if (n >= 128) {
            this.isLZMAChunk = true;
            this.uncompressedSize = (n & 0x1F) << 16;
            this.uncompressedSize += this.in.readUnsignedShort() + 1;
            int n2 = this.in.readUnsignedShort() + 1;
            if (n >= 192) {
                this.needProps = false;
                this.decodeProps();
            } else {
                if (this.needProps) {
                    throw new CorruptedInputException();
                }
                if (n >= 160) {
                    this.lzma.reset();
                }
            }
            this.rc.prepareInputBuffer(this.in, n2);
        } else {
            if (n > 2) {
                throw new CorruptedInputException();
            }
            this.isLZMAChunk = false;
            this.uncompressedSize = this.in.readUnsignedShort() + 1;
        }
    }

    private void decodeProps() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.in.readUnsignedByte();
        if (n4 > 224) {
            throw new CorruptedInputException();
        }
        if ((n3 = (n4 -= (n2 = n4 / 45) * 9 * 5) - (n = n4 / 9) * 9) + n > 4) {
            throw new CorruptedInputException();
        }
        this.lzma = new LZMADecoder(this.lz, this.rc, n3, n, n2);
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.isLZMAChunk ? this.uncompressedSize : Math.min(this.uncompressedSize, this.in.available());
    }

    private void putArraysToCache() {
        if (this.lz != null) {
            this.lz.putArraysToCache(this.arrayCache);
            this.lz = null;
            this.rc.putArraysToCache(this.arrayCache);
            this.rc = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.putArraysToCache();
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }
}

