/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.tunnel;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.texboobcat.tunnelyrefab.tunnel.PortForwardError;
import org.texboobcat.tunnelyrefab.tunnel.TunnelClient;

public class UdpProxyServer {
    private final String localhost = "127.0.0.1";
    private final int servicePort;
    private final TunnelClient tunnelClient;
    private final String serviceName;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicLong packetsReceived = new AtomicLong(0L);
    private final AtomicLong packetsSent = new AtomicLong(0L);
    private final AtomicLong packetsDropped = new AtomicLong(0L);
    private static final int MAX_UDP_PACKET_SIZE = 1472;
    private static final int MAX_VOICE_PACKET_SIZE = 2048;
    private DatagramSocket localSocket;
    private Thread receiverThread;
    private InetAddress localAddress;
    private final ConcurrentHashMap<String, Long> lastPacketTime = new ConcurrentHashMap();

    public UdpProxyServer(int servicePort, TunnelClient tunnelClient, String serviceName) {
        this.servicePort = servicePort;
        this.tunnelClient = tunnelClient;
        this.serviceName = serviceName;
    }

    public void start() throws IOException {
        if (this.running.get()) {
            System.out.println("[Tunnely UDP] " + this.serviceName + " proxy already running");
            return;
        }
        IOException lastException = null;
        int MAX_RETRIES = 3;
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                this.localAddress = InetAddress.getByName("127.0.0.1");
                this.localSocket = new DatagramSocket();
                this.running.set(true);
                this.receiverThread = new Thread(this::receiveFromService, "Tunnely-UDP-" + this.serviceName + "-Receiver");
                this.receiverThread.setDaemon(true);
                this.receiverThread.start();
                System.out.println("[Tunnely UDP] " + this.serviceName + " proxy started on local port " + this.localSocket.getLocalPort() + " -> service port " + this.servicePort);
                return;
            }
            catch (IOException e) {
                lastException = e;
                this.running.set(false);
                if (this.localSocket != null) {
                    this.localSocket.close();
                    this.localSocket = null;
                }
                if (attempt >= 2) continue;
                long backoffMs = 100L * (1L << attempt);
                System.out.println("[Tunnely UDP] Failed to start " + this.serviceName + " proxy (attempt " + (attempt + 1) + "/3), retrying in " + backoffMs + "ms...");
                try {
                    Thread.sleep(backoffMs);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted during retry backoff", ie);
                }
            }
        }
        PortForwardError error = PortForwardError.fromException(lastException);
        throw new IOException("Failed to start UDP proxy for " + this.serviceName + " after 3 attempts: " + error.getFullMessage(), lastException);
    }

    public void handleRelayPacket(byte[] data) {
        if (!this.running.get() || data == null || data.length == 0) {
            return;
        }
        if (!this.isValidPacketSize(data.length)) {
            this.packetsDropped.incrementAndGet();
            if (this.packetsDropped.get() % 10L == 0L) {
                System.err.println("[Tunnely UDP] " + this.serviceName + " dropped " + this.packetsDropped.get() + " oversized packets (last: " + data.length + " bytes)");
            }
            return;
        }
        try {
            DatagramPacket packet = new DatagramPacket(data, data.length, this.localAddress, this.servicePort);
            this.localSocket.send(packet);
            this.packetsReceived.incrementAndGet();
            if (this.packetsReceived.get() % 100L == 0L) {
                System.out.println("[Tunnely UDP] " + this.serviceName + " forwarded " + this.packetsReceived.get() + " packets from relay to local service");
            }
        }
        catch (IOException e) {
            System.err.println("[Tunnely UDP] Error forwarding packet to " + this.serviceName + ": " + e.getMessage());
        }
    }

    private boolean isValidPacketSize(int size) {
        if (size > 2048) {
            System.err.println("[Tunnely UDP] Rejecting oversized packet: " + size + " bytes (max: 2048)");
            return false;
        }
        if (size > 1472) {
            System.out.println("[Tunnely UDP] Warning: Large packet (" + size + " bytes) may fragment");
        }
        return true;
    }

    private void receiveFromService() {
        byte[] buffer = new byte[65507];
        System.out.println("[Tunnely UDP] Starting receiver for " + this.serviceName + " on port " + this.servicePort);
        while (this.running.get()) {
            try {
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                this.localSocket.receive(packet);
                byte[] data = new byte[packet.getLength()];
                System.arraycopy(packet.getData(), packet.getOffset(), data, 0, packet.getLength());
                if (this.tunnelClient == null || !this.tunnelClient.isConnected()) continue;
                this.tunnelClient.sendUdpPacket(data, this.servicePort);
                this.packetsSent.incrementAndGet();
                if (this.packetsSent.get() % 100L != 0L) continue;
                System.out.println("[Tunnely UDP] " + this.serviceName + " forwarded " + this.packetsSent.get() + " packets from local service to relay");
            }
            catch (SocketException e) {
                if (!this.running.get()) break;
                System.err.println("[Tunnely UDP] Socket error in " + this.serviceName + " receiver: " + e.getMessage());
                break;
            }
            catch (IOException e) {
                if (!this.running.get()) continue;
                System.err.println("[Tunnely UDP] Error receiving from " + this.serviceName + ": " + e.getMessage());
            }
        }
        System.out.println("[Tunnely UDP] Receiver thread exiting for " + this.serviceName);
    }

    public String getStats() {
        long dropped = this.packetsDropped.get();
        if (dropped > 0L) {
            return String.format("%s (Port %d): \u2193%d \u2191%d packets (%d dropped)", this.serviceName, this.servicePort, this.packetsReceived.get(), this.packetsSent.get(), dropped);
        }
        return String.format("%s (Port %d): \u2193%d \u2191%d packets", this.serviceName, this.servicePort, this.packetsReceived.get(), this.packetsSent.get());
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getServicePort() {
        return this.servicePort;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void shutdown() {
        if (!this.running.get()) {
            return;
        }
        System.out.println("[Tunnely UDP] Shutting down " + this.serviceName + " proxy...");
        this.running.set(false);
        if (this.localSocket != null && !this.localSocket.isClosed()) {
            this.localSocket.close();
        }
        if (this.receiverThread != null && this.receiverThread.isAlive()) {
            try {
                this.receiverThread.join(1000L);
            }
            catch (InterruptedException e) {
                this.receiverThread.interrupt();
            }
        }
        System.out.println("[Tunnely UDP] " + this.serviceName + " proxy shutdown complete. Stats: " + this.getStats());
    }
}

