/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JOptionPane;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.worlds.DownloadState;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;

public class DownloadProgressScreen
extends class_437 {
    private final class_437 parent;
    private final WorldManager worldManager;
    private final WorldInfo world;
    private final Path stateFile;
    private Timer progressTimer;
    private String statusMessage = "Starting download...";
    private int downloadProgress = 0;
    private String downloadedBytes = "0 B";
    private String totalBytes = "0 B";
    private String speed = "0 B/s";
    private boolean isPaused = false;
    private boolean isCompleted = false;
    private boolean isCancelled = false;
    private boolean isExtracting = false;
    private class_4185 pauseButton;
    private class_4185 cancelButton;
    private BandwidthSlider bandwidthSlider;

    public DownloadProgressScreen(class_437 parent, WorldInfo world) {
        super((class_2561)class_2561.method_43470((String)"Downloading World"));
        this.parent = parent;
        this.world = world;
        this.worldManager = new WorldManager();
        this.stateFile = null;
    }

    public DownloadProgressScreen(class_437 parent, WorldManager worldManager, Path stateFile) {
        super((class_2561)class_2561.method_43470((String)"Resuming Download"));
        this.parent = parent;
        this.worldManager = worldManager;
        this.world = null;
        this.stateFile = stateFile;
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        this.pauseButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u23f8 Pause"), button -> this.togglePause()).method_46434(centerX - 105, centerY + 50, 100, 20).method_46431();
        this.method_37063((class_364)this.pauseButton);
        this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2716 Cancel"), button -> this.cancelDownload()).method_46434(centerX + 5, centerY + 50, 100, 20).method_46431();
        this.method_37063((class_364)this.cancelButton);
        this.bandwidthSlider = new BandwidthSlider(centerX - 150, centerY + 90, 300, 20);
        this.method_37063((class_364)this.bandwidthSlider);
        int presetY = centerY + 120;
        int presetX = centerX - 165;
        this.addPresetButton(presetX, presetY, "Unlimited", 0L);
        this.addPresetButton(presetX + 70, presetY, "100 KB/s", 102400L);
        this.addPresetButton(presetX + 140, presetY, "500 KB/s", 512000L);
        this.addPresetButton(presetX + 210, presetY, "1 MB/s", 0x100000L);
        this.addPresetButton(presetX + 280, presetY, "2 MB/s", 0x200000L);
        this.startDownload();
    }

    private void addPresetButton(int x, int y, String label, long bytesPerSecond) {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)label), button -> this.setBandwidthLimit(bytesPerSecond)).method_46434(x, y, 65, 18).method_46431());
    }

    private void setBandwidthLimit(long bytesPerSecond) {
        this.worldManager.setBandwidthLimit(bytesPerSecond);
        this.bandwidthSlider.updateFromConfig();
        this.statusMessage = "Bandwidth limit set to: " + this.formatBytesPerSecond(bytesPerSecond);
    }

    private void startDownload() {
        this.startProgressMonitoring();
        new Thread(() -> {
            try {
                WorldManager.DownloadResult result;
                if (this.stateFile != null) {
                    this.statusMessage = "Resuming download...";
                    result = this.worldManager.resumePausedDownload(this.stateFile, Paths.get("saves", new String[0]), this::onProgress);
                } else {
                    this.statusMessage = "Starting download...";
                    result = this.worldManager.downloadWorldResumable(this.world.getId(), Paths.get("saves", new String[0]), this::onProgress);
                }
                this.field_22787.execute(() -> {
                    this.stopProgressMonitoring();
                    if (result.isSuccess()) {
                        this.isCompleted = true;
                        this.statusMessage = "\u00a7a\u2713 Download complete! World saved to: " + result.getWorldFolderName();
                        this.downloadProgress = 100;
                        new Timer().schedule(new TimerTask(){

                            @Override
                            public void run() {
                                DownloadProgressScreen.this.field_22787.execute(() -> {
                                    if (!DownloadProgressScreen.this.isCancelled) {
                                        DownloadProgressScreen.this.field_22787.method_1507(DownloadProgressScreen.this.parent);
                                    }
                                });
                            }
                        }, 3000L);
                    } else {
                        this.statusMessage = result.getMessage().contains("paused") ? "\u00a7eDownload paused. You can resume it later from the Downloads menu." : "\u00a7c\u2717 " + result.getMessage();
                    }
                });
            }
            catch (Exception e) {
                this.field_22787.execute(() -> {
                    this.stopProgressMonitoring();
                    this.statusMessage = "\u00a7cDownload failed: " + e.getMessage();
                    e.printStackTrace();
                });
            }
        }).start();
    }

    private void onProgress(int percentage, String message) {
        this.field_22787.execute(() -> {
            this.downloadProgress = percentage;
            if (message.contains("Extracting")) {
                this.isExtracting = true;
                this.statusMessage = message;
            } else if (!this.isExtracting) {
                this.statusMessage = message;
            }
        });
    }

    private void startProgressMonitoring() {
        if (this.progressTimer != null) {
            this.progressTimer.cancel();
        }
        this.progressTimer = new Timer();
        this.progressTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                DownloadState state = DownloadProgressScreen.this.worldManager.getCurrentDownloadState();
                if (state != null) {
                    DownloadProgressScreen.this.field_22787.execute(() -> {
                        DownloadProgressScreen.this.downloadedBytes = state.getDownloadedBytesFormatted();
                        DownloadProgressScreen.this.totalBytes = state.getTotalBytesFormatted();
                        DownloadProgressScreen.this.speed = DownloadProgressScreen.this.formatBytesPerSecond(state.getDownloadSpeed());
                        DownloadProgressScreen.this.isPaused = state.isPaused();
                        if (DownloadProgressScreen.this.pauseButton != null) {
                            DownloadProgressScreen.this.pauseButton.method_25355((class_2561)class_2561.method_43470((String)(DownloadProgressScreen.this.isPaused ? "\u25b6 Resume" : "\u23f8 Pause")));
                        }
                    });
                }
            }
        }, 0L, 500L);
    }

    private void stopProgressMonitoring() {
        if (this.progressTimer != null) {
            this.progressTimer.cancel();
            this.progressTimer = null;
        }
    }

    private void togglePause() {
        if (this.isExtracting) {
            this.statusMessage = "\u00a7cCannot pause during extraction";
            return;
        }
        if (this.isCompleted || this.isCancelled) {
            return;
        }
        if (this.isPaused) {
            this.statusMessage = "\u00a7ePlease use the Downloads menu to resume";
        } else {
            this.worldManager.pauseCurrentDownload();
            this.isPaused = true;
            this.statusMessage = "\u00a7ePausing download...";
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    DownloadProgressScreen.this.field_22787.execute(() -> {
                        DownloadProgressScreen.this.stopProgressMonitoring();
                        DownloadProgressScreen.this.field_22787.method_1507(DownloadProgressScreen.this.parent);
                    });
                }
            }, 1000L);
        }
    }

    private void cancelDownload() {
        if (this.isCompleted) {
            this.field_22787.method_1507(this.parent);
            return;
        }
        int choice = JOptionPane.showConfirmDialog(null, "Are you sure you want to cancel this download?", "Cancel Download", 0);
        if (choice == 0) {
            this.worldManager.cancelCurrentDownload();
            this.isCancelled = true;
            this.stopProgressMonitoring();
            this.statusMessage = "\u00a7cDownload cancelled";
            this.field_22787.method_1507(this.parent);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics, mouseX, mouseY, partialTicks);
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        String title = this.world != null ? "Downloading: " + this.world.getName() : "Resuming Download";
        graphics.method_25300(this.field_22793, title, centerX, 20, 0xFFFFFF);
        graphics.method_25300(this.field_22793, this.statusMessage, centerX, centerY - 80, 0xFFFFFF);
        int barWidth = 300;
        int barHeight = 30;
        int barX = centerX - barWidth / 2;
        int barY = centerY - 50;
        graphics.method_25294(barX, barY, barX + barWidth, barY + barHeight, Integer.MIN_VALUE);
        int fillWidth = barWidth * this.downloadProgress / 100;
        int fillColor = this.isCompleted ? -2147418368 : (this.isPaused ? -2130729728 : -2141847723);
        graphics.method_25294(barX, barY, barX + fillWidth, barY + barHeight, fillColor);
        graphics.method_25294(barX, barY, barX + barWidth, barY + 2, -12566464);
        graphics.method_25294(barX, barY + barHeight - 2, barX + barWidth, barY + barHeight, -12566464);
        graphics.method_25294(barX, barY, barX + 2, barY + barHeight, -12566464);
        graphics.method_25294(barX + barWidth - 2, barY, barX + barWidth, barY + barHeight, -12566464);
        String progressText = this.downloadProgress + "%";
        graphics.method_25300(this.field_22793, progressText, centerX, barY + 10, 0xFFFFFF);
        String bytesInfo = this.downloadedBytes + " / " + this.totalBytes;
        graphics.method_25300(this.field_22793, bytesInfo, centerX, centerY - 15, 0xAAAAAA);
        if (!this.isCompleted && !this.isPaused) {
            graphics.method_25300(this.field_22793, "Speed: " + this.speed, centerX, centerY, 0xAAAAAA);
        } else if (this.isPaused) {
            graphics.method_25300(this.field_22793, "\u00a7ePaused", centerX, centerY, 0xFFAA00);
        }
        graphics.method_25300(this.field_22793, "Download Speed Limit", centerX, centerY + 75, 0xFFFFFF);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        long currentLimit = this.worldManager.getBandwidthLimit();
        String limitText = currentLimit == 0L ? "Unlimited" : this.formatBytesPerSecond(currentLimit);
        graphics.method_25300(this.field_22793, "\u00a77" + limitText, centerX, centerY + 113, 0xAAAAAA);
    }

    public void method_25432() {
        this.stopProgressMonitoring();
        super.method_25432();
    }

    public boolean method_25422() {
        return this.isCompleted || this.isCancelled;
    }

    private String formatBytesPerSecond(long bytesPerSecond) {
        if (bytesPerSecond == 0L) {
            return "Unlimited";
        }
        if (bytesPerSecond < 1024L) {
            return bytesPerSecond + " B/s";
        }
        int exp = (int)(Math.log(bytesPerSecond) / Math.log(1024.0));
        String pre = "" + "KMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB/s", (double)bytesPerSecond / Math.pow(1024.0, exp), pre);
    }

    private class BandwidthSlider
    extends class_357 {
        private static final long MAX_LIMIT = 0xA00000L;

        public BandwidthSlider(int x, int y, int width, int height) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), 0.0);
            this.updateFromConfig();
            this.method_25346();
        }

        public void updateFromConfig() {
            long currentLimit = DownloadProgressScreen.this.worldManager.getBandwidthLimit();
            this.field_22753 = currentLimit == 0L ? 0.0 : Math.min(1.0, (double)currentLimit / 1.048576E7);
            this.method_25346();
        }

        protected void method_25346() {
            long limit = (long)(this.field_22753 * 1.048576E7);
            if (limit < 10240L) {
                limit = 0L;
            }
            this.method_25355((class_2561)class_2561.method_43470((String)DownloadProgressScreen.this.formatBytesPerSecond(limit)));
        }

        protected void method_25344() {
            long limit = (long)(this.field_22753 * 1.048576E7);
            if (limit < 10240L) {
                limit = 0L;
            }
            DownloadProgressScreen.this.worldManager.setBandwidthLimit(limit);
        }
    }
}

