/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.ui.screens.DownloadProgressScreen;
import org.texboobcat.tunnelyrefab.ui.screens.MyWorldsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.PausedDownloadsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WarningPopupScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldDetailsScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WorldUploadScreen;
import org.texboobcat.tunnelyrefab.worlds.ImageLoader;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;
import org.texboobcat.tunnelyrefab.worlds.ui.DownloadProtection;
import org.texboobcat.tunnelyrefab.worlds.ui.WorldBadge;

public class WorldBrowserScreen
extends class_437 {
    private final class_437 parent;
    private final WorldManager worldManager;
    private class_342 searchBox;
    private List<WorldInfo> worlds = new ArrayList<WorldInfo>();
    private int scrollOffset = 0;
    private final int WORLD_ENTRY_HEIGHT = 85;
    private int maxScrollOffset = 0;
    private int currentPage = 0;
    private final int WORLDS_PER_PAGE = 20;
    private boolean loading = false;
    private String statusMessage = "";
    private WorldInfo hoveredWorld = null;
    private String hoveredButton = null;

    public WorldBrowserScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Community Worlds"));
        this.parent = parent;
        this.worldManager = new WorldManager();
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        this.searchBox = new class_342(this.field_22793, centerX - 150, 35, 250, 20, (class_2561)class_2561.method_43470((String)"Search"));
        this.searchBox.method_1880(100);
        this.searchBox.method_47404((class_2561)class_2561.method_43470((String)"Search worlds..."));
        this.method_37063((class_364)this.searchBox);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udd0d"), button -> this.performSearch()).method_46434(centerX + 105, 35, 45, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25c0 Previous"), button -> this.previousPage()).method_46434(centerX - 155, this.field_22790 - 55, 75, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Next \u25b6"), button -> this.nextPage()).method_46434(centerX + 80, this.field_22790 - 55, 75, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Upload World"), button -> this.field_22787.method_1507((class_437)new WorldUploadScreen(this))).method_46434(centerX - 205, this.field_22790 - 30, 90, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"My Worlds"), button -> this.field_22787.method_1507((class_437)new MyWorldsScreen(this))).method_46434(centerX - 110, this.field_22790 - 30, 90, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u23f8 Downloads"), button -> this.field_22787.method_1507((class_437)new PausedDownloadsScreen(this))).method_46434(centerX - 15, this.field_22790 - 30, 90, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> this.field_22787.method_1507(this.parent)).method_46434(centerX + 80, this.field_22790 - 30, 90, 20).method_46431());
        this.loadWorlds();
    }

    private void loadWorlds() {
        if (this.loading) {
            return;
        }
        this.loading = true;
        this.statusMessage = "Loading worlds...";
        new Thread(() -> {
            try {
                List<WorldInfo> loadedWorlds = this.worldManager.listPublicWorlds(20, this.currentPage * 20);
                this.field_22787.execute(() -> {
                    this.worlds = loadedWorlds;
                    this.scrollOffset = 0;
                    this.updateMaxScroll();
                    this.loading = false;
                    this.statusMessage = this.worlds.isEmpty() ? "No worlds found" : "Loaded " + this.worlds.size() + " worlds";
                });
            }
            catch (Exception e) {
                this.field_22787.execute(() -> {
                    this.statusMessage = "\u00a7cFailed to load worlds: " + e.getMessage();
                    this.loading = false;
                });
            }
        }).start();
    }

    private void performSearch() {
        String query = this.searchBox.method_1882().trim();
        if (query.isEmpty()) {
            this.loadWorlds();
            return;
        }
        if (this.loading) {
            return;
        }
        this.loading = true;
        this.statusMessage = "Searching...";
        new Thread(() -> {
            try {
                List<WorldInfo> searchResults = this.worldManager.searchWorlds(query);
                this.field_22787.execute(() -> {
                    this.worlds = searchResults;
                    this.scrollOffset = 0;
                    this.currentPage = 0;
                    this.updateMaxScroll();
                    this.loading = false;
                    this.statusMessage = this.worlds.isEmpty() ? "\u00a7cNo worlds found for: " + query : "Found " + this.worlds.size() + " worlds";
                });
            }
            catch (Exception e) {
                this.field_22787.execute(() -> {
                    this.statusMessage = "\u00a7cSearch failed: " + e.getMessage();
                    this.loading = false;
                });
            }
        }).start();
    }

    private void downloadWorld(WorldInfo world) {
        if (this.loading) {
            return;
        }
        DownloadProtection.DownloadCheckResult check = DownloadProtection.checkDownloadSafety(world);
        if (check.isBlocked()) {
            this.field_22787.method_1507((class_437)new WarningPopupScreen(this, this, check.getTitle(), check.getMessage(), 0xFF5555, null));
            return;
        }
        if (check.isWarning()) {
            this.field_22787.method_1507((class_437)new WarningPopupScreen(this, this, check.getTitle(), check.getMessage(), 0xFFAA00, () -> this.proceedWithDownload(world)));
            return;
        }
        this.proceedWithDownload(world);
    }

    private void proceedWithDownload(WorldInfo world) {
        this.field_22787.method_1507((class_437)new DownloadProgressScreen(this, world));
    }

    private void viewWorldDetails(WorldInfo world) {
        this.field_22787.method_1507((class_437)new WorldDetailsScreen(this, world));
    }

    private void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.loadWorlds();
        }
    }

    private void nextPage() {
        if (this.worlds.size() >= 20) {
            ++this.currentPage;
            this.loadWorlds();
        }
    }

    private void updateMaxScroll() {
        int visibleHeight = this.field_22790 - 130;
        int contentHeight = this.worlds.size() * 85;
        this.maxScrollOffset = Math.max(0, contentHeight - visibleHeight);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_25300(this.field_22793, "\ud83c\udf0d Community Worlds", this.field_22789 / 2, 15, 0xFFFFFF);
        if (!this.statusMessage.isEmpty()) {
            graphics.method_25300(this.field_22793, this.statusMessage, this.field_22789 / 2, 60, 0xAAAAAA);
        }
        this.renderWorldList(graphics, mouseX, mouseY);
        if (!this.worlds.isEmpty()) {
            String pageInfo = "Page " + (this.currentPage + 1);
            graphics.method_25300(this.field_22793, pageInfo, this.field_22789 / 2, this.field_22790 - 45, 0xAAAAAA);
        }
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, -15724528);
    }

    private void renderWorldList(class_332 graphics, int mouseX, int mouseY) {
        int startY = 75;
        int endY = this.field_22790 - 60;
        int centerX = this.field_22789 / 2;
        int entryWidth = 400;
        int entryX = centerX - entryWidth / 2;
        graphics.method_44379(0, startY, this.field_22789, endY);
        int yOffset = startY - this.scrollOffset;
        for (int i = 0; i < this.worlds.size(); ++i) {
            WorldInfo world = this.worlds.get(i);
            int entryY = yOffset + i * 85;
            if (entryY + 85 < startY || entryY > endY) continue;
            this.renderWorldEntry(graphics, world, entryX, entryY, entryWidth, mouseX, mouseY);
        }
        graphics.method_44380();
    }

    private void renderWorldEntry(class_332 graphics, WorldInfo world, int x, int y, int width, int mouseX, int mouseY) {
        boolean hovered = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + 85 - 5;
        int bgColor = hovered ? -2143272896 : -2145378272;
        graphics.method_25294(x, y, x + width, y + 85 - 5, bgColor);
        graphics.method_25294(x, y, x + width, y + 1, -12566464);
        graphics.method_25294(x, y + 85 - 5, x + width, y + 85 - 4, -12566464);
        int thumbnailSize = 64;
        int thumbnailX = x + 5;
        int thumbnailY = y + 5;
        if (world.hasScreenshot()) {
            class_2960 screenshot = ImageLoader.loadImage(world.getScreenshotUrl());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.method_25290(screenshot, thumbnailX, thumbnailY, 0.0f, 0.0f, thumbnailSize, thumbnailSize, thumbnailSize, thumbnailSize);
        } else {
            graphics.method_25294(thumbnailX, thumbnailY, thumbnailX + thumbnailSize, thumbnailY + thumbnailSize, -12566464);
            graphics.method_25300(this.field_22793, "No", thumbnailX + thumbnailSize / 2, thumbnailY + 20, 0x888888);
            graphics.method_25300(this.field_22793, "Image", thumbnailX + thumbnailSize / 2, thumbnailY + 32, 0x888888);
        }
        int textX = thumbnailX + thumbnailSize + 10;
        Object nameText = world.getName();
        if (world.isVerified()) {
            nameText = "\u2713 " + (String)nameText;
        }
        if (world.isFeatured()) {
            nameText = "\u2b50 " + (String)nameText;
        }
        graphics.method_25303(this.field_22793, (String)nameText, textX, y + 5, 0xFFFFFF);
        String authorLine = "\u00a77by " + world.getAuthorUsername() + " | " + world.getFormattedRating() + " | \ud83d\udce5 " + world.getFormattedDownloadCount();
        graphics.method_25303(this.field_22793, authorLine, textX, y + 18, 0xAAAAAA);
        String detailsLine = "\u00a77" + world.getWorldType() + " | " + world.getMinecraftVersion() + " | \ud83d\udcbe " + world.getFormattedFileSize();
        graphics.method_25303(this.field_22793, detailsLine, textX, y + 31, 0xAAAAAA);
        Object desc = world.getDescription();
        if (((String)desc).length() > 45) {
            desc = ((String)desc).substring(0, 42) + "...";
        }
        graphics.method_25303(this.field_22793, "\u00a77" + (String)desc, textX, y + 44, 0x888888);
        WorldBadge.BadgeInfo securityBadge = WorldBadge.getSecurityBadge(world);
        if (securityBadge != null) {
            int badgeX = x + width - 75;
            int badgeY = y + 5;
            int badgeWidth = 70;
            int badgeHeight = 16;
            graphics.method_25294(badgeX, badgeY, badgeX + badgeWidth, badgeY + badgeHeight, securityBadge.backgroundColor);
            graphics.method_25300(this.field_22793, securityBadge.text, badgeX + badgeWidth / 2, badgeY + 4, securityBadge.textColor);
        }
        int buttonY = y + 58;
        int buttonWidth = 80;
        int buttonHeight = 18;
        int buttonSpacing = 85;
        boolean viewDetailsHovered = this.isMouseOverButton(mouseX, mouseY, x + 5, buttonY, buttonWidth, buttonHeight);
        if (viewDetailsHovered) {
            graphics.method_25294(x + 5, buttonY, x + 5 + buttonWidth, buttonY + buttonHeight, -2130706433);
            this.hoveredWorld = world;
            this.hoveredButton = "details";
        } else {
            graphics.method_25294(x + 5, buttonY, x + 5 + buttonWidth, buttonY + buttonHeight, -2139062144);
        }
        graphics.method_25300(this.field_22793, "View Details", x + 5 + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
        if (!this.loading) {
            boolean downloadHovered = this.isMouseOverButton(mouseX, mouseY, x + buttonSpacing, buttonY, buttonWidth, buttonHeight);
            if (downloadHovered) {
                graphics.method_25294(x + buttonSpacing, buttonY, x + buttonSpacing + buttonWidth, buttonY + buttonHeight, -2147418368);
                this.hoveredWorld = world;
                this.hoveredButton = "download";
            } else {
                graphics.method_25294(x + buttonSpacing, buttonY, x + buttonSpacing + buttonWidth, buttonY + buttonHeight, -2147450880);
            }
            graphics.method_25300(this.field_22793, "\u2b07 Download", x + buttonSpacing + buttonWidth / 2, buttonY + 5, 0xFFFFFF);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hoveredWorld != null && this.hoveredButton != null) {
            if (this.hoveredButton.equals("details")) {
                this.viewWorldDetails(this.hoveredWorld);
                return true;
            }
            if (this.hoveredButton.equals("download")) {
                this.downloadWorld(this.hoveredWorld);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_16014(double mouseX, double mouseY) {
        this.hoveredWorld = null;
        this.hoveredButton = null;
        super.method_16014(mouseX, mouseY);
    }

    private boolean isMouseOverButton(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double scrollDelta) {
        this.scrollOffset -= (int)(scrollDelta * 20.0);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScrollOffset));
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox.method_25370() && keyCode == 257) {
            this.performSearch();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25432() {
        super.method_25432();
    }

    public boolean method_25421() {
        return true;
    }
}

