/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.ui.screens.WorldUpdateScreen;
import org.texboobcat.tunnelyrefab.worlds.WorldInfo;
import org.texboobcat.tunnelyrefab.worlds.WorldManager;
import org.texboobcat.tunnelyrefab.worlds.WorldUploadRequest;

public class WorldEditScreen
extends class_437 {
    private final class_437 parent;
    private final WorldInfo existingWorld;
    private final String selectedLocalWorld;
    private final WorldManager worldManager;
    private class_342 nameBox;
    private class_342 descriptionBox;
    private class_342 tagsBox;
    private class_342 minecraftVersionBox;
    private String worldType;
    private boolean isPublic;
    private boolean pruneChunks = true;
    private String statusMessage = "";
    private boolean updating = false;
    private int uploadProgress = 0;
    private static final String[] WORLD_TYPES = new String[]{"Survival", "Creative", "Adventure", "Hardcore", "Skyblock", "Modded"};
    private int worldTypeIndex = 0;

    public WorldEditScreen(class_437 parent, WorldInfo existingWorld, String selectedLocalWorld) {
        super((class_2561)class_2561.method_43470((String)"Edit World Metadata"));
        this.parent = parent;
        this.existingWorld = existingWorld;
        this.selectedLocalWorld = selectedLocalWorld;
        this.worldManager = new WorldManager();
        this.worldType = existingWorld.getWorldType();
        this.isPublic = existingWorld.isPublic();
        for (int i = 0; i < WORLD_TYPES.length; ++i) {
            if (!WORLD_TYPES[i].equals(this.worldType)) continue;
            this.worldTypeIndex = i;
            break;
        }
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int startY = 50;
        int fieldWidth = 300;
        this.nameBox = new class_342(this.field_22793, centerX - fieldWidth / 2, startY, fieldWidth, 20, (class_2561)class_2561.method_43470((String)"World Name"));
        this.nameBox.method_1880(100);
        this.nameBox.method_1852(this.existingWorld.getName());
        this.method_37063((class_364)this.nameBox);
        this.descriptionBox = new class_342(this.field_22793, centerX - fieldWidth / 2, startY + 40, fieldWidth, 20, (class_2561)class_2561.method_43470((String)"Description"));
        this.descriptionBox.method_1880(500);
        this.descriptionBox.method_1852(this.existingWorld.getDescription());
        this.method_37063((class_364)this.descriptionBox);
        this.tagsBox = new class_342(this.field_22793, centerX - fieldWidth / 2, startY + 80, fieldWidth, 20, (class_2561)class_2561.method_43470((String)"Tags"));
        this.tagsBox.method_1880(200);
        this.tagsBox.method_1852(String.join((CharSequence)", ", this.existingWorld.getTags()));
        this.method_37063((class_364)this.tagsBox);
        this.minecraftVersionBox = new class_342(this.field_22793, centerX - fieldWidth / 2, startY + 120, fieldWidth, 20, (class_2561)class_2561.method_43470((String)"Minecraft Version"));
        this.minecraftVersionBox.method_1880(20);
        this.minecraftVersionBox.method_1852(this.existingWorld.getMinecraftVersion());
        this.method_37063((class_364)this.minecraftVersionBox);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Type: " + this.worldType)), button -> {
            this.worldTypeIndex = (this.worldTypeIndex + 1) % WORLD_TYPES.length;
            this.worldType = WORLD_TYPES[this.worldTypeIndex];
            button.method_25355((class_2561)class_2561.method_43470((String)("Type: " + this.worldType)));
        }).method_46434(centerX - fieldWidth / 2, startY + 160, fieldWidth / 2 - 5, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.isPublic ? "Public" : "Private")), button -> {
            this.isPublic = !this.isPublic;
            button.method_25355((class_2561)class_2561.method_43470((String)(this.isPublic ? "Public" : "Private")));
        }).method_46434(centerX + 5, startY + 160, fieldWidth / 2 - 5, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Prune: " + (this.pruneChunks ? "ON" : "OFF"))), button -> {
            this.pruneChunks = !this.pruneChunks;
            button.method_25355((class_2561)class_2561.method_43470((String)("Prune: " + (this.pruneChunks ? "ON" : "OFF"))));
        }).method_46434(centerX - fieldWidth / 2, startY + 190, fieldWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Update World"), button -> this.updateWorld()).method_46434(centerX - 105, this.field_22790 - 30, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), button -> this.field_22787.method_1507(this.parent)).method_46434(centerX + 10, this.field_22790 - 30, 100, 20).method_46431());
    }

    private void updateWorld() {
        if (this.updating) {
            return;
        }
        String name = this.nameBox.method_1882().trim();
        if (name.isEmpty()) {
            this.statusMessage = "\u00a7cWorld name cannot be empty";
            return;
        }
        String description = this.descriptionBox.method_1882().trim();
        if (description.isEmpty()) {
            this.statusMessage = "\u00a7cDescription cannot be empty";
            return;
        }
        String version = this.minecraftVersionBox.method_1882().trim();
        if (version.isEmpty()) {
            this.statusMessage = "\u00a7cMinecraft version cannot be empty";
            return;
        }
        this.updating = true;
        this.statusMessage = "Preparing update...";
        this.uploadProgress = 0;
        new Thread(() -> {
            try {
                String tagsInput = this.tagsBox.method_1882().trim();
                ArrayList<String> tags = new ArrayList();
                if (!tagsInput.isEmpty()) {
                    tags = Arrays.asList(tagsInput.split("\\s*,\\s*"));
                }
                WorldUploadRequest request = new WorldUploadRequest();
                request.setWorldFolderName(this.selectedLocalWorld);
                request.setWorldName(name);
                request.setDescription(description);
                request.setMinecraftVersion(version);
                request.setWorldType(this.worldType);
                request.setTags(tags);
                request.setPublic(this.isPublic);
                request.setPruneUninhabitedChunks(this.pruneChunks);
                request.setProgressCallback((percentage, currentFile) -> this.field_22787.execute(() -> {
                    this.uploadProgress = percentage;
                    this.statusMessage = "Updating... " + percentage + "%";
                }));
                WorldManager.UploadResult result = this.worldManager.updateWorld(this.existingWorld.getId(), request);
                this.field_22787.execute(() -> {
                    this.updating = false;
                    if (result.isSuccess()) {
                        this.statusMessage = "\u00a7a\u2713 World updated successfully!";
                        new Thread(() -> {
                            try {
                                Thread.sleep(2000L);
                                this.field_22787.execute(() -> this.field_22787.method_1507(this.parent instanceof WorldUpdateScreen ? ((WorldUpdateScreen)this.parent).getParent() : this.parent));
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }).start();
                    } else {
                        this.statusMessage = "\u00a7c\u2717 " + result.getMessage();
                    }
                });
            }
            catch (Exception e) {
                this.field_22787.execute(() -> {
                    this.updating = false;
                    this.statusMessage = "\u00a7cUpdate failed: " + e.getMessage();
                });
            }
        }).start();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics, mouseX, mouseY, partialTicks);
        graphics.method_25300(this.field_22793, "Update: " + this.existingWorld.getName(), this.field_22789 / 2, 15, 0xFFFFFF);
        graphics.method_25300(this.field_22793, "\u00a77Edit metadata and upload new world file", this.field_22789 / 2, 30, 0xAAAAAA);
        int centerX = this.field_22789 / 2;
        int startY = 50;
        int fieldWidth = 300;
        graphics.method_25303(this.field_22793, "World Name:", centerX - fieldWidth / 2, startY - 10, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "Description:", centerX - fieldWidth / 2, startY + 30, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "Tags (comma separated):", centerX - fieldWidth / 2, startY + 70, 0xFFFFFF);
        graphics.method_25303(this.field_22793, "Minecraft Version:", centerX - fieldWidth / 2, startY + 110, 0xFFFFFF);
        graphics.method_25300(this.field_22793, "\u00a77Local world: \u00a7b" + this.selectedLocalWorld, this.field_22789 / 2, startY + 220, 0xAAAAAA);
        if (!this.statusMessage.isEmpty()) {
            graphics.method_25300(this.field_22793, this.statusMessage, this.field_22789 / 2, startY + 240, 0xFFFFFF);
        }
        if (this.updating && this.uploadProgress > 0) {
            int barWidth = 300;
            int barX = this.field_22789 / 2 - barWidth / 2;
            int barY = startY + 260;
            graphics.method_25294(barX, barY, barX + barWidth, barY + 10, -2145378272);
            graphics.method_25294(barX, barY, barX + barWidth * this.uploadProgress / 100, barY + 10, -2147439873);
            graphics.method_25294(barX, barY, barX + barWidth, barY + 1, -12566464);
            graphics.method_25294(barX, barY + 9, barX + barWidth, barY + 10, -12566464);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }
}

