/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.util;

import java.net.URI;

public final class TunnelyResolver {
    public static final int DEFAULT_MC_PORT = 25565;

    private TunnelyResolver() {
    }

    public static boolean looksLikeHttpUrl(String input) {
        if (input == null) {
            return false;
        }
        try {
            URI uri = URI.create(input.trim());
            String scheme = uri.getScheme();
            return ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) && uri.getHost() != null && !uri.getHost().isBlank();
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean looksLikeTunnelyUrl(String input) {
        if (input == null) {
            return false;
        }
        try {
            URI uri = URI.create(input.trim());
            String scheme = uri.getScheme();
            if (scheme == null) {
                return false;
            }
            boolean isWebSocket = "ws".equalsIgnoreCase(scheme) || "wss".equalsIgnoreCase(scheme);
            boolean isHttp = "http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme);
            return (isWebSocket || isHttp) && uri.getHost() != null && !uri.getHost().isBlank();
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static Resolved resolveUrl(String input) {
        if (!TunnelyResolver.looksLikeTunnelyUrl(input)) {
            return null;
        }
        try {
            URI uri = URI.create(input.trim());
            String host = uri.getHost();
            int port = uri.getPort();
            if (port < 0) {
                String scheme = uri.getScheme();
                if ("https".equalsIgnoreCase(scheme)) {
                    scheme = "wss";
                } else if ("http".equalsIgnoreCase(scheme)) {
                    scheme = "ws";
                }
                port = "wss".equalsIgnoreCase(scheme) ? 443 : ("ws".equalsIgnoreCase(scheme) ? 80 : 25565);
            }
            if (host == null || host.isBlank()) {
                return null;
            }
            return new Resolved(host, port);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static String normalizeToHostPort(String input) {
        Resolved r = TunnelyResolver.resolveUrl(input);
        return r == null ? null : r.host + ":" + r.port;
    }

    public static boolean isEndpoint(String input) {
        return TunnelyResolver.parseEndpoint(input) != null;
    }

    public static ParsedEndpoint parseEndpoint(String input) {
        if (input == null) {
            return null;
        }
        String trimmed = input.trim();
        try {
            if (trimmed.contains("://")) {
                int lastSlash;
                String sessionId;
                String path;
                URI uri = URI.create(trimmed);
                String host = uri.getHost();
                if (host == null || host.isBlank()) {
                    return null;
                }
                int port = uri.getPort();
                String scheme = uri.getScheme();
                if (port < 0) {
                    port = "wss".equalsIgnoreCase(scheme) ? 443 : ("ws".equalsIgnoreCase(scheme) ? 80 : 25565);
                }
                if ((path = uri.getPath()) == null || path.isBlank() || "/".equals(path)) {
                    return null;
                }
                if (path.endsWith("/") && path.length() > 1) {
                    path = path.substring(0, path.length() - 1);
                }
                String string = sessionId = (lastSlash = path.lastIndexOf(47)) >= 0 ? path.substring(lastSlash + 1) : path;
                if (sessionId.isBlank()) {
                    return null;
                }
                String relayUrl = scheme + "://" + host + ":" + port;
                return new ParsedEndpoint(relayUrl, sessionId);
            }
            int slash = trimmed.indexOf(47);
            if (slash <= 0 || slash >= trimmed.length() - 1) {
                return null;
            }
            String hostPort = trimmed.substring(0, slash);
            String sessionId = trimmed.substring(slash + 1);
            if (sessionId.isBlank()) {
                return null;
            }
            int colon = hostPort.lastIndexOf(58);
            if (colon <= 0 || colon >= hostPort.length() - 1) {
                return null;
            }
            String relayUrl = "wss://" + hostPort;
            return new ParsedEndpoint(relayUrl, sessionId);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static final class Resolved {
        public final String host;
        public final int port;

        public Resolved(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }

    public static final class ParsedEndpoint {
        public final String relayUrl;
        public final String sessionId;

        public ParsedEndpoint(String relayUrl, String sessionId) {
            this.relayUrl = relayUrl;
            this.sessionId = sessionId;
        }
    }
}

