/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ImageLoader {
    private static final Map<String, class_2960> imageCache = new HashMap<String, class_2960>();
    private static final Map<String, CompletableFuture<class_2960>> loadingImages = new HashMap<String, CompletableFuture<class_2960>>();
    private static final class_2960 PLACEHOLDER = class_2960.method_60656((String)"textures/misc/unknown_pack.png");

    public static class_2960 loadImage(String imageUrl) {
        if (imageUrl == null || imageUrl.isEmpty()) {
            return PLACEHOLDER;
        }
        if (imageCache.containsKey(imageUrl)) {
            return imageCache.get(imageUrl);
        }
        if (loadingImages.containsKey(imageUrl)) {
            return PLACEHOLDER;
        }
        CompletableFuture<class_2960> future = CompletableFuture.supplyAsync(() -> {
            try {
                return ImageLoader.downloadAndRegisterImage(imageUrl);
            }
            catch (Exception e) {
                System.err.println("[ImageLoader] Failed to load image: " + imageUrl);
                e.printStackTrace();
                return PLACEHOLDER;
            }
        });
        loadingImages.put(imageUrl, future);
        future.thenAccept(resourceLocation -> {
            imageCache.put(imageUrl, (class_2960)resourceLocation);
            loadingImages.remove(imageUrl);
        });
        return PLACEHOLDER;
    }

    public static boolean isImageLoaded(String imageUrl) {
        return imageCache.containsKey(imageUrl);
    }

    public static class_2960 getImage(String imageUrl) {
        return imageCache.getOrDefault(imageUrl, PLACEHOLDER);
    }

    private static class_2960 downloadAndRegisterImage(String imageUrl) throws Exception {
        URL url = new URL(imageUrl);
        try (InputStream inputStream = url.openStream();){
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            if (bufferedImage == null) {
                System.err.println("[ImageLoader] Failed to read image from: " + imageUrl);
                class_2960 class_29602 = PLACEHOLDER;
                return class_29602;
            }
            class_1011 nativeImage = ImageLoader.convertToNativeImage(bufferedImage);
            class_1043 dynamicTexture = new class_1043(nativeImage);
            String textureName = "world_screenshot_" + Math.abs(imageUrl.hashCode());
            class_2960 resourceLocation = class_2960.method_60655((String)"tunnelyrefab", (String)textureName);
            class_310.method_1551().execute(() -> class_310.method_1551().method_1531().method_4616(resourceLocation, (class_1044)dynamicTexture));
            class_2960 class_29603 = resourceLocation;
            return class_29603;
        }
    }

    private static class_1011 convertToNativeImage(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        class_1011 nativeImage = new class_1011(width, height, false);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = bufferedImage.getRGB(x, y);
                int alpha = rgb >> 24 & 0xFF;
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                int abgr = alpha << 24 | blue << 16 | green << 8 | red;
                nativeImage.method_4305(x, y, abgr);
            }
        }
        return nativeImage;
    }

    public static void clearCache() {
        imageCache.clear();
        loadingImages.clear();
    }

    public static void removeFromCache(String imageUrl) {
        imageCache.remove(imageUrl);
        loadingImages.remove(imageUrl);
    }
}

