/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.worlds;

import java.time.Instant;
import org.texboobcat.tunnelyrefab.shaded.com.google.gson.annotations.SerializedName;

public class WorldNotification {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="user_id")
    private String userId;
    @SerializedName(value="type")
    private String type;
    @SerializedName(value="title")
    private String title;
    @SerializedName(value="message")
    private String message;
    @SerializedName(value="data")
    private Object data;
    @SerializedName(value="read")
    private boolean read;
    @SerializedName(value="created_at")
    private String createdAt;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return this.title != null ? this.title : "Notification";
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMessage() {
        return this.message != null ? this.message : "";
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public String getIcon() {
        if (this.type == null) {
            return "\u2139\ufe0f";
        }
        switch (this.type) {
            case "world_scan_failed": {
                return "\u26a0\ufe0f";
            }
            case "world_scan_passed": {
                return "\u2705";
            }
            case "world_downloaded": {
                return "\u2b07\ufe0f";
            }
            case "world_rated": {
                return "\u2b50";
            }
            case "world_commented": {
                return "\ud83d\udcac";
            }
        }
        return "\u2139\ufe0f";
    }

    public boolean isSecurityNotification() {
        return this.type != null && (this.type.equals("world_scan_failed") || this.type.equals("world_scan_passed"));
    }

    public boolean isCritical() {
        return this.type != null && this.type.equals("world_scan_failed");
    }

    public String getFormattedTime() {
        if (this.createdAt == null) {
            return "Unknown";
        }
        try {
            Instant instant = Instant.parse(this.createdAt);
            long minutesAgo = (System.currentTimeMillis() - instant.toEpochMilli()) / 60000L;
            if (minutesAgo < 1L) {
                return "Just now";
            }
            if (minutesAgo < 60L) {
                return minutesAgo + "m ago";
            }
            long hoursAgo = minutesAgo / 60L;
            if (hoursAgo < 24L) {
                return hoursAgo + "h ago";
            }
            long daysAgo = hoursAgo / 24L;
            if (daysAgo < 7L) {
                return daysAgo + "d ago";
            }
            if (daysAgo < 30L) {
                return daysAgo / 7L + "w ago";
            }
            return daysAgo / 30L + "mo ago";
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    public String getShortMessage() {
        String msg = this.getMessage();
        if (msg.length() <= 80) {
            return msg;
        }
        return msg.substring(0, 77) + "...";
    }
}

