/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.texboobcat.tunnelyrefab.tunnel.ClientTunnelManager;
import org.texboobcat.tunnelyrefab.ui.ColorUtil;
import org.texboobcat.tunnelyrefab.ui.screens.ConnectionInfoScreen;

public class DirectJoinScreen
extends class_437 {
    private final class_437 parent;
    private class_342 endpointInput;
    private String statusMessage = "";
    private int statusColor = 0xFFFFFF;
    private class_4185 connectButton;
    private class_4185 helpButton;
    private boolean showHelpTooltip = false;

    public DirectJoinScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Direct Join"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int startY = this.field_22790 / 2 - 50;
        this.endpointInput = new class_342(this.field_22793, centerX - 150, startY, 300, 20, (class_2561)class_2561.method_43470((String)"Tunnel Endpoint"));
        this.endpointInput.method_1880(200);
        this.endpointInput.method_47404((class_2561)class_2561.method_43470((String)"relay-host:port/session-id"));
        this.endpointInput.method_1852("");
        this.method_37063((class_364)this.endpointInput);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udccb Paste"), button -> {
            String clipboard = this.field_22787.field_1774.method_1460();
            this.endpointInput.method_1852(clipboard);
            this.validateEndpoint(clipboard);
        }).method_46434(centerX - 155, startY + 30, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Clear"), button -> {
            this.endpointInput.method_1852("");
            this.statusMessage = "";
        }).method_46434(centerX + 55, startY + 30, 100, 20).method_46431());
        this.connectButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udd17 Connect"), button -> this.connectToServer()).method_46434(centerX - 100, startY + 60, 200, 20).method_46431();
        this.method_37063((class_364)this.connectButton);
        this.helpButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2139\ufe0f How to use"), button -> {}).method_46434(centerX - 100, startY + 90, 200, 20).method_46431();
        this.method_37063((class_364)this.helpButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), button -> this.field_22787.method_1507(this.parent)).method_46434(centerX - 100, this.field_22790 - 30, 200, 20).method_46431());
    }

    private boolean validateEndpoint(String endpoint) {
        if (endpoint == null || endpoint.trim().isEmpty()) {
            this.statusMessage = "\u00a7cPlease enter a tunnel endpoint";
            this.statusColor = 0xFF0000;
            return false;
        }
        if (!(endpoint = endpoint.trim()).contains(":") || !endpoint.contains("/")) {
            this.statusMessage = "\u00a7cInvalid format. Expected: host:port/session-id";
            this.statusColor = 0xFF0000;
            return false;
        }
        String[] parts = endpoint.split("/", 2);
        if (parts.length != 2) {
            this.statusMessage = "\u00a7cInvalid format. Expected: host:port/session-id";
            this.statusColor = 0xFF0000;
            return false;
        }
        String hostPort = parts[0];
        String sessionId = parts[1];
        if (!hostPort.contains(":")) {
            this.statusMessage = "\u00a7cMissing port. Expected: host:port/session-id";
            this.statusColor = 0xFF0000;
            return false;
        }
        if (sessionId.trim().isEmpty()) {
            this.statusMessage = "\u00a7cMissing session ID";
            this.statusColor = 0xFF0000;
            return false;
        }
        this.statusMessage = "\u00a7aValid endpoint format \u2713";
        this.statusColor = 65280;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void connectToServer() {
        String sessionId;
        Object relayUrl;
        block5: {
            String endpoint = this.endpointInput.method_1882().trim();
            if (!this.validateEndpoint(endpoint)) {
                return;
            }
            System.out.println("[Tunnely UI] Direct joining to endpoint: " + endpoint);
            if (endpoint.contains("://")) {
                int lastSlash = endpoint.lastIndexOf(47);
                if (lastSlash > 0 && lastSlash < endpoint.length() - 1) {
                    relayUrl = endpoint.substring(0, lastSlash);
                    sessionId = endpoint.substring(lastSlash + 1);
                    break block5;
                } else {
                    this.statusMessage = "\u00a7cInvalid endpoint format";
                    this.statusColor = 0xFF0000;
                    return;
                }
            }
            String[] parts = endpoint.split("/", 2);
            if (parts.length != 2) {
                this.statusMessage = "\u00a7cInvalid endpoint format";
                this.statusColor = 0xFF0000;
                return;
            }
            String relayHostPort = parts[0];
            sessionId = parts[1];
            relayUrl = "wss://" + relayHostPort;
            System.out.println("[Tunnely UI] Legacy endpoint format detected, assuming WSS");
        }
        this.statusMessage = "\u00a7eConnecting to server...";
        this.statusColor = 0xFFFF00;
        ClientTunnelManager clientManager = ClientTunnelManager.getInstance();
        clientManager.connectToServer((String)relayUrl, sessionId, () -> this.field_22787.execute(() -> {
            this.statusMessage = "\u00a7aConnecting to Minecraft server...";
            this.statusColor = 65280;
            System.out.println("[Tunnely UI] Successfully connected through tunnel!");
        }), error -> this.field_22787.execute(() -> {
            System.err.println("[Tunnely UI] Connection error: " + error);
            String errorType = this.categorizeError((String)error);
            this.field_22787.method_1507((class_437)new ConnectionInfoScreen(this.parent, "Direct Connection", errorType, (String)error, errorType.equals("FULL") || errorType.equals("CONNECTION_FAILED") ? this::connectToServer : null));
        }));
    }

    private String categorizeError(String error) {
        if (error == null) {
            return "GENERIC";
        }
        String lowerError = error.toLowerCase();
        if (lowerError.contains("full") || lowerError.contains("capacity")) {
            return "FULL";
        }
        if (lowerError.contains("not authorized") || lowerError.contains("unauthorized")) {
            return "NOT_AUTHORIZED";
        }
        if (lowerError.contains("not found") || lowerError.contains("session not found")) {
            return "NOT_FOUND";
        }
        if (lowerError.contains("connection") || lowerError.contains("timeout") || lowerError.contains("failed to connect")) {
            return "CONNECTION_FAILED";
        }
        if (lowerError.contains("incompatible") || lowerError.contains("version")) {
            return "INCOMPATIBLE";
        }
        return "GENERIC";
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, ColorUtil.opaque(0xFFFFFF));
        graphics.method_25300(this.field_22793, "\u00a77Enter a tunnel endpoint to connect directly", this.field_22789 / 2, 35, ColorUtil.opaque(0xAAAAAA));
        graphics.method_25303(this.field_22793, "\u00a7eTunnel Endpoint:", this.field_22789 / 2 - 150, this.field_22790 / 2 - 65, 0xFFFF00);
        if (!this.statusMessage.isEmpty()) {
            graphics.method_25300(this.field_22793, this.statusMessage, this.field_22789 / 2, this.field_22790 / 2 + 20, this.statusColor);
        }
        this.showHelpTooltip = this.helpButton.method_25405((double)mouseX, (double)mouseY);
        if (this.showHelpTooltip) {
            int tooltipX = mouseX + 10;
            int tooltipY = mouseY - 10;
            int tooltipWidth = 280;
            int tooltipHeight = 80;
            if (tooltipX + tooltipWidth > this.field_22789) {
                tooltipX = this.field_22789 - tooltipWidth - 5;
            }
            if (tooltipY + tooltipHeight > this.field_22790) {
                tooltipY = this.field_22790 - tooltipHeight - 5;
            }
            if (tooltipY < 5) {
                tooltipY = 5;
            }
            graphics.method_25294(tooltipX - 5, tooltipY - 5, tooltipX + tooltipWidth, tooltipY + tooltipHeight, -267386864);
            graphics.method_25294(tooltipX - 6, tooltipY - 6, tooltipX + tooltipWidth + 1, tooltipY - 5, -11513776);
            graphics.method_25294(tooltipX - 6, tooltipY + tooltipHeight, tooltipX + tooltipWidth + 1, tooltipY + tooltipHeight + 1, -11513776);
            graphics.method_25294(tooltipX - 6, tooltipY - 5, tooltipX - 5, tooltipY + tooltipHeight, -11513776);
            graphics.method_25294(tooltipX + tooltipWidth, tooltipY - 5, tooltipX + tooltipWidth + 1, tooltipY + tooltipHeight, -11513776);
            int textY = tooltipY;
            graphics.method_25303(this.field_22793, "\u00a76How to use Direct Join:", tooltipX, textY, ColorUtil.opaque(0xFFFFFF));
            graphics.method_25303(this.field_22793, "\u00a771. Get endpoint from a friend", tooltipX, textY += 14, ColorUtil.opaque(0xAAAAAA));
            graphics.method_25303(this.field_22793, "\u00a772. Paste it in the box above", tooltipX, textY += 12, ColorUtil.opaque(0xAAAAAA));
            graphics.method_25303(this.field_22793, "\u00a773. Click Connect", tooltipX, textY += 12, ColorUtil.opaque(0xAAAAAA));
            graphics.method_25303(this.field_22793, "\u00a774. Add server in multiplayer menu", tooltipX, textY += 12, ColorUtil.opaque(0xAAAAAA));
            graphics.method_25303(this.field_22793, "\u00a78Example: relay.example.com:8080/abc-123", tooltipX, textY += 16, ColorUtil.opaque(0x888888));
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public void method_25393() {
        super.method_25393();
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        String text = this.endpointInput.method_1882();
        super.method_25410(minecraft, width, height);
        this.endpointInput.method_1852(text);
    }

    public boolean method_25421() {
        return false;
    }
}

