/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.tunnel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.texboobcat.tunnelyrefab.tunnel.TunnelClient;

public class HostProxyServer {
    private final String localhost = "127.0.0.1";
    private final int serverPort;
    private final TunnelClient tunnelClient;
    private final ConcurrentHashMap<Long, ClientConnection> activeConnections = new ConcurrentHashMap();
    private final AtomicLong connectionIdCounter = new AtomicLong(0L);
    private volatile boolean running = true;

    public HostProxyServer(int serverPort, TunnelClient tunnelClient) {
        this.serverPort = serverPort;
        this.tunnelClient = tunnelClient;
    }

    public void handleRelayPacket(byte[] data) {
        if (!this.running || data == null || data.length == 0) {
            return;
        }
        ClientConnection connection = this.getOrCreateConnection();
        if (connection != null && connection.isConnected()) {
            try {
                connection.sendToMinecraft(data);
            }
            catch (IOException e) {
                System.err.println("[Tunnely Host] Error sending to Minecraft server: " + e.getMessage());
                this.activeConnections.remove(connection.getId());
                connection.close();
            }
        }
    }

    private ClientConnection getOrCreateConnection() {
        ClientConnection existing = this.activeConnections.get(0L);
        if (existing != null && !existing.isConnected()) {
            System.out.println("[Tunnely Host] Removing dead connection, will recreate");
            this.activeConnections.remove(0L);
            existing.close();
            existing = null;
        }
        if (existing == null) {
            try {
                System.out.println("[Tunnely Host] Creating connection to local Minecraft server on port " + this.serverPort);
                ClientConnection conn = new ClientConnection(0L, "127.0.0.1", this.serverPort);
                conn.start();
                this.activeConnections.put(0L, conn);
                return conn;
            }
            catch (IOException e) {
                System.err.println("[Tunnely Host] Failed to connect to local Minecraft server: " + e.getMessage());
                return null;
            }
        }
        return existing;
    }

    public void forceReconnect() {
        System.out.println("[Tunnely Host] Forcing Minecraft connection refresh...");
        ClientConnection current = this.activeConnections.get(0L);
        if (current != null) {
            current.close();
            this.activeConnections.remove(0L);
            System.out.println("[Tunnely Host] Connection closed, will reconnect on next packet");
        }
    }

    public void shutdown() {
        this.running = false;
        for (ClientConnection connection : this.activeConnections.values()) {
            connection.close();
        }
        this.activeConnections.clear();
        System.out.println("[Tunnely Host] Proxy server shutdown complete");
    }

    private class ClientConnection {
        private final long id;
        private final Socket minecraftSocket;
        private final OutputStream toMinecraft;
        private final InputStream fromMinecraft;
        private final Thread readerThread;
        private volatile boolean connected = true;

        public ClientConnection(long id, String host, int port) throws IOException {
            this.id = id;
            this.minecraftSocket = new Socket(host, port);
            this.toMinecraft = this.minecraftSocket.getOutputStream();
            this.fromMinecraft = this.minecraftSocket.getInputStream();
            this.readerThread = new Thread(this::readFromMinecraft, "Tunnely-HostProxy-Reader-" + id);
            System.out.println("[Tunnely Host] Connected to local Minecraft server: " + host + ":" + port);
        }

        public void start() {
            this.readerThread.start();
        }

        public long getId() {
            return this.id;
        }

        public boolean isConnected() {
            return this.connected && !this.minecraftSocket.isClosed();
        }

        public void sendToMinecraft(byte[] data) throws IOException {
            if (!this.isConnected()) {
                throw new IOException("Connection closed");
            }
            this.toMinecraft.write(data);
            this.toMinecraft.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readFromMinecraft() {
            byte[] buffer = new byte[8192];
            try {
                int bytesRead;
                while (this.connected && HostProxyServer.this.running && (bytesRead = this.fromMinecraft.read(buffer)) != -1) {
                    byte[] packet = new byte[bytesRead];
                    System.arraycopy(buffer, 0, packet, 0, bytesRead);
                    if (HostProxyServer.this.tunnelClient == null || !HostProxyServer.this.tunnelClient.isConnected()) continue;
                    HostProxyServer.this.tunnelClient.sendPacket(packet);
                }
                System.out.println("[Tunnely Host] Minecraft connection closed, will auto-reconnect on next packet");
                this.connected = false;
            }
            catch (IOException e) {
                if (this.connected && HostProxyServer.this.running) {
                    System.err.println("[Tunnely Host] Error reading from Minecraft: " + e.getMessage());
                }
                this.connected = false;
            }
            finally {
                System.out.println("[Tunnely Host] Reader thread exiting, connection will be recreated as needed");
            }
        }

        public void close() {
            this.connected = false;
            try {
                if (this.minecraftSocket != null && !this.minecraftSocket.isClosed()) {
                    this.minecraftSocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.readerThread != null && this.readerThread.isAlive()) {
                this.readerThread.interrupt();
            }
        }
    }
}

