/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.auth.SupabaseClient;
import org.texboobcat.tunnelyrefab.tunnel.ClientTunnelManager;
import org.texboobcat.tunnelyrefab.ui.ColorUtil;
import org.texboobcat.tunnelyrefab.ui.screens.ConnectionInfoScreen;
import org.texboobcat.tunnelyrefab.ui.screens.WarningPopupScreen;
import org.texboobcat.tunnelyrefab.util.CompatibilityDetector;
import org.texboobcat.tunnelyrefab.util.SafeDisconnect;

public class PublicLobbiesScreen
extends Screen {
    private final Screen parent;
    private ServerListWidget serverList;
    private String statusMessage = "\u00a7eLoading public servers...";
    private int statusColor = 0xFFFF00;
    private Checkbox compatibleOnlyCheckbox;
    private CompatibilityDetector.CompatibilityInfo clientCompatibility;
    private String regionFilter = "ALL";
    private Button regionButton;
    private Button refreshButton;
    private Button backButton;
    private Set<String> availableRegions = new HashSet<String>();
    private volatile boolean isLoading = false;
    private List<JsonObject> cachedServers = new ArrayList<JsonObject>();
    private int totalServersCount = 0;
    private int compatibleServersCount = 0;
    private int totalPlayersOnline = 0;
    private final List<ServerRow> rows = new ArrayList<ServerRow>();
    private int scrollOffset = 0;
    private final int ITEM_HEIGHT = 62;
    private boolean draggingScrollbar = false;
    private int dragThumbOffsetY = 0;
    private static boolean warningShownThisSession = false;

    public PublicLobbiesScreen(Screen parent) {
        this(parent, false);
    }

    public PublicLobbiesScreen(Screen parent, boolean skipWarning) {
        super((Component)Component.literal((String)"Public Lobbies"));
        this.parent = parent;
        this.clientCompatibility = CompatibilityDetector.detect();
        if (skipWarning) {
            warningShownThisSession = true;
        }
        System.out.println("[Tunnely] Client compatibility: " + this.clientCompatibility.toString());
    }

    private void cycleRegionFilter() {
        ArrayList<String> regions = new ArrayList<String>();
        regions.add("ALL");
        ArrayList<String> sortedRegions = new ArrayList<String>(this.availableRegions);
        Collections.sort(sortedRegions);
        regions.addAll(sortedRegions);
        int currentIndex = regions.indexOf(this.regionFilter);
        if (currentIndex == -1) {
            this.regionFilter = "ALL";
        } else {
            int nextIndex = (currentIndex + 1) % regions.size();
            this.regionFilter = (String)regions.get(nextIndex);
        }
    }

    private String regionButtonLabel() {
        if (this.availableRegions.isEmpty()) {
            return "Region: ALL";
        }
        return "Region: " + this.regionFilter;
    }

    protected void init() {
        super.init();
        if (!warningShownThisSession && (this.clientCompatibility.modpackId == null || this.clientCompatibility.modpackId.isEmpty())) {
            System.out.println("[Tunnely] No modpack detected - showing compatibility warning popup");
            warningShownThisSession = true;
            this.minecraft.setScreen((Screen)new WarningPopupScreen(new PublicLobbiesScreen(this.parent, true), this.parent, "Warning: No Modpack Detected", "\u00a77You don't have a modpack file detected.\n\n\u00a77This means you're \u00a7chighly likely to be incompatible\u00a77\n\u00a77with most public servers.\n\n\u00a77Most public servers use modpacks from:\n\u00a78\u2022 \u00a77CurseForge\n\u00a78\u2022 \u00a77Modrinth\n\u00a78\u2022 \u00a77Custom modpacks\n\n\u00a77You can still browse, but check compatibility carefully!", 0xFFAA00, null));
            return;
        }
        int buttonWidth = 100;
        int buttonSpacing = 8;
        int totalButtonsWidth = buttonWidth * 3 + buttonSpacing * 2 + 140;
        int startX = (this.width - totalButtonsWidth) / 2;
        int buttonY = this.height - 40;
        this.compatibleOnlyCheckbox = Checkbox.builder((Component)Component.literal((String)"Compatible Only"), (Font)this.font).pos(startX, buttonY).selected(false).onValueChange((cb, selected) -> {
            if (this.serverList != null) {
                this.serverList.setSelected(null);
            }
            if (!this.isLoading && !this.cachedServers.isEmpty()) {
                this.applyFiltersAndRender();
            } else {
                this.loadPublicServers();
            }
        }).build();
        this.addRenderableWidget((GuiEventListener)this.compatibleOnlyCheckbox);
        this.regionButton = Button.builder((Component)Component.literal((String)this.regionButtonLabel()), button -> {
            this.cycleRegionFilter();
            button.setMessage((Component)Component.literal((String)this.regionButtonLabel()));
            if (!this.isLoading && !this.cachedServers.isEmpty()) {
                this.applyFiltersAndRender();
            } else {
                this.loadPublicServers();
            }
        }).bounds(startX + 140 + buttonSpacing, buttonY, buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.regionButton);
        this.refreshButton = Button.builder((Component)Component.literal((String)"\u27f3 Refresh"), button -> this.loadPublicServers()).bounds(startX + 140 + buttonSpacing + buttonWidth + buttonSpacing, buttonY, buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.refreshButton);
        this.backButton = Button.builder((Component)Component.literal((String)"Back"), button -> this.minecraft.setScreen(this.parent)).bounds(startX + 140 + buttonSpacing + (buttonWidth + buttonSpacing) * 2, buttonY, buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.backButton);
        this.loadPublicServers();
    }

    private void loadPublicServers() {
        if (this.isLoading) {
            System.out.println("[Tunnely UI] Load already in progress; skipping new request");
            return;
        }
        this.isLoading = true;
        System.out.println("[Tunnely UI] ===== LOADING PUBLIC SERVERS =====");
        this.statusMessage = "\u00a7eLoading public servers...";
        this.statusColor = 0xFFFF00;
        this.rows.clear();
        this.availableRegions.clear();
        this.cachedServers.clear();
        this.totalServersCount = 0;
        this.compatibleServersCount = 0;
        this.totalPlayersOnline = 0;
        if (this.compatibleOnlyCheckbox != null) {
            this.compatibleOnlyCheckbox.active = false;
        }
        if (this.regionButton != null) {
            this.regionButton.active = false;
        }
        if (this.refreshButton != null) {
            this.refreshButton.active = false;
        }
        if (this.backButton != null) {
            this.backButton.active = false;
        }
        new Thread(() -> {
            try {
                SupabaseClient client = new SupabaseClient();
                SupabaseClient.ServerListResult result = client.getPublicServers();
                this.minecraft.execute(() -> {
                    if (result.success) {
                        try {
                            System.out.println("[Tunnely UI] Parsing public server data...");
                            JsonArray servers = JsonParser.parseString((String)result.data).getAsJsonArray();
                            System.out.println("[Tunnely UI] Found " + servers.size() + " public server(s)");
                            this.cachedServers.clear();
                            for (JsonElement element : servers) {
                                this.cachedServers.add(element.getAsJsonObject());
                            }
                            this.applyFiltersAndRender();
                            if (this.regionButton != null) {
                                this.regionButton.setMessage((Component)Component.literal((String)this.regionButtonLabel()));
                            }
                            if (this.compatibleOnlyCheckbox != null) {
                                this.compatibleOnlyCheckbox.active = true;
                            }
                            if (this.regionButton != null) {
                                this.regionButton.active = true;
                            }
                            if (this.refreshButton != null) {
                                this.refreshButton.active = true;
                            }
                            if (this.backButton != null) {
                                this.backButton.active = true;
                            }
                            this.isLoading = false;
                        }
                        catch (Exception e) {
                            this.statusMessage = "\u00a7cFailed to parse server list";
                            this.statusColor = 0xFF0000;
                            System.err.println("[Tunnely UI] \u2717 Exception parsing public servers: " + e.getMessage());
                            e.printStackTrace();
                            if (this.compatibleOnlyCheckbox != null) {
                                this.compatibleOnlyCheckbox.active = true;
                            }
                            if (this.regionButton != null) {
                                this.regionButton.active = true;
                            }
                            if (this.refreshButton != null) {
                                this.refreshButton.active = true;
                            }
                            if (this.backButton != null) {
                                this.backButton.active = true;
                            }
                            this.isLoading = false;
                        }
                    } else {
                        this.statusMessage = "\u00a7c" + result.error;
                        this.statusColor = 0xFF0000;
                        System.err.println("[Tunnely UI] \u2717 Failed to load public servers: " + result.error);
                        if (this.compatibleOnlyCheckbox != null) {
                            this.compatibleOnlyCheckbox.active = true;
                        }
                        if (this.regionButton != null) {
                            this.regionButton.active = true;
                        }
                        if (this.refreshButton != null) {
                            this.refreshButton.active = true;
                        }
                        if (this.backButton != null) {
                            this.backButton.active = true;
                        }
                        this.isLoading = false;
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[Tunnely UI] \u2717 Exception loading public servers: " + e.getMessage());
                e.printStackTrace();
                this.minecraft.execute(() -> {
                    this.statusMessage = "\u00a7cError: " + e.getMessage();
                    this.statusColor = 0xFF0000;
                    if (this.compatibleOnlyCheckbox != null) {
                        this.compatibleOnlyCheckbox.active = true;
                    }
                    if (this.regionButton != null) {
                        this.regionButton.active = true;
                    }
                    if (this.refreshButton != null) {
                        this.refreshButton.active = true;
                    }
                    if (this.backButton != null) {
                        this.backButton.active = true;
                    }
                    this.isLoading = false;
                });
            }
        }, "Tunnely-LoadPublic").start();
    }

    private void applyFiltersAndRender() {
        try {
            this.rows.clear();
            this.availableRegions.clear();
            boolean filterCompatible = this.compatibleOnlyCheckbox != null && this.compatibleOnlyCheckbox.selected();
            String region = this.regionFilter;
            int displayedCount = 0;
            this.totalServersCount = 0;
            this.compatibleServersCount = 0;
            this.totalPlayersOnline = 0;
            if (this.cachedServers.isEmpty()) {
                this.statusMessage = "\u00a77No public servers available";
                this.statusColor = 0xAAAAAA;
            } else {
                for (JsonObject server : this.cachedServers) {
                    String relayRegion;
                    String serverId = server.get("id").getAsString();
                    String serverName = server.has("server_name") && !server.get("server_name").isJsonNull() ? server.get("server_name").getAsString() : "Unnamed Server";
                    String endpoint = server.has("public_endpoint") && !server.get("public_endpoint").isJsonNull() ? server.get("public_endpoint").getAsString() : "N/A";
                    String gameMode = server.has("game_mode") && !server.get("game_mode").isJsonNull() ? server.get("game_mode").getAsString() : "survival";
                    String string = relayRegion = server.has("relay_region") && !server.get("relay_region").isJsonNull() ? server.get("relay_region").getAsString() : "Unknown";
                    if (relayRegion != null && !relayRegion.equals("Unknown")) {
                        this.availableRegions.add(relayRegion);
                    }
                    String minecraftVersion = server.has("minecraft_version") && !server.get("minecraft_version").isJsonNull() ? server.get("minecraft_version").getAsString() : null;
                    String modLoader = server.has("mod_loader") && !server.get("mod_loader").isJsonNull() ? server.get("mod_loader").getAsString() : null;
                    String modpackId = server.has("modpack_id") && !server.get("modpack_id").isJsonNull() ? server.get("modpack_id").getAsString() : null;
                    String modpackVersion = server.has("modpack_version") && !server.get("modpack_version").isJsonNull() ? server.get("modpack_version").getAsString() : null;
                    int currentPlayers = server.has("current_players") && !server.get("current_players").isJsonNull() ? server.get("current_players").getAsInt() : 0;
                    int maxPlayers = server.has("max_players") && !server.get("max_players").isJsonNull() ? server.get("max_players").getAsInt() : 20;
                    this.totalPlayersOnline += currentPlayers;
                    CompatibilityDetector.CompatibilityInfo serverCompat = new CompatibilityDetector.CompatibilityInfo(minecraftVersion, modLoader, modpackId, modpackVersion);
                    boolean isCompatible = this.clientCompatibility.isCompatibleWith(serverCompat);
                    ++this.totalServersCount;
                    if (isCompatible) {
                        ++this.compatibleServersCount;
                    }
                    if (filterCompatible && !isCompatible || !"ALL".equalsIgnoreCase(region) && (relayRegion == null || !relayRegion.equalsIgnoreCase(region))) continue;
                    ++displayedCount;
                    String hostName = "Unknown";
                    if (server.has("host") && !server.get("host").isJsonNull()) {
                        JsonObject hostProfile = server.getAsJsonObject("host");
                        if (hostProfile.has("minecraft_name") && !hostProfile.get("minecraft_name").isJsonNull()) {
                            hostName = hostProfile.get("minecraft_name").getAsString();
                        }
                    } else if (server.has("host_name") && !server.get("host_name").isJsonNull()) {
                        hostName = server.get("host_name").getAsString();
                    }
                    this.rows.add(new ServerRow(serverId, serverName, hostName, endpoint, gameMode, relayRegion, serverCompat, isCompatible, currentPlayers, maxPlayers));
                }
                if (displayedCount == 0 && filterCompatible) {
                    this.statusMessage = "\u00a77No compatible servers found";
                    this.statusColor = 0xAAAAAA;
                } else if (displayedCount == 0) {
                    this.statusMessage = "\u00a77No servers match filters";
                    this.statusColor = 0xAAAAAA;
                } else {
                    this.statusMessage = "\u00a7aShowing " + displayedCount + " of " + this.totalServersCount + " server(s)";
                    this.statusColor = 65280;
                }
            }
            if (this.regionButton != null) {
                this.regionButton.setMessage((Component)Component.literal((String)this.regionButtonLabel()));
            }
        }
        catch (Exception e) {
            System.err.println("[Tunnely UI] Error while applying filters: " + e.getMessage());
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.fill(0, 0, this.width, 68, -1728053248);
        int contentTop = 70;
        int contentBottom = this.height - 60;
        int viewHeight = contentBottom - contentTop;
        int rowWidth = Math.min(600, this.width - 40);
        int rowLeft = (this.width - rowWidth) / 2;
        graphics.enableScissor(0, contentTop, this.width, contentBottom);
        int y = contentTop - this.scrollOffset;
        for (ServerRow r : this.rows) {
            if (y > contentTop - 62 && y < contentBottom) {
                String gm;
                int gmW;
                int tw;
                Object t;
                float ratio;
                graphics.fill(rowLeft + 2, y + 2, rowLeft + rowWidth - 2, y + 62 - 2, 0x22000000);
                String compatIcon = r.isCompatible ? "\u00a7a\u2713" : "\u00a7c\u2717";
                graphics.drawString(this.font, compatIcon, rowLeft + 8, y + 8, ColorUtil.opaque(0xFFFFFF));
                String displayName = r.serverName.length() > 30 ? r.serverName.substring(0, 27) + "..." : r.serverName;
                graphics.drawString(this.font, "\u00a7f\u00a7l" + displayName, rowLeft + 28, y + 8, ColorUtil.opaque(0xFFFFFF));
                String hostInfo = "\u00a77Host: \u00a7f" + (String)(r.hostName.length() > 15 ? r.hostName.substring(0, 12) + "..." : r.hostName);
                graphics.drawString(this.font, hostInfo, rowLeft + 28, y + 20, ColorUtil.opaque(0xAAAAAA));
                Object playerText = "\u00a77Players: ";
                float f = ratio = r.maxPlayers > 0 ? (float)r.currentPlayers / (float)r.maxPlayers : 0.0f;
                String pColor = ratio >= 0.9f ? "\u00a7c" : (ratio >= 0.7f ? "\u00a7e" : "\u00a7a");
                playerText = (String)playerText + pColor + r.currentPlayers + "\u00a77/\u00a7f" + r.maxPlayers;
                int hostWidth = this.font.width(hostInfo);
                graphics.drawString(this.font, (String)playerText, rowLeft + 28 + hostWidth + 15, y + 20, ColorUtil.opaque(0xAAAAAA));
                int badgeX = rowLeft + 28;
                int badgeY = y + 32;
                int maxBadgeX = rowLeft + rowWidth - 70 - 20;
                int lineStartX = rowLeft + 28;
                if (r.compatibility.minecraftVersion != null) {
                    t = "\u00a7e" + r.compatibility.minecraftVersion;
                    tw = this.font.width((String)t);
                    if (badgeX + tw > maxBadgeX) {
                        badgeY += 10;
                        badgeX = lineStartX;
                    }
                    graphics.drawString(this.font, (String)t, badgeX, badgeY, ColorUtil.opaque(0xFFFFFF));
                    badgeX += tw + 8;
                }
                if (r.compatibility.modLoader != null) {
                    String lc = r.compatibility.modLoader.equals("fabric") ? "\u00a7b" : (r.compatibility.modLoader.equals("forge") ? "\u00a7c" : "\u00a7d");
                    String t2 = lc + r.compatibility.modLoader.toUpperCase();
                    int tw2 = this.font.width(t2);
                    if (badgeX + tw2 > maxBadgeX) {
                        badgeY += 10;
                        badgeX = lineStartX;
                    }
                    graphics.drawString(this.font, t2, badgeX, badgeY, ColorUtil.opaque(0xFFFFFF));
                    badgeX += tw2 + 8;
                } else {
                    t = "\u00a77VANILLA";
                    tw = this.font.width((String)t);
                    if (badgeX + tw > maxBadgeX) {
                        badgeY += 10;
                        badgeX = lineStartX;
                    }
                    graphics.drawString(this.font, (String)t, badgeX, badgeY, ColorUtil.opaque(0xFFFFFF));
                    badgeX += tw + 8;
                }
                if (r.relayRegion != null) {
                    t = "\u00a76" + r.relayRegion.toUpperCase();
                    int tw3 = this.font.width((String)t);
                    if (badgeX + tw3 > maxBadgeX) {
                        badgeY += 10;
                        badgeX = lineStartX;
                    }
                    graphics.drawString(this.font, (String)t, badgeX, badgeY, ColorUtil.opaque(0xFFFFFF));
                    badgeX += tw3 + 8;
                }
                if (badgeX + (gmW = this.font.width(gm = "\u00a79" + r.gameMode.substring(0, 1).toUpperCase() + r.gameMode.substring(1))) > maxBadgeX) {
                    badgeY += 10;
                    badgeX = lineStartX;
                }
                graphics.drawString(this.font, gm, badgeX, badgeY, ColorUtil.opaque(0xFFFFFF));
                if (r.compatibility.modpackId != null) {
                    String t3 = "\u00a7d\ud83d\udce6 " + (String)(r.compatibility.modpackId.length() > 20 ? r.compatibility.modpackId.substring(0, 17) + "..." : r.compatibility.modpackId);
                    if (r.compatibility.modpackVersion != null) {
                        t3 = t3 + " \u00a77v" + r.compatibility.modpackVersion;
                    }
                    graphics.drawString(this.font, t3, rowLeft + 28, y + 44, ColorUtil.opaque(0xFFFFFF));
                }
                int joinX = rowLeft + rowWidth - 65;
                int joinY = y + 31 - 10;
                graphics.fill(joinX, joinY, joinX + 60, joinY + 20, -8355712);
                graphics.fill(joinX - 1, joinY - 1, joinX + 61, joinY, -12566464);
                graphics.fill(joinX - 1, joinY + 20, joinX + 61, joinY + 21, -12566464);
                graphics.fill(joinX - 1, joinY, joinX, joinY + 20, -12566464);
                graphics.fill(joinX + 60, joinY, joinX + 61, joinY + 20, -12566464);
                graphics.drawCenteredString(this.font, "Join", joinX + 30, joinY + 6, -1);
            }
            y += 62;
        }
        graphics.disableScissor();
        int totalHeight = this.rows.size() * 62;
        int maxScroll = Math.max(0, totalHeight - viewHeight);
        if (maxScroll > 0) {
            int trackX = rowLeft + rowWidth + 8;
            int trackTop = contentTop;
            int trackBottom = contentBottom;
            int trackHeight = trackBottom - trackTop;
            int thumbHeight = Math.max(20, trackHeight * trackHeight / totalHeight);
            int thumbMaxTravel = trackHeight - thumbHeight;
            int thumbY = trackTop + this.scrollOffset * thumbMaxTravel / maxScroll;
            graphics.fill(trackX, trackTop, trackX + 6, trackBottom, 0x40000000);
            graphics.fill(trackX, thumbY, trackX + 6, thumbY + thumbHeight, -2130706433);
        }
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, "\u00a76\u00a7lPublic Lobbies", this.width / 2, 12, ColorUtil.opaque(0xFFFFFF));
        graphics.drawCenteredString(this.font, this.statusMessage, this.width / 2, 28, ColorUtil.opaque(this.statusColor));
        if (!this.isLoading && this.totalServersCount > 0) {
            String statsLeft = "\u00a77Players Online: \u00a7f" + this.totalPlayersOnline;
            String statsRight = "\u00a77Compatible: \u00a7a" + this.compatibleServersCount + "\u00a77/\u00a7f" + this.totalServersCount;
            graphics.drawString(this.font, statsLeft, 10, 48, ColorUtil.opaque(0xAAAAAA));
            graphics.drawString(this.font, statsRight, this.width - this.font.width(statsRight) - 10, 48, ColorUtil.opaque(0xAAAAAA));
        }
        graphics.fill(0, this.height - 55, this.width, this.height, -1728053248);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int contentTop = 70;
        int contentBottom = this.height - 60;
        int viewHeight = contentBottom - contentTop;
        int totalHeight = this.rows.size() * 62;
        int maxScroll = Math.max(0, totalHeight - viewHeight);
        this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset - (int)(scrollY * 10.0)));
        return true;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean dragging) {
        int viewHeight;
        if (event.button() != 0) {
            return super.mouseClicked(event, dragging);
        }
        int mx = (int)event.x();
        int my = (int)event.y();
        int contentTop = 70;
        int contentBottom = this.height - 60;
        if (my < contentTop || my > contentBottom) {
            return super.mouseClicked(event, dragging);
        }
        int rowWidth = Math.min(600, this.width - 40);
        int rowLeft = (this.width - rowWidth) / 2;
        int trackX = rowLeft + rowWidth + 8;
        int trackTop = contentTop;
        int trackBottom = contentBottom;
        int trackHeight = trackBottom - trackTop;
        int totalHeight = this.rows.size() * 62;
        int maxScroll = Math.max(0, totalHeight - (viewHeight = trackHeight));
        if (maxScroll > 0 && mx >= trackX && mx <= trackX + 6 && my >= trackTop && my <= trackBottom) {
            int thumbHeight = Math.max(20, trackHeight * trackHeight / totalHeight);
            int thumbMaxTravel = trackHeight - thumbHeight;
            int thumbY = trackTop + this.scrollOffset * thumbMaxTravel / maxScroll;
            this.draggingScrollbar = true;
            this.dragThumbOffsetY = my - thumbY;
            return true;
        }
        int y = contentTop - this.scrollOffset;
        for (ServerRow r : this.rows) {
            if (my >= y && my < y + 62) {
                int joinX = rowLeft + rowWidth - 65;
                int joinY = y + 31 - 10;
                if (mx < joinX || mx > joinX + 60 || my < joinY || my > joinY + 20) break;
                this.joinServer(r);
                return true;
            }
            y += 62;
        }
        return super.mouseClicked(event, dragging);
    }

    public boolean mouseDragged(MouseButtonEvent event, double dx, double dy) {
        if (this.draggingScrollbar) {
            int viewHeight;
            int contentTop = 70;
            int contentBottom = this.height - 60;
            int trackHeight = contentBottom - contentTop;
            int totalHeight = this.rows.size() * 62;
            int maxScroll = Math.max(0, totalHeight - (viewHeight = trackHeight));
            if (maxScroll > 0) {
                int thumbHeight = Math.max(20, trackHeight * trackHeight / totalHeight);
                int thumbMaxTravel = trackHeight - thumbHeight;
                int mouseY = (int)event.y();
                int newThumbY = Math.max(contentTop, Math.min(contentBottom - thumbHeight, mouseY - this.dragThumbOffsetY));
                int travel = newThumbY - contentTop;
                this.scrollOffset = Math.max(0, Math.min(maxScroll, (int)((long)travel * (long)maxScroll / (long)Math.max(1, thumbMaxTravel))));
            }
            return true;
        }
        return super.mouseDragged(event, dx, dy);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        if (this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.mouseReleased(event);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void joinServer(ServerRow row) {
        String sessionId;
        Object relayUrl;
        block5: {
            if (row.endpoint == null || row.endpoint.equals("N/A")) {
                this.minecraft.setScreen((Screen)new ConnectionInfoScreen(this, row.serverName, "NOT_FOUND", "Server endpoint not available"));
                return;
            }
            if (row.endpoint.contains("://")) {
                int lastSlash = row.endpoint.lastIndexOf(47);
                if (lastSlash > 0 && lastSlash < row.endpoint.length() - 1) {
                    relayUrl = row.endpoint.substring(0, lastSlash);
                    sessionId = row.endpoint.substring(lastSlash + 1);
                    break block5;
                } else {
                    this.minecraft.setScreen((Screen)new ConnectionInfoScreen(this, row.serverName, "GENERIC", "Invalid endpoint format: " + row.endpoint));
                    return;
                }
            }
            if (!row.endpoint.contains("/")) {
                this.minecraft.setScreen((Screen)new ConnectionInfoScreen(this, row.serverName, "GENERIC", "Invalid endpoint format: " + row.endpoint));
                return;
            }
            String[] parts = row.endpoint.split("/", 2);
            String relayHostPort = parts[0];
            sessionId = parts[1];
            relayUrl = "wss://" + relayHostPort;
        }
        SafeDisconnect.disconnectAndThen(() -> this.lambda$joinServer$11((String)relayUrl, sessionId, row));
    }

    private String categorizeError(String error) {
        if (error == null) {
            return "GENERIC";
        }
        String lowerError = error.toLowerCase();
        if (lowerError.contains("full") || lowerError.contains("capacity")) {
            return "FULL";
        }
        if (lowerError.contains("not authorized") || lowerError.contains("unauthorized")) {
            return "NOT_AUTHORIZED";
        }
        if (lowerError.contains("not found") || lowerError.contains("session not found")) {
            return "NOT_FOUND";
        }
        if (lowerError.contains("connection") || lowerError.contains("timeout") || lowerError.contains("failed to connect")) {
            return "CONNECTION_FAILED";
        }
        if (lowerError.contains("incompatible") || lowerError.contains("version")) {
            return "INCOMPATIBLE";
        }
        return "GENERIC";
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private /* synthetic */ void lambda$joinServer$11(String relayUrl, String sessionId, ServerRow row) {
        ClientTunnelManager manager = ClientTunnelManager.getInstance();
        manager.connectToServer(relayUrl, sessionId, () -> System.out.println("[Tunnely UI] \u2713 Connection successful"), error -> this.minecraft.execute(() -> {
            String errorType = this.categorizeError((String)error);
            this.minecraft.setScreen((Screen)new ConnectionInfoScreen(this, row.serverName, errorType, (String)error, errorType.equals("FULL") || errorType.equals("CONNECTION_FAILED") ? () -> this.joinServer(row) : null));
        }));
    }

    private static class ServerRow {
        final String id;
        final String serverName;
        final String hostName;
        final String endpoint;
        final String gameMode;
        final String relayRegion;
        final CompatibilityDetector.CompatibilityInfo compatibility;
        final boolean isCompatible;
        final int currentPlayers;
        final int maxPlayers;

        ServerRow(String id, String serverName, String hostName, String endpoint, String gameMode, String relayRegion, CompatibilityDetector.CompatibilityInfo compatibility, boolean isCompatible, int currentPlayers, int maxPlayers) {
            this.id = id;
            this.serverName = serverName;
            this.hostName = hostName;
            this.endpoint = endpoint;
            this.gameMode = gameMode;
            this.relayRegion = relayRegion;
            this.compatibility = compatibility;
            this.isCompatible = isCompatible;
            this.currentPlayers = currentPlayers;
            this.maxPlayers = maxPlayers;
        }
    }

    private class ServerListWidget
    extends ObjectSelectionList<ServerEntry> {
        public ServerListWidget(Minecraft minecraft, int width, int height, int top, int bottom, int itemHeight) {
            super(minecraft, width, height, top, bottom);
        }

        public int getRowWidth() {
            return Math.min(600, this.width - 40);
        }

        public int getRowLeft() {
            return (this.width - this.getRowWidth()) / 2;
        }

        protected int getScrollbarPosition() {
            return this.getRowLeft() + this.getRowWidth() + 8;
        }

        public void clear() {
            this.clearEntries();
            this.setSelected(null);
        }

        public void addServer(String id, String serverName, String hostName, String endpoint, String gameMode, String relayRegion, CompatibilityDetector.CompatibilityInfo compatibility, boolean isCompatible, int currentPlayers, int maxPlayers) {
            this.addEntry((AbstractSelectionList.Entry)new ServerEntry(id, serverName, hostName, endpoint, gameMode, relayRegion, compatibility, isCompatible, currentPlayers, maxPlayers));
        }

        class ServerEntry
        extends ObjectSelectionList.Entry<ServerEntry> {
            private static final int ROW_HEIGHT = 62;
            private final String id;
            private final String serverName;
            private final String hostName;
            private final String endpoint;
            private final String gameMode;
            private final String relayRegion;
            private final CompatibilityDetector.CompatibilityInfo compatibility;
            private final boolean isCompatible;
            private final int currentPlayers;
            private final int maxPlayers;
            private int joinX;
            private int joinY;
            private int joinW = 60;
            private int joinH = 20;

            public ServerEntry(String id, String serverName, String hostName, String endpoint, String gameMode, String relayRegion, CompatibilityDetector.CompatibilityInfo compatibility, boolean isCompatible, int currentPlayers, int maxPlayers) {
                this.id = id;
                this.serverName = serverName;
                this.hostName = hostName;
                this.endpoint = endpoint;
                this.gameMode = gameMode;
                this.relayRegion = relayRegion;
                this.compatibility = compatibility;
                this.isCompatible = isCompatible;
                this.currentPlayers = currentPlayers;
                this.maxPlayers = maxPlayers;
            }

            /*
             * Enabled aggressive block sorting
             */
            private void joinServer() {
                String sessionId;
                Object relayUrl;
                block6: {
                    System.out.println("[Tunnely UI] Joining server: " + this.id + " (" + this.serverName + ")");
                    if (this.endpoint == null || this.endpoint.equals("N/A")) {
                        System.err.println("[Tunnely UI] Cannot join - no endpoint available");
                        PublicLobbiesScreen.this.minecraft.setScreen((Screen)new ConnectionInfoScreen(PublicLobbiesScreen.this, this.serverName, "NOT_FOUND", "Server endpoint not available"));
                        return;
                    }
                    if (this.currentPlayers >= this.maxPlayers) {
                        System.err.println("[Tunnely UI] Cannot join - server is full");
                        PublicLobbiesScreen.this.minecraft.setScreen((Screen)new ConnectionInfoScreen(PublicLobbiesScreen.this, this.serverName, "FULL", "Server is full", this::joinServer));
                        return;
                    }
                    if (this.endpoint.contains("://")) {
                        int lastSlash = this.endpoint.lastIndexOf(47);
                        if (lastSlash > 0 && lastSlash < this.endpoint.length() - 1) {
                            relayUrl = this.endpoint.substring(0, lastSlash);
                            sessionId = this.endpoint.substring(lastSlash + 1);
                            break block6;
                        } else {
                            System.err.println("[Tunnely UI] Invalid endpoint format: " + this.endpoint);
                            PublicLobbiesScreen.this.minecraft.setScreen((Screen)new ConnectionInfoScreen(PublicLobbiesScreen.this, this.serverName, "GENERIC", "Invalid endpoint format: " + this.endpoint));
                            return;
                        }
                    }
                    if (!this.endpoint.contains("/")) {
                        System.err.println("[Tunnely UI] Invalid endpoint format: " + this.endpoint);
                        PublicLobbiesScreen.this.minecraft.setScreen((Screen)new ConnectionInfoScreen(PublicLobbiesScreen.this, this.serverName, "GENERIC", "Invalid endpoint format: " + this.endpoint));
                        return;
                    }
                    String[] parts = this.endpoint.split("/", 2);
                    String relayHostPort = parts[0];
                    sessionId = parts[1];
                    relayUrl = "wss://" + relayHostPort;
                    System.out.println("[Tunnely UI] Legacy endpoint format detected, assuming WSS");
                }
                System.out.println("[Tunnely UI] Parsed relay URL: " + (String)relayUrl);
                System.out.println("[Tunnely UI] Session ID: " + sessionId);
                SafeDisconnect.disconnectAndThen(() -> this.lambda$joinServer$3((String)relayUrl, sessionId));
            }

            private String categorizeError(String error) {
                if (error == null) {
                    return "GENERIC";
                }
                String lowerError = error.toLowerCase();
                if (lowerError.contains("full") || lowerError.contains("capacity")) {
                    return "FULL";
                }
                if (lowerError.contains("not authorized") || lowerError.contains("unauthorized")) {
                    return "NOT_AUTHORIZED";
                }
                if (lowerError.contains("not found") || lowerError.contains("session not found")) {
                    return "NOT_FOUND";
                }
                if (lowerError.contains("connection") || lowerError.contains("timeout") || lowerError.contains("failed to connect")) {
                    return "CONNECTION_FAILED";
                }
                if (lowerError.contains("incompatible") || lowerError.contains("version")) {
                    return "INCOMPATIBLE";
                }
                return "GENERIC";
            }

            public void renderContent(GuiGraphics graphics, int index, int top, boolean isMouseOver, float partialTick) {
                int textWidth;
                float playerRatio;
                int left = ServerListWidget.this.getRowLeft();
                int width = ServerListWidget.this.getRowWidth();
                int height = 60;
                graphics.fill(left + 2, top + 2, left + width - 2, top + height - 2, 0x22000000);
                String compatIcon = this.isCompatible ? "\u00a7a\u2713" : "\u00a7c\u2717";
                graphics.drawString(PublicLobbiesScreen.this.font, compatIcon, left + 8, top + 8, ColorUtil.opaque(0xFFFFFF));
                String displayName = this.serverName.length() > 30 ? this.serverName.substring(0, 27) + "..." : this.serverName;
                graphics.drawString(PublicLobbiesScreen.this.font, "\u00a7f\u00a7l" + displayName, left + 28, top + 8, ColorUtil.opaque(0xFFFFFF));
                String hostInfo = "\u00a77Host: \u00a7f" + (String)(this.hostName.length() > 15 ? this.hostName.substring(0, 12) + "..." : this.hostName);
                graphics.drawString(PublicLobbiesScreen.this.font, hostInfo, left + 28, top + 20, ColorUtil.opaque(0xAAAAAA));
                Object playerText = "\u00a77Players: ";
                float f = playerRatio = this.maxPlayers > 0 ? (float)this.currentPlayers / (float)this.maxPlayers : 0.0f;
                String playerColor = playerRatio >= 0.9f ? "\u00a7c" : (playerRatio >= 0.7f ? "\u00a7e" : "\u00a7a");
                playerText = (String)playerText + playerColor + this.currentPlayers + "\u00a77/\u00a7f" + this.maxPlayers;
                int hostWidth = PublicLobbiesScreen.this.font.width(hostInfo);
                graphics.drawString(PublicLobbiesScreen.this.font, (String)playerText, left + 28 + hostWidth + 15, top + 20, ColorUtil.opaque(0xAAAAAA));
                int joinButtonStartX = left + width - 70;
                int maxBadgeX = joinButtonStartX - 20;
                int badgeX = left + 28;
                int badgeY = top + 32;
                int lineStartX = left + 28;
                if (this.compatibility.minecraftVersion != null) {
                    String versionText = "\u00a7e" + this.compatibility.minecraftVersion;
                    textWidth = PublicLobbiesScreen.this.font.width(versionText);
                    if (badgeX + textWidth > maxBadgeX) {
                        badgeY += 10;
                        badgeX = lineStartX;
                    }
                    graphics.drawString(PublicLobbiesScreen.this.font, versionText, badgeX, badgeY, ColorUtil.opaque(0xFFFFFF));
                    badgeX += textWidth + 8;
                }
                if (this.compatibility.modLoader != null) {
                    String loaderColor = this.compatibility.modLoader.equals("fabric") ? "\u00a7b" : (this.compatibility.modLoader.equals("forge") ? "\u00a7c" : "\u00a7d");
                    String loaderText = loaderColor + this.compatibility.modLoader.toUpperCase();
                    int textWidth2 = PublicLobbiesScreen.this.font.width(loaderText);
                    if (badgeX + textWidth2 > maxBadgeX) {
                        badgeY += 10;
                        badgeX = lineStartX;
                    }
                    graphics.drawString(PublicLobbiesScreen.this.font, loaderText, badgeX, badgeY, ColorUtil.opaque(0xFFFFFF));
                    badgeX += textWidth2 + 8;
                } else {
                    String vanillaText = "\u00a77VANILLA";
                    textWidth = PublicLobbiesScreen.this.font.width(vanillaText);
                    if (badgeX + textWidth > maxBadgeX) {
                        badgeY += 10;
                        badgeX = lineStartX;
                    }
                    graphics.drawString(PublicLobbiesScreen.this.font, vanillaText, badgeX, badgeY, ColorUtil.opaque(0xFFFFFF));
                    badgeX += textWidth + 8;
                }
                if (this.relayRegion != null) {
                    String regionText = "\u00a76" + this.relayRegion.toUpperCase();
                    int textWidth3 = PublicLobbiesScreen.this.font.width(regionText);
                    if (badgeX + textWidth3 > maxBadgeX) {
                        badgeY += 10;
                        badgeX = lineStartX;
                    }
                    graphics.drawString(PublicLobbiesScreen.this.font, regionText, badgeX, badgeY, ColorUtil.opaque(0xFFFFFF));
                    badgeX += textWidth3 + 8;
                }
                String gameModeText = "\u00a79" + this.gameMode.substring(0, 1).toUpperCase() + this.gameMode.substring(1);
                int gameModeWidth = PublicLobbiesScreen.this.font.width(gameModeText);
                if (badgeX + gameModeWidth > maxBadgeX) {
                    badgeY += 10;
                    badgeX = lineStartX;
                }
                graphics.drawString(PublicLobbiesScreen.this.font, gameModeText, badgeX, badgeY, ColorUtil.opaque(0xFFFFFF));
                if (this.compatibility.modpackId != null) {
                    String modpackText = "\u00a7d\ud83d\udce6 " + (String)(this.compatibility.modpackId.length() > 20 ? this.compatibility.modpackId.substring(0, 17) + "..." : this.compatibility.modpackId);
                    if (this.compatibility.modpackVersion != null) {
                        modpackText = modpackText + " \u00a77v" + this.compatibility.modpackVersion;
                    }
                    graphics.drawString(PublicLobbiesScreen.this.font, modpackText, left + 28, top + 44, ColorUtil.opaque(0xFFFFFF));
                }
                this.joinX = left + width - 65;
                this.joinY = top + 31 - 10;
                int border = -12566464;
                int fill = -8355712;
                int textColor = -1;
                graphics.fill(this.joinX, this.joinY, this.joinX + this.joinW, this.joinY + this.joinH, fill);
                graphics.fill(this.joinX - 1, this.joinY - 1, this.joinX + this.joinW + 1, this.joinY, border);
                graphics.fill(this.joinX - 1, this.joinY + this.joinH, this.joinX + this.joinW + 1, this.joinY + this.joinH + 1, border);
                graphics.fill(this.joinX - 1, this.joinY, this.joinX, this.joinY + this.joinH, border);
                graphics.fill(this.joinX + this.joinW, this.joinY, this.joinX + this.joinW + 1, this.joinY + this.joinH, border);
                graphics.drawCenteredString(PublicLobbiesScreen.this.font, "Join", this.joinX + this.joinW / 2, this.joinY + 6, textColor);
            }

            public boolean mouseClicked(MouseButtonEvent event, boolean dragging) {
                if (event.button() == 0) {
                    int mx = (int)event.x();
                    int my = (int)event.y();
                    if (mx >= this.joinX && mx <= this.joinX + this.joinW && my >= this.joinY && my <= this.joinY + this.joinH) {
                        this.joinServer();
                        return true;
                    }
                }
                return false;
            }

            public Component getNarration() {
                return Component.literal((String)(this.serverName + " by " + this.hostName + " (" + this.currentPlayers + "/" + this.maxPlayers + " players)" + (this.isCompatible ? " Compatible" : " Incompatible")));
            }

            public int getHeight() {
                return 62;
            }

            private /* synthetic */ void lambda$joinServer$3(String relayUrl, String sessionId) {
                ClientTunnelManager manager = ClientTunnelManager.getInstance();
                manager.connectToServer(relayUrl, sessionId, () -> System.out.println("[Tunnely UI] \u2713 Connection successful"), error -> {
                    System.err.println("[Tunnely UI] \u2717 Connection failed: " + error);
                    PublicLobbiesScreen.this.minecraft.execute(() -> {
                        String errorType = this.categorizeError((String)error);
                        PublicLobbiesScreen.this.minecraft.setScreen((Screen)new ConnectionInfoScreen(PublicLobbiesScreen.this, this.serverName, errorType, (String)error, errorType.equals("FULL") || errorType.equals("CONNECTION_FAILED") ? this::joinServer : null));
                    });
                });
            }
        }
    }
}

