/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.config.TunnelConfig;
import org.texboobcat.tunnelyrefab.ui.ColorUtil;
import org.texboobcat.tunnelyrefab.ui.screens.SettingsScreen;

public class TermsOfServiceScreen
extends Screen {
    private final Screen parent;
    private final Runnable onAccept;
    private Checkbox acceptCheckbox;
    private Button acceptButton;
    private Button declineButton;
    private Button exportButton;
    private Button settingsButton;
    private String tosVersion = "";
    private String tosTitle = "";
    private String acceptanceText = "";
    private String footer = "";
    private List<TosSection> sections = new ArrayList<TosSection>();
    private List<RenderedSection> renderedSections = new ArrayList<RenderedSection>();
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;

    public TermsOfServiceScreen(Screen parent, Runnable onAccept) {
        super((Component)Component.literal((String)"Terms of Service"));
        this.parent = parent;
        this.onAccept = onAccept;
        this.loadTosFromJson();
    }

    private void loadTosFromJson() {
        try {
            InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/terms-of-service.json");
            if (stream == null) {
                System.err.println("[Tunnely] Could not load terms-of-service.json");
                this.tosTitle = "Terms of Service";
                this.sections.add(new TosSection("Error", "Could not load Terms of Service. Please contact support."));
                return;
            }
            InputStreamReader reader = new InputStreamReader(stream);
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            this.tosVersion = json.has("version") ? json.get("version").getAsString() : "1.0.0";
            this.tosTitle = json.has("title") ? json.get("title").getAsString() : "Terms of Service";
            this.acceptanceText = json.has("acceptance_text") ? json.get("acceptance_text").getAsString() : "I accept the Terms of Service";
            String string = this.footer = json.has("footer") ? json.get("footer").getAsString() : "";
            if (json.has("sections")) {
                JsonArray sectionsArray = json.getAsJsonArray("sections");
                for (int i = 0; i < sectionsArray.size(); ++i) {
                    JsonObject section = sectionsArray.get(i).getAsJsonObject();
                    String title = section.has("title") ? section.get("title").getAsString() : "";
                    String content = section.has("content") ? section.get("content").getAsString() : "";
                    this.sections.add(new TosSection(title, content));
                }
            }
            System.out.println("[Tunnely] Loaded TOS version " + this.tosVersion + " with " + this.sections.size() + " sections");
        }
        catch (Exception e) {
            System.err.println("[Tunnely] Error loading TOS: " + e.getMessage());
            e.printStackTrace();
            this.tosTitle = "Terms of Service";
            this.sections.add(new TosSection("Error", "Could not load Terms of Service. Please contact support."));
        }
    }

    protected void init() {
        super.init();
        int footerHeight = 0;
        if (!this.footer.isEmpty()) {
            List<String> footerLines = this.wrapText(this.footer, this.width - 40);
            footerHeight = footerLines.size() * 11 + 10;
        }
        int buttonY = this.height - 30;
        int checkboxY = buttonY - 35;
        this.prepareRenderedSections();
        this.acceptCheckbox = Checkbox.builder((Component)Component.literal((String)this.acceptanceText), (Font)this.font).pos(this.width / 2 - 100, checkboxY).selected(false).onValueChange((checkbox, selected) -> {
            this.acceptButton.active = selected;
        }).build();
        this.addRenderableWidget((GuiEventListener)this.acceptCheckbox);
        this.acceptButton = Button.builder((Component)Component.literal((String)"\u00a7aI Agree"), button -> this.acceptTos()).bounds(this.width / 2 - 155, buttonY, 100, 20).build();
        this.acceptButton.active = false;
        this.addRenderableWidget((GuiEventListener)this.acceptButton);
        this.declineButton = Button.builder((Component)Component.literal((String)"\u00a7cDecline"), button -> this.minecraft.setScreen(this.parent)).bounds(this.width / 2 - 50, buttonY, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.declineButton);
        this.exportButton = Button.builder((Component)Component.literal((String)"\u00a7e\ud83d\udcc4 Export"), button -> this.exportTos()).bounds(this.width / 2 + 55, buttonY, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.exportButton);
        this.settingsButton = Button.builder((Component)Component.literal((String)"\u2699"), button -> this.minecraft.setScreen((Screen)new SettingsScreen(this))).bounds(this.width - 30, 5, 25, 20).build();
        this.addRenderableWidget((GuiEventListener)this.settingsButton);
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            String testLine = String.valueOf(line) + (line.length() > 0 ? " " : "") + word;
            if (this.font.width(testLine) > maxWidth) {
                if (line.length() > 0) {
                    lines.add(line.toString());
                    line = new StringBuilder(word);
                    continue;
                }
                lines.add(word);
                continue;
            }
            line.append(line.length() > 0 ? " " : "").append(word);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        return lines;
    }

    public void tick() {
        super.tick();
        this.acceptButton.active = this.acceptCheckbox.selected();
    }

    private void acceptTos() {
        System.out.println("[Tunnely] TOS accepted - version " + this.tosVersion);
        TunnelConfig config = TunnelConfig.getInstance();
        config.setAcceptedTosVersion(this.tosVersion);
        if (this.onAccept != null) {
            this.onAccept.run();
        }
    }

    private void exportTos() {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String filename = String.format("Tunnely_TOS_%s_%s.txt", this.tosVersion.replace(".", "_"), dateFormat.format(new Date()));
            File exportFile = new File(filename);
            try (PrintWriter writer = new PrintWriter(new FileWriter(exportFile));){
                writer.println("=".repeat(80));
                writer.println(this.tosTitle);
                writer.println("Version: " + this.tosVersion);
                writer.println("Exported: " + String.valueOf(new Date()));
                writer.println("=".repeat(80));
                writer.println();
                for (TosSection section : this.sections) {
                    writer.println("-".repeat(80));
                    writer.println(section.title);
                    writer.println("-".repeat(80));
                    writer.println();
                    writer.println(section.content);
                    writer.println();
                }
                if (!this.footer.isEmpty()) {
                    writer.println("=".repeat(80));
                    writer.println("ACCEPTANCE NOTICE");
                    writer.println("=".repeat(80));
                    writer.println();
                    writer.println(this.footer);
                    writer.println();
                }
                writer.println("=".repeat(80));
                writer.println("End of Terms of Service");
                writer.println("=".repeat(80));
            }
            System.out.println("[Tunnely] \u2713 TOS exported to: " + exportFile.getAbsolutePath());
            this.minecraft.execute(() -> System.out.println("[Tunnely] TOS saved to game directory: " + filename));
        }
        catch (IOException e) {
            System.err.println("[Tunnely] \u2717 Failed to export TOS: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void prepareRenderedSections() {
        this.renderedSections.clear();
        int contentWidth = Math.min(600, this.width - 50);
        for (TosSection tosSection : this.sections) {
            List<String> wrappedContent = this.wrapContentText(tosSection.content, contentWidth - 30);
            this.renderedSections.add(new RenderedSection(tosSection.title, wrappedContent));
        }
        int totalHeight = 0;
        for (RenderedSection rs : this.renderedSections) {
            totalHeight += 22 + rs.wrappedContent.size() * 11 + 10;
        }
        int n = 55;
        int contentBottom = this.height - 75;
        int viewHeight = contentBottom - n;
        this.maxScrollOffset = Math.max(0, totalHeight - viewHeight);
    }

    private List<String> wrapContentText(String text, int maxWidth) {
        String[] paragraphs;
        ArrayList<String> lines = new ArrayList<String>();
        for (String paragraph : paragraphs = text.split("\\n")) {
            if (paragraph.trim().isEmpty()) {
                lines.add("");
                continue;
            }
            String[] words = paragraph.split(" ");
            StringBuilder line = new StringBuilder();
            for (String word : words) {
                String testLine = String.valueOf(line) + (line.length() > 0 ? " " : "") + word;
                if (this.font.width(testLine) > maxWidth) {
                    if (line.length() > 0) {
                        lines.add(line.toString());
                        line = new StringBuilder(word);
                        continue;
                    }
                    lines.add(word);
                    continue;
                }
                line.append(line.length() > 0 ? " " : "").append(word);
            }
            if (line.length() <= 0) continue;
            lines.add(line.toString());
        }
        return lines;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.drawCenteredString(this.font, "\u00a76\u00a7l" + this.tosTitle, this.width / 2, 15, ColorUtil.opaque(0xFFFFFF));
        graphics.drawCenteredString(this.font, "\u00a77Version " + this.tosVersion, this.width / 2, 30, ColorUtil.opaque(0xAAAAAA));
        int contentTop = 55;
        int contentBottom = this.height - 75;
        int contentWidth = Math.min(600, this.width - 50);
        int contentLeft = this.width / 2 - contentWidth / 2;
        graphics.enableScissor(0, contentTop, this.width, contentBottom);
        int y = contentTop - this.scrollOffset;
        for (RenderedSection rs : this.renderedSections) {
            if (y + 8 >= contentTop - 20 && y <= contentBottom) {
                graphics.drawString(this.font, "\u00a76\u00a7l" + rs.title, contentLeft + 10, y + 8, ColorUtil.opaque(0xFFAA00));
            }
            int yOffset = y + 22;
            for (String line : rs.wrappedContent) {
                if (yOffset >= contentTop - 20 && yOffset <= contentBottom && !line.isEmpty()) {
                    graphics.drawString(this.font, "\u00a77" + line, contentLeft + 20, yOffset, ColorUtil.opaque(0xAAAAAA));
                }
                yOffset += 11;
            }
            y += 22 + rs.wrappedContent.size() * 11 + 10;
        }
        graphics.disableScissor();
        if (this.maxScrollOffset > 0) {
            int scrollbarX = contentLeft + contentWidth + 10;
            int scrollbarHeight = contentBottom - contentTop;
            int scrollbarThumbHeight = Math.max(20, (int)((float)scrollbarHeight * (float)scrollbarHeight / (float)(scrollbarHeight + this.maxScrollOffset)));
            int scrollbarThumbY = contentTop + (int)((float)this.scrollOffset / (float)this.maxScrollOffset * (float)(scrollbarHeight - scrollbarThumbHeight));
            graphics.fill(scrollbarX, contentTop, scrollbarX + 6, contentBottom, 0x44FFFFFF);
            graphics.fill(scrollbarX, scrollbarThumbY, scrollbarX + 6, scrollbarThumbY + scrollbarThumbHeight, -1426063361);
        }
        if (!this.footer.isEmpty()) {
            List<String> footerLines = this.wrapText(this.footer, this.width - 40);
            int startY = this.height - 75 - footerLines.size() * 11;
            for (int i = 0; i < footerLines.size(); ++i) {
                graphics.drawCenteredString(this.font, "\u00a77\u00a7o" + footerLines.get(i), this.width / 2, startY + i * 11, ColorUtil.opaque(0xAAAAAA));
            }
        }
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.maxScrollOffset > 0) {
            this.scrollOffset = Math.max(0, Math.min(this.maxScrollOffset, this.scrollOffset - (int)(scrollY * 20.0)));
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static class TosSection {
        final String title;
        final String content;

        TosSection(String title, String content) {
            this.title = title;
            this.content = content;
        }
    }

    private static class RenderedSection {
        final String title;
        final List<String> wrappedContent;

        RenderedSection(String title, List<String> wrappedContent) {
            this.title = title;
            this.wrappedContent = wrappedContent;
        }
    }
}

