/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.tunnelyrefab.ui.screens;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.texboobcat.tunnelyrefab.ui.ColorUtil;

public class WarningPopupScreen
extends Screen {
    private final Screen parent;
    private final Screen backScreen;
    private final String title;
    private final String message;
    private final Runnable onContinue;
    private MultiLineLabel messageLabel;
    private Button continueButton;
    private Button backButton;
    private final int warningColor;

    public WarningPopupScreen(Screen parent, String title, String message) {
        this(parent, parent, title, message, 0xFFAA00, null);
    }

    public WarningPopupScreen(Screen parent, Screen backScreen, String title, String message, int warningColor, Runnable onContinue) {
        super((Component)Component.literal((String)title));
        this.parent = parent;
        this.backScreen = backScreen;
        this.title = title;
        this.message = message;
        this.warningColor = warningColor;
        this.onContinue = onContinue;
    }

    protected void init() {
        super.init();
        this.messageLabel = MultiLineLabel.create((Font)this.font, (Component)Component.literal((String)this.message), (int)(this.width - 80));
        this.continueButton = Button.builder((Component)Component.literal((String)"OK"), button -> {
            if (this.onContinue != null) {
                this.onContinue.run();
            }
            this.minecraft.setScreen(this.parent);
        }).bounds(this.width / 2 - 100, this.height - 50, 95, 20).build();
        this.addRenderableWidget((GuiEventListener)this.continueButton);
        this.backButton = Button.builder((Component)Component.literal((String)"Back"), button -> this.minecraft.setScreen(this.backScreen)).bounds(this.width / 2 + 5, this.height - 50, 95, 20).build();
        this.addRenderableWidget((GuiEventListener)this.backButton);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.drawCenteredString(this.font, "\u00a7e\u00a7l\u26a0", this.width / 2, 60, ColorUtil.opaque(this.warningColor));
        graphics.drawCenteredString(this.font, "\u00a7l" + this.title, this.width / 2, 80, ColorUtil.opaque(0xFFFFFF));
        int messageY = 105;
        this.messageLabel.render(graphics, MultiLineLabel.Align.CENTER, this.width / 2, messageY, 10, true, -1);
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

