/*
 * Decompiled with CFR 0.152.
 */
package com.example.meteors;

import com.example.meteors.GiantMeteorEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class GiantMeteorEntityRenderer
extends EntityRenderer<GiantMeteorEntity> {
    private final BlockRenderDispatcher dispatcher;

    public GiantMeteorEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.dispatcher = context.getBlockRenderDispatcher();
    }

    public void render(GiantMeteorEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Level level;
        BlockState blockState = entity.getBlockState();
        if (blockState.getRenderShape() == RenderShape.MODEL && blockState != (level = entity.level()).getBlockState(entity.blockPosition()) && blockState.getRenderShape() != RenderShape.INVISIBLE) {
            poseStack.pushPose();
            BlockPos blockpos = BlockPos.containing((double)entity.getX(), (double)entity.getBoundingBox().maxY, (double)entity.getZ());
            poseStack.translate(-0.5, 0.0, -0.5);
            poseStack.translate(0.5, 0.5, 0.5);
            float scale = 15.0f;
            poseStack.scale(scale, scale, scale);
            float time = (float)entity.tickCount + partialTicks;
            poseStack.mulPose(Axis.YP.rotationDegrees(time * 0.5f));
            poseStack.mulPose(Axis.XP.rotationDegrees(time * 0.2f));
            poseStack.translate(-0.5, -0.5, -0.5);
            this.dispatcher.renderSingleBlock(blockState, poseStack, buffer, packedLight, 10, ModelData.EMPTY, null);
            poseStack.popPose();
            super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    public ResourceLocation getTextureLocation(GiantMeteorEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

