/*
 * Decompiled with CFR 0.152.
 */
package com.cookta2012.dimstructrestrict;

import com.cookta2012.dimstructrestrict.DimensionRule;
import com.cookta2012.dimstructrestrict.Rule;
import com.cookta2012.dimstructrestrict.StructureRule;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="dimstructrestrict")
public class DimensionalStructureRestrict {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"dimstructrestrict");
    public static final Map<ResourceLocation, Rule> STRUCTURE_RULES = new HashMap<ResourceLocation, Rule>();
    public static final Map<ResourceLocation, Rule> DIMENSION_RULES = new HashMap<ResourceLocation, Rule>();
    private Boolean dirtyConfig = false;
    private String configFile = "DimStruct Restrict.json";

    public DimensionalStructureRestrict() {
        this.loadConfig();
    }

    public Boolean isConfigDirty() {
        return this.dirtyConfig;
    }

    public void setConfigDirty() {
        this.dirtyConfig = true;
    }

    private void setConfigClean() {
        this.dirtyConfig = false;
    }

    private void loadConfig() {
        Path cfg = FMLPaths.CONFIGDIR.get().resolve(this.configFile);
        try {
            if (Files.notExists(cfg, new LinkOption[0])) {
                Files.writeString(cfg, (CharSequence)"{\n  \"structures\": [\n    {\n      \"id\": \"minecraft:village_plains\",\n      \"whitelist\": [\"minecraft:overworld\"],\n      \"active\": true\n    }\n  ],\n  \"dimensions\": [\n    {\n      \"id\": \"minecraft:the_end\",\n      \"blacklist\": [\"minecraft:village_plains\"]\n    }\n  ]\n}\n", new OpenOption[0]);
            }
            try (BufferedReader reader = Files.newBufferedReader(cfg);
                 JsonReader jsonReader = new JsonReader((Reader)reader);){
                jsonReader.setLenient(true);
                JsonElement root = JsonParser.parseReader((JsonReader)jsonReader);
                if (root.isJsonArray()) {
                    this.parseArr(root.getAsJsonArray(), Rule.Type.STRUCTURE, STRUCTURE_RULES);
                } else if (root.isJsonObject()) {
                    JsonObject obj = root.getAsJsonObject();
                    if (obj.has("structures")) {
                        this.parseArr(obj.getAsJsonArray("structures"), Rule.Type.STRUCTURE, STRUCTURE_RULES);
                    }
                    if (obj.has("dimensions")) {
                        this.parseArr(obj.getAsJsonArray("dimensions"), Rule.Type.DIMENSION, DIMENSION_RULES);
                    }
                } else {
                    throw new IllegalStateException("\"" + this.configFile + "\" must be proper JSON or Structure array");
                }
                if (this.isConfigDirty().booleanValue()) {
                    this.saveConfig();
                    this.loadConfig();
                }
            }
        }
        catch (JsonSyntaxException syntaxEx) {
            throw new RuntimeException("Malformed JSON in file \"" + this.configFile + "\" at line " + syntaxEx.getMessage(), syntaxEx);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to load \"" + this.configFile + "\": " + ex.getMessage(), ex);
        }
    }

    private void saveConfig() {
        Path cfg = FMLPaths.CONFIGDIR.get().resolve(this.configFile);
        JsonObject root = new JsonObject();
        JsonArray structuresArray = new JsonArray();
        for (Map.Entry<ResourceLocation, Rule> entry : STRUCTURE_RULES.entrySet()) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", entry.getKey().toString());
            Rule rule = entry.getValue();
            JsonArray list = new JsonArray();
            for (ResourceLocation dim : rule.resource()) {
                list.add(dim.toString());
            }
            if (rule.mode() == Rule.Mode.WHITELIST) {
                jsonObject.add("whitelist", (JsonElement)list);
            } else {
                jsonObject.add("blacklist", (JsonElement)list);
            }
            jsonObject.addProperty("false_place", Boolean.valueOf(rule.false_place() != null ? rule.false_place() : false));
            jsonObject.addProperty("active", Boolean.valueOf(rule.active() != null ? rule.active() : false));
            structuresArray.add((JsonElement)jsonObject);
        }
        root.add("structures", (JsonElement)structuresArray);
        JsonArray dimensionsArray = new JsonArray();
        for (Map.Entry<ResourceLocation, Rule> entry : DIMENSION_RULES.entrySet()) {
            JsonObject o = new JsonObject();
            o.addProperty("id", entry.getKey().toString());
            Rule rule = entry.getValue();
            JsonArray list = new JsonArray();
            for (ResourceLocation structId : rule.resource()) {
                list.add(structId.toString());
            }
            if (rule.mode() == Rule.Mode.WHITELIST) {
                o.add("whitelist", (JsonElement)list);
            } else {
                o.add("blacklist", (JsonElement)list);
            }
            o.addProperty("false_place", Boolean.valueOf(rule.false_place() != null ? rule.false_place() : false));
            o.addProperty("active", Boolean.valueOf(rule.active() != null ? rule.active() : false));
            dimensionsArray.add((JsonElement)o);
        }
        root.add("dimensions", (JsonElement)dimensionsArray);
        try {
            Files.writeString(cfg, (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)root), new OpenOption[0]);
            this.setConfigClean();
            LOGGER.debug("Config saved to " + cfg);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to save \"" + this.configFile + "\": " + exception.getMessage(), exception);
        }
    }

    private Boolean get_param(JsonObject o, String param_name) {
        return this.get_param(o, param_name, false);
    }

    private Boolean get_param(JsonObject o, String param_name, Boolean _default) {
        if (!o.has(param_name)) {
            this.setConfigDirty();
            return _default;
        }
        return o.get(param_name).getAsBoolean();
    }

    private void parseArr(JsonArray arr, Rule.Type ruletype, Map<ResourceLocation, Rule> resourceMap) {
        block4: for (JsonElement elem : arr) {
            JsonObject o = elem.getAsJsonObject();
            String idStr = o.get("id").getAsString();
            ResourceLocation id = new ResourceLocation(idStr);
            boolean hasWhitelist = o.has("whitelist");
            boolean hasBlacklist = o.has("blacklist");
            if (hasWhitelist && hasBlacklist) {
                throw new IllegalStateException("Structure rule '" + idStr + "' has both whitelist and blacklist.");
            }
            if (!hasWhitelist && !hasBlacklist) continue;
            Rule.Mode mode = hasWhitelist ? Rule.Mode.WHITELIST : Rule.Mode.BLACKLIST;
            JsonArray list = o.getAsJsonArray(hasWhitelist ? "whitelist" : "blacklist");
            HashSet<ResourceLocation> resources = new HashSet<ResourceLocation>();
            for (JsonElement j : list) {
                resources.add(new ResourceLocation(j.getAsString()));
            }
            Boolean false_place = this.get_param(o, "false_place");
            Boolean active = this.get_param(o, "active");
            switch (ruletype) {
                case DIMENSION: {
                    resourceMap.put(id, new DimensionRule(id, mode, resources, false_place, active));
                    continue block4;
                }
                case STRUCTURE: {
                    resourceMap.put(id, new StructureRule(id, mode, resources, false_place, active));
                    continue block4;
                }
            }
            throw new IllegalStateException("Attempted to create invalid Rule Type");
        }
    }
}

