/*
 * Decompiled with CFR 0.152.
 */
package com.cookta2012.dimstructrestrict;

import com.cookta2012.dimstructrestrict.DimensionalStructureRestrict;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public abstract class Rule {
    private final ResourceLocation id;
    private final Type type;
    private final Mode mode;
    private final Set<ResourceLocation> resource;
    private final Boolean false_place;
    private final Boolean active;

    public Rule(ResourceLocation id, Type type, Mode mode, Set<ResourceLocation> resource, Boolean false_place, Boolean active) {
        this.id = id;
        this.type = type;
        this.mode = mode;
        this.resource = resource;
        this.false_place = false_place;
        this.active = active;
    }

    private String getType() {
        return switch (this.type) {
            case Type.DIMENSION -> "Dimension";
            case Type.STRUCTURE -> "Structure";
            default -> throw new IllegalStateException("Attempted to return invalid Rule Type");
        };
    }

    private String getMode() {
        return switch (this.mode) {
            case Mode.WHITELIST -> "Whitelist";
            case Mode.BLACKLIST -> "Blacklist";
            default -> throw new IllegalStateException("Attempted to return invalid Mode Type");
        };
    }

    public Mode mode() {
        return this.mode;
    }

    public Set<ResourceLocation> resource() {
        return this.resource;
    }

    public Boolean false_place() {
        return this.false_place;
    }

    public Boolean active() {
        return this.active;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return Objects.equals((Object)this.mode, (Object)rule.mode) && Objects.equals(this.resource, rule.resource) && Objects.equals(this.false_place, rule.false_place) && Objects.equals(this.active, rule.active);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.resource, this.false_place, this.active});
    }

    public String toString() {
        return "Rule{mode=" + this.mode + ", resource=" + this.resource + ", false_place=" + this.false_place + ", active=" + this.active + "}";
    }

    public Boolean isRestricted(ResourceLocation targetResource, Boolean isClean) {
        if (!this.active.booleanValue()) {
            DimensionalStructureRestrict.LOGGER.debug("Rule not active" + this.type.toString());
            return false;
        }
        if (this.false_place.booleanValue() && !isClean.booleanValue()) {
            DimensionalStructureRestrict.LOGGER.debug("Rule set to false_place");
            return false;
        }
        if (this.mode == Mode.WHITELIST) {
            if (!this.resource().contains(targetResource)) {
                this.logDebugMessage(isClean, targetResource);
                return true;
            }
        } else if (this.resource().contains(targetResource)) {
            this.logDebugMessage(isClean, targetResource);
            return true;
        }
        return false;
    }

    private void logDebugMessage(Boolean isClean, ResourceLocation targetResource) {
        DimensionalStructureRestrict.LOGGER.debug(this.getType() + " Rule " + this.getMode() + (isClean == false ? " un" : " ") + "cleanly prevented generation of Structure: " + (this.type == Type.DIMENSION ? targetResource.toString() : this.id.toString()) + " in Dimension: " + (this.type == Type.STRUCTURE ? targetResource.toString() : this.id.toString()) + " due to " + (this.mode == Mode.WHITELIST ? "not being whitelisted" : "being blacklisted"));
    }

    public static enum Type {
        DIMENSION,
        STRUCTURE;

    }

    public static enum Mode {
        WHITELIST,
        BLACKLIST;

    }
}

